/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.TopLevel;
import org.sbolstandard.core2.URIcompliance;

public class Model
extends TopLevel {
    private URI source;
    private URI language;
    private URI framework;

    Model(URI identity, URI source, URI language, URI framework) throws SBOLValidationException {
        super(identity);
        this.setSource(source);
        this.setLanguage(language);
        this.setFramework(framework);
    }

    private Model(Model model) throws SBOLValidationException {
        super(model);
        this.setSource(model.getSource());
        this.setLanguage(model.getLanguage());
        this.setFramework(model.getFramework());
    }

    void copy(Model model) throws SBOLValidationException {
        this.copy((Identified)model);
    }

    public URI getSource() {
        return this.source;
    }

    public void setSource(URI source) throws SBOLValidationException {
        if (source == null) {
            throw new SBOLValidationException("sbol-11502", this);
        }
        this.source = source;
    }

    public URI getLanguage() {
        return this.language;
    }

    public void setLanguage(URI language) throws SBOLValidationException {
        if (language == null) {
            throw new SBOLValidationException("sbol-11504", this);
        }
        this.language = language;
    }

    public URI getFramework() {
        return this.framework;
    }

    public void setFramework(URI framework) throws SBOLValidationException {
        if (framework == null) {
            throw new SBOLValidationException("sbol-11508", this);
        }
        this.framework = framework;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.framework == null ? 0 : this.framework.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Model other = (Model)obj;
        if (this.framework == null ? other.framework != null : !this.framework.equals(other.framework)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    @Override
    Model deepCopy() throws SBOLValidationException {
        return new Model(this);
    }

    @Override
    Model copy(String URIprefix, String displayId, String version) throws SBOLValidationException {
        Model cloned = this.deepCopy();
        cloned.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        cloned.setDisplayId(displayId);
        cloned.setVersion(version);
        URI newIdentity = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        if (!this.getIdentity().equals(newIdentity)) {
            cloned.addWasDerivedFrom(this.getIdentity());
        } else {
            cloned.setWasDerivedFroms(this.getWasDerivedFroms());
        }
        cloned.setIdentity(newIdentity);
        return cloned;
    }

    @Override
    void checkDescendantsURIcompliance() {
    }

    @Override
    public String toString() {
        return "Model [identity=" + this.getIdentity() + (this.isSetDisplayId() ? ", displayId=" + this.getDisplayId() : "") + (this.isSetName() ? ", name=" + this.getName() : "") + (this.isSetDescription() ? ", description=" + this.getDescription() : "") + ", source=" + this.source + ", language=" + this.language + ", framework=" + this.framework + "]";
    }
}

