/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.DirectionType;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.RefinementType;
import org.sbolstandard.core2.SBOLValidate;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.URIcompliance;

public class Module
extends Identified {
    private HashMap<URI, MapsTo> mapsTos = new HashMap();
    private URI definition;
    private ModuleDefinition moduleDefinition = null;

    Module(URI identity, URI moduleDefinition) throws SBOLValidationException {
        super(identity);
        this.setDefinition(moduleDefinition);
    }

    private Module(Module module) throws SBOLValidationException {
        super(module);
        this.setDefinition(module.getDefinitionURI());
        for (MapsTo mapping : module.getMapsTos()) {
            this.addMapsTo(mapping.deepCopy());
        }
    }

    void copy(Module module) throws SBOLValidationException {
        this.copy((Identified)module);
        if (!module.getMapsTos().isEmpty()) {
            for (MapsTo mapsTo : module.getMapsTos()) {
                String displayId = mapsTo.getDisplayId();
                if (displayId == null) {
                    displayId = URIcompliance.extractDisplayId(mapsTo.getIdentity());
                }
                MapsTo newMapsTo = this.createMapsTo(displayId, mapsTo.getRefinement(), mapsTo.getLocal().getDisplayId(), mapsTo.getRemoteURI());
                newMapsTo.copy(mapsTo);
            }
        }
    }

    public URI getDefinitionURI() {
        return this.definition;
    }

    public ModuleDefinition getDefinition() {
        if (this.getSBOLDocument() == null) {
            return null;
        }
        return this.getSBOLDocument().getModuleDefinition(this.definition);
    }

    public void setDefinition(URI definitionURI) throws SBOLValidationException {
        if (definitionURI == null) {
            throw new SBOLValidationException("sbol-11702", this);
        }
        if (this.getSBOLDocument() != null) {
            if (this.getSBOLDocument().isComplete() && this.getSBOLDocument().getModuleDefinition(definitionURI) == null) {
                throw new SBOLValidationException("sbol-11703", this);
            }
            if (this.moduleDefinition != null) {
                ModuleDefinition md = this.getSBOLDocument().getModuleDefinition(definitionURI);
                if (md != null && this.moduleDefinition.getIdentity().equals(md.getIdentity())) {
                    throw new SBOLValidationException("sbol-11704", this);
                }
                HashSet<URI> visited = new HashSet<URI>();
                visited.add(this.moduleDefinition.getIdentity());
                try {
                    SBOLValidate.checkModuleDefinitionCycle(this.getSBOLDocument(), md, visited);
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException("sbol-11705", this);
                }
            }
        }
        this.definition = definitionURI;
    }

    MapsTo createMapsTo(URI identity, RefinementType refinement, URI local, URI remote) throws SBOLValidationException {
        MapsTo mapping = new MapsTo(identity, refinement, local, remote);
        this.addMapsTo(mapping);
        return mapping;
    }

    public MapsTo createMapsTo(String displayId, RefinementType refinement, String localId, String remoteId) throws SBOLValidationException {
        URI localURI = URIcompliance.createCompliantURI(this.moduleDefinition.getPersistentIdentity().toString(), localId, this.moduleDefinition.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.moduleDefinition != null && this.moduleDefinition.getFunctionalComponent(localURI) == null) {
            this.moduleDefinition.createFunctionalComponent(localId, AccessType.PUBLIC, localId, "", DirectionType.INOUT);
        }
        URI remoteURI = URIcompliance.createCompliantURI(this.getDefinition().getPersistentIdentity().toString(), remoteId, this.getDefinition().getVersion());
        return this.createMapsTo(displayId, refinement, localURI, remoteURI);
    }

    MapsTo createMapsTo(String displayId, RefinementType refinement, String localId, URI remoteURI) throws SBOLValidationException {
        URI localURI = URIcompliance.createCompliantURI(this.moduleDefinition.getPersistentIdentity().toString(), localId, this.moduleDefinition.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.moduleDefinition != null && this.moduleDefinition.getFunctionalComponent(localURI) == null) {
            this.moduleDefinition.createFunctionalComponent(localId, AccessType.PUBLIC, localId, "", DirectionType.INOUT);
        }
        return this.createMapsTo(displayId, refinement, localURI, remoteURI);
    }

    public MapsTo createMapsTo(String displayId, RefinementType refinement, URI local, URI remote) throws SBOLValidationException {
        String parentPersistentIdStr = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        URI newMapsToURI = URIcompliance.createCompliantURI(parentPersistentIdStr, displayId, version);
        MapsTo m = this.createMapsTo(newMapsToURI, refinement, local, remote);
        m.setPersistentIdentity(URIcompliance.createCompliantURI(parentPersistentIdStr, displayId, ""));
        m.setDisplayId(displayId);
        m.setVersion(version);
        return m;
    }

    private void addMapsTo(MapsTo mapsTo) throws SBOLValidationException {
        mapsTo.setSBOLDocument(this.getSBOLDocument());
        mapsTo.setModuleDefinition(this.moduleDefinition);
        mapsTo.setModule(this);
        if (this.getSBOLDocument() != null && mapsTo.getLocal() == null) {
            throw new SBOLValidationException("sbol-10804", mapsTo);
        }
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete()) {
            if (mapsTo.getRemote() == null) {
                throw new SBOLValidationException("sbol-10809", mapsTo);
            }
            if (mapsTo.getRemote().getAccess().equals((Object)AccessType.PRIVATE)) {
                throw new SBOLValidationException("sbol-10807", mapsTo);
            }
            if (mapsTo.getRefinement().equals((Object)RefinementType.VERIFYIDENTICAL) && !mapsTo.getLocal().getDefinitionURI().equals(mapsTo.getRemote().getDefinitionURI())) {
                throw new SBOLValidationException("sbol-10811", mapsTo);
            }
        }
        if (this.moduleDefinition != null) {
            SBOLValidate.checkModuleDefinitionMapsTos(this.moduleDefinition, mapsTo);
        }
        this.addChildSafely(mapsTo, this.mapsTos, "mapsTo", new Map[0]);
    }

    public boolean removeMapsTo(MapsTo mapsTo) {
        return this.removeChildSafely(mapsTo, this.mapsTos);
    }

    public MapsTo getMapsTo(String displayId) {
        try {
            return this.mapsTos.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public MapsTo getMapsTo(URI referenceURI) {
        return this.mapsTos.get(referenceURI);
    }

    public Set<MapsTo> getMapsTos() {
        return new HashSet<MapsTo>(this.mapsTos.values());
    }

    public void clearMapsTos() {
        Object[] valueSetArray;
        for (Object mapsTo : valueSetArray = this.mapsTos.values().toArray()) {
            this.removeMapsTo((MapsTo)mapsTo);
        }
    }

    void setMapsTos(Set<MapsTo> mappings) throws SBOLValidationException {
        this.clearMapsTos();
        for (MapsTo mapping : mappings) {
            this.addMapsTo(mapping);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.mapsTos == null ? 0 : this.mapsTos.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Module other = (Module)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return !(this.mapsTos == null ? other.mapsTos != null : !this.mapsTos.equals(other.mapsTos));
    }

    @Override
    Module deepCopy() throws SBOLValidationException {
        return new Module(this);
    }

    void updateCompliantURI(String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!this.getIdentity().equals(URIcompliance.createCompliantURI(URIprefix, displayId, version))) {
            this.addWasDerivedFrom(this.getIdentity());
        }
        this.setIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, version));
        this.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        this.setDisplayId(displayId);
        this.setVersion(version);
        for (MapsTo mapsTo : this.getMapsTos()) {
            mapsTo.updateCompliantURI(this.getPersistentIdentity().toString(), mapsTo.getDisplayId(), version);
            this.removeChildSafely(mapsTo, this.mapsTos);
            this.addMapsTo(mapsTo);
            String localId = URIcompliance.extractDisplayId(mapsTo.getLocalURI());
            mapsTo.setLocal(URIcompliance.createCompliantURI(URIprefix, localId, version));
        }
    }

    ModuleDefinition getModuleDefinition() {
        return this.moduleDefinition;
    }

    void setModuleDefinition(ModuleDefinition moduleDefinition) {
        this.moduleDefinition = moduleDefinition;
    }

    @Override
    public String toString() {
        return "Module [" + super.toString() + ", definition=" + this.definition + (this.getMapsTos().size() > 0 ? ", mapsTos=" + this.getMapsTos() : "") + "]";
    }
}

