/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.DirectionType;
import org.sbolstandard.core2.FunctionalComponent;
import org.sbolstandard.core2.Interaction;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.Model;
import org.sbolstandard.core2.Module;
import org.sbolstandard.core2.Participation;
import org.sbolstandard.core2.RefinementType;
import org.sbolstandard.core2.SBOLValidate;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.TopLevel;
import org.sbolstandard.core2.URIcompliance;

public class ModuleDefinition
extends TopLevel {
    private Set<URI> roles = new HashSet<URI>();
    private HashMap<URI, Module> modules = new HashMap();
    private HashMap<URI, Interaction> interactions = new HashMap();
    private HashMap<URI, FunctionalComponent> functionalComponents = new HashMap();
    private Set<URI> models = new HashSet<URI>();

    ModuleDefinition(URI identity) throws SBOLValidationException {
        super(identity);
    }

    private ModuleDefinition(ModuleDefinition moduleDefinition) throws SBOLValidationException {
        super(moduleDefinition);
        for (URI role : moduleDefinition.getRoles()) {
            this.addRole(role);
        }
        for (FunctionalComponent component : moduleDefinition.getFunctionalComponents()) {
            this.addFunctionalComponent(component.deepCopy());
        }
        for (Module subModule : moduleDefinition.getModules()) {
            this.addModule(subModule.deepCopy());
        }
        for (Interaction interaction : moduleDefinition.getInteractions()) {
            this.addInteraction(interaction.deepCopy());
        }
        this.setModels(moduleDefinition.getModelURIs());
    }

    void copy(ModuleDefinition moduleDefinition) throws SBOLValidationException {
        String displayId;
        this.copy((TopLevel)moduleDefinition);
        for (URI role : moduleDefinition.getRoles()) {
            this.addRole(role);
        }
        for (FunctionalComponent component : moduleDefinition.getFunctionalComponents()) {
            displayId = component.getDisplayId();
            if (displayId == null) {
                displayId = URIcompliance.extractDisplayId(component.getIdentity());
            }
            FunctionalComponent newComponent = this.createFunctionalComponent(displayId, component.getAccess(), component.getDefinitionURI(), component.getDirection());
            newComponent.copy(component);
        }
        for (Module subModule : moduleDefinition.getModules()) {
            displayId = subModule.getDisplayId();
            if (displayId == null) {
                displayId = URIcompliance.extractDisplayId(subModule.getIdentity());
            }
            Module newModule = this.createModule(displayId, subModule.getDefinitionURI());
            newModule.copy(subModule);
        }
        for (Interaction interaction : moduleDefinition.getInteractions()) {
            displayId = interaction.getDisplayId();
            if (displayId == null) {
                displayId = URIcompliance.extractDisplayId(interaction.getIdentity());
            }
            Interaction newInteraction = this.createInteraction(displayId, interaction.getTypes());
            newInteraction.copy(interaction);
        }
        this.setModels(moduleDefinition.getModelURIs());
    }

    public boolean addRole(URI roleURI) {
        return this.roles.add(roleURI);
    }

    public boolean removeRole(URI roleURI) {
        return this.roles.remove(roleURI);
    }

    public void setRoles(Set<URI> roles) {
        this.clearRoles();
        if (roles == null) {
            return;
        }
        for (URI role : roles) {
            this.addRole(role);
        }
    }

    public Set<URI> getRoles() {
        HashSet<URI> result = new HashSet<URI>();
        result.addAll(this.roles);
        return result;
    }

    public boolean containsRole(URI roleURI) {
        return this.roles.contains(roleURI);
    }

    public void clearRoles() {
        this.roles.clear();
    }

    private Module createModule(URI identity, URI moduleDefinitionURI) throws SBOLValidationException {
        Module module = new Module(identity, moduleDefinitionURI);
        this.addModule(module);
        return module;
    }

    public Module createModule(String displayId, String moduleDefinitionId, String version) throws SBOLValidationException {
        URI definitionURI = URIcompliance.createCompliantURI(this.getSBOLDocument().getDefaultURIprefix(), "md", moduleDefinitionId, version, this.getSBOLDocument().isTypesInURIs());
        return this.createModule(displayId, definitionURI);
    }

    public Module createModule(String displayId, String moduleDefinitionId) throws SBOLValidationException {
        return this.createModule(displayId, moduleDefinitionId, "");
    }

    public Module createModule(String displayId, URI moduleDefinitionURI) throws SBOLValidationException {
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && this.getSBOLDocument().getModuleDefinition(moduleDefinitionURI) == null) {
            throw new SBOLValidationException("sbol-11703", this);
        }
        String URIprefix = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        URI newModuleURI = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        Module m = this.createModule(newModuleURI, moduleDefinitionURI);
        m.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        m.setDisplayId(displayId);
        m.setVersion(version);
        return m;
    }

    private void addModule(Module module) throws SBOLValidationException {
        module.setSBOLDocument(this.getSBOLDocument());
        module.setModuleDefinition(this);
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && module.getDefinition() == null) {
            throw new SBOLValidationException("sbol-11703", module);
        }
        if (module.getDefinition() != null && this.getIdentity().equals(module.getDefinition().getIdentity())) {
            throw new SBOLValidationException("sbol-11704", module);
        }
        HashSet<URI> visited = new HashSet<URI>();
        visited.add(this.getIdentity());
        try {
            SBOLValidate.checkModuleDefinitionCycle(this.getSBOLDocument(), module.getDefinition(), visited);
        }
        catch (SBOLValidationException e) {
            throw new SBOLValidationException("sbol-11705", module);
        }
        this.addChildSafely(module, this.modules, "module", this.functionalComponents, this.interactions);
        for (MapsTo mapsTo : module.getMapsTos()) {
            if (this.getFunctionalComponent(mapsTo.getLocalURI()) == null) {
                throw new SBOLValidationException("sbol-10804", mapsTo);
            }
            mapsTo.setSBOLDocument(this.getSBOLDocument());
            mapsTo.setModuleDefinition(this);
            mapsTo.setModule(module);
        }
    }

    public boolean removeModule(Module module) {
        return this.removeChildSafely(module, this.modules);
    }

    public Module getModule(String displayId) {
        try {
            return this.modules.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public Module getModule(URI moduleURI) {
        return this.modules.get(moduleURI);
    }

    public Set<Module> getModules() {
        return new HashSet<Module>(this.modules.values());
    }

    public void clearModules() {
        Object[] valueSetArray;
        for (Object module : valueSetArray = this.modules.values().toArray()) {
            this.removeModule((Module)module);
        }
    }

    void setModules(Set<Module> modules) throws SBOLValidationException {
        this.clearModules();
        if (modules == null) {
            return;
        }
        for (Module module : modules) {
            this.addModule(module);
        }
    }

    private Interaction createInteraction(URI identity, Set<URI> types) throws SBOLValidationException {
        Interaction interaction = new Interaction(identity, types);
        this.addInteraction(interaction);
        return interaction;
    }

    public Interaction createInteraction(String displayId, Set<URI> types) throws SBOLValidationException {
        String URIprefix = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        URI interactionURI = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        Interaction i = this.createInteraction(interactionURI, types);
        i.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        i.setDisplayId(displayId);
        i.setVersion(version);
        return i;
    }

    public Interaction createInteraction(String displayId, URI type) throws SBOLValidationException {
        String URIprefix = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        URI newInteractionURI = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        HashSet<URI> types = new HashSet<URI>();
        types.add(type);
        Interaction i = this.createInteraction(newInteractionURI, types);
        i.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        i.setDisplayId(displayId);
        i.setVersion(version);
        return i;
    }

    private void addInteraction(Interaction interaction) throws SBOLValidationException {
        this.addChildSafely(interaction, this.interactions, "interaction", this.functionalComponents, this.modules);
        interaction.setSBOLDocument(this.getSBOLDocument());
        interaction.setModuleDefinition(this);
        for (Participation participation : interaction.getParticipations()) {
            if (this.getFunctionalComponent(participation.getParticipantURI()) == null) {
                throw new SBOLValidationException("sbol-12003", participation);
            }
            participation.setSBOLDocument(this.getSBOLDocument());
            participation.setModuleDefinition(this);
        }
    }

    public boolean removeInteraction(Interaction interaction) {
        return this.removeChildSafely(interaction, this.interactions);
    }

    public Interaction getInteraction(String displayId) {
        try {
            return this.interactions.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public Interaction getInteraction(URI interactionURI) {
        return this.interactions.get(interactionURI);
    }

    public Set<Interaction> getInteractions() {
        return new HashSet<Interaction>(this.interactions.values());
    }

    public void clearInteractions() {
        Object[] valueSetArray;
        for (Object interaction : valueSetArray = this.interactions.values().toArray()) {
            this.removeInteraction((Interaction)interaction);
        }
    }

    void setInteractions(Set<Interaction> interactions) throws SBOLValidationException {
        this.clearInteractions();
        if (interactions == null) {
            return;
        }
        for (Interaction interaction : interactions) {
            this.addInteraction(interaction);
        }
    }

    private FunctionalComponent createFunctionalComponent(URI identity, AccessType access, URI definitionURI, DirectionType direction) throws SBOLValidationException {
        FunctionalComponent functionalComponent = new FunctionalComponent(identity, access, definitionURI, direction);
        this.addFunctionalComponent(functionalComponent);
        return functionalComponent;
    }

    public FunctionalComponent createFunctionalComponent(String displayId, AccessType access, String definitionId, String version, DirectionType direction) throws SBOLValidationException {
        URI definitionURI = URIcompliance.createCompliantURI(this.getSBOLDocument().getDefaultURIprefix(), "cd", definitionId, version, this.getSBOLDocument().isTypesInURIs());
        return this.createFunctionalComponent(displayId, access, definitionURI, direction);
    }

    public FunctionalComponent createFunctionalComponent(String displayId, AccessType access, String definitionId, DirectionType direction) throws SBOLValidationException {
        return this.createFunctionalComponent(displayId, access, definitionId, "", direction);
    }

    public FunctionalComponent createFunctionalComponent(String displayId, AccessType access, URI definitionURI, DirectionType direction) throws SBOLValidationException {
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && this.getSBOLDocument().getComponentDefinition(definitionURI) == null) {
            throw new SBOLValidationException("sbol-10604", this);
        }
        String URIprefix = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        URI functionalComponentURI = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        FunctionalComponent fc = this.createFunctionalComponent(functionalComponentURI, access, definitionURI, direction);
        fc.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        fc.setDisplayId(displayId);
        fc.setVersion(version);
        return fc;
    }

    private void addFunctionalComponent(FunctionalComponent functionalComponent) throws SBOLValidationException {
        functionalComponent.setSBOLDocument(this.getSBOLDocument());
        functionalComponent.setModuleDefinition(this);
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && functionalComponent.getDefinition() == null) {
            throw new SBOLValidationException("sbol-10604", functionalComponent);
        }
        this.addChildSafely(functionalComponent, this.functionalComponents, "functionalComponent", this.interactions, this.modules);
        for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
            if (this.getFunctionalComponent(mapsTo.getLocalURI()) == null) {
                throw new SBOLValidationException("sbol-10804", mapsTo);
            }
            mapsTo.setSBOLDocument(this.getSBOLDocument());
            mapsTo.setModuleDefinition(this);
            mapsTo.setComponentInstance(functionalComponent);
        }
    }

    private void addFunctionalComponentNoCheck(FunctionalComponent functionalComponent) throws SBOLValidationException {
        functionalComponent.setSBOLDocument(this.getSBOLDocument());
        functionalComponent.setModuleDefinition(this);
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && functionalComponent.getDefinition() == null) {
            throw new SBOLValidationException("sbol-10604", functionalComponent);
        }
        this.addChildSafely(functionalComponent, this.functionalComponents, "functionalComponent", this.interactions, this.modules);
    }

    private void checkMapsTosLocalURIs() throws SBOLValidationException {
        for (FunctionalComponent functionalComponent : this.getFunctionalComponents()) {
            for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
                if (this.getFunctionalComponent(mapsTo.getLocalURI()) == null) {
                    throw new SBOLValidationException("sbol-10804", mapsTo);
                }
                mapsTo.setSBOLDocument(this.getSBOLDocument());
                mapsTo.setModuleDefinition(this);
                mapsTo.setComponentInstance(functionalComponent);
            }
        }
    }

    public boolean removeFunctionalComponent(FunctionalComponent functionalComponent) throws SBOLValidationException {
        for (Interaction i : this.interactions.values()) {
            for (Participation p : i.getParticipations()) {
                if (!p.getParticipantURI().equals(functionalComponent.getIdentity())) continue;
                throw new SBOLValidationException("sbol-12003", p);
            }
        }
        for (FunctionalComponent c : this.functionalComponents.values()) {
            for (MapsTo mt : c.getMapsTos()) {
                if (!mt.getLocalURI().equals(functionalComponent.getIdentity())) continue;
                throw new SBOLValidationException("sbol-10804", mt);
            }
        }
        for (Module m : this.modules.values()) {
            for (MapsTo mt : m.getMapsTos()) {
                if (!mt.getLocalURI().equals(functionalComponent.getIdentity())) continue;
                throw new SBOLValidationException("sbol-10804", mt);
            }
        }
        if (this.getSBOLDocument() != null) {
            for (ModuleDefinition md : this.getSBOLDocument().getModuleDefinitions()) {
                for (Module m : md.getModules()) {
                    for (MapsTo mt : m.getMapsTos()) {
                        if (!mt.getRemoteURI().equals(functionalComponent.getIdentity())) continue;
                        throw new SBOLValidationException("sbol-10806", functionalComponent);
                    }
                }
            }
        }
        return this.removeChildSafely(functionalComponent, this.functionalComponents);
    }

    public FunctionalComponent getFunctionalComponent(String displayId) {
        try {
            return this.functionalComponents.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public FunctionalComponent getFunctionalComponent(URI functionalComponentURI) {
        return this.functionalComponents.get(functionalComponentURI);
    }

    public Set<FunctionalComponent> getFunctionalComponents() {
        return new HashSet<FunctionalComponent>(this.functionalComponents.values());
    }

    public void clearFunctionalComponents() throws SBOLValidationException {
        Object[] valueSetArray;
        for (Object functionalComponent : valueSetArray = this.functionalComponents.values().toArray()) {
            this.removeFunctionalComponent((FunctionalComponent)functionalComponent);
        }
    }

    void setFunctionalComponents(Set<FunctionalComponent> components) throws SBOLValidationException {
        this.clearFunctionalComponents();
        if (components == null) {
            return;
        }
        for (FunctionalComponent component : components) {
            this.addFunctionalComponentNoCheck(component);
        }
        this.checkMapsTosLocalURIs();
    }

    public boolean addModel(Model model) throws SBOLValidationException {
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && this.getSBOLDocument().getModel(model.getIdentity()) == null) {
            throw new SBOLValidationException("sbol-11608", model);
        }
        return this.addModel(model.getIdentity());
    }

    public boolean addModel(String modelId, String version) throws SBOLValidationException {
        URI modelURI = URIcompliance.createCompliantURI(this.getSBOLDocument().getDefaultURIprefix(), "mod", modelId, version, this.getSBOLDocument().isTypesInURIs());
        return this.addModel(modelURI);
    }

    public boolean addModel(String modelId) throws SBOLValidationException {
        return this.addModel(modelId, "");
    }

    public boolean addModel(URI modelURI) throws SBOLValidationException {
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && this.getSBOLDocument().getModel(modelURI) == null) {
            throw new SBOLValidationException("sbol-11608", this);
        }
        return this.models.add(modelURI);
    }

    public boolean removeModel(URI modelURI) {
        return this.models.remove(modelURI);
    }

    public void setModels(Set<URI> models) throws SBOLValidationException {
        this.clearModels();
        if (models == null) {
            return;
        }
        for (URI model : models) {
            this.addModel(model);
        }
    }

    public Set<URI> getModelURIs() {
        HashSet<URI> result = new HashSet<URI>();
        result.addAll(this.models);
        return result;
    }

    public Set<Model> getModels() {
        HashSet<Model> result = new HashSet<Model>();
        for (URI modelURI : this.models) {
            Model model = this.getSBOLDocument().getModel(modelURI);
            result.add(model);
        }
        return result;
    }

    public boolean containsModel(URI modelURI) {
        return this.models.contains(modelURI);
    }

    public void clearModels() {
        this.models.clear();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.functionalComponents == null ? 0 : this.functionalComponents.hashCode());
        result = 31 * result + (this.interactions == null ? 0 : this.interactions.hashCode());
        result = 31 * result + (this.models == null ? 0 : this.models.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.modules == null ? 0 : this.modules.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleDefinition other = (ModuleDefinition)obj;
        if (this.functionalComponents == null ? other.functionalComponents != null : !this.functionalComponents.equals(other.functionalComponents)) {
            return false;
        }
        if (this.interactions == null ? other.interactions != null : !this.interactions.equals(other.interactions)) {
            return false;
        }
        if (this.models == null ? other.models != null : !this.models.equals(other.models)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        return !(this.modules == null ? other.modules != null : !this.modules.equals(other.modules));
    }

    @Override
    ModuleDefinition deepCopy() throws SBOLValidationException {
        return new ModuleDefinition(this);
    }

    @Override
    ModuleDefinition copy(String URIprefix, String displayId, String version) throws SBOLValidationException {
        ModuleDefinition cloned = this.deepCopy();
        cloned.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        cloned.setDisplayId(displayId);
        cloned.setVersion(version);
        URI newIdentity = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        if (!this.getIdentity().equals(newIdentity)) {
            cloned.addWasDerivedFrom(this.getIdentity());
        } else {
            cloned.setWasDerivedFroms(this.getWasDerivedFroms());
        }
        cloned.setIdentity(newIdentity);
        int count = 0;
        for (FunctionalComponent component : cloned.getFunctionalComponents()) {
            if (!component.isSetDisplayId()) {
                component.setDisplayId("functionalComponent" + ++count);
            }
            component.updateCompliantURI(cloned.getPersistentIdentity().toString(), component.getDisplayId(), version);
            cloned.removeChildSafely(component, cloned.functionalComponents);
            cloned.addFunctionalComponent(component);
        }
        count = 0;
        for (Module module : cloned.getModules()) {
            if (!module.isSetDisplayId()) {
                module.setDisplayId("module" + ++count);
            }
            module.updateCompliantURI(cloned.getPersistentIdentity().toString(), module.getDisplayId(), version);
            cloned.removeChildSafely(module, cloned.modules);
            cloned.addModule(module);
        }
        count = 0;
        for (Interaction interaction : cloned.getInteractions()) {
            if (!interaction.isSetDisplayId()) {
                interaction.setDisplayId("interaction" + ++count);
            }
            interaction.updateCompliantURI(cloned.getPersistentIdentity().toString(), interaction.getDisplayId(), version);
            cloned.removeChildSafely(interaction, cloned.interactions);
            cloned.addInteraction(interaction);
        }
        return cloned;
    }

    @Override
    void checkDescendantsURIcompliance() throws SBOLValidationException {
        if (!this.getModules().isEmpty()) {
            for (Module module : this.getModules()) {
                try {
                    URIcompliance.isChildURIcompliant(this, module);
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException(e.getRule(), module);
                }
                if (module.getMapsTos().isEmpty()) continue;
                for (MapsTo mapsTo : module.getMapsTos()) {
                    try {
                        URIcompliance.isChildURIcompliant(module, mapsTo);
                    }
                    catch (SBOLValidationException e) {
                        throw new SBOLValidationException(e.getRule(), mapsTo);
                    }
                }
            }
        }
        if (!this.getFunctionalComponents().isEmpty()) {
            for (FunctionalComponent functionalComponent : this.getFunctionalComponents()) {
                try {
                    URIcompliance.isChildURIcompliant(this, functionalComponent);
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException(e.getRule(), functionalComponent);
                }
                if (functionalComponent.getMapsTos().isEmpty()) continue;
                for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
                    try {
                        URIcompliance.isChildURIcompliant(functionalComponent, mapsTo);
                    }
                    catch (SBOLValidationException e) {
                        throw new SBOLValidationException(e.getRule(), mapsTo);
                    }
                }
            }
        }
        if (!this.getInteractions().isEmpty()) {
            for (Interaction interaction : this.getInteractions()) {
                try {
                    URIcompliance.isChildURIcompliant(this, interaction);
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException(e.getRule(), interaction);
                }
                for (Participation participation : interaction.getParticipations()) {
                    try {
                        URIcompliance.isChildURIcompliant(interaction, participation);
                    }
                    catch (SBOLValidationException e) {
                        throw new SBOLValidationException(e.getRule(), participation);
                    }
                }
            }
        }
    }

    ModuleDefinition flatten(String URIprefix, String displayId, String version) throws SBOLValidationException {
        return this.flattenRecurse().copy(URIprefix, displayId, version);
    }

    private ModuleDefinition flattenRecurse() throws SBOLValidationException {
        ModuleDefinition flatModuleDefinition = this.deepCopy();
        for (Module module : this.getModules()) {
            ModuleDefinition flatModule = module.getDefinition().flattenRecurse();
            for (FunctionalComponent fc : flatModule.getFunctionalComponents()) {
                boolean foundIt = false;
                URI oldURI = fc.getIdentity();
                URI newURI = null;
                for (MapsTo mapsTo : module.getMapsTos()) {
                    if (!mapsTo.getRemoteURI().equals(fc.getIdentity())) continue;
                    newURI = mapsTo.getLocalURI();
                    FunctionalComponent topFc = flatModuleDefinition.getFunctionalComponent(newURI);
                    if (mapsTo.getRefinement() == RefinementType.USEREMOTE) {
                        topFc.setDefinition(fc.getDefinitionURI());
                    } else if (mapsTo.getRefinement() == RefinementType.VERIFYIDENTICAL) {
                        if (!topFc.getDefinitionURI().equals(fc.getDefinitionURI())) {
                            throw new SBOLValidationException("sbol-10811", mapsTo);
                        }
                    } else if (mapsTo.getRefinement() == RefinementType.MERGE) {
                        // empty if block
                    }
                    foundIt = true;
                    break;
                }
                if (!foundIt) {
                    FunctionalComponent newFC = fc.deepCopy();
                    newFC.updateCompliantURI(this.getPersistentIdentity().toString(), module.getDisplayId() + "__" + fc.getDisplayId(), this.getVersion());
                    newURI = newFC.getIdentity();
                    flatModuleDefinition.addFunctionalComponent(newFC);
                }
                for (Interaction i : flatModule.getInteractions()) {
                    for (Participation p : i.getParticipations()) {
                        if (!p.getParticipantURI().equals(oldURI)) continue;
                        p.setParticipant(newURI);
                    }
                }
            }
            for (Interaction i : flatModule.getInteractions()) {
                flatModuleDefinition.addInteraction(i.deepCopy());
            }
        }
        flatModuleDefinition.clearModules();
        return flatModuleDefinition;
    }

    @Override
    public String toString() {
        return "ModuleDefinition [" + super.toString() + (this.getRoles().size() > 0 ? ", roles=" + this.getRoles() : "") + (this.getFunctionalComponents().size() > 0 ? ", functionalComponents=" + this.getFunctionalComponents() : "") + (this.getModules().size() > 0 ? ", modules=" + this.getModules() : "") + (this.getInteractions().size() > 0 ? ", interactions=" + this.getInteractions() : "") + (this.getModels().size() > 0 ? ", models=" + this.getModelURIs() : "") + "]";
    }
}

