/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sbol2Terms;

public enum OrientationType {
    INLINE("inline"),
    REVERSECOMPLEMENT("reverseComplement");

    private final String orientationType;
    private static final URI inline;
    private static final URI reverseComplement;

    private OrientationType(String orientationType) {
        this.orientationType = orientationType;
    }

    public String toString() {
        return this.orientationType;
    }

    static OrientationType convertToOrientationType(URI orientation) throws SBOLValidationException {
        if (orientation != null) {
            if (orientation.equals(inline)) {
                return INLINE;
            }
            if (orientation.equals(reverseComplement)) {
                return REVERSECOMPLEMENT;
            }
            throw new SBOLValidationException("sbol-11002", new Identified[0]);
        }
        throw new SBOLValidationException("sbol-11002", new Identified[0]);
    }

    static URI convertToURI(OrientationType orientation) {
        if (orientation != null) {
            if (orientation.equals((Object)INLINE)) {
                return inline;
            }
            if (orientation.equals((Object)REVERSECOMPLEMENT)) {
                return reverseComplement;
            }
            return null;
        }
        return null;
    }

    static {
        inline = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "inline");
        reverseComplement = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "reverseComplement");
    }
}

