/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.FunctionalComponent;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.URIcompliance;

public class Participation
extends Identified {
    private Set<URI> roles = new HashSet<URI>();
    private URI participant;
    private ModuleDefinition moduleDefinition = null;

    Participation(URI identity, URI participant, Set<URI> roles) throws SBOLValidationException {
        super(identity);
        this.setParticipant(participant);
        this.setRoles(roles);
    }

    private Participation(Participation participation) throws SBOLValidationException {
        super(participation);
        for (URI role : participation.getRoles()) {
            this.addRole(URI.create(role.toString()));
        }
        this.setParticipant(participation.getParticipantURI());
    }

    void copy(Participation participation) throws SBOLValidationException {
        this.copy((Identified)participation);
    }

    public URI getParticipantURI() {
        return this.participant;
    }

    public FunctionalComponent getParticipant() {
        if (this.moduleDefinition == null) {
            return null;
        }
        return this.moduleDefinition.getFunctionalComponent(this.participant);
    }

    public ComponentDefinition getParticipantDefinition() {
        if (this.moduleDefinition != null) {
            return this.moduleDefinition.getFunctionalComponent(this.participant).getDefinition();
        }
        return null;
    }

    public void setParticipant(URI participant) throws SBOLValidationException {
        if (participant == null) {
            throw new SBOLValidationException("sbol-12002", this);
        }
        if (this.moduleDefinition != null && this.moduleDefinition.getFunctionalComponent(participant) == null) {
            throw new SBOLValidationException("sbol-12003", this);
        }
        this.participant = participant;
    }

    public boolean addRole(URI roleURI) {
        return this.roles.add(roleURI);
    }

    public boolean removeRole(URI roleURI) throws SBOLValidationException {
        if (this.roles.size() == 1 && this.roles.contains(roleURI)) {
            throw new SBOLValidationException("sbol-12004", this);
        }
        return this.roles.remove(roleURI);
    }

    public void setRoles(Set<URI> roles) throws SBOLValidationException {
        if (roles == null || roles.size() == 0) {
            throw new SBOLValidationException("sbol-12004", this);
        }
        this.clearRoles();
        for (URI role : roles) {
            this.addRole(role);
        }
    }

    public Set<URI> getRoles() {
        return this.roles;
    }

    public boolean containsRole(URI roleURI) {
        return this.roles.contains(roleURI);
    }

    private void clearRoles() {
        this.roles.clear();
    }

    @Override
    Participation deepCopy() throws SBOLValidationException {
        return new Participation(this);
    }

    void updateCompliantURI(String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!this.getIdentity().equals(URIcompliance.createCompliantURI(URIprefix, displayId, version))) {
            this.addWasDerivedFrom(this.getIdentity());
        }
        this.setIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, version));
        this.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        this.setDisplayId(displayId);
        this.setVersion(version);
    }

    void setModuleDefinition(ModuleDefinition moduleDefinition) {
        this.moduleDefinition = moduleDefinition;
    }

    @Override
    public String toString() {
        return "Participation [" + super.toString() + ", roles=" + this.roles + ", participant=" + this.participant + "]";
    }
}

