/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import javax.xml.namespace.QName;
import org.sbolstandard.core2.Annotation;
import org.sbolstandard.core2.Cut;
import org.sbolstandard.core2.Location;
import org.sbolstandard.core2.SBOLValidationException;

public class Range
extends Location {
    private int start = 0;
    private int end = 0;

    Range(URI identity, int start, int end) throws SBOLValidationException {
        super(identity);
        this.setEnd(end);
        this.setStart(start);
    }

    private Range(Range range) throws SBOLValidationException {
        super(range);
        this.setEnd(range.getEnd());
        this.setStart(range.getStart());
    }

    void copy(Range range) throws SBOLValidationException {
        this.copy((Location)range);
    }

    public void setStart(int value) throws SBOLValidationException {
        if (value <= 0) {
            throw new SBOLValidationException("sbol-11102", this);
        }
        if (value > this.end) {
            throw new SBOLValidationException("sbol-11104", this);
        }
        this.start = value;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int value) throws SBOLValidationException {
        if (value <= 0) {
            throw new SBOLValidationException("sbol-11103", this);
        }
        if (value < this.start) {
            throw new SBOLValidationException("sbol-11104", this);
        }
        this.end = value;
    }

    @Override
    Location deepCopy() throws SBOLValidationException {
        return new Range(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.end;
        result = 31 * result + (this.getOrientation() == null ? 0 : this.getOrientation().hashCode());
        result = 31 * result + this.start;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.getOrientation() != other.getOrientation()) {
            return false;
        }
        return this.start == other.start;
    }

    @Override
    public String toString() {
        return "Range [" + super.toString() + ", start=" + this.start + ", end=" + this.end + "]";
    }

    @Override
    public int compareTo(Location location) {
        int thisPos = -1;
        Annotation annotation = this.getAnnotation(new QName("http://www.ncbi.nlm.nih.gov/genbank#", "position", "genbank"));
        if (annotation != null) {
            thisPos = Integer.parseInt(annotation.getStringValue().replace("position", ""));
        }
        int otherPos = -1;
        annotation = location.getAnnotation(new QName("http://www.ncbi.nlm.nih.gov/genbank#", "position", "genbank"));
        if (annotation != null) {
            otherPos = Integer.parseInt(annotation.getStringValue().replace("position", ""));
        }
        if (thisPos != -1 && otherPos != -1) {
            int result = thisPos - otherPos;
            return result;
        }
        if (location instanceof Range) {
            int result = this.start - ((Range)location).getStart();
            if (result == 0) {
                result = this.end - ((Range)location).getEnd();
            }
            return result;
        }
        if (location instanceof Cut) {
            int result = this.start - ((Cut)location).getAt();
            if (result == 0) {
                result = this.end - ((Cut)location).getAt();
            }
            return result;
        }
        return -2147483647;
    }
}

