/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sbol2Terms;

public enum RefinementType {
    VERIFYIDENTICAL("verifyIdentical"),
    USELOCAL("useLocal"),
    USEREMOTE("useRemote"),
    MERGE("merge");

    private final String refinementType;
    private static final URI merge;
    private static final URI useLocal;
    private static final URI useRemote;
    private static final URI verifyIdentical;

    private RefinementType(String refinementType) {
        this.refinementType = refinementType;
    }

    public String toString() {
        return this.refinementType;
    }

    static RefinementType convertToRefinementType(URI refinement) throws SBOLValidationException {
        if (refinement != null) {
            if (refinement.equals(merge)) {
                return MERGE;
            }
            if (refinement.equals(useLocal)) {
                return USELOCAL;
            }
            if (refinement.equals(useRemote)) {
                return USEREMOTE;
            }
            if (refinement.equals(verifyIdentical)) {
                return VERIFYIDENTICAL;
            }
            throw new SBOLValidationException("sbol-10810", new Identified[0]);
        }
        throw new SBOLValidationException("sbol-10810", new Identified[0]);
    }

    static URI convertToURI(RefinementType refinement) {
        if (refinement != null) {
            if (refinement.equals((Object)MERGE)) {
                return merge;
            }
            if (refinement.equals((Object)USELOCAL)) {
                return useLocal;
            }
            if (refinement.equals((Object)USEREMOTE)) {
                return useRemote;
            }
            if (refinement.equals((Object)VERIFYIDENTICAL)) {
                return verifyIdentical;
            }
            return null;
        }
        return null;
    }

    static {
        merge = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "merge");
        useLocal = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "useLocal");
        useRemote = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "useRemote");
        verifyIdentical = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "verifyIdentical");
    }
}

