/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sbol2Terms;

public enum RestrictionType {
    PRECEDES("precedes"),
    SAME_ORIENTATION_AS("sameOrienationAs"),
    OPPOSITE_ORIENTATION_AS("oppositeOrienationAs");

    private final String restrictionType;
    private static final URI precedes;
    private static final URI sameOrientationAs;
    private static final URI oppositeOrientationAs;

    private RestrictionType(String restrictionType) {
        this.restrictionType = restrictionType;
    }

    public String toString() {
        return this.restrictionType;
    }

    static RestrictionType convertToRestrictionType(URI restriction) throws SBOLValidationException {
        if (restriction != null) {
            if (restriction.equals(precedes)) {
                return PRECEDES;
            }
            if (restriction.equals(sameOrientationAs)) {
                return SAME_ORIENTATION_AS;
            }
            if (restriction.equals(oppositeOrientationAs)) {
                return OPPOSITE_ORIENTATION_AS;
            }
            throw new SBOLValidationException("sbol-11412", new Identified[0]);
        }
        throw new SBOLValidationException("sbol-11412", new Identified[0]);
    }

    static URI convertToURI(RestrictionType restriction) throws SBOLValidationException {
        if (restriction != null) {
            if (restriction.equals((Object)PRECEDES)) {
                return precedes;
            }
            if (restriction.equals((Object)SAME_ORIENTATION_AS)) {
                return sameOrientationAs;
            }
            if (restriction.equals((Object)OPPOSITE_ORIENTATION_AS)) {
                return oppositeOrientationAs;
            }
            throw new SBOLValidationException("sbol-11412", new Identified[0]);
        }
        throw new SBOLValidationException("sbol-11412", new Identified[0]);
    }

    static {
        precedes = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "precedes");
        sameOrientationAs = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "sameOrientationAs");
        oppositeOrientationAs = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "oppositeOrientationAs");
    }
}

