/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sbol2Terms;

public enum RoleIntegrationType {
    OVERRIDEROLES("overrideRoles"),
    MERGEROLES("mergeRoles");

    private final String roleIntegrationType;
    private static final URI mergeRoles;
    private static final URI overrideRoles;

    private RoleIntegrationType(String roleIntegrationType) {
        this.roleIntegrationType = roleIntegrationType;
    }

    public String toString() {
        return this.roleIntegrationType;
    }

    static RoleIntegrationType convertToRoleIntegrationType(URI roleIntegration) throws SBOLValidationException {
        if (roleIntegration != null) {
            if (roleIntegration.equals(mergeRoles)) {
                return MERGEROLES;
            }
            if (roleIntegration.equals(overrideRoles)) {
                return OVERRIDEROLES;
            }
            throw new SBOLValidationException("sbol-10708", new Identified[0]);
        }
        throw new SBOLValidationException("sbol-10708", new Identified[0]);
    }

    static URI convertToURI(RoleIntegrationType refinement) {
        if (refinement != null) {
            if (refinement.equals((Object)MERGEROLES)) {
                return mergeRoles;
            }
            if (refinement.equals((Object)OVERRIDEROLES)) {
                return overrideRoles;
            }
            return null;
        }
        return null;
    }

    static {
        mergeRoles = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "mergeRoles");
        overrideRoles = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "overrideRoles");
    }
}

