/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.sbolstandard.core2.Annotation;
import org.sbolstandard.core2.Collection;
import org.sbolstandard.core2.Component;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.FunctionalComponent;
import org.sbolstandard.core2.GenericTopLevel;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.Interaction;
import org.sbolstandard.core2.Location;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.Model;
import org.sbolstandard.core2.Module;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.Participation;
import org.sbolstandard.core2.SBOLConversionException;
import org.sbolstandard.core2.SBOLReader;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.SBOLWriter;
import org.sbolstandard.core2.Sbol1Terms;
import org.sbolstandard.core2.Sbol2Terms;
import org.sbolstandard.core2.Sequence;
import org.sbolstandard.core2.SequenceAnnotation;
import org.sbolstandard.core2.SequenceConstraint;
import org.sbolstandard.core2.TopLevel;
import org.sbolstandard.core2.URIcompliance;
import org.sbolstandard.core2.Version;
import org.synbiohub.frontend.SynBioHubException;
import org.synbiohub.frontend.SynBioHubFrontend;
import uk.ac.ncl.intbio.core.datatree.Datatree;
import uk.ac.ncl.intbio.core.datatree.NamespaceBinding;

public class SBOLDocument {
    private HashMap<URI, GenericTopLevel> genericTopLevels = new HashMap();
    private HashMap<URI, Collection> collections = new HashMap();
    private HashMap<URI, ComponentDefinition> componentDefinitions = new HashMap();
    private HashMap<URI, Model> models = new HashMap();
    private HashMap<URI, ModuleDefinition> moduleDefinitions = new HashMap();
    private HashMap<URI, Sequence> sequences = new HashMap();
    private HashMap<String, NamespaceBinding> nameSpaces = new HashMap();
    private HashMap<String, SynBioHubFrontend> registries;
    private Set<String> prefixes;
    private String defaultURIprefix;
    private boolean complete = false;
    private boolean compliant = true;
    private boolean typesInURIs = false;
    private boolean createDefaults = false;
    public static final String TURTLE = "TURTLE";
    public static final String JSON = "JSON";
    public static final String RDFV1 = "RDFV1";
    public static final String RDF = "RDF";
    public static final String FASTAformat = "FASTA";
    public static final String GENBANK = "GENBANK";

    public SBOLDocument() {
        try {
            this.addNamespaceBinding(Sbol2Terms.sbol2);
            this.addNamespaceBinding(Sbol1Terms.rdf);
            this.addNamespaceBinding(Sbol2Terms.dc);
            this.addNamespaceBinding(Sbol2Terms.prov);
        }
        catch (SBOLValidationException e) {
            e.printStackTrace();
        }
        this.prefixes = new HashSet<String>();
        this.registries = new HashMap();
    }

    public ModuleDefinition createModuleDefinition(String displayId) throws SBOLValidationException {
        return this.createModuleDefinition(this.defaultURIprefix, displayId, "");
    }

    public ModuleDefinition createModuleDefinition(String displayId, String version) throws SBOLValidationException {
        return this.createModuleDefinition(this.defaultURIprefix, displayId, version);
    }

    public ModuleDefinition createModuleDefinition(String URIprefix, String displayId, String version) throws SBOLValidationException {
        URIprefix = URIcompliance.checkURIprefix(URIprefix);
        ModuleDefinition md = new ModuleDefinition(URIcompliance.createCompliantURI(URIprefix, "md", displayId, version, this.typesInURIs));
        md.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, "md", displayId, "", this.typesInURIs));
        md.setDisplayId(displayId);
        md.setVersion(version);
        this.addModuleDefinition(md);
        return md;
    }

    void addModuleDefinition(ModuleDefinition moduleDefinition) throws SBOLValidationException {
        this.addTopLevel(moduleDefinition, this.moduleDefinitions, "moduleDefinition", this.collections, this.componentDefinitions, this.genericTopLevels, this.models, this.sequences);
        for (FunctionalComponent functionalComponent : moduleDefinition.getFunctionalComponents()) {
            functionalComponent.setSBOLDocument(this);
            for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
                mapsTo.setSBOLDocument(this);
            }
        }
        for (Module module : moduleDefinition.getModules()) {
            module.setSBOLDocument(this);
            module.setModuleDefinition(moduleDefinition);
            for (MapsTo mapsTo : module.getMapsTos()) {
                mapsTo.setSBOLDocument(this);
            }
        }
        for (Interaction interaction : moduleDefinition.getInteractions()) {
            interaction.setSBOLDocument(this);
            interaction.setModuleDefinition(moduleDefinition);
            for (Participation participation : interaction.getParticipations()) {
                participation.setSBOLDocument(this);
                participation.setModuleDefinition(moduleDefinition);
            }
        }
    }

    public boolean removeModuleDefinition(ModuleDefinition moduleDefinition) throws SBOLValidationException {
        if (this.complete) {
            for (ModuleDefinition md : this.moduleDefinitions.values()) {
                for (Module m : md.getModules()) {
                    if (!m.getDefinitionURI().equals(moduleDefinition.getIdentity())) continue;
                    throw new SBOLValidationException("sbol-11703", new Identified[0]);
                }
            }
        }
        return this.removeTopLevel(moduleDefinition, this.moduleDefinitions);
    }

    public ModuleDefinition getModuleDefinition(String displayId, String version) {
        try {
            return this.getModuleDefinition(URIcompliance.createCompliantURI(this.defaultURIprefix, "md", displayId, version, this.typesInURIs));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public ModuleDefinition getModuleDefinition(URI moduleDefinitionURI) {
        ModuleDefinition moduleDefinition = this.moduleDefinitions.get(moduleDefinitionURI);
        if (moduleDefinition == null) {
            for (SynBioHubFrontend frontend : this.getRegistries()) {
                try {
                    SBOLDocument document = frontend.getSBOL(moduleDefinitionURI);
                    if (document == null) continue;
                    moduleDefinition = document.getModuleDefinition(moduleDefinitionURI);
                    this.createCopy(document);
                }
                catch (SBOLValidationException | SynBioHubException e) {
                    moduleDefinition = null;
                }
            }
        }
        return moduleDefinition;
    }

    public Set<ModuleDefinition> getModuleDefinitions() {
        HashSet<ModuleDefinition> moduleDefinitions = new HashSet<ModuleDefinition>();
        moduleDefinitions.addAll(this.moduleDefinitions.values());
        return moduleDefinitions;
    }

    public void clearModuleDefinitions() throws SBOLValidationException {
        Object[] valueSetArray;
        for (Object moduleDefinition : valueSetArray = this.moduleDefinitions.values().toArray()) {
            this.removeModuleDefinition((ModuleDefinition)moduleDefinition);
        }
    }

    public Collection createCollection(String displayId) throws SBOLValidationException {
        return this.createCollection(this.defaultURIprefix, displayId, "");
    }

    public Collection createCollection(String displayId, String version) throws SBOLValidationException {
        return this.createCollection(this.defaultURIprefix, displayId, version);
    }

    public Collection createCollection(String URIprefix, String displayId, String version) throws SBOLValidationException {
        URIprefix = URIcompliance.checkURIprefix(URIprefix);
        Collection c = new Collection(URIcompliance.createCompliantURI(URIprefix, "col", displayId, version, this.typesInURIs));
        c.setDisplayId(displayId);
        c.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, "col", displayId, "", this.typesInURIs));
        c.setVersion(version);
        this.addCollection(c);
        return c;
    }

    void addCollection(Collection collection) throws SBOLValidationException {
        this.addTopLevel(collection, this.collections, "collection", this.componentDefinitions, this.genericTopLevels, this.models, this.moduleDefinitions, this.sequences);
    }

    public boolean removeCollection(Collection collection) throws SBOLValidationException {
        return this.removeTopLevel(collection, this.collections);
    }

    public Collection getCollection(String displayId, String version) {
        try {
            return this.getCollection(URIcompliance.createCompliantURI(this.defaultURIprefix, "col", displayId, version, this.typesInURIs));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public Collection getCollection(URI collectionURI) {
        Collection collection = this.collections.get(collectionURI);
        if (collection == null) {
            for (SynBioHubFrontend frontend : this.getRegistries()) {
                try {
                    SBOLDocument document = frontend.getSBOL(collectionURI);
                    if (document == null) continue;
                    collection = document.getCollection(collectionURI);
                    this.createCopy(document);
                }
                catch (SBOLValidationException | SynBioHubException e) {
                    collection = null;
                }
            }
        }
        return collection;
    }

    public Set<Collection> getCollections() {
        HashSet<Collection> collections = new HashSet<Collection>();
        collections.addAll(this.collections.values());
        return collections;
    }

    public void clearCollections() throws SBOLValidationException {
        Object[] valueSetArray;
        for (Object collection : valueSetArray = this.collections.values().toArray()) {
            this.removeCollection((Collection)collection);
        }
    }

    public Model createModel(String displayId, URI source, URI language, URI framework) throws SBOLValidationException {
        return this.createModel(this.defaultURIprefix, displayId, "", source, language, framework);
    }

    public Model createModel(String displayId, String version, URI source, URI language, URI framework) throws SBOLValidationException {
        return this.createModel(this.defaultURIprefix, displayId, version, source, language, framework);
    }

    public Model createModel(String URIprefix, String displayId, String version, URI source, URI language, URI framework) throws SBOLValidationException {
        URIprefix = URIcompliance.checkURIprefix(URIprefix);
        Model model = new Model(URIcompliance.createCompliantURI(URIprefix, "mod", displayId, version, this.typesInURIs), source, language, framework);
        model.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, "mod", displayId, "", this.typesInURIs));
        model.setDisplayId(displayId);
        model.setVersion(version);
        this.addModel(model);
        return model;
    }

    void addModel(Model model) throws SBOLValidationException {
        this.addTopLevel(model, this.models, "model", this.collections, this.componentDefinitions, this.genericTopLevels, this.moduleDefinitions, this.sequences);
    }

    public boolean removeModel(Model model) throws SBOLValidationException {
        if (this.complete) {
            for (ModuleDefinition md : this.moduleDefinitions.values()) {
                if (!md.containsModel(model.getIdentity())) continue;
                throw new SBOLValidationException("sbol-11608", md);
            }
        }
        return this.removeTopLevel(model, this.models);
    }

    public Model getModel(String displayId, String version) {
        try {
            return this.getModel(URIcompliance.createCompliantURI(this.defaultURIprefix, "mod", displayId, version, this.typesInURIs));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public Model getModel(URI modelURI) {
        Model model = this.models.get(modelURI);
        if (model == null) {
            for (SynBioHubFrontend frontend : this.getRegistries()) {
                try {
                    SBOLDocument document = frontend.getSBOL(modelURI);
                    if (document == null) continue;
                    model = document.getModel(modelURI);
                    this.createCopy(document);
                }
                catch (SBOLValidationException | SynBioHubException e) {
                    model = null;
                }
            }
        }
        return model;
    }

    public Set<Model> getModels() {
        HashSet<Model> models = new HashSet<Model>();
        models.addAll(this.models.values());
        return models;
    }

    public void clearModels() throws SBOLValidationException {
        Object[] valueSetArray;
        for (Object model : valueSetArray = this.models.values().toArray()) {
            this.removeModel((Model)model);
        }
    }

    public ComponentDefinition createComponentDefinition(String displayId, Set<URI> types) throws SBOLValidationException {
        return this.createComponentDefinition(this.defaultURIprefix, displayId, "", types);
    }

    public ComponentDefinition createComponentDefinition(String displayId, URI type) throws SBOLValidationException {
        HashSet<URI> types = new HashSet<URI>();
        types.add(type);
        return this.createComponentDefinition(this.defaultURIprefix, displayId, "", types);
    }

    public ComponentDefinition createComponentDefinition(String displayId, String version, Set<URI> types) throws SBOLValidationException {
        return this.createComponentDefinition(this.defaultURIprefix, displayId, version, types);
    }

    public ComponentDefinition createComponentDefinition(String displayId, String version, URI type) throws SBOLValidationException {
        HashSet<URI> types = new HashSet<URI>();
        types.add(type);
        return this.createComponentDefinition(this.defaultURIprefix, displayId, version, types);
    }

    public ComponentDefinition createComponentDefinition(String URIprefix, String displayId, String version, Set<URI> types) throws SBOLValidationException {
        URIprefix = URIcompliance.checkURIprefix(URIprefix);
        ComponentDefinition cd = new ComponentDefinition(URIcompliance.createCompliantURI(URIprefix, "cd", displayId, version, this.typesInURIs), types);
        cd.setDisplayId(displayId);
        cd.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, "cd", displayId, "", this.typesInURIs));
        cd.setVersion(version);
        this.addComponentDefinition(cd);
        return cd;
    }

    public ComponentDefinition createComponentDefinition(String URIprefix, String displayId, String version, URI type) throws SBOLValidationException {
        HashSet<URI> types = new HashSet<URI>();
        types.add(type);
        return this.createComponentDefinition(URIprefix, displayId, version, types);
    }

    void addComponentDefinition(ComponentDefinition componentDefinition) throws SBOLValidationException {
        this.addTopLevel(componentDefinition, this.componentDefinitions, "componentDefinition", this.collections, this.genericTopLevels, this.models, this.moduleDefinitions, this.sequences);
        for (Component component : componentDefinition.getComponents()) {
            component.setSBOLDocument(this);
            for (MapsTo mapsTo : component.getMapsTos()) {
                mapsTo.setSBOLDocument(this);
            }
        }
        for (SequenceAnnotation sa : componentDefinition.getSequenceAnnotations()) {
            sa.setSBOLDocument(this);
            sa.setComponentDefinition(componentDefinition);
            for (Location location : sa.getLocations()) {
                location.setSBOLDocument(this);
            }
        }
        for (SequenceConstraint sc : componentDefinition.getSequenceConstraints()) {
            sc.setSBOLDocument(this);
            sc.setComponentDefinition(componentDefinition);
        }
    }

    public boolean removeComponentDefinition(ComponentDefinition componentDefinition) throws SBOLValidationException {
        if (this.complete) {
            for (ComponentDefinition cd : this.componentDefinitions.values()) {
                for (Component component : cd.getComponents()) {
                    if (!component.getDefinitionURI().equals(componentDefinition.getIdentity())) continue;
                    throw new SBOLValidationException("sbol-10604", component);
                }
            }
            for (ModuleDefinition md : this.moduleDefinitions.values()) {
                for (FunctionalComponent functionalComponent : md.getFunctionalComponents()) {
                    if (!functionalComponent.getDefinitionURI().equals(componentDefinition.getIdentity())) continue;
                    throw new SBOLValidationException("sbol-10604", functionalComponent);
                }
            }
        }
        return this.removeTopLevel(componentDefinition, this.componentDefinitions);
    }

    public ComponentDefinition getComponentDefinition(String displayId, String version) {
        try {
            return this.getComponentDefinition(URIcompliance.createCompliantURI(this.defaultURIprefix, "cd", displayId, version, this.typesInURIs));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public ComponentDefinition getComponentDefinition(URI componentDefinitionURI) {
        ComponentDefinition componentDefinition = this.componentDefinitions.get(componentDefinitionURI);
        if (componentDefinition == null) {
            for (SynBioHubFrontend frontend : this.getRegistries()) {
                try {
                    SBOLDocument document = frontend.getSBOL(componentDefinitionURI);
                    if (document == null) continue;
                    componentDefinition = document.getComponentDefinition(componentDefinitionURI);
                    this.createCopy(document);
                }
                catch (SBOLValidationException | SynBioHubException e) {
                    componentDefinition = null;
                }
            }
        }
        return componentDefinition;
    }

    public Set<ComponentDefinition> getComponentDefinitions() {
        HashSet<ComponentDefinition> components = new HashSet<ComponentDefinition>();
        components.addAll(this.componentDefinitions.values());
        return components;
    }

    public Set<ComponentDefinition> getRootComponentDefinitions() {
        Set<ComponentDefinition> componentDefs = this.getComponentDefinitions();
        for (ComponentDefinition componentDefinition : this.getComponentDefinitions()) {
            for (Component component : componentDefinition.getComponents()) {
                ComponentDefinition childDefinition = component.getDefinition();
                if (childDefinition == null || !componentDefs.contains(childDefinition)) continue;
                componentDefs.remove(childDefinition);
            }
        }
        return componentDefs;
    }

    public Set<ModuleDefinition> getRootModuleDefinitions() {
        Set<ModuleDefinition> moduleDefs = this.getModuleDefinitions();
        for (ModuleDefinition moduleDefinition : this.getModuleDefinitions()) {
            for (Module module : moduleDefinition.getModules()) {
                ModuleDefinition childDefinition = module.getDefinition();
                if (childDefinition == null || !moduleDefs.contains(childDefinition)) continue;
                moduleDefs.remove(childDefinition);
            }
        }
        return moduleDefs;
    }

    public void clearComponentDefinitions() throws SBOLValidationException {
        Object[] valueSetArray;
        for (Object componentDefinition : valueSetArray = this.componentDefinitions.values().toArray()) {
            this.removeComponentDefinition((ComponentDefinition)componentDefinition);
        }
    }

    public Sequence createSequence(String displayId, String elements, URI encoding) throws SBOLValidationException {
        return this.createSequence(this.defaultURIprefix, displayId, "", elements, encoding);
    }

    public Sequence createSequence(String displayId, String version, String elements, URI encoding) throws SBOLValidationException {
        return this.createSequence(this.defaultURIprefix, displayId, version, elements, encoding);
    }

    public Sequence createSequence(String URIprefix, String displayId, String version, String elements, URI encoding) throws SBOLValidationException {
        URIprefix = URIcompliance.checkURIprefix(URIprefix);
        Sequence s = new Sequence(URIcompliance.createCompliantURI(URIprefix, "seq", displayId, version, this.typesInURIs), elements, encoding);
        s.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, "seq", displayId, "", this.typesInURIs));
        s.setDisplayId(displayId);
        s.setVersion(version);
        this.addSequence(s);
        return s;
    }

    public void createCopy(SBOLDocument document) throws SBOLValidationException {
        for (TopLevel topLevel : document.getTopLevels()) {
            this.createCopy(topLevel);
        }
    }

    public TopLevel createCopy(TopLevel topLevel) throws SBOLValidationException {
        return this.createCopy(topLevel, null, null, null);
    }

    public TopLevel createCopy(TopLevel topLevel, String displayId) throws SBOLValidationException {
        return this.createCopy(topLevel, this.defaultURIprefix, displayId, "");
    }

    public TopLevel rename(TopLevel topLevel, String displayId) throws SBOLValidationException {
        return this.rename(topLevel, this.defaultURIprefix, displayId, "");
    }

    public TopLevel createCopy(TopLevel topLevel, String displayId, String version) throws SBOLValidationException {
        return this.createCopy(topLevel, this.defaultURIprefix, displayId, version);
    }

    public TopLevel rename(TopLevel topLevel, String displayId, String version) throws SBOLValidationException {
        return this.rename(topLevel, this.defaultURIprefix, displayId, version);
    }

    public TopLevel createCopy(TopLevel topLevel, String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (URIprefix == null) {
            URIprefix = URIcompliance.extractURIprefix(topLevel.getIdentity());
            URIprefix = URIcompliance.checkURIprefix(URIprefix);
        } else {
            URIprefix = URIcompliance.checkURIprefix(URIprefix);
        }
        if (displayId == null && (displayId = topLevel.getDisplayId()) == null) {
            displayId = URIcompliance.extractDisplayId(topLevel.getIdentity());
        }
        if (version == null) {
            version = topLevel.getVersion();
        }
        if (topLevel instanceof Collection) {
            Collection newCollection = this.createCollection(URIprefix, displayId, version);
            newCollection.copy((Collection)topLevel);
            return newCollection;
        }
        if (topLevel instanceof ComponentDefinition) {
            ComponentDefinition newComponentDefinition = this.createComponentDefinition(URIprefix, displayId, version, ((ComponentDefinition)topLevel).getTypes());
            newComponentDefinition.copy((ComponentDefinition)topLevel);
            return newComponentDefinition;
        }
        if (topLevel instanceof Model) {
            Model newModel = this.createModel(URIprefix, displayId, version, ((Model)topLevel).getSource(), ((Model)topLevel).getLanguage(), ((Model)topLevel).getFramework());
            newModel.copy((Model)topLevel);
            return newModel;
        }
        if (topLevel instanceof ModuleDefinition) {
            ModuleDefinition newModuleDefinition = this.createModuleDefinition(URIprefix, displayId, version);
            newModuleDefinition.copy((ModuleDefinition)topLevel);
            return newModuleDefinition;
        }
        if (topLevel instanceof Sequence) {
            Sequence newSequence = this.createSequence(URIprefix, displayId, version, ((Sequence)topLevel).getElements(), ((Sequence)topLevel).getEncoding());
            newSequence.copy((Sequence)topLevel);
            return newSequence;
        }
        if (topLevel instanceof GenericTopLevel) {
            GenericTopLevel newGenericTopLevel = this.createGenericTopLevel(URIprefix, displayId, version, ((GenericTopLevel)topLevel).getRDFType());
            newGenericTopLevel.copy((GenericTopLevel)topLevel);
            return newGenericTopLevel;
        }
        throw new IllegalArgumentException("Unable to copy " + topLevel.getIdentity());
    }

    public SBOLDocument createRecursiveCopy(TopLevel topLevel) throws SBOLValidationException {
        SBOLDocument document = new SBOLDocument();
        this.createRecursiveCopy(document, topLevel);
        return document;
    }

    private void createRecursiveCopy(SBOLDocument document, Annotation annotation) throws SBOLValidationException {
        if (annotation.isURIValue()) {
            TopLevel gtl = this.getTopLevel(annotation.getURIValue());
            if (gtl != null) {
                this.createRecursiveCopy(document, gtl);
            }
        } else if (annotation.isNestedAnnotations()) {
            for (Annotation nestedAnnotation : annotation.getAnnotations()) {
                this.createRecursiveCopy(document, nestedAnnotation);
            }
        }
    }

    private void createRecursiveCopy(SBOLDocument document, TopLevel topLevel) throws SBOLValidationException {
        if (document.getTopLevel(topLevel.getIdentity()) != null) {
            return;
        }
        if (topLevel instanceof GenericTopLevel || topLevel instanceof Sequence || topLevel instanceof Model) {
            document.createCopy(topLevel);
        } else if (topLevel instanceof Collection) {
            for (TopLevel topLevel2 : ((Collection)topLevel).getMembers()) {
                this.createRecursiveCopy(document, topLevel2);
            }
            document.createCopy(topLevel);
        } else if (topLevel instanceof ComponentDefinition) {
            for (Component component : ((ComponentDefinition)topLevel).getComponents()) {
                if (component.getDefinition() == null) continue;
                this.createRecursiveCopy(document, component.getDefinition());
            }
            for (TopLevel topLevel3 : ((ComponentDefinition)topLevel).getSequences()) {
                this.createRecursiveCopy(document, topLevel3);
            }
            document.createCopy(topLevel);
        } else if (topLevel instanceof ModuleDefinition) {
            for (FunctionalComponent functionalComponent : ((ModuleDefinition)topLevel).getFunctionalComponents()) {
                if (functionalComponent.getDefinition() == null) continue;
                this.createRecursiveCopy(document, functionalComponent.getDefinition());
            }
            for (Module module : ((ModuleDefinition)topLevel).getModules()) {
                if (module.getDefinition() == null) continue;
                this.createRecursiveCopy(document, module.getDefinition());
            }
            for (Model model : ((ModuleDefinition)topLevel).getModels()) {
                if (document.getModel(model.getIdentity()) != null) continue;
                document.createCopy(model);
            }
            document.createCopy(topLevel);
        }
        for (Annotation annotation : topLevel.getAnnotations()) {
            if (annotation.isURIValue()) {
                TopLevel gtl = this.getTopLevel(annotation.getURIValue());
                if (gtl == null) continue;
                this.createRecursiveCopy(document, gtl);
                continue;
            }
            if (!annotation.isNestedAnnotations()) continue;
            for (Annotation nestedAnnotation : annotation.getAnnotations()) {
                this.createRecursiveCopy(document, nestedAnnotation);
            }
        }
    }

    private String extractDocumentURIPrefix() {
        String documentURIPrefix = "";
        for (TopLevel topLevel : this.getTopLevels()) {
            if (documentURIPrefix.equals("")) {
                documentURIPrefix = URIcompliance.extractURIprefix(topLevel.getIdentity());
                continue;
            }
            for (int i = 0; i < documentURIPrefix.length(); ++i) {
                if (i < topLevel.getIdentity().toString().length() && documentURIPrefix.charAt(i) == topLevel.getIdentity().toString().charAt(i)) continue;
                if (i == 0) {
                    documentURIPrefix = "";
                    break;
                }
                documentURIPrefix = documentURIPrefix.substring(0, i);
                break;
            }
            if (!documentURIPrefix.equals("")) continue;
            break;
        }
        return documentURIPrefix;
    }

    private void fixDocumentURIPrefix() throws SBOLValidationException {
        String documentURIPrefix = this.extractDocumentURIPrefix();
        this.setDefaultURIprefix(documentURIPrefix);
        for (TopLevel topLevel : this.getTopLevels()) {
            if (topLevel.getIdentity().equals(URIcompliance.createCompliantURI(documentURIPrefix, topLevel.getDisplayId(), topLevel.getVersion()))) continue;
            String newDisplayId = topLevel.getIdentity().toString().replaceAll(documentURIPrefix, "");
            String newVersion = "";
            if (topLevel.isSetVersion()) {
                newDisplayId = newDisplayId.replace("/" + topLevel.getVersion(), "");
                newVersion = topLevel.getVersion();
            }
            newDisplayId = newDisplayId.replaceAll("/", "_");
            while (this.getTopLevel(URIcompliance.createCompliantURI(documentURIPrefix, newDisplayId, newVersion)) != null) {
                newDisplayId = newDisplayId.replaceAll("_", "__");
            }
            TopLevel newTopLevel = this.createCopy(topLevel, newDisplayId, newVersion);
            this.removeTopLevel(topLevel);
            this.updateReferences(topLevel.getIdentity(), newTopLevel.getIdentity());
            this.updateReferences(topLevel.getPersistentIdentity(), newTopLevel.getPersistentIdentity());
        }
    }

    private void updateReferences(List<Annotation> annotations, URI originalIdentity, URI newIdentity) {
        for (Annotation annotation : annotations) {
            if (annotation.isURIValue()) {
                if (!annotation.getURIValue().equals(originalIdentity)) continue;
                annotation.setURIValue(newIdentity);
                continue;
            }
            if (!annotation.isNestedAnnotations()) continue;
            this.updateReferences(annotation.getAnnotations(), originalIdentity, newIdentity);
        }
    }

    private void updateReferences(Identified identified, URI originalIdentity, URI newIdentity) {
        this.updateReferences(identified.getAnnotations(), originalIdentity, newIdentity);
    }

    private void updateReferences(URI originalIdentity, URI newIdentity) throws SBOLValidationException {
        URI newURI;
        String displayId;
        ComponentDefinition cd;
        for (Collection collection : this.getCollections()) {
            for (URI memberURI : collection.getMemberURIs()) {
                if (!memberURI.equals(originalIdentity)) continue;
                collection.removeMember(originalIdentity);
                collection.addMember(newIdentity);
            }
            this.updateReferences(collection, originalIdentity, newIdentity);
        }
        for (ComponentDefinition componentDefinition : this.getComponentDefinitions()) {
            this.updateReferences(componentDefinition, originalIdentity, newIdentity);
            for (Component component : componentDefinition.getComponents()) {
                if (component.getDefinitionURI().equals(originalIdentity)) {
                    component.setDefinition(newIdentity);
                    for (MapsTo mapsTo : component.getMapsTos()) {
                        cd = this.getComponentDefinition(newIdentity);
                        if (cd == null) continue;
                        displayId = URIcompliance.extractDisplayId(mapsTo.getRemoteURI());
                        newURI = URIcompliance.createCompliantURI(cd.getPersistentIdentity().toString(), displayId, cd.getVersion());
                        mapsTo.setRemote(newURI);
                    }
                }
                this.updateReferences(component, originalIdentity, newIdentity);
                for (MapsTo mapsTo : component.getMapsTos()) {
                    this.updateReferences(mapsTo, originalIdentity, newIdentity);
                }
            }
            for (SequenceAnnotation sa : componentDefinition.getSequenceAnnotations()) {
                for (Location loc : sa.getLocations()) {
                    this.updateReferences(loc, originalIdentity, newIdentity);
                }
                this.updateReferences(sa, originalIdentity, newIdentity);
            }
            for (SequenceConstraint sc : componentDefinition.getSequenceConstraints()) {
                this.updateReferences(sc, originalIdentity, newIdentity);
            }
            for (URI sequenceURI : componentDefinition.getSequenceURIs()) {
                if (!sequenceURI.equals(originalIdentity)) continue;
                componentDefinition.removeSequence(originalIdentity);
                componentDefinition.addSequence(newIdentity);
            }
        }
        for (ModuleDefinition moduleDefinition : this.getModuleDefinitions()) {
            this.updateReferences(moduleDefinition, originalIdentity, newIdentity);
            for (FunctionalComponent functionalComponent : moduleDefinition.getFunctionalComponents()) {
                if (functionalComponent.getDefinitionURI().equals(originalIdentity)) {
                    functionalComponent.setDefinition(newIdentity);
                    for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
                        cd = this.getComponentDefinition(newIdentity);
                        if (cd == null) continue;
                        displayId = URIcompliance.extractDisplayId(mapsTo.getRemoteURI());
                        newURI = URIcompliance.createCompliantURI(cd.getPersistentIdentity().toString(), displayId, cd.getVersion());
                        mapsTo.setRemote(newURI);
                    }
                }
                this.updateReferences(functionalComponent, originalIdentity, newIdentity);
                for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
                    this.updateReferences(mapsTo, originalIdentity, newIdentity);
                }
            }
            for (Module module : moduleDefinition.getModules()) {
                if (module.getDefinitionURI().equals(originalIdentity)) {
                    module.setDefinition(newIdentity);
                    for (MapsTo mapsTo : module.getMapsTos()) {
                        ModuleDefinition md = this.getModuleDefinition(newIdentity);
                        if (md == null) continue;
                        displayId = URIcompliance.extractDisplayId(mapsTo.getRemoteURI());
                        newURI = URIcompliance.createCompliantURI(md.getPersistentIdentity().toString(), displayId, md.getVersion());
                        mapsTo.setRemote(newURI);
                    }
                }
                this.updateReferences(module, originalIdentity, newIdentity);
                for (MapsTo mapsTo : module.getMapsTos()) {
                    this.updateReferences(mapsTo, originalIdentity, newIdentity);
                }
            }
            for (Interaction interaction : moduleDefinition.getInteractions()) {
                this.updateReferences(interaction, originalIdentity, newIdentity);
                for (Participation participation : interaction.getParticipations()) {
                    this.updateReferences(participation, originalIdentity, newIdentity);
                }
            }
            for (URI modelURI : moduleDefinition.getModelURIs()) {
                if (!modelURI.equals(originalIdentity)) continue;
                moduleDefinition.removeModel(originalIdentity);
                moduleDefinition.addModel(newIdentity);
            }
        }
        for (Model model : this.getModels()) {
            this.updateReferences(model, originalIdentity, newIdentity);
        }
        for (Sequence sequence : this.getSequences()) {
            this.updateReferences(sequence, originalIdentity, newIdentity);
        }
        for (GenericTopLevel genericTopLevel : this.getGenericTopLevels()) {
            this.updateReferences(genericTopLevel, originalIdentity, newIdentity);
        }
    }

    private void changeURIPrefixVersion(List<Annotation> annotations, String URIPrefix, String version) throws SBOLValidationException {
        for (Annotation annotation : annotations) {
            if (annotation.isURIValue()) {
                TopLevel topLevel = this.getTopLevel(annotation.getURIValue());
                if (topLevel == null) continue;
                annotation.setURIValue(URIcompliance.createCompliantURI(URIPrefix, topLevel.getDisplayId() != null ? topLevel.getDisplayId() : URIcompliance.extractDisplayId(topLevel.getIdentity()), version != null ? version : topLevel.getVersion()));
                continue;
            }
            if (!annotation.isNestedAnnotations()) continue;
            URI nestedURI = annotation.getNestedIdentity();
            URI newURI = nestedURI.toString().startsWith(URIPrefix) ? URI.create(nestedURI.toString() + "/" + version) : URI.create(nestedURI.toString().replace("http://", URIPrefix) + "/" + version);
            annotation.setNestedIdentity(newURI);
            List<Annotation> nestedAnnotations = annotation.getAnnotations();
            this.changeURIPrefixVersion(nestedAnnotations, URIPrefix, version);
            annotation.setAnnotations(nestedAnnotations);
        }
    }

    private void changeURIPrefixVersion(Identified identified, String URIPrefix, String version) throws SBOLValidationException {
        if (URIPrefix == null) {
            URIPrefix = URIcompliance.extractURIprefix(identified.getIdentity());
            URIPrefix = URIcompliance.checkURIprefix(URIPrefix);
        }
        this.changeURIPrefixVersion(identified.getAnnotations(), URIPrefix, version);
    }

    public SBOLDocument changeURIPrefixVersion(String URIPrefix, String version) throws SBOLValidationException {
        SBOLDocument document = new SBOLDocument();
        document.createCopy(this);
        document.fixDocumentURIPrefix();
        for (TopLevel topLevel : document.getTopLevels()) {
            document.rename(topLevel, URIPrefix, null, version);
        }
        for (TopLevel topLevel : document.getTopLevels()) {
            document.changeURIPrefixVersion(topLevel, URIPrefix, version);
        }
        document.setDefaultURIprefix(URIPrefix);
        return document;
    }

    public TopLevel rename(TopLevel topLevel, String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!(URIprefix != null && !URIcompliance.extractURIprefix(topLevel.getIdentity()).equals(URIprefix) || displayId != null && !topLevel.getDisplayId().equals(displayId) || version != null && !topLevel.getVersion().equals(version))) {
            return topLevel;
        }
        TopLevel renamedTopLevel = this.createCopy(topLevel, URIprefix, displayId, version);
        this.removeTopLevel(topLevel);
        this.updateReferences(topLevel.getIdentity(), renamedTopLevel.getIdentity());
        this.updateReferences(topLevel.getPersistentIdentity(), renamedTopLevel.getPersistentIdentity());
        return renamedTopLevel;
    }

    void addSequence(Sequence sequence) throws SBOLValidationException {
        this.addTopLevel(sequence, this.sequences, "sequence", this.collections, this.componentDefinitions, this.genericTopLevels, this.models, this.moduleDefinitions);
    }

    public boolean removeSequence(Sequence sequence) throws SBOLValidationException {
        if (this.complete) {
            for (ComponentDefinition cd : this.componentDefinitions.values()) {
                if (!cd.containsSequence(sequence.getIdentity())) continue;
                throw new SBOLValidationException("sbol-10513", cd);
            }
        }
        return this.removeTopLevel(sequence, this.sequences);
    }

    public Sequence getSequence(String displayId, String version) {
        try {
            return this.getSequence(URIcompliance.createCompliantURI(this.defaultURIprefix, "seq", displayId, version, this.typesInURIs));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public Sequence getSequence(URI sequenceURI) {
        Sequence sequence = this.sequences.get(sequenceURI);
        if (sequence == null) {
            for (SynBioHubFrontend frontend : this.getRegistries()) {
                try {
                    SBOLDocument document = frontend.getSBOL(sequenceURI);
                    if (document == null) continue;
                    sequence = document.getSequence(sequenceURI);
                    this.createCopy(document);
                }
                catch (SBOLValidationException | SynBioHubException e) {
                    sequence = null;
                }
            }
        }
        return sequence;
    }

    public Set<Sequence> getSequences() {
        HashSet<Sequence> structures = new HashSet<Sequence>();
        structures.addAll(this.sequences.values());
        return structures;
    }

    public void clearSequences() throws SBOLValidationException {
        Object[] valueSetArray;
        for (Object sequence : valueSetArray = this.sequences.values().toArray()) {
            this.removeSequence((Sequence)sequence);
        }
    }

    public GenericTopLevel createGenericTopLevel(String displayId, QName rdfType) throws SBOLValidationException {
        return this.createGenericTopLevel(this.defaultURIprefix, displayId, "", rdfType);
    }

    public GenericTopLevel createGenericTopLevel(String displayId, String version, QName rdfType) throws SBOLValidationException {
        return this.createGenericTopLevel(this.defaultURIprefix, displayId, version, rdfType);
    }

    public GenericTopLevel createGenericTopLevel(String URIprefix, String displayId, String version, QName rdfType) throws SBOLValidationException {
        URIprefix = URIcompliance.checkURIprefix(URIprefix);
        if (rdfType.getNamespaceURI().equals(Sbol2Terms.sbol2.getNamespaceURI()) || rdfType.getNamespaceURI().equals(Sbol1Terms.sbol1.getNamespaceURI())) {
            throw new SBOLValidationException("sbol-12302", new Identified[0]);
        }
        GenericTopLevel g = new GenericTopLevel(URIcompliance.createCompliantURI(URIprefix, "gen", displayId, version, this.typesInURIs), rdfType);
        g.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, "gen", displayId, "", this.typesInURIs));
        g.setDisplayId(displayId);
        g.setVersion(version);
        this.addGenericTopLevel(g);
        return g;
    }

    void addGenericTopLevel(GenericTopLevel genericTopLevel) throws SBOLValidationException {
        QName qNameInNamespace = this.getNamespace(URI.create(genericTopLevel.getRDFType().getNamespaceURI()));
        if (qNameInNamespace == null) {
            String prefix = genericTopLevel.getRDFType().getPrefix();
            if (this.getNamespace(prefix) != null) {
                prefix = this.getNamespacePrefix(URI.create(genericTopLevel.getRDFType().getNamespaceURI()));
                genericTopLevel.setRDFType(new QName(genericTopLevel.getRDFType().getNamespaceURI(), genericTopLevel.getRDFType().getLocalPart(), prefix));
            } else {
                this.addNamespace(URI.create(genericTopLevel.getRDFType().getNamespaceURI()), genericTopLevel.getRDFType().getPrefix());
            }
        } else if (genericTopLevel.getRDFType().getPrefix() != qNameInNamespace.getPrefix()) {
            genericTopLevel.setRDFType(new QName(genericTopLevel.getRDFType().getNamespaceURI(), genericTopLevel.getRDFType().getLocalPart(), qNameInNamespace.getPrefix()));
        }
        this.addTopLevel(genericTopLevel, this.genericTopLevels, "genericTopLevel", this.collections, this.componentDefinitions, this.models, this.moduleDefinitions, this.sequences);
    }

    public boolean removeGenericTopLevel(GenericTopLevel genericTopLevel) throws SBOLValidationException {
        return this.removeTopLevel(genericTopLevel, this.genericTopLevels);
    }

    public GenericTopLevel getGenericTopLevel(String displayId, String version) {
        try {
            return this.getGenericTopLevel(URIcompliance.createCompliantURI(this.defaultURIprefix, "gen", displayId, version, this.typesInURIs));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public GenericTopLevel getGenericTopLevel(URI genericTopLevelURI) {
        GenericTopLevel genericTopLevel = this.genericTopLevels.get(genericTopLevelURI);
        if (genericTopLevel == null) {
            for (SynBioHubFrontend frontend : this.getRegistries()) {
                try {
                    SBOLDocument document = frontend.getSBOL(genericTopLevelURI);
                    if (document == null) continue;
                    genericTopLevel = document.getGenericTopLevel(genericTopLevelURI);
                    this.createCopy(document);
                }
                catch (SBOLValidationException | SynBioHubException e) {
                    genericTopLevel = null;
                }
            }
        }
        return genericTopLevel;
    }

    public Set<GenericTopLevel> getGenericTopLevels() {
        HashSet<GenericTopLevel> topLevels = new HashSet<GenericTopLevel>();
        topLevels.addAll(this.genericTopLevels.values());
        return topLevels;
    }

    public void clearGenericTopLevels() throws SBOLValidationException {
        Object[] valueSetArray;
        for (Object genericTopLevel : valueSetArray = this.genericTopLevels.values().toArray()) {
            this.removeGenericTopLevel((GenericTopLevel)genericTopLevel);
        }
    }

    public TopLevel getTopLevel(URI topLevelURI) {
        TopLevel topLevel = this.collections.get(topLevelURI);
        if (topLevel != null) {
            return topLevel;
        }
        topLevel = this.moduleDefinitions.get(topLevelURI);
        if (topLevel != null) {
            return topLevel;
        }
        topLevel = this.models.get(topLevelURI);
        if (topLevel != null) {
            return topLevel;
        }
        topLevel = this.componentDefinitions.get(topLevelURI);
        if (topLevel != null) {
            return topLevel;
        }
        topLevel = this.sequences.get(topLevelURI);
        if (topLevel != null) {
            return topLevel;
        }
        topLevel = this.genericTopLevels.get(topLevelURI);
        if (topLevel != null) {
            return topLevel;
        }
        if (topLevel == null) {
            for (SynBioHubFrontend frontend : this.getRegistries()) {
                try {
                    SBOLDocument document = frontend.getSBOL(topLevelURI);
                    if (document == null) continue;
                    topLevel = document.getTopLevel(topLevelURI);
                    this.createCopy(document);
                }
                catch (SBOLValidationException | SynBioHubException e) {
                    topLevel = null;
                }
            }
        }
        return null;
    }

    public Set<TopLevel> getTopLevels() {
        HashSet<TopLevel> topLevels = new HashSet<TopLevel>();
        for (Collection collection : this.collections.values()) {
            topLevels.add(collection);
        }
        for (Sequence sequence : this.sequences.values()) {
            topLevels.add(sequence);
        }
        for (Model model : this.models.values()) {
            topLevels.add(model);
        }
        for (GenericTopLevel genericTopLevel : this.genericTopLevels.values()) {
            topLevels.add(genericTopLevel);
        }
        for (ComponentDefinition componentDefinition : this.componentDefinitions.values()) {
            topLevels.add(componentDefinition);
        }
        for (ModuleDefinition moduleDefinition : this.moduleDefinitions.values()) {
            topLevels.add(moduleDefinition);
        }
        return topLevels;
    }

    public Set<TopLevel> getByWasDerivedFrom(URI wasDerivedFrom) {
        HashSet<TopLevel> topLevels = new HashSet<TopLevel>();
        for (TopLevel topLevel : this.getTopLevels()) {
            for (URI wdf : topLevel.getWasDerivedFroms()) {
                if (!wdf.equals(wasDerivedFrom)) continue;
                topLevels.add(topLevel);
            }
        }
        return topLevels;
    }

    public SynBioHubFrontend addRegistry(String registryURL) {
        SynBioHubFrontend stackFrontend = new SynBioHubFrontend(registryURL);
        this.registries.put(registryURL, stackFrontend);
        return stackFrontend;
    }

    public SynBioHubFrontend addRegistry(String registryURL, String uriPrefix) {
        SynBioHubFrontend stackFrontend = new SynBioHubFrontend(registryURL, uriPrefix);
        this.registries.put(registryURL, stackFrontend);
        return stackFrontend;
    }

    public void addNamespace(URI nameSpaceURI, String prefix) throws SBOLValidationException {
        this.addNamespaceBinding(Datatree.NamespaceBinding((String)nameSpaceURI.toString(), (String)prefix));
    }

    public void addNamespace(QName qName) throws SBOLValidationException {
        this.addNamespaceBinding(Datatree.NamespaceBinding((String)qName.getNamespaceURI(), (String)qName.getPrefix()));
    }

    void addNamespaceBinding(NamespaceBinding namespaceBinding) throws SBOLValidationException {
        if (!(namespaceBinding.getNamespaceURI().endsWith("#") || namespaceBinding.getNamespaceURI().endsWith(":") || namespaceBinding.getNamespaceURI().endsWith("/"))) {
            throw new SBOLValidationException("sbol-10105", new Identified[0]);
        }
        this.nameSpaces.put(namespaceBinding.getPrefix(), namespaceBinding);
    }

    public void clearNamespaces() {
        Object[] keySetArray;
        for (Object key : keySetArray = this.nameSpaces.keySet().toArray()) {
            if (this.isRequiredNamespaceBinding(URI.create((String)key))) continue;
            this.nameSpaces.remove((String)key);
        }
    }

    public void clearRegistries() {
        Object[] keySetArray;
        for (Object key : keySetArray = this.registries.keySet().toArray()) {
            this.removeRegistry((String)key);
        }
    }

    String getNamespacePrefix(URI namespaceURI) {
        QName qName = this.getNamespace(namespaceURI);
        int nsNum = 0;
        if (qName == null) {
            boolean foundIt;
            do {
                foundIt = false;
                if (!this.nameSpaces.keySet().contains("ns" + nsNum)) continue;
                ++nsNum;
                foundIt = true;
                break;
            } while (foundIt);
            this.nameSpaces.put("ns" + nsNum, Datatree.NamespaceBinding((String)namespaceURI.toString(), (String)("ns" + nsNum)));
            return "ns" + nsNum;
        }
        return qName.getPrefix();
    }

    public QName getNamespace(String namespacePrefix) {
        NamespaceBinding namespaceBinding = this.nameSpaces.get(namespacePrefix);
        if (namespaceBinding == null) {
            return null;
        }
        return new QName(namespaceBinding.getNamespaceURI(), "", namespaceBinding.getPrefix());
    }

    public QName getNamespace(URI namespaceURI) {
        for (NamespaceBinding namespaceBinding : this.nameSpaces.values()) {
            if (!namespaceBinding.getNamespaceURI().equals(namespaceURI.toString())) continue;
            return new QName(namespaceBinding.getNamespaceURI(), "", namespaceBinding.getPrefix());
        }
        return null;
    }

    public List<QName> getNamespaces() {
        ArrayList<QName> bindings = new ArrayList<QName>();
        for (NamespaceBinding namespaceBinding : this.nameSpaces.values()) {
            bindings.add(new QName(namespaceBinding.getNamespaceURI(), "", namespaceBinding.getPrefix()));
        }
        return bindings;
    }

    public SynBioHubFrontend getRegistry(String registryURL) {
        return this.registries.get(registryURL);
    }

    public List<SynBioHubFrontend> getRegistries() {
        ArrayList<SynBioHubFrontend> registries = new ArrayList<SynBioHubFrontend>();
        for (SynBioHubFrontend registry : this.registries.values()) {
            registries.add(registry);
        }
        return registries;
    }

    List<NamespaceBinding> getNamespaceBindings() {
        ArrayList<NamespaceBinding> bindings = new ArrayList<NamespaceBinding>();
        bindings.addAll(this.nameSpaces.values());
        return bindings;
    }

    public void removeNamespace(URI namespaceURI) {
        if (this.isRequiredNamespaceBinding(namespaceURI)) {
            throw new IllegalStateException("Cannot remove required namespace " + namespaceURI.toString());
        }
        String prefix = this.getNamespace(namespaceURI).getPrefix();
        this.nameSpaces.remove(prefix);
    }

    public void removeRegistry(String registryId) {
        this.registries.remove(registryId);
    }

    private boolean isRequiredNamespaceBinding(URI namespaceURI) {
        if (namespaceURI.toString().equals(Sbol2Terms.sbol2.getNamespaceURI())) {
            return true;
        }
        if (namespaceURI.toString().equals(Sbol2Terms.dc.getNamespaceURI())) {
            return true;
        }
        if (namespaceURI.toString().equals(Sbol2Terms.prov.getNamespaceURI())) {
            return true;
        }
        return namespaceURI.toString().equals(Sbol1Terms.rdf.getNamespaceURI());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collections == null ? 0 : this.collections.hashCode());
        result = 31 * result + (this.componentDefinitions == null ? 0 : this.componentDefinitions.hashCode());
        result = 31 * result + (this.genericTopLevels == null ? 0 : this.genericTopLevels.hashCode());
        result = 31 * result + (this.models == null ? 0 : this.models.hashCode());
        result = 31 * result + (this.moduleDefinitions == null ? 0 : this.moduleDefinitions.hashCode());
        result = 31 * result + (this.nameSpaces == null ? 0 : this.nameSpaces.hashCode());
        result = 31 * result + (this.sequences == null ? 0 : this.sequences.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SBOLDocument other = (SBOLDocument)obj;
        if (this.collections == null ? other.collections != null : !this.collections.equals(other.collections)) {
            return false;
        }
        if (this.componentDefinitions == null ? other.componentDefinitions != null : !this.componentDefinitions.equals(other.componentDefinitions)) {
            return false;
        }
        if (this.genericTopLevels == null ? other.genericTopLevels != null : !this.genericTopLevels.equals(other.genericTopLevels)) {
            return false;
        }
        if (this.models == null ? other.models != null : !this.models.equals(other.models)) {
            return false;
        }
        if (this.moduleDefinitions == null ? other.moduleDefinitions != null : !this.moduleDefinitions.equals(other.moduleDefinitions)) {
            return false;
        }
        if (this.nameSpaces == null ? other.nameSpaces != null : !this.nameSpaces.equals(other.nameSpaces)) {
            return false;
        }
        return !(this.sequences == null ? other.sequences != null : !this.sequences.equals(other.sequences));
    }

    @SafeVarargs
    private final <TL extends TopLevel> void addTopLevel(TL newTopLevel, Map<URI, TL> instancesMap, String typeName, Map<URI, ? extends Identified> ... maps) throws SBOLValidationException {
        boolean childrenCompliant = true;
        try {
            URIcompliance.isURIcompliant(newTopLevel);
        }
        catch (SBOLValidationException e) {
            childrenCompliant = false;
        }
        if (this.compliant && childrenCompliant) {
            URI persistentId = URI.create(URIcompliance.extractPersistentId(newTopLevel.getIdentity()));
            if (URIcompliance.keyExistsInAnyMap(persistentId, maps)) {
                throw new SBOLValidationException("sbol-10220", newTopLevel);
            }
            if (instancesMap.containsKey(newTopLevel.getIdentity())) {
                throw new SBOLValidationException("sbol-10202", newTopLevel);
            }
            String prefix = URIcompliance.extractURIprefix(persistentId);
            while (prefix != null) {
                if (URIcompliance.keyExistsInAnyMap(URI.create(prefix), maps)) {
                    throw new SBOLValidationException("sbol-10202", newTopLevel);
                }
                if (instancesMap.containsKey(URI.create(prefix))) {
                    throw new SBOLValidationException("sbol-10202", newTopLevel);
                }
                prefix = URIcompliance.extractURIprefix(URI.create(prefix));
            }
            if (this.prefixes.contains(persistentId.toString())) {
                throw new IllegalArgumentException("Persistent identity `" + persistentId.toString() + "' matches URI prefix in document.");
            }
            prefix = URIcompliance.extractURIprefix(persistentId);
            while (prefix != null) {
                this.prefixes.add(prefix);
                prefix = URIcompliance.extractURIprefix(URI.create(prefix));
            }
            instancesMap.put(newTopLevel.getIdentity(), newTopLevel);
            Identified latest = (Identified)instancesMap.get(persistentId);
            if (latest == null) {
                instancesMap.put(persistentId, newTopLevel);
            } else if (Version.isFirstVersionNewer(URIcompliance.extractVersion(newTopLevel.getIdentity()), URIcompliance.extractVersion(latest.getIdentity()))) {
                instancesMap.put(persistentId, newTopLevel);
            }
        } else {
            if (URIcompliance.keyExistsInAnyMap(newTopLevel.getIdentity(), new Map[0])) {
                throw new SBOLValidationException("sbol-10202", newTopLevel);
            }
            if (instancesMap.containsKey(newTopLevel.getIdentity())) {
                throw new SBOLValidationException("sbol-10202", newTopLevel);
            }
            instancesMap.put(newTopLevel.getIdentity(), newTopLevel);
            if (newTopLevel.isSetPersistentIdentity()) {
                Identified latest = (Identified)instancesMap.get(newTopLevel.getPersistentIdentity());
                if (latest == null) {
                    instancesMap.put(newTopLevel.getPersistentIdentity(), newTopLevel);
                } else if (Version.isFirstVersionNewer(URIcompliance.extractVersion(newTopLevel.getIdentity()), URIcompliance.extractVersion(latest.getIdentity()))) {
                    instancesMap.put(newTopLevel.getPersistentIdentity(), newTopLevel);
                }
            }
        }
        newTopLevel.setSBOLDocument(this);
    }

    private final <TL extends TopLevel> boolean removeTopLevel(TopLevel topLevel, Map<URI, TL> instancesMap) throws SBOLValidationException {
        if (this.complete) {
            for (Collection c : this.collections.values()) {
                if (!c.containsMember(topLevel.getIdentity())) continue;
                throw new SBOLValidationException("sbol-12103", c);
            }
        }
        HashSet<TopLevel> setToRemove = new HashSet<TopLevel>();
        setToRemove.add(topLevel);
        boolean changed = instancesMap.values().removeAll(setToRemove);
        URI latestVersion = null;
        for (TopLevel tl : instancesMap.values()) {
            if (!topLevel.getPersistentIdentity().toString().equals(tl.getPersistentIdentity().toString())) continue;
            if (latestVersion == null) {
                latestVersion = tl.getIdentity();
                continue;
            }
            if (!Version.isFirstVersionNewer(URIcompliance.extractVersion(tl.getIdentity()), URIcompliance.extractVersion(latestVersion))) continue;
            latestVersion = tl.getIdentity();
        }
        if (latestVersion != null) {
            instancesMap.put(topLevel.getPersistentIdentity(), instancesMap.get(latestVersion));
        }
        return changed;
    }

    public void removeTopLevel(TopLevel topLevel) throws SBOLValidationException {
        if (topLevel instanceof GenericTopLevel) {
            this.removeGenericTopLevel((GenericTopLevel)topLevel);
        } else if (topLevel instanceof Collection) {
            this.removeCollection((Collection)topLevel);
        } else if (topLevel instanceof Sequence) {
            this.removeSequence((Sequence)topLevel);
        } else if (topLevel instanceof ComponentDefinition) {
            this.removeComponentDefinition((ComponentDefinition)topLevel);
        } else if (topLevel instanceof Model) {
            this.removeModel((Model)topLevel);
        } else if (topLevel instanceof ModuleDefinition) {
            this.removeModuleDefinition((ModuleDefinition)topLevel);
        }
    }

    public void setDefaultURIprefix(String defaultURIprefix) throws IllegalArgumentException {
        if (!(defaultURIprefix.endsWith("/") || defaultURIprefix.endsWith(":") || defaultURIprefix.endsWith("#"))) {
            defaultURIprefix = defaultURIprefix + "/";
        }
        if (!URIcompliance.isURIprefixCompliant(defaultURIprefix)) {
            throw new IllegalArgumentException("Unable to set default URI prefix to non-compliant value `" + defaultURIprefix + "'");
        }
        this.defaultURIprefix = defaultURIprefix;
    }

    public String getDefaultURIprefix() {
        return this.defaultURIprefix;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isCompliant() {
        return this.compliant;
    }

    void setCompliant(boolean compliant) {
        this.compliant = compliant;
    }

    public boolean isTypesInURIs() {
        return this.typesInURIs;
    }

    public void setTypesInURIs(boolean typesInURIs) {
        this.typesInURIs = typesInURIs;
    }

    public boolean isCreateDefaults() {
        return this.createDefaults;
    }

    public void setCreateDefaults(boolean createDefaults) {
        this.createDefaults = createDefaults;
    }

    public void read(String fileName) throws SBOLValidationException, IOException, SBOLConversionException {
        this.read(new File(fileName));
    }

    public void read(File file) throws SBOLValidationException, IOException, SBOLConversionException {
        FileInputStream stream = new FileInputStream(file);
        BufferedInputStream buffer = new BufferedInputStream(stream);
        this.read(buffer);
    }

    public void read(InputStream in) throws SBOLValidationException, IOException, SBOLConversionException {
        SBOLReader.read(this, in, RDF);
    }

    public void write(String filename) throws IOException, SBOLConversionException {
        SBOLWriter.write(this, new File(filename));
    }

    public void write(String filename, String fileType) throws IOException, SBOLConversionException {
        SBOLWriter.write(this, new File(filename), fileType);
    }

    public void write(File file) throws IOException, SBOLConversionException {
        FileOutputStream stream = new FileOutputStream(file);
        BufferedOutputStream buffer = new BufferedOutputStream(stream);
        SBOLWriter.write(this, buffer);
        stream.close();
        buffer.close();
    }

    public void write(File file, String fileType) throws IOException, SBOLConversionException {
        FileOutputStream stream = new FileOutputStream(file);
        BufferedOutputStream buffer = new BufferedOutputStream(stream);
        SBOLWriter.write(this, buffer, fileType);
        stream.close();
        buffer.close();
    }

    public void write(OutputStream out) throws SBOLConversionException {
        SBOLWriter.write(this, out);
    }

    public void write(OutputStream out, String fileType) throws SBOLConversionException, IOException {
        SBOLWriter.write(this, out, fileType);
    }

    public String toString() {
        return "SBOLDocument [genericTopLevels=" + this.genericTopLevels + ", collections=" + this.collections + ", componentDefinitions=" + this.componentDefinitions + ", models=" + this.models + ", moduleDefinitions=" + this.moduleDefinitions + ", sequences=" + this.sequences + ", nameSpaces=" + this.nameSpaces + ", defaultURIprefix=" + this.defaultURIprefix + ", complete=" + this.complete + ", compliant=" + this.compliant + ", typesInURIs=" + this.typesInURIs + ", createDefaults=" + this.createDefaults + "]";
    }
}

