/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.sbolstandard.core2.Collection;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.GenericTopLevel;
import org.sbolstandard.core2.Model;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.SBOLConversionException;
import org.sbolstandard.core2.SBOLDocument;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sequence;
import org.sbolstandard.core2.TopLevel;

public final class SBOLFactory {
    private static SBOLDocument document = new SBOLDocument();

    public static void setSBOLDocument(SBOLDocument sbolDocument) {
        document = sbolDocument;
    }

    public static void clear() {
        document = new SBOLDocument();
    }

    public static ModuleDefinition createModuleDefinition(String displayId) throws SBOLValidationException {
        return document.createModuleDefinition(displayId);
    }

    public static ModuleDefinition createModuleDefinition(String displayId, String version) throws SBOLValidationException {
        return document.createModuleDefinition(displayId, version);
    }

    public static ModuleDefinition createModuleDefinition(String URIprefix, String displayId, String version) throws SBOLValidationException {
        return document.createModuleDefinition(URIprefix, displayId, version);
    }

    public static boolean removeModuleDefinition(ModuleDefinition moduleDefinition) throws SBOLValidationException {
        return document.removeModuleDefinition(moduleDefinition);
    }

    public static ModuleDefinition getModuleDefinition(String displayId, String version) {
        return document.getModuleDefinition(displayId, version);
    }

    public static ModuleDefinition getModuleDefinition(URI moduleURI) {
        return document.getModuleDefinition(moduleURI);
    }

    public static Set<ModuleDefinition> getModuleDefinitions() {
        return document.getModuleDefinitions();
    }

    public static void clearModuleDefinitions() throws SBOLValidationException {
        document.clearModuleDefinitions();
    }

    public static Collection createCollection(String displayId) throws SBOLValidationException {
        return document.createCollection(displayId);
    }

    public static Collection createCollection(String displayId, String version) throws SBOLValidationException {
        return document.createCollection(displayId, version);
    }

    public static Collection createCollection(String URIprefix, String displayId, String version) throws SBOLValidationException {
        return document.createCollection(URIprefix, displayId, version);
    }

    public static boolean removeCollection(Collection collection) throws SBOLValidationException {
        return document.removeCollection(collection);
    }

    public static Collection getCollection(String displayId, String version) {
        return document.getCollection(displayId, version);
    }

    public static Collection getCollection(URI collectionURI) {
        return document.getCollection(collectionURI);
    }

    public static Set<Collection> getCollections() {
        return document.getCollections();
    }

    public static void clearCollections() throws SBOLValidationException {
        document.clearCollections();
    }

    public static Model createModel(String displayId, URI source, URI language, URI framework) throws SBOLValidationException {
        return document.createModel(displayId, "", source, language, framework);
    }

    public static Model createModel(String displayId, String version, URI source, URI language, URI framework) throws SBOLValidationException {
        return document.createModel(displayId, version, source, language, framework);
    }

    public static Model createModel(String URIprefix, String displayId, String version, URI source, URI language, URI framework) throws SBOLValidationException {
        return document.createModel(URIprefix, displayId, version, source, language, framework);
    }

    public static boolean removeModel(Model model) throws SBOLValidationException {
        return document.removeModel(model);
    }

    public static Model getModel(String displayId, String version) {
        return document.getModel(displayId, version);
    }

    public static Model getModel(URI modelURI) {
        return document.getModel(modelURI);
    }

    public static Set<Model> getModels() {
        return document.getModels();
    }

    public static void clearModels() throws SBOLValidationException {
        document.clearModels();
    }

    public static ComponentDefinition createComponentDefinition(String displayId, Set<URI> types) throws SBOLValidationException {
        return document.createComponentDefinition(displayId, types);
    }

    public static ComponentDefinition createComponentDefinition(String displayId, URI type) throws SBOLValidationException {
        return document.createComponentDefinition(displayId, type);
    }

    public static ComponentDefinition createComponentDefinition(String displayId, String version, Set<URI> types) throws SBOLValidationException {
        return document.createComponentDefinition(displayId, version, types);
    }

    public static ComponentDefinition createComponentDefinition(String displayId, String version, URI type) throws SBOLValidationException {
        return document.createComponentDefinition(displayId, version, type);
    }

    public static ComponentDefinition createComponentDefinition(String URIprefix, String displayId, String version, Set<URI> types) throws SBOLValidationException {
        return document.createComponentDefinition(URIprefix, displayId, version, types);
    }

    public static ComponentDefinition createComponentDefinition(String URIprefix, String displayId, String version, URI type) throws SBOLValidationException {
        return document.createComponentDefinition(URIprefix, displayId, version, type);
    }

    public static boolean removeComponentDefinition(ComponentDefinition componentDefinition) throws SBOLValidationException {
        return document.removeComponentDefinition(componentDefinition);
    }

    public static ComponentDefinition getComponentDefinition(String displayId, String version) {
        return document.getComponentDefinition(displayId, version);
    }

    public static ComponentDefinition getComponentDefinition(URI componentDefinitionURI) {
        return document.getComponentDefinition(componentDefinitionURI);
    }

    public static Set<ComponentDefinition> getComponentDefinitions() {
        return document.getComponentDefinitions();
    }

    public static Set<ComponentDefinition> getRootComponentDefinitions() {
        return document.getRootComponentDefinitions();
    }

    public static void clearComponentDefinitions() throws SBOLValidationException {
        document.clearComponentDefinitions();
    }

    public static Sequence createSequence(String displayId, String elements, URI encoding) throws SBOLValidationException {
        return document.createSequence(displayId, elements, encoding);
    }

    public static Sequence createSequence(String displayId, String version, String elements, URI encoding) throws SBOLValidationException {
        return document.createSequence(displayId, version, elements, encoding);
    }

    public static Sequence createSequence(String URIprefix, String displayId, String version, String elements, URI encoding) throws SBOLValidationException {
        return document.createSequence(URIprefix, displayId, version, elements, encoding);
    }

    public static void createCopy(SBOLDocument document) throws SBOLValidationException {
        for (TopLevel topLevel : document.getTopLevels()) {
            SBOLFactory.createCopy(topLevel);
        }
    }

    public static TopLevel createCopy(TopLevel topLevel) throws SBOLValidationException {
        return document.createCopy(topLevel);
    }

    public static TopLevel createCopy(TopLevel topLevel, String displayId) throws SBOLValidationException {
        return document.createCopy(topLevel, displayId);
    }

    public static TopLevel createCopy(TopLevel topLevel, String displayId, String version) throws SBOLValidationException {
        return document.createCopy(topLevel, displayId, version);
    }

    public static TopLevel createCopy(TopLevel topLevel, String URIprefix, String displayId, String version) throws SBOLValidationException {
        return document.createCopy(topLevel, URIprefix, displayId, version);
    }

    public static SBOLDocument createRecursiveCopy(TopLevel topLevel) throws SBOLValidationException {
        return document.createRecursiveCopy(topLevel);
    }

    public static boolean removeSequence(Sequence sequence) throws SBOLValidationException {
        return document.removeSequence(sequence);
    }

    public static Sequence getSequence(String displayId, String version) {
        return document.getSequence(displayId, version);
    }

    public static Sequence getSequence(URI sequenceURI) {
        return document.getSequence(sequenceURI);
    }

    public static Set<Sequence> getSequences() {
        return document.getSequences();
    }

    public static void clearSequences() throws SBOLValidationException {
        document.clearSequences();
    }

    public static GenericTopLevel createGenericTopLevel(String displayId, QName rdfType) throws SBOLValidationException {
        return document.createGenericTopLevel(displayId, rdfType);
    }

    public static GenericTopLevel createGenericTopLevel(String displayId, String version, QName rdfType) throws SBOLValidationException {
        return document.createGenericTopLevel(displayId, version, rdfType);
    }

    public static GenericTopLevel createGenericTopLevel(String URIprefix, String displayId, String version, QName rdfType) throws SBOLValidationException {
        return document.createGenericTopLevel(URIprefix, displayId, version, rdfType);
    }

    public static boolean removeGenericTopLevel(GenericTopLevel genericTopLevel) throws SBOLValidationException {
        return document.removeGenericTopLevel(genericTopLevel);
    }

    public static GenericTopLevel getGenericTopLevel(String displayId, String version) {
        return document.getGenericTopLevel(displayId, version);
    }

    public static GenericTopLevel getGenericTopLevel(URI topLevelURI) {
        return document.getGenericTopLevel(topLevelURI);
    }

    public static Set<GenericTopLevel> getGenericTopLevels() {
        return document.getGenericTopLevels();
    }

    public static void clearGenericTopLevels() throws SBOLValidationException {
        document.clearGenericTopLevels();
    }

    public static TopLevel getTopLevel(URI topLevelURI) {
        return document.getTopLevel(topLevelURI);
    }

    public static Set<TopLevel> getTopLevels() {
        return document.getTopLevels();
    }

    public static Set<TopLevel> getByWasDerivedFrom(URI wasDerivedFrom) {
        return document.getByWasDerivedFrom(wasDerivedFrom);
    }

    public static void addNamespace(URI namespaceURI, String prefix) throws SBOLValidationException {
        document.addNamespace(namespaceURI, prefix);
    }

    public static void addNamespace(QName qName) throws SBOLValidationException {
        document.addNamespace(qName);
    }

    public static void clearNamespaces() {
        document.clearNamespaces();
    }

    public static QName getNamespace(URI namespaceURI) {
        return document.getNamespace(namespaceURI);
    }

    public static List<QName> getNamespaces() {
        return document.getNamespaces();
    }

    public static void removeNamespace(URI namespaceURI) {
        document.removeNamespace(namespaceURI);
    }

    public int hashCode() {
        return document.hashCode();
    }

    public boolean equals(Object obj) {
        return document.equals(obj);
    }

    public static void setDefaultURIprefix(String defaultURIprefix) {
        document.setDefaultURIprefix(defaultURIprefix);
    }

    public static String getDefaultURIprefix() {
        return document.getDefaultURIprefix();
    }

    public static boolean isComplete() {
        return document.isComplete();
    }

    public static void setComplete(boolean complete) {
        document.setComplete(complete);
    }

    public static boolean isCompliant() {
        return document.isCompliant();
    }

    public static boolean isTypesInURIs() {
        return document.isTypesInURIs();
    }

    public static void setTypesInURIs(boolean typesInURIs) {
        document.setTypesInURIs(typesInURIs);
    }

    public static boolean isCreateDefaults() {
        return document.isCreateDefaults();
    }

    public static void setCreateDefaults(boolean createDefaults) {
        document.setCreateDefaults(createDefaults);
    }

    public static void read(String fileName) throws SBOLValidationException, IOException, SBOLConversionException {
        document.read(fileName);
    }

    public static void read(File file) throws SBOLValidationException, IOException, SBOLConversionException {
        document.read(file);
    }

    public static void read(InputStream in) throws SBOLValidationException, IOException, SBOLConversionException {
        document.read(in);
    }

    public static void write(String filename) throws IOException, SBOLConversionException {
        document.write(filename);
    }

    public static void write(String filename, String fileType) throws IOException, SBOLConversionException {
        document.write(new File(filename), fileType);
    }

    public static void write(File file) throws IOException, SBOLConversionException {
        document.write(file);
    }

    public static void write(File file, String fileType) throws IOException, SBOLConversionException {
        document.write(file, fileType);
    }

    public static void write(OutputStream out) throws SBOLConversionException {
        document.write(out);
    }

    public static void write(OutputStream out, String fileType) throws SBOLConversionException, IOException {
        document.write(out, fileType);
    }

    public String toString() {
        return document.toString();
    }
}

