/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonReader;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.Annotation;
import org.sbolstandard.core2.Collection;
import org.sbolstandard.core2.Component;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.Cut;
import org.sbolstandard.core2.DirectionType;
import org.sbolstandard.core2.FASTA;
import org.sbolstandard.core2.FunctionalComponent;
import org.sbolstandard.core2.GenBank;
import org.sbolstandard.core2.GenericLocation;
import org.sbolstandard.core2.GenericTopLevel;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.Interaction;
import org.sbolstandard.core2.Location;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.Model;
import org.sbolstandard.core2.Module;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.OrientationType;
import org.sbolstandard.core2.Participation;
import org.sbolstandard.core2.Range;
import org.sbolstandard.core2.RefinementType;
import org.sbolstandard.core2.RestrictionType;
import org.sbolstandard.core2.RoleIntegrationType;
import org.sbolstandard.core2.SBOLConversionException;
import org.sbolstandard.core2.SBOLDocument;
import org.sbolstandard.core2.SBOLValidate;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sbol1Terms;
import org.sbolstandard.core2.Sbol2Terms;
import org.sbolstandard.core2.Sequence;
import org.sbolstandard.core2.SequenceAnnotation;
import org.sbolstandard.core2.SequenceConstraint;
import org.sbolstandard.core2.SequenceOntology;
import org.sbolstandard.core2.TopLevel;
import org.sbolstandard.core2.URIcompliance;
import uk.ac.intbio.core.io.turtle.TurtleIo;
import uk.ac.ncl.intbio.core.datatree.Datatree;
import uk.ac.ncl.intbio.core.datatree.DocumentRoot;
import uk.ac.ncl.intbio.core.datatree.IdentifiableDocument;
import uk.ac.ncl.intbio.core.datatree.Literal;
import uk.ac.ncl.intbio.core.datatree.NamedProperty;
import uk.ac.ncl.intbio.core.datatree.NamespaceBinding;
import uk.ac.ncl.intbio.core.datatree.NestedDocument;
import uk.ac.ncl.intbio.core.datatree.PropertyValue;
import uk.ac.ncl.intbio.core.datatree.TopLevelDocument;
import uk.ac.ncl.intbio.core.io.CoreIoException;
import uk.ac.ncl.intbio.core.io.IoReader;
import uk.ac.ncl.intbio.core.io.json.JsonIo;
import uk.ac.ncl.intbio.core.io.json.StringifyQName;
import uk.ac.ncl.intbio.core.io.rdf.RdfIo;

public class SBOLReader {
    public static final String SBOLVERSION1 = "v1";
    public static final String SBOLVERSION2 = "v2";
    public static boolean keepGoing = false;
    private static List<String> errors = new ArrayList<String>();
    private static String URIPrefix = null;
    private static String version = "";
    private static boolean typesInURI = false;
    private static boolean dropObjectsWithDuplicateURIs = false;
    private static boolean compliant = true;
    private static URI defaultSequenceEncoding = Sequence.IUPAC_DNA;

    public static boolean isKeepGoing() {
        return keepGoing;
    }

    public static void setKeepGoing(boolean keepGoing) {
        SBOLReader.keepGoing = keepGoing;
    }

    public static void clearErrors() {
        errors = new ArrayList<String>();
    }

    public static List<String> getErrors() {
        return errors;
    }

    public static int getNumErrors() {
        return errors.size();
    }

    public static boolean isCompliant() {
        return compliant;
    }

    public static void setCompliant(boolean compliant) {
        SBOLReader.compliant = compliant;
    }

    public static void setURIPrefix(String URIprefix) {
        URIPrefix = URIprefix;
    }

    public static void unsetURIPrefix() {
        URIPrefix = null;
    }

    public static void setVersion(String version) {
        SBOLReader.version = version;
    }

    public static void setTypesInURI(boolean typesInURI) {
        SBOLReader.typesInURI = typesInURI;
    }

    public static boolean isDropObjectsWithDuplicateURIs() {
        return dropObjectsWithDuplicateURIs;
    }

    public static void setDropObjectsWithDuplicateURIs(boolean dropObjectsWithDuplicateURIs) {
        SBOLReader.dropObjectsWithDuplicateURIs = dropObjectsWithDuplicateURIs;
    }

    public static URI getDefaultSequenceEncoding() {
        return defaultSequenceEncoding;
    }

    public static void setDefaultSequenceEncoding(URI defaultSequenceEncoding) {
        SBOLReader.defaultSequenceEncoding = defaultSequenceEncoding;
    }

    private static String getSBOLVersion(DocumentRoot<QName> document) throws SBOLValidationException {
        boolean foundRDF = false;
        boolean foundSBOL1 = false;
        boolean foundSBOL2 = false;
        for (NamespaceBinding n : document.getNamespaceBindings()) {
            if (n.getNamespaceURI().equals(Sbol1Terms.rdf.getNamespaceURI())) {
                foundRDF = true;
            }
            if (n.getNamespaceURI().equals(Sbol1Terms.sbol1.getNamespaceURI())) {
                foundSBOL1 = true;
            }
            if (!n.getNamespaceURI().equals(Sbol2Terms.sbol2.getNamespaceURI())) continue;
            foundSBOL2 = true;
        }
        if (foundSBOL2) {
            if (!foundRDF) {
                throw new SBOLValidationException("sbol-10102", new Identified[0]);
            }
            return SBOLVERSION2;
        }
        if (foundSBOL1) {
            if (!foundRDF) {
                throw new SBOLValidationException("sbol-10102", new Identified[0]);
            }
            return SBOLVERSION1;
        }
        throw new SBOLValidationException("sbol-10101", new Identified[0]);
    }

    public static String getSBOLVersion(String fileName) throws FileNotFoundException, SBOLValidationException, SBOLConversionException {
        return SBOLReader.getSBOLVersion(fileName, "RDF");
    }

    private static String getSBOLVersion(String fileName, String fileType) throws FileNotFoundException, SBOLValidationException, SBOLConversionException {
        FileInputStream stream = new FileInputStream(new File(fileName));
        BufferedInputStream buffer = new BufferedInputStream(stream);
        return SBOLReader.getSBOLVersion(buffer, fileType);
    }

    public static SBOLDocument read(String fileName) throws SBOLValidationException, IOException, SBOLConversionException {
        return SBOLReader.read(fileName, "RDF");
    }

    private static SBOLDocument read(String fileName, String fileType) throws SBOLValidationException, IOException, SBOLConversionException {
        return SBOLReader.read(new File(fileName), fileType);
    }

    public static String getSBOLVersion(File file) throws FileNotFoundException, SBOLValidationException, SBOLConversionException {
        return SBOLReader.getSBOLVersion(file, "RDF");
    }

    public static SBOLDocument read(File file) throws SBOLValidationException, IOException, SBOLConversionException {
        return SBOLReader.read(file, "RDF");
    }

    private static SBOLDocument read(File file, String fileType) throws SBOLValidationException, IOException, SBOLConversionException {
        FileInputStream stream = new FileInputStream(file);
        BufferedInputStream buffer = new BufferedInputStream(stream);
        return SBOLReader.read(buffer, fileType);
    }

    private static String getSBOLVersion(File file, String fileType) throws FileNotFoundException, SBOLValidationException, SBOLConversionException {
        FileInputStream stream = new FileInputStream(file);
        BufferedInputStream buffer = new BufferedInputStream(stream);
        return SBOLReader.getSBOLVersion(buffer, fileType);
    }

    private static String getSBOLVersion(InputStream in, String fileType) throws SBOLValidationException, SBOLConversionException {
        String inputStreamString;
        Scanner scanner = new Scanner(in, "UTF-8");
        try {
            inputStreamString = scanner.useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            scanner.close();
            throw new SBOLConversionException("File is empty.");
        }
        DocumentRoot<QName> document = null;
        document = fileType.equals("JSON") ? SBOLReader.readJSON(new StringReader(inputStreamString)) : (fileType.equals("TURTLE") ? SBOLReader.readTurtle(new StringReader(inputStreamString)) : SBOLReader.readRDF(new StringReader(inputStreamString)));
        scanner.close();
        return SBOLReader.getSBOLVersion(document);
    }

    public static SBOLDocument read(InputStream in) throws SBOLValidationException, IOException, SBOLConversionException {
        SBOLDocument SBOLDoc = new SBOLDocument();
        SBOLDoc.setCompliant(compliant);
        SBOLReader.read(SBOLDoc, in, "RDF");
        return SBOLDoc;
    }

    public static SBOLDocument read(InputStream in, String fileType) throws SBOLValidationException, IOException, SBOLConversionException {
        SBOLDocument SBOLDoc = new SBOLDocument();
        SBOLDoc.setCompliant(compliant);
        if (URIPrefix != null) {
            SBOLDoc.setDefaultURIprefix(URIPrefix);
        }
        SBOLReader.read(SBOLDoc, in, fileType);
        return SBOLDoc;
    }

    static void read(SBOLDocument SBOLDoc, InputStream in, String fileType) throws SBOLValidationException, IOException, SBOLConversionException {
        String inputStreamString;
        compliant = SBOLDoc.isCompliant();
        Scanner scanner = new Scanner(in, "UTF-8");
        try {
            inputStreamString = scanner.useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            scanner.close();
            throw new SBOLConversionException("File is empty.");
        }
        SBOLReader.clearErrors();
        DocumentRoot<QName> document = null;
        try {
            if (FASTA.isFastaString(inputStreamString)) {
                SBOLDoc.setCreateDefaults(true);
                SBOLDoc.setCompliant(true);
                if (URIPrefix == null) {
                    scanner.close();
                    throw new SBOLConversionException("No URI prefix has been provided.");
                }
                SBOLDoc.setDefaultURIprefix(URIPrefix);
                FASTA.read(SBOLDoc, inputStreamString, URIPrefix, version, defaultSequenceEncoding);
                scanner.close();
                return;
            }
            if (GenBank.isGenBankString(inputStreamString)) {
                SBOLDoc.setCreateDefaults(true);
                SBOLDoc.setCompliant(true);
                if (URIPrefix == null) {
                    scanner.close();
                    throw new SBOLConversionException("No URI prefix has been provided.");
                }
                SBOLDoc.setDefaultURIprefix(URIPrefix);
                GenBank.read(SBOLDoc, inputStreamString, URIPrefix);
                scanner.close();
                return;
            }
            document = fileType.equals("JSON") ? SBOLReader.readJSON(new StringReader(inputStreamString)) : (fileType.equals("TURTLE") ? SBOLReader.readTurtle(new StringReader(inputStreamString)) : SBOLReader.readRDF(new StringReader(inputStreamString)));
            if (SBOLReader.getSBOLVersion(document).equals(SBOLVERSION1)) {
                scanner.close();
                SBOLReader.readV1(SBOLDoc, document);
                return;
            }
        }
        catch (SBOLValidationException e) {
            if (keepGoing) {
                errors.add(e.getMessage());
                return;
            }
            throw new SBOLValidationException(e);
        }
        for (NamespaceBinding n : document.getNamespaceBindings()) {
            if (SBOLDoc.getNamespace(URI.create(n.getNamespaceURI())) != null) continue;
            if (n.getPrefix() == null) {
                SBOLDoc.addNamespaceBinding(Datatree.NamespaceBinding((String)n.getNamespaceURI(), (String)""));
                continue;
            }
            SBOLDoc.addNamespaceBinding(Datatree.NamespaceBinding((String)n.getNamespaceURI(), (String)n.getPrefix()));
        }
        SBOLReader.readTopLevelDocs(SBOLDoc, document);
        scanner.close();
        SBOLValidate.clearErrors();
        SBOLValidate.validateCompliance(SBOLDoc);
        if (SBOLValidate.getNumErrors() > 0) {
            SBOLDoc.setCompliant(false);
        }
    }

    public static String getSBOLVersion(InputStream in) throws SBOLValidationException, SBOLConversionException {
        return SBOLReader.getSBOLVersion(in, "RDF");
    }

    private static SBOLDocument readV1(SBOLDocument SBOLDoc, DocumentRoot<QName> document) throws SBOLValidationException, SBOLConversionException {
        for (NamespaceBinding n : document.getNamespaceBindings()) {
            if (n.getNamespaceURI().equals(Sbol1Terms.sbol1.getNamespaceURI())) {
                SBOLDoc.addNamespaceBinding(Datatree.NamespaceBinding((String)Sbol2Terms.sbol2.getNamespaceURI(), (String)Sbol2Terms.sbol2.getPrefix()));
                continue;
            }
            if (SBOLDoc.getNamespace(URI.create(n.getNamespaceURI())) != null) continue;
            SBOLDoc.addNamespaceBinding(Datatree.NamespaceBinding((String)n.getNamespaceURI(), (String)n.getPrefix()));
        }
        SBOLDoc.addNamespaceBinding(Datatree.NamespaceBinding((String)Sbol2Terms.prov.getNamespaceURI(), (String)Sbol2Terms.prov.getPrefix()));
        SBOLReader.readTopLevelDocsV1(SBOLDoc, document);
        SBOLValidate.clearErrors();
        SBOLValidate.validateCompliance(SBOLDoc);
        if (SBOLValidate.getNumErrors() > 0) {
            SBOLDoc.setCompliant(false);
        }
        return SBOLDoc;
    }

    private static DocumentRoot<QName> readJSON(Reader stream) throws SBOLValidationException {
        DocumentRoot root;
        JsonReader reader = Json.createReaderFactory(Collections.emptyMap()).createReader(stream);
        JsonIo jsonIo = new JsonIo();
        IoReader ioReader = jsonIo.createIoReader(reader.read());
        try {
            root = ioReader.read();
        }
        catch (CoreIoException e) {
            throw new SBOLValidationException("sbol-10105", (Throwable)e, new Identified[0]);
        }
        return StringifyQName.string2qname.mapDR(root);
    }

    private static DocumentRoot<QName> readRDF(Reader reader) throws SBOLValidationException {
        try {
            XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
            RdfIo rdfIo = new RdfIo();
            return rdfIo.createIoReader(xmlReader).read();
        }
        catch (FactoryConfigurationError e) {
            throw new SBOLValidationException("sbol-10105", (Throwable)e, new Identified[0]);
        }
        catch (XMLStreamException e) {
            throw new SBOLValidationException("sbol-10105", (Throwable)e, new Identified[0]);
        }
        catch (CoreIoException e) {
            throw new SBOLValidationException("sbol-10105", (Throwable)e, new Identified[0]);
        }
        catch (ClassCastException e) {
            if (e.getMessage().contains("IdentifiableDocument")) {
                throw new SBOLValidationException("sbol-10201", (Throwable)e, new Identified[0]);
            }
            throw new SBOLValidationException("sbol-10105", (Throwable)e, new Identified[0]);
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof URISyntaxException) {
                throw new SBOLValidationException("sbol-10201", (Throwable)e, new Identified[0]);
            }
            throw new SBOLValidationException("sbol-10105", (Throwable)e, new Identified[0]);
        }
    }

    private static DocumentRoot<QName> readTurtle(Reader reader) throws SBOLValidationException {
        TurtleIo turtleIo = new TurtleIo();
        try {
            return turtleIo.createIoReader(reader).read();
        }
        catch (CoreIoException e) {
            throw new SBOLValidationException("sbol-10105", (Throwable)e, new Identified[0]);
        }
    }

    private static void readTopLevelDocsV1(SBOLDocument SBOLDoc, DocumentRoot<QName> document) throws SBOLValidationException, SBOLConversionException {
        SBOLReader.clearErrors();
        for (TopLevelDocument topLevel : document.getTopLevelDocuments()) {
            try {
                if (((QName)topLevel.getType()).equals(Sbol1Terms.DNAComponent.DNAComponent)) {
                    SBOLReader.parseDnaComponentV1(SBOLDoc, (IdentifiableDocument<QName>)topLevel);
                    continue;
                }
                if (((QName)topLevel.getType()).equals(Sbol1Terms.DNASequence.DNASequence)) {
                    SBOLReader.parseDnaSequenceV1(SBOLDoc, (IdentifiableDocument<QName>)topLevel);
                    continue;
                }
                if (((QName)topLevel.getType()).equals(Sbol1Terms.Collection.Collection)) {
                    SBOLReader.parseCollectionV1(SBOLDoc, (IdentifiableDocument<QName>)topLevel);
                    continue;
                }
                SBOLReader.parseGenericTopLevel(SBOLDoc, (IdentifiableDocument<QName>)topLevel);
            }
            catch (SBOLValidationException e) {
                if (keepGoing) {
                    errors.add(e.getMessage());
                    continue;
                }
                throw new SBOLValidationException(e);
            }
        }
    }

    private static void readTopLevelDocs(SBOLDocument SBOLDoc, DocumentRoot<QName> document) throws SBOLValidationException {
        HashMap<URI, NestedDocument<QName>> nested = new HashMap<URI, NestedDocument<QName>>();
        ArrayList<TopLevelDocument> topLevels = new ArrayList<TopLevelDocument>();
        SBOLReader.clearErrors();
        for (TopLevelDocument topLevel : document.getTopLevelDocuments()) {
            if (((QName)topLevel.getType()).equals(Sbol2Terms.Description.Description)) {
                if (topLevel.getPropertyValues((Object)Sbol2Terms.Description.type).isEmpty()) {
                    if (keepGoing) {
                        errors.add(new SBOLValidationException("sbol-12302", topLevel.getIdentity()).getMessage());
                    } else {
                        throw new SBOLValidationException("sbol-12302", topLevel.getIdentity());
                    }
                }
                for (PropertyValue value : topLevel.getPropertyValues((Object)Sbol2Terms.Description.type)) {
                    Literal type = (Literal)value;
                    if (type.getValue().toString().equals(Sbol2Terms.Component.Component.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Component.Component, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.Cut.Cut.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Cut.Cut, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.FunctionalComponent.FunctionalComponent.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.FunctionalComponent.FunctionalComponent, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.GenericLocation.GenericLocation.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.GenericLocation.GenericLocation, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.Interaction.Interaction.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Interaction.Interaction, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.Location.Location.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Location.Location, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.MapsTo.MapsTo.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.MapsTo.MapsTo, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.Module.Module.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Module.Module, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.Participation.Participation.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Participation.Participation, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.Range.Range.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Range.Range, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.SequenceAnnotation.SequenceAnnotation.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.SequenceAnnotation.SequenceAnnotation, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.SequenceConstraint.SequenceConstraint.toString().replaceAll("\\{|\\}", ""))) {
                        nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.SequenceConstraint.SequenceConstraint, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.Collection.Collection.toString().replaceAll("\\{|\\}", ""))) {
                        topLevels.add(Datatree.TopLevelDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Collection.Collection, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.ModuleDefinition.ModuleDefinition.toString().replaceAll("\\{|\\}", ""))) {
                        topLevels.add(Datatree.TopLevelDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.ModuleDefinition.ModuleDefinition, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.Model.Model.toString().replaceAll("\\{|\\}", ""))) {
                        topLevels.add(Datatree.TopLevelDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Model.Model, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.Sequence.Sequence.toString().replaceAll("\\{|\\}", ""))) {
                        topLevels.add(Datatree.TopLevelDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.Sequence.Sequence, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    if (type.getValue().toString().equals(Sbol2Terms.ComponentDefinition.ComponentDefinition.toString().replaceAll("\\{|\\}", ""))) {
                        topLevels.add(Datatree.TopLevelDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)Sbol2Terms.ComponentDefinition.ComponentDefinition, (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                        continue;
                    }
                    topLevels.add(topLevel);
                }
                continue;
            }
            if (((QName)topLevel.getType()).equals(Sbol2Terms.Component.Component) || ((QName)topLevel.getType()).equals(Sbol2Terms.Cut.Cut) || ((QName)topLevel.getType()).equals(Sbol2Terms.FunctionalComponent.FunctionalComponent) || ((QName)topLevel.getType()).equals(Sbol2Terms.GenericLocation.GenericLocation) || ((QName)topLevel.getType()).equals(Sbol2Terms.Interaction.Interaction) || ((QName)topLevel.getType()).equals(Sbol2Terms.Location.Location) || ((QName)topLevel.getType()).equals(Sbol2Terms.MapsTo.MapsTo) || ((QName)topLevel.getType()).equals(Sbol2Terms.Module.Module) || ((QName)topLevel.getType()).equals(Sbol2Terms.Participation.Participation) || ((QName)topLevel.getType()).equals(Sbol2Terms.Range.Range) || ((QName)topLevel.getType()).equals(Sbol2Terms.SequenceAnnotation.SequenceAnnotation) || ((QName)topLevel.getType()).equals(Sbol2Terms.SequenceConstraint.SequenceConstraint)) {
                nested.put(topLevel.getIdentity(), (NestedDocument<QName>)Datatree.NestedDocument((Datatree.NamespaceBindings)Datatree.NamespaceBindings((List)topLevel.getNamespaceBindings()), (Object)topLevel.getType(), (URI)topLevel.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties((List)topLevel.getProperties())));
                continue;
            }
            topLevels.add(topLevel);
        }
        for (TopLevelDocument topLevel : topLevels) {
            try {
                if (((QName)topLevel.getType()).equals(Sbol2Terms.Collection.Collection)) {
                    SBOLReader.parseCollections(SBOLDoc, (IdentifiableDocument<QName>)topLevel, nested);
                    continue;
                }
                if (((QName)topLevel.getType()).equals(Sbol2Terms.ModuleDefinition.ModuleDefinition)) {
                    SBOLReader.parseModuleDefinition(SBOLDoc, (IdentifiableDocument<QName>)topLevel, nested);
                    continue;
                }
                if (((QName)topLevel.getType()).equals(Sbol2Terms.Model.Model)) {
                    SBOLReader.parseModels(SBOLDoc, (IdentifiableDocument<QName>)topLevel);
                    continue;
                }
                if (((QName)topLevel.getType()).equals(Sbol2Terms.Sequence.Sequence)) {
                    SBOLReader.parseSequences(SBOLDoc, (IdentifiableDocument<QName>)topLevel);
                    continue;
                }
                if (((QName)topLevel.getType()).equals(Sbol2Terms.ComponentDefinition.ComponentDefinition)) {
                    SBOLReader.parseComponentDefinitions(SBOLDoc, (IdentifiableDocument<QName>)topLevel, nested);
                    continue;
                }
                SBOLReader.parseGenericTopLevel(SBOLDoc, (IdentifiableDocument<QName>)topLevel);
            }
            catch (SBOLValidationException e) {
                if (keepGoing) {
                    errors.add(e.getMessage());
                    continue;
                }
                throw new SBOLValidationException(e);
            }
        }
    }

    private static ComponentDefinition parseDnaComponentV1(SBOLDocument SBOLDoc, IdentifiableDocument<QName> componentDef) throws SBOLValidationException, SBOLConversionException {
        ComponentDefinition componentDefinition;
        String displayId = null;
        String name = null;
        String description = null;
        URI seq_identity = null;
        HashSet<URI> roles = new HashSet<URI>();
        URI identity = componentDef.getIdentity();
        String persIdentity = componentDef.getIdentity().toString();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        ArrayList<SequenceAnnotation> sequenceAnnotations = new ArrayList<SequenceAnnotation>();
        HashSet<String> instantiatedComponents = new HashSet<String>();
        HashSet<Component> components = new HashSet<Component>();
        HashSet<SequenceConstraint> sequenceConstraints = new HashSet<SequenceConstraint>();
        ArrayList<SBOLPair> precedePairs = new ArrayList<SBOLPair>();
        HashMap<URI, URI> componentDefMap = new HashMap<URI, URI>();
        HashSet<URI> type = new HashSet<URI>();
        type.add(ComponentDefinition.DNA);
        type.add(SequenceOntology.LINEAR);
        int component_num = 0;
        int sa_num = 0;
        if (URIPrefix != null) {
            displayId = SBOLReader.findDisplayId(componentDef.getIdentity().toString());
            identity = URIcompliance.createCompliantURI(URIPrefix, "cd", displayId, version, typesInURI);
            persIdentity = URIcompliance.createCompliantURI(URIPrefix, "cd", displayId, "", typesInURI).toString();
        }
        for (Object namedProperty : componentDef.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.DNAComponent.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", componentDef.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                displayId = URIcompliance.fixDisplayId(displayId);
                if (URIPrefix == null) continue;
                persIdentity = URIcompliance.createCompliantURI(URIPrefix, "cd", displayId, "", typesInURI).toString();
                identity = URIcompliance.createCompliantURI(URIPrefix, "cd", displayId, version, typesInURI);
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.DNAComponent.name)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", componentDef.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.DNAComponent.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", componentDef.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.DNAComponent.type)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10507", componentDef.getIdentity());
                }
                URI uRI = SequenceOntology.convertSeqOntologyV1(((Literal)namedProperty.getValue()).getValue().toString());
                roles.add(uRI);
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.DNAComponent.annotations)) {
                if (namedProperty.getValue() instanceof IdentifiableDocument) {
                    SequenceAnnotation sequenceAnnotation = SBOLReader.parseSequenceAnnotationV1(SBOLDoc, (NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), precedePairs, persIdentity, ++sa_num, instantiatedComponents);
                    sequenceAnnotations.add(sequenceAnnotation);
                    URI component_identity = URIcompliance.createCompliantURI(persIdentity, "component" + component_num, version);
                    URI component_persIdentity = URIcompliance.createCompliantURI(persIdentity, "component" + component_num, "");
                    String component_displayId = "component" + component_num;
                    AccessType access = AccessType.PUBLIC;
                    URI instantiatedComponent = sequenceAnnotation.getComponentURI();
                    ComponentDefinition instantiatedDef = SBOLDoc.getComponentDefinition(instantiatedComponent);
                    if (compliant && instantiatedDef != null && instantiatedDef.isSetDisplayId() && !instantiatedComponents.contains(instantiatedDef.getDisplayId())) {
                        component_identity = URIcompliance.createCompliantURI(persIdentity, instantiatedDef.getDisplayId(), version);
                        component_persIdentity = URIcompliance.createCompliantURI(persIdentity, instantiatedDef.getDisplayId(), "");
                        component_displayId = instantiatedDef.getDisplayId();
                        instantiatedComponents.add(instantiatedDef.getDisplayId());
                    } else {
                        ++component_num;
                    }
                    Component component = new Component(component_identity, access, instantiatedComponent);
                    if (!persIdentity.equals("")) {
                        component.setPersistentIdentity(component_persIdentity);
                        component.setDisplayId(component_displayId);
                        component.setVersion(version);
                    }
                    components.add(component);
                    URI originalURI = ((NestedDocument)namedProperty.getValue()).getIdentity();
                    componentDefMap.put(originalURI, component_identity);
                    sequenceAnnotation.setComponent(component_identity);
                    continue;
                }
                throw new SBOLConversionException("SequenceAnnotation must be nested in SBOL1.");
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.DNAComponent.dnaSequence)) {
                if (seq_identity != null) {
                    throw new SBOLValidationException("sbol-10512", componentDef.getIdentity());
                }
                if (namedProperty.getValue() instanceof Literal) {
                    if (!(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                        throw new SBOLValidationException("sbol-10512", componentDef.getIdentity());
                    }
                    seq_identity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                    continue;
                }
                seq_identity = SBOLReader.parseDnaSequenceV1(SBOLDoc, (IdentifiableDocument<QName>)((NestedDocument)namedProperty.getValue())).getIdentity();
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        if (roles.isEmpty()) {
            roles.add(SequenceOntology.ENGINEERED_REGION);
        }
        int sc_number = 0;
        for (SBOLPair sBOLPair : precedePairs) {
            URI sc_identity = URIcompliance.createCompliantURI(persIdentity, "sequenceConstraint" + ++sc_number, version);
            URI restrictionURI = RestrictionType.convertToURI(RestrictionType.PRECEDES);
            URI subject = null;
            URI object = null;
            for (URI key : componentDefMap.keySet()) {
                if (sBOLPair.getLeft().equals(key)) {
                    subject = (URI)componentDefMap.get(key);
                    continue;
                }
                if (!sBOLPair.getRight().equals(key)) continue;
                object = (URI)componentDefMap.get(key);
            }
            SequenceConstraint sc = null;
            if (compliant && !persIdentity.equals("")) {
                String subjectId = URIcompliance.extractDisplayId(subject);
                String objectId = URIcompliance.extractDisplayId(object);
                sc_identity = URIcompliance.createCompliantURI(persIdentity, subjectId + "_cons_" + objectId, version);
                sc = new SequenceConstraint(sc_identity, restrictionURI, subject, object);
                sc.setPersistentIdentity(URIcompliance.createCompliantURI(persIdentity, subjectId + "_cons_" + objectId, ""));
                sc.setDisplayId(subjectId + "_cons_" + objectId);
                sc.setVersion(version);
            } else {
                sc = new SequenceConstraint(sc_identity, restrictionURI, subject, object);
            }
            sequenceConstraints.add(sc);
        }
        ComponentDefinition c = new ComponentDefinition(identity, type);
        if (!persIdentity.equals("")) {
            c.setPersistentIdentity(URI.create(persIdentity));
            c.setVersion(version);
        }
        if (roles != null) {
            c.setRoles(roles);
        }
        if (identity != componentDef.getIdentity()) {
            c.addWasDerivedFrom(componentDef.getIdentity());
        }
        if (displayId != null) {
            c.setDisplayId(displayId);
        }
        if (name != null && !name.isEmpty()) {
            c.setName(name);
        }
        if (description != null && !description.isEmpty()) {
            c.setDescription(description);
        }
        if (seq_identity != null) {
            c.addSequence(seq_identity);
        }
        if (!annotations.isEmpty()) {
            c.setAnnotations(annotations);
        }
        if (!components.isEmpty()) {
            c.setComponents(components);
        }
        if (!sequenceAnnotations.isEmpty()) {
            for (SequenceAnnotation sa : sequenceAnnotations) {
                if (dropObjectsWithDuplicateURIs && c.getSequenceAnnotation(sa.getIdentity()) != null) continue;
                c.addSequenceAnnotation(sa);
            }
        }
        if (!sequenceConstraints.isEmpty()) {
            c.setSequenceConstraints(sequenceConstraints);
        }
        if ((componentDefinition = SBOLDoc.getComponentDefinition(identity)) == null) {
            SBOLDoc.addComponentDefinition(c);
        } else if (c.isSetWasDerivedFrom() && componentDefinition.isSetWasDerivedFrom() && !c.getWasDerivedFrom().equals(componentDefinition.getWasDerivedFrom())) {
            Set<TopLevel> topLevels = SBOLDoc.getByWasDerivedFrom(c.getWasDerivedFrom());
            for (TopLevel topLevel : topLevels) {
                if (!(topLevel instanceof ComponentDefinition)) continue;
                return (ComponentDefinition)topLevel;
            }
            do {
                displayId = displayId + "_";
                identity = URIcompliance.createCompliantURI(URIPrefix, "cd", displayId, version, typesInURI);
                persIdentity = URIcompliance.createCompliantURI(URIPrefix, "cd", displayId, "", typesInURI).toString();
            } while (SBOLDoc.getComponentDefinition(identity) != null);
            c = c.copy(URIPrefix, displayId, version);
            if (identity != componentDef.getIdentity()) {
                c.setWasDerivedFrom(componentDef.getIdentity());
            }
            SBOLDoc.addComponentDefinition(c);
        } else {
            if (dropObjectsWithDuplicateURIs) {
                return componentDefinition;
            }
            if (!c.equals(componentDefinition)) {
                throw new SBOLValidationException("sbol-10202", c);
            }
        }
        return c;
    }

    private static Sequence parseDnaSequenceV1(SBOLDocument SBOLDoc, IdentifiableDocument<QName> topLevel) throws SBOLValidationException {
        Sequence oldS;
        String elements = null;
        String displayId = null;
        String name = null;
        String description = null;
        URI identity = topLevel.getIdentity();
        URI persistentIdentity = topLevel.getIdentity();
        URI encoding = Sequence.IUPAC_DNA;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (URIPrefix != null) {
            displayId = SBOLReader.findDisplayId(topLevel.getIdentity().toString());
            identity = URIcompliance.createCompliantURI(URIPrefix, "seq", displayId, version, typesInURI);
            persistentIdentity = URIcompliance.createCompliantURI(URIPrefix, "seq", displayId, "", typesInURI);
        }
        for (NamedProperty namedProperty : topLevel.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.DNASequence.nucleotides)) {
                elements = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", topLevel.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                if (URIPrefix == null) continue;
                identity = URIcompliance.createCompliantURI(URIPrefix, "seq", displayId, version, typesInURI);
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", topLevel.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", topLevel.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Sequence sequence = new Sequence(identity, elements, encoding);
        if (persistentIdentity != null) {
            sequence.setPersistentIdentity(persistentIdentity);
            sequence.setVersion(version);
        }
        if (identity != topLevel.getIdentity()) {
            sequence.setWasDerivedFrom(topLevel.getIdentity());
        }
        if (displayId != null) {
            sequence.setDisplayId(displayId);
        }
        if (name != null) {
            sequence.setName(name);
        }
        if (description != null) {
            sequence.setDescription(description);
        }
        if (!annotations.isEmpty()) {
            sequence.setAnnotations(annotations);
        }
        if ((oldS = SBOLDoc.getSequence(identity)) == null) {
            SBOLDoc.addSequence(sequence);
        } else if (sequence.isSetWasDerivedFrom() && oldS.isSetWasDerivedFrom() && !sequence.getWasDerivedFrom().equals(oldS.getWasDerivedFrom())) {
            Set<TopLevel> topLevels = SBOLDoc.getByWasDerivedFrom(sequence.getWasDerivedFrom());
            for (TopLevel top : topLevels) {
                if (!(top instanceof Sequence)) continue;
                return (Sequence)top;
            }
            do {
                displayId = displayId + "_";
                identity = URIcompliance.createCompliantURI(URIPrefix, "seq", displayId, version, typesInURI);
                persistentIdentity = URIcompliance.createCompliantURI(URIPrefix, "seq", displayId, "", typesInURI);
            } while (SBOLDoc.getSequence(identity) != null);
            sequence.setIdentity(identity);
            sequence.setDisplayId(displayId);
            sequence.setPersistentIdentity(persistentIdentity);
            SBOLDoc.addSequence(sequence);
        } else {
            if (dropObjectsWithDuplicateURIs) {
                return oldS;
            }
            if (!sequence.equals(oldS)) {
                throw new SBOLValidationException("sbol-10202", sequence);
            }
        }
        return sequence;
    }

    private static String findDisplayId(String topLevelIdentity) {
        String displayId = null;
        topLevelIdentity = topLevelIdentity.trim();
        while (topLevelIdentity.endsWith("/") || topLevelIdentity.endsWith("#") || topLevelIdentity.endsWith(":")) {
            topLevelIdentity = topLevelIdentity.replaceAll("/$", "");
            topLevelIdentity = topLevelIdentity.replaceAll("#$", "");
            topLevelIdentity = topLevelIdentity.replaceAll(":$", "");
        }
        int slash = topLevelIdentity.lastIndexOf(47);
        int pound = topLevelIdentity.lastIndexOf(35);
        int colon = topLevelIdentity.lastIndexOf(58);
        displayId = slash != -1 ? topLevelIdentity.substring(slash + 1) : (pound != -1 && pound > colon ? topLevelIdentity.substring(pound + 1) : (colon != -1 ? topLevelIdentity.substring(colon + 1) : topLevelIdentity.toString()));
        displayId = URIcompliance.fixDisplayId(displayId);
        return displayId;
    }

    private static Collection parseCollectionV1(SBOLDocument SBOLDoc, IdentifiableDocument<QName> topLevel) throws SBOLValidationException, SBOLConversionException {
        Collection oldC;
        URI identity = topLevel.getIdentity();
        URI persistentIdentity = null;
        String displayId = null;
        String name = null;
        String description = null;
        HashSet<URI> members = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (URIPrefix != null) {
            displayId = SBOLReader.findDisplayId(topLevel.getIdentity().toString());
            identity = URIcompliance.createCompliantURI(URIPrefix, "seq", displayId, version, typesInURI);
            persistentIdentity = URIcompliance.createCompliantURI(URIPrefix, "seq", displayId, "", typesInURI);
        }
        for (NamedProperty namedProperty : topLevel.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.Collection.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", topLevel.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                displayId = URIcompliance.fixDisplayId(displayId);
                if (URIPrefix == null) continue;
                identity = URIcompliance.createCompliantURI(URIPrefix, "col", displayId, version, typesInURI);
                persistentIdentity = URIcompliance.createCompliantURI(URIPrefix, "col", displayId, "", typesInURI);
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.Collection.name)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", topLevel.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.Collection.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", topLevel.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.Collection.component)) {
                if (namedProperty.getValue() instanceof Literal) {
                    members.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                    continue;
                }
                members.add(SBOLReader.parseDnaComponentV1(SBOLDoc, (IdentifiableDocument<QName>)((NestedDocument)namedProperty.getValue())).getIdentity());
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Collection c = new Collection(identity);
        if (persistentIdentity != null) {
            c.setPersistentIdentity(persistentIdentity);
            c.setVersion(version);
        }
        if (identity != topLevel.getIdentity()) {
            c.addWasDerivedFrom(topLevel.getIdentity());
        }
        if (displayId != null) {
            c.setDisplayId(displayId);
        }
        if (name != null) {
            c.setName(name);
        }
        if (description != null) {
            c.setDescription(description);
        }
        if (!members.isEmpty()) {
            c.setMembers(members);
        }
        if (!annotations.isEmpty()) {
            c.setAnnotations(annotations);
        }
        if ((oldC = SBOLDoc.getCollection(topLevel.getIdentity())) == null) {
            SBOLDoc.addCollection(c);
        } else if (!c.equals(oldC)) {
            throw new SBOLValidationException("sbol-10202", c);
        }
        return c;
    }

    private static SequenceAnnotation parseSequenceAnnotationV1(SBOLDocument SBOLDoc, NestedDocument<QName> sequenceAnnotation, List<SBOLPair> precedePairs, String parentURI, int sa_num, Set<String> instantiatedComponents) throws SBOLValidationException, SBOLConversionException {
        Integer start = null;
        Integer end = null;
        String strand = null;
        URI componentURI = null;
        URI identity = sequenceAnnotation.getIdentity();
        String persIdentity = sequenceAnnotation.getIdentity().toString();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (URIPrefix != null) {
            persIdentity = URIcompliance.createCompliantURI(parentURI, "annotation" + sa_num, "").toString();
            identity = URIcompliance.createCompliantURI(parentURI, "annotation" + sa_num, version);
        }
        if (!((QName)sequenceAnnotation.getType()).equals(Sbol1Terms.SequenceAnnotations.SequenceAnnotation)) {
            throw new SBOLConversionException("QName has to be" + Sbol1Terms.SequenceAnnotations.SequenceAnnotation.toString());
        }
        for (NamedProperty namedProperty : sequenceAnnotation.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.SequenceAnnotations.bioStart)) {
                if (!(namedProperty.getValue() instanceof Literal) || start != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-11102", sequenceAnnotation.getIdentity());
                }
                String temp = ((Literal)namedProperty.getValue()).getValue().toString();
                start = Integer.parseInt(temp);
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.SequenceAnnotations.bioEnd)) {
                if (!(namedProperty.getValue() instanceof Literal) || end != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-11103", sequenceAnnotation.getIdentity());
                }
                String temp2 = ((Literal)namedProperty.getValue()).getValue().toString();
                end = Integer.parseInt(temp2);
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.SequenceAnnotations.strand)) {
                if (!(namedProperty.getValue() instanceof Literal) || strand != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-11002", sequenceAnnotation.getIdentity());
                }
                strand = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.SequenceAnnotations.subComponent)) {
                if (componentURI != null) {
                    throw new SBOLValidationException("sbol-10904", sequenceAnnotation.getIdentity());
                }
                if (namedProperty.getValue() instanceof NestedDocument) {
                    componentURI = SBOLReader.parseDnaComponentV1(SBOLDoc, (IdentifiableDocument<QName>)((NestedDocument)namedProperty.getValue())).getIdentity();
                    continue;
                }
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10904", sequenceAnnotation.getIdentity());
                }
                componentURI = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol1Terms.SequenceAnnotations.precedes)) {
                URI left = sequenceAnnotation.getIdentity();
                URI right = null;
                if (namedProperty.getValue() instanceof NestedDocument) {
                    right = SBOLReader.parseSequenceAnnotationV1(SBOLDoc, (NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), precedePairs, parentURI, ++sa_num, instantiatedComponents).getIdentity();
                } else {
                    if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                        throw new SBOLValidationException("sbol-11404", sequenceAnnotation.getIdentity());
                    }
                    right = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                }
                SBOLPair pair = new SBOLPair(left, right);
                precedePairs.add(pair);
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        String componentDisplayId = URIcompliance.extractDisplayId(componentURI);
        String displayId = "annotation" + sa_num;
        if (compliant && componentDisplayId != null && !instantiatedComponents.contains(componentDisplayId)) {
            identity = URIcompliance.createCompliantURI(parentURI, componentDisplayId + "_annotation", version);
            persIdentity = URIcompliance.createCompliantURI(parentURI, componentDisplayId + "_annotation", "").toString();
            displayId = componentDisplayId + "_annotation";
        }
        Location location = null;
        if (start != null && end != null) {
            URI range_identity = URIcompliance.createCompliantURI(persIdentity, "range", version);
            location = new Range(range_identity, start, end);
            if (!persIdentity.equals("")) {
                location.setPersistentIdentity(URIcompliance.createCompliantURI(persIdentity, "range", ""));
                location.setDisplayId("range");
                location.setVersion(version);
            }
            if (strand != null) {
                if (strand.equals("+")) {
                    location.setOrientation(OrientationType.INLINE);
                } else if (strand.equals("-")) {
                    location.setOrientation(OrientationType.REVERSECOMPLEMENT);
                }
            }
        } else {
            URI dummyGenericLoc_id = URIcompliance.createCompliantURI(persIdentity, "genericLocation", version);
            location = new GenericLocation(dummyGenericLoc_id);
            if (!persIdentity.equals("")) {
                location.setPersistentIdentity(URIcompliance.createCompliantURI(persIdentity, "genericLocation", ""));
                location.setDisplayId("genericLocation");
                location.setVersion(version);
            }
            if (strand != null) {
                if (strand.equals("+")) {
                    location.setOrientation(OrientationType.INLINE);
                } else if (strand.equals("-")) {
                    location.setOrientation(OrientationType.REVERSECOMPLEMENT);
                }
            }
        }
        HashSet<Location> locations = new HashSet<Location>();
        locations.add(location);
        SequenceAnnotation s = new SequenceAnnotation(identity, locations);
        if (!persIdentity.equals("")) {
            s.setPersistentIdentity(URI.create(persIdentity));
            s.setDisplayId(displayId);
            s.setVersion(version);
        }
        if (identity != sequenceAnnotation.getIdentity()) {
            s.addWasDerivedFrom(sequenceAnnotation.getIdentity());
        }
        if (componentURI != null) {
            s.setComponent(componentURI);
        }
        if (!annotations.isEmpty()) {
            s.setAnnotations(annotations);
        }
        return s;
    }

    private static ComponentDefinition parseComponentDefinitions(SBOLDocument SBOLDoc, IdentifiableDocument<QName> topLevel, Map<URI, NestedDocument<QName>> nested) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        HashSet<URI> type = new HashSet<URI>();
        HashSet<URI> roles = new HashSet<URI>();
        HashSet<URI> sequences = new HashSet<URI>();
        HashSet<Component> components = new HashSet<Component>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        HashSet<SequenceAnnotation> sequenceAnnotations = new HashSet<SequenceAnnotation>();
        HashSet<SequenceConstraint> sequenceConstraints = new HashSet<SequenceConstraint>();
        for (NamedProperty namedProperty : topLevel.getProperties()) {
            NestedDocument<QName> nestedDocument;
            URI uri;
            NestedDocument nestedDocument2;
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", topLevel.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", topLevel.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", topLevel.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentDefinition.type)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10502", topLevel.getIdentity());
                }
                type.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentDefinition.roles)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10507", topLevel.getIdentity());
                }
                roles.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentDefinition.hasComponent) || ((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentDefinition.hasSubComponent)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    nestedDocument2 = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument2.getType() == null || !((QName)nestedDocument2.getType()).equals(Sbol2Terms.Component.Component)) {
                        throw new SBOLValidationException("sbol-10519", topLevel.getIdentity());
                    }
                    components.add(SBOLReader.parseComponent(SBOLDoc, (NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), nested));
                    continue;
                }
                uri = (URI)((Literal)namedProperty.getValue()).getValue();
                nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.Component.Component)) {
                    throw new SBOLValidationException("sbol-10519", topLevel.getIdentity());
                }
                components.add(SBOLReader.parseComponent(SBOLDoc, nested.get(uri), nested));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentDefinition.hasSequence)) {
                if (namedProperty.getValue() instanceof Literal) {
                    if (!(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                        throw new SBOLValidationException("sbol-10512", topLevel.getIdentity());
                    }
                    sequences.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                    continue;
                }
                if (namedProperty.getValue() instanceof IdentifiableDocument) {
                    if (((QName)((IdentifiableDocument)namedProperty).getType()).equals(Sbol2Terms.Sequence.Sequence)) {
                        Sequence sequence = SBOLReader.parseSequences(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty.getValue()));
                        sequences.add(sequence.getIdentity());
                        continue;
                    }
                    throw new SBOLValidationException("sbol-10512", topLevel.getIdentity());
                }
                throw new SBOLValidationException("sbol-10512", topLevel.getIdentity());
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentDefinition.hasSequenceAnnotations)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    nestedDocument2 = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument2.getType() == null || !((QName)nestedDocument2.getType()).equals(Sbol2Terms.SequenceAnnotation.SequenceAnnotation)) {
                        throw new SBOLValidationException("sbol-10521", topLevel.getIdentity());
                    }
                    sequenceAnnotations.add(SBOLReader.parseSequenceAnnotation((NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), nested));
                    continue;
                }
                uri = (URI)((Literal)namedProperty.getValue()).getValue();
                nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.SequenceAnnotation.SequenceAnnotation)) {
                    throw new SBOLValidationException("sbol-10521", topLevel.getIdentity());
                }
                sequenceAnnotations.add(SBOLReader.parseSequenceAnnotation(nested.get(uri), nested));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentDefinition.hasSequenceConstraints)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    nestedDocument2 = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument2.getType() == null || !((QName)nestedDocument2.getType()).equals(Sbol2Terms.SequenceConstraint.SequenceConstraint)) {
                        throw new SBOLValidationException("sbol-10524", topLevel.getIdentity());
                    }
                    sequenceConstraints.add(SBOLReader.parseSequenceConstraint((NestedDocument<QName>)((NestedDocument)namedProperty.getValue())));
                    continue;
                }
                uri = (URI)((Literal)namedProperty.getValue()).getValue();
                nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.SequenceConstraint.SequenceConstraint)) {
                    throw new SBOLValidationException("sbol-10524", topLevel.getIdentity());
                }
                sequenceConstraints.add(SBOLReader.parseSequenceConstraint(nested.get(uri)));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", topLevel.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", topLevel.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", topLevel.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        ComponentDefinition c = new ComponentDefinition(topLevel.getIdentity(), type);
        if (roles != null) {
            c.setRoles(roles);
        }
        if (displayId != null) {
            c.setDisplayId(displayId);
        }
        if (persistentIdentity != null) {
            c.setPersistentIdentity(persistentIdentity);
        }
        if (!sequences.isEmpty()) {
            c.setSequences(sequences);
        }
        if (!components.isEmpty()) {
            c.setComponents(components);
        }
        if (!sequenceAnnotations.isEmpty()) {
            c.setSequenceAnnotations(sequenceAnnotations);
        }
        if (!sequenceConstraints.isEmpty()) {
            c.setSequenceConstraints(sequenceConstraints);
        }
        if (name != null) {
            c.setName(name);
        }
        if (description != null) {
            c.setDescription(description);
        }
        if (!annotations.isEmpty()) {
            c.setAnnotations(annotations);
        }
        if (version != null) {
            c.setVersion(version);
        }
        c.setWasDerivedFroms(wasDerivedFroms);
        ComponentDefinition oldC = SBOLDoc.getComponentDefinition(topLevel.getIdentity());
        if (oldC == null) {
            SBOLDoc.addComponentDefinition(c);
        } else if (!c.equals(oldC)) {
            throw new SBOLValidationException("sbol-10202", c);
        }
        return c;
    }

    private static SequenceConstraint parseSequenceConstraint(NestedDocument<QName> sequenceConstraint) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        URI restriction = null;
        URI subject = null;
        URI object = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : sequenceConstraint.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", sequenceConstraint.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.SequenceConstraint.restriction)) {
                if (!(namedProperty.getValue() instanceof Literal) || restriction != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-11407", sequenceConstraint.getIdentity());
                }
                restriction = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.SequenceConstraint.hasSubject)) {
                if (!(namedProperty.getValue() instanceof Literal) || subject != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-11402", sequenceConstraint.getIdentity());
                }
                subject = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.SequenceConstraint.hasObject)) {
                if (!(namedProperty.getValue() instanceof Literal) || object != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-11404", sequenceConstraint.getIdentity());
                }
                object = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", sequenceConstraint.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", sequenceConstraint.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", sequenceConstraint.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", sequenceConstraint.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", sequenceConstraint.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        SequenceConstraint s = new SequenceConstraint(sequenceConstraint.getIdentity(), restriction, subject, object);
        if (displayId != null) {
            s.setDisplayId(displayId);
        }
        if (name != null) {
            s.setName(name);
        }
        if (description != null) {
            s.setDescription(description);
        }
        if (persistentIdentity != null) {
            s.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            s.setVersion(version);
        }
        s.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            s.setAnnotations(annotations);
        }
        return s;
    }

    private static SequenceAnnotation parseSequenceAnnotation(NestedDocument<QName> sequenceAnnotation, Map<URI, NestedDocument<QName>> nested) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        Location location = null;
        URI componentURI = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        HashSet<URI> roles = new HashSet<URI>();
        HashSet<Location> locations = new HashSet<Location>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : sequenceAnnotation.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", sequenceAnnotation.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", sequenceAnnotation.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", sequenceAnnotation.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.SequenceAnnotation.roles)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10906", sequenceAnnotation.getIdentity());
                }
                roles.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Location.Location)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    NestedDocument nestedDocument = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.Range.Range) && !((QName)nestedDocument.getType()).equals(Sbol2Terms.Cut.Cut) && !((QName)nestedDocument.getType()).equals(Sbol2Terms.GenericLocation.GenericLocation)) {
                        throw new SBOLValidationException("sbol-10902", sequenceAnnotation.getIdentity());
                    }
                    location = SBOLReader.parseLocation((NestedDocument<QName>)((NestedDocument)namedProperty.getValue()));
                } else {
                    URI uri = (URI)((Literal)namedProperty.getValue()).getValue();
                    NestedDocument<QName> nestedDocument = nested.get(uri);
                    if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.Range.Range) && !((QName)nestedDocument.getType()).equals(Sbol2Terms.Cut.Cut) && !((QName)nestedDocument.getType()).equals(Sbol2Terms.GenericLocation.GenericLocation)) {
                        throw new SBOLValidationException("sbol-10902", sequenceAnnotation.getIdentity());
                    }
                    location = SBOLReader.parseLocation(nested.get(uri));
                }
                locations.add(location);
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.SequenceAnnotation.hasComponent)) {
                if (!(namedProperty.getValue() instanceof Literal) || componentURI != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10904", sequenceAnnotation.getIdentity());
                }
                componentURI = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", sequenceAnnotation.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", sequenceAnnotation.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", sequenceAnnotation.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        SequenceAnnotation s = new SequenceAnnotation(sequenceAnnotation.getIdentity(), locations);
        if (persistentIdentity != null) {
            s.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            s.setVersion(version);
        }
        if (displayId != null) {
            s.setDisplayId(displayId);
        }
        if (componentURI != null) {
            s.setComponent(componentURI);
        }
        if (name != null) {
            s.setName(name);
        }
        if (description != null) {
            s.setDescription(description);
        }
        s.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            s.setAnnotations(annotations);
        }
        if (!roles.isEmpty()) {
            s.setRoles(roles);
        }
        return s;
    }

    private static Location parseLocation(NestedDocument<QName> location) throws SBOLValidationException {
        Location l = null;
        if (((QName)location.getType()).equals(Sbol2Terms.Range.Range)) {
            l = SBOLReader.parseRange(location);
        } else if (((QName)location.getType()).equals(Sbol2Terms.Cut.Cut)) {
            l = SBOLReader.parseCut(location);
        } else if (((QName)location.getType()).equals(Sbol2Terms.GenericLocation.GenericLocation)) {
            l = SBOLReader.parseGenericLocation(location);
        }
        return l;
    }

    private static GenericLocation parseGenericLocation(NestedDocument<QName> typeGenLoc) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        URI orientation = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : typeGenLoc.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.GenericLocation.orientation)) {
                if (!(namedProperty.getValue() instanceof Literal) || orientation != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-11002", typeGenLoc.getIdentity());
                }
                orientation = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", typeGenLoc.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", typeGenLoc.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", typeGenLoc.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", typeGenLoc.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", typeGenLoc.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", typeGenLoc.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        GenericLocation gl = new GenericLocation(typeGenLoc.getIdentity());
        if (displayId != null) {
            gl.setDisplayId(displayId);
        }
        if (name != null) {
            gl.setName(name);
        }
        if (description != null) {
            gl.setDescription(description);
        }
        if (orientation != null) {
            try {
                gl.setOrientation(OrientationType.convertToOrientationType(orientation));
            }
            catch (SBOLValidationException e) {
                throw new SBOLValidationException("sbol-11002", gl);
            }
        }
        if (persistentIdentity != null) {
            gl.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            gl.setVersion(version);
        }
        gl.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            gl.setAnnotations(annotations);
        }
        return gl;
    }

    private static Cut parseCut(NestedDocument<QName> typeCut) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        Integer at = null;
        URI orientation = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : typeCut.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", typeCut.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", typeCut.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", typeCut.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", typeCut.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Cut.at)) {
                if (!(namedProperty.getValue() instanceof Literal) || at != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-11202", typeCut.getIdentity());
                }
                String temp = ((Literal)namedProperty.getValue()).getValue().toString();
                try {
                    at = Integer.parseInt(temp);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SBOLValidationException("sbol-11202", typeCut.getIdentity());
                }
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Cut.orientation)) {
                if (!(namedProperty.getValue() instanceof Literal) || orientation != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-11002", typeCut.getIdentity());
                }
                orientation = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", typeCut.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", typeCut.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        if (at == null) {
            throw new SBOLValidationException("Cut requires at property.", new Identified[0]);
        }
        Cut c = new Cut(typeCut.getIdentity(), at);
        if (persistentIdentity != null) {
            c.setPersistentIdentity(persistentIdentity);
        }
        if (displayId != null) {
            c.setDisplayId(displayId);
        }
        if (name != null) {
            c.setName(name);
        }
        if (description != null) {
            c.setDescription(description);
        }
        if (orientation != null) {
            try {
                c.setOrientation(OrientationType.convertToOrientationType(orientation));
            }
            catch (SBOLValidationException e) {
                throw new SBOLValidationException("sbol-11002", c);
            }
        }
        if (version != null) {
            c.setVersion(version);
        }
        c.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            c.setAnnotations(annotations);
        }
        return c;
    }

    private static Location parseRange(NestedDocument<QName> typeRange) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        Integer start = null;
        Integer end = null;
        URI orientation = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : typeRange.getProperties()) {
            String temp;
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Range.start)) {
                if (!(namedProperty.getValue() instanceof Literal) || start != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-11102", typeRange.getIdentity());
                }
                temp = ((Literal)namedProperty.getValue()).getValue().toString();
                try {
                    start = Integer.parseInt(temp);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SBOLValidationException("sbol-11102", typeRange.getIdentity());
                }
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", typeRange.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", typeRange.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", typeRange.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", typeRange.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Range.end)) {
                if (!(namedProperty.getValue() instanceof Literal) || end != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-11103", typeRange.getIdentity());
                }
                temp = ((Literal)namedProperty.getValue()).getValue().toString();
                try {
                    end = Integer.parseInt(temp);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SBOLValidationException("sbol-11103", typeRange.getIdentity());
                }
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Range.orientation)) {
                if (!(namedProperty.getValue() instanceof Literal) || orientation != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-11002", typeRange.getIdentity());
                }
                orientation = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", typeRange.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", typeRange.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Range r = new Range(typeRange.getIdentity(), start, end);
        if (displayId != null) {
            r.setDisplayId(displayId);
        }
        if (name != null) {
            r.setName(name);
        }
        if (description != null) {
            r.setDescription(description);
        }
        if (persistentIdentity != null) {
            r.setPersistentIdentity(persistentIdentity);
        }
        if (orientation != null) {
            try {
                r.setOrientation(OrientationType.convertToOrientationType(orientation));
            }
            catch (SBOLValidationException e) {
                throw new SBOLValidationException("sbol-11002", r);
            }
        }
        if (version != null) {
            r.setVersion(version);
        }
        r.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            r.setAnnotations(annotations);
        }
        return r;
    }

    private static Component parseComponent(SBOLDocument SBOLDoc, NestedDocument<QName> component, Map<URI, NestedDocument<QName>> nested) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        URI subComponentURI = null;
        AccessType access = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        HashSet<URI> roles = new HashSet<URI>();
        URI roleIntegration = null;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        HashSet<MapsTo> mapsTo = new HashSet<MapsTo>();
        for (NamedProperty namedProperty : component.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", component.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", component.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", component.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Component.roles)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10702", component.getIdentity());
                }
                roles.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Component.roleIntegration)) {
                if (!(namedProperty.getValue() instanceof Literal) || roleIntegration != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10708", component.getIdentity());
                }
                roleIntegration = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentInstance.access)) {
                if (!(namedProperty.getValue() instanceof Literal) || access != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10607", component.getIdentity());
                }
                String accessTypeStr = ((Literal)namedProperty.getValue()).getValue().toString();
                if (accessTypeStr.startsWith("http://www.sbolstandard.org/")) {
                    System.out.println("Warning: namespace for access types should be http://sbols.org/v2#");
                    accessTypeStr = accessTypeStr.replace("http://www.sbolstandard.org/", "http://sbols.org/v2#");
                }
                try {
                    access = AccessType.convertToAccessType(URI.create(accessTypeStr));
                    continue;
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException("sbol-10607", component.getIdentity());
                }
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Module.hasMapsTo)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    NestedDocument nestedDocument = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.MapsTo.MapsTo)) {
                        throw new SBOLValidationException("sbol-10606", component.getIdentity());
                    }
                    mapsTo.add(SBOLReader.parseMapsTo((NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), false));
                    continue;
                }
                URI uri = (URI)((Literal)namedProperty.getValue()).getValue();
                NestedDocument<QName> nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.MapsTo.MapsTo)) {
                    throw new SBOLValidationException("sbol-10606", component.getIdentity());
                }
                mapsTo.add(SBOLReader.parseMapsTo(nested.get(uri), false));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentInstance.hasComponentDefinition)) {
                if (subComponentURI != null) {
                    throw new SBOLValidationException("sbol-10602", component.getIdentity());
                }
                if (namedProperty.getValue() instanceof Literal) {
                    if (!(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                        throw new SBOLValidationException("sbol-10602", component.getIdentity());
                    }
                    subComponentURI = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                    continue;
                }
                if (namedProperty.getValue() instanceof IdentifiableDocument) {
                    if (((QName)((IdentifiableDocument)namedProperty).getType()).equals(Sbol2Terms.ComponentDefinition.ComponentDefinition)) {
                        ComponentDefinition componentDefinition = SBOLReader.parseComponentDefinitions(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty.getValue()), nested);
                        subComponentURI = componentDefinition.getIdentity();
                        continue;
                    }
                    throw new SBOLValidationException("sbol-10602", component.getIdentity());
                }
                throw new SBOLValidationException("sbol-10602", component.getIdentity());
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", component.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", component.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", component.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Component c = new Component(component.getIdentity(), access, subComponentURI);
        if (persistentIdentity != null) {
            c.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            c.setVersion(version);
        }
        if (displayId != null) {
            c.setDisplayId(displayId);
        }
        if (access != null) {
            c.setAccess(access);
        }
        if (roleIntegration != null) {
            try {
                c.setRoleIntegration(RoleIntegrationType.convertToRoleIntegrationType(roleIntegration));
            }
            catch (SBOLValidationException e) {
                throw new SBOLValidationException("sbol-10708", c);
            }
        }
        if (!roles.isEmpty()) {
            c.setRoles(roles);
        }
        if (!mapsTo.isEmpty()) {
            c.setMapsTos(mapsTo);
        }
        if (subComponentURI != null) {
            c.setDefinition(subComponentURI);
        }
        if (name != null) {
            c.setName(name);
        }
        if (description != null) {
            c.setDescription(description);
        }
        c.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            c.setAnnotations(annotations);
        }
        return c;
    }

    private static GenericTopLevel parseGenericTopLevel(SBOLDocument SBOLDoc, IdentifiableDocument<QName> topLevel) throws SBOLValidationException {
        GenericTopLevel oldG;
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        QName type = (QName)topLevel.getType();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : topLevel.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Description.type)) {
                String typeStr = ((Literal)namedProperty.getValue()).getValue().toString();
                String nameSpace = URIcompliance.extractNamespace(URI.create(typeStr));
                String localPart = URIcompliance.extractDisplayId(URI.create(typeStr));
                String prefix = SBOLDoc.getNamespacePrefix(URI.create(nameSpace));
                type = new QName(nameSpace, localPart, prefix);
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", topLevel.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", topLevel.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", topLevel.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", topLevel.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", topLevel.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", topLevel.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        GenericTopLevel t = new GenericTopLevel(topLevel.getIdentity(), type);
        if (persistentIdentity != null) {
            t.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            t.setVersion(version);
        }
        if (displayId != null) {
            t.setDisplayId(displayId);
        }
        if (name != null) {
            t.setName(name);
        }
        if (description != null) {
            t.setDescription(description);
        }
        t.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            t.setAnnotations(annotations);
        }
        if ((oldG = SBOLDoc.getGenericTopLevel(topLevel.getIdentity())) == null) {
            SBOLDoc.addGenericTopLevel(t);
        } else if (!t.equals(oldG)) {
            throw new SBOLValidationException("sbol-10202", t);
        }
        return t;
    }

    private static Model parseModels(SBOLDocument SBOLDoc, IdentifiableDocument<QName> topLevel) throws SBOLValidationException {
        Model oldM;
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        URI source = null;
        URI language = null;
        URI framework = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : topLevel.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", topLevel.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", topLevel.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", topLevel.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Model.source)) {
                if (!(namedProperty.getValue() instanceof Literal) || source != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10502", topLevel.getIdentity());
                }
                source = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Model.language)) {
                if (!(namedProperty.getValue() instanceof Literal) || language != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10504", topLevel.getIdentity());
                }
                language = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Model.framework)) {
                if (!(namedProperty.getValue() instanceof Literal) || framework != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10508", topLevel.getIdentity());
                }
                framework = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", topLevel.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", topLevel.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", topLevel.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Model m = new Model(topLevel.getIdentity(), source, language, framework);
        if (persistentIdentity != null) {
            m.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            m.setVersion(version);
        }
        if (displayId != null) {
            m.setDisplayId(displayId);
        }
        if (name != null) {
            m.setName(name);
        }
        if (description != null) {
            m.setDescription(description);
        }
        m.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            m.setAnnotations(annotations);
        }
        if ((oldM = SBOLDoc.getModel(topLevel.getIdentity())) == null) {
            SBOLDoc.addModel(m);
        } else if (!m.equals(oldM)) {
            throw new SBOLValidationException("sbol-10202", m);
        }
        return m;
    }

    private static Collection parseCollections(SBOLDocument SBOLDoc, IdentifiableDocument<QName> topLevel, Map<URI, NestedDocument<QName>> nested) throws SBOLValidationException {
        Collection oldC;
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        HashSet<URI> members = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : topLevel.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", topLevel.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", topLevel.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", topLevel.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Collection.hasMembers)) {
                if (namedProperty.getValue() instanceof Literal) {
                    if (!(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                        throw new SBOLValidationException("sbol-12102", topLevel.getIdentity());
                    }
                    members.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                    continue;
                }
                if (namedProperty.getValue() instanceof NestedDocument) {
                    if (((IdentifiableDocument)namedProperty).getType().equals(Sbol2Terms.Collection.Collection)) {
                        SBOLReader.parseCollections(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty), nested);
                        continue;
                    }
                    if (((IdentifiableDocument)namedProperty).equals(Sbol2Terms.ModuleDefinition.ModuleDefinition)) {
                        SBOLReader.parseModuleDefinition(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty), nested);
                        continue;
                    }
                    if (((IdentifiableDocument)namedProperty).equals(Sbol2Terms.Model.Model)) {
                        SBOLReader.parseModels(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty));
                        continue;
                    }
                    if (((IdentifiableDocument)namedProperty).equals(Sbol2Terms.Sequence.Sequence)) {
                        SBOLReader.parseSequences(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty));
                        continue;
                    }
                    if (((IdentifiableDocument)namedProperty).equals(Sbol2Terms.ComponentDefinition.ComponentDefinition)) {
                        SBOLReader.parseComponentDefinitions(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty), nested);
                        continue;
                    }
                    SBOLReader.parseGenericTopLevel(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty));
                    continue;
                }
                throw new SBOLValidationException("sbol-12102", topLevel.getIdentity());
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", topLevel.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", topLevel.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", topLevel.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Collection c = new Collection(topLevel.getIdentity());
        if (displayId != null) {
            c.setDisplayId(displayId);
        }
        if (version != null) {
            c.setVersion(version);
        }
        if (persistentIdentity != null) {
            c.setPersistentIdentity(persistentIdentity);
        }
        if (!members.isEmpty()) {
            c.setMembers(members);
        }
        if (name != null) {
            c.setName(name);
        }
        if (description != null) {
            c.setDescription(description);
        }
        c.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            c.setAnnotations(annotations);
        }
        if ((oldC = SBOLDoc.getCollection(topLevel.getIdentity())) == null) {
            SBOLDoc.addCollection(c);
        } else if (!c.equals(oldC)) {
            throw new SBOLValidationException("sbol-10202", c);
        }
        return c;
    }

    private static ModuleDefinition parseModuleDefinition(SBOLDocument SBOLDoc, IdentifiableDocument<QName> topLevel, Map<URI, NestedDocument<QName>> nested) throws SBOLValidationException {
        ModuleDefinition oldM;
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        HashSet<URI> roles = new HashSet<URI>();
        HashSet<URI> models = new HashSet<URI>();
        HashSet<FunctionalComponent> functionalComponents = new HashSet<FunctionalComponent>();
        HashSet<Interaction> interactions = new HashSet<Interaction>();
        HashSet<Module> subModules = new HashSet<Module>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : topLevel.getProperties()) {
            NestedDocument<QName> nestedDocument;
            URI uri;
            NestedDocument nestedDocument2;
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", topLevel.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", topLevel.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", topLevel.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ModuleDefinition.roles)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-11602", topLevel.getIdentity());
                }
                roles.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ModuleDefinition.hasModule) || ((QName)namedProperty.getName()).equals(Sbol2Terms.ModuleDefinition.hasSubModule)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    nestedDocument2 = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument2.getType() == null || !((QName)nestedDocument2.getType()).equals(Sbol2Terms.Module.Module)) {
                        throw new SBOLValidationException("sbol-11604", topLevel.getIdentity());
                    }
                    subModules.add(SBOLReader.parseModule(SBOLDoc, (NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), nested));
                    continue;
                }
                uri = (URI)((Literal)namedProperty.getValue()).getValue();
                nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.Module.Module)) {
                    throw new SBOLValidationException("sbol-11604", topLevel.getIdentity());
                }
                subModules.add(SBOLReader.parseModule(SBOLDoc, nested.get(uri), nested));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ModuleDefinition.hasInteractions)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    nestedDocument2 = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument2.getType() == null || !((QName)nestedDocument2.getType()).equals(Sbol2Terms.Interaction.Interaction)) {
                        throw new SBOLValidationException("sbol-11605", topLevel.getIdentity());
                    }
                    interactions.add(SBOLReader.parseInteraction((NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), nested));
                    continue;
                }
                uri = (URI)((Literal)namedProperty.getValue()).getValue();
                nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.Interaction.Interaction)) {
                    throw new SBOLValidationException("sbol-11605", topLevel.getIdentity());
                }
                interactions.add(SBOLReader.parseInteraction(nested.get(uri), nested));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ModuleDefinition.hasfunctionalComponent) || ((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentDefinition.hasComponent)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    nestedDocument2 = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument2.getType() == null || !((QName)nestedDocument2.getType()).equals(Sbol2Terms.FunctionalComponent.FunctionalComponent)) {
                        throw new SBOLValidationException("sbol-11606", topLevel.getIdentity());
                    }
                    functionalComponents.add(SBOLReader.parseFunctionalComponent(SBOLDoc, (NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), nested));
                    continue;
                }
                uri = (URI)((Literal)namedProperty.getValue()).getValue();
                nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.FunctionalComponent.FunctionalComponent)) {
                    throw new SBOLValidationException("sbol-11606", topLevel.getIdentity());
                }
                functionalComponents.add(SBOLReader.parseFunctionalComponent(SBOLDoc, nested.get(uri), nested));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ModuleDefinition.hasModels)) {
                if (namedProperty.getValue() instanceof Literal) {
                    if (!(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                        throw new SBOLValidationException("sbol-11607", topLevel.getIdentity());
                    }
                    models.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                    continue;
                }
                if (namedProperty.getValue() instanceof IdentifiableDocument) {
                    if (((QName)((IdentifiableDocument)namedProperty).getType()).equals(Sbol2Terms.Model.Model)) {
                        Model model = SBOLReader.parseModels(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty.getValue()));
                        models.add(model.getIdentity());
                        continue;
                    }
                    throw new SBOLValidationException("sbol-11607", topLevel.getIdentity());
                }
                throw new SBOLValidationException("sbol-11607", topLevel.getIdentity());
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", topLevel.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", topLevel.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", topLevel.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        ModuleDefinition moduleDefinition = new ModuleDefinition(topLevel.getIdentity());
        if (!roles.isEmpty()) {
            moduleDefinition.setRoles(roles);
        }
        if (persistentIdentity != null) {
            moduleDefinition.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            moduleDefinition.setVersion(version);
        }
        if (displayId != null) {
            moduleDefinition.setDisplayId(displayId);
        }
        if (!functionalComponents.isEmpty()) {
            moduleDefinition.setFunctionalComponents(functionalComponents);
        }
        if (!interactions.isEmpty()) {
            moduleDefinition.setInteractions(interactions);
        }
        if (!models.isEmpty()) {
            moduleDefinition.setModels(models);
        }
        if (!subModules.isEmpty()) {
            moduleDefinition.setModules(subModules);
        }
        if (name != null) {
            moduleDefinition.setName(name);
        }
        if (description != null) {
            moduleDefinition.setDescription(description);
        }
        moduleDefinition.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            moduleDefinition.setAnnotations(annotations);
        }
        if ((oldM = SBOLDoc.getModuleDefinition(topLevel.getIdentity())) == null) {
            SBOLDoc.addModuleDefinition(moduleDefinition);
        } else if (!moduleDefinition.equals(oldM)) {
            throw new SBOLValidationException("sbol-10202", moduleDefinition);
        }
        return moduleDefinition;
    }

    private static Module parseModule(SBOLDocument SBOLDoc, NestedDocument<QName> module, Map<URI, NestedDocument<QName>> nested) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        URI definitionURI = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        HashSet<MapsTo> mappings = new HashSet<MapsTo>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : module.getProperties()) {
            URI uri;
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", module.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", module.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", module.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Module.hasMapsTo)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    NestedDocument nestedDocument = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.MapsTo.MapsTo)) {
                        throw new SBOLValidationException("sbol-11706", module.getIdentity());
                    }
                    mappings.add(SBOLReader.parseMapsTo((NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), false));
                    continue;
                }
                uri = (URI)((Literal)namedProperty.getValue()).getValue();
                NestedDocument<QName> nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.MapsTo.MapsTo)) {
                    throw new SBOLValidationException("sbol-11706", module.getIdentity());
                }
                mappings.add(SBOLReader.parseMapsTo(nested.get(uri), false));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Module.hasMapping)) {
                System.out.println("Warning: tag should be sbol:mapTo, not sbol:mapping.");
                if (namedProperty.getValue() instanceof NestedDocument) {
                    mappings.add(SBOLReader.parseMapsTo((NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), true));
                    continue;
                }
                uri = (URI)((Literal)namedProperty.getValue()).getValue();
                mappings.add(SBOLReader.parseMapsTo(nested.get(uri), true));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Module.hasDefinition)) {
                if (definitionURI != null) {
                    throw new SBOLValidationException("sbol-11702", module.getIdentity());
                }
                if (namedProperty.getValue() instanceof Literal) {
                    if (!(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                        throw new SBOLValidationException("sbol-11702", module.getIdentity());
                    }
                    definitionURI = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                    continue;
                }
                if (namedProperty.getValue() instanceof IdentifiableDocument) {
                    if (((QName)((IdentifiableDocument)namedProperty).getType()).equals(Sbol2Terms.ModuleDefinition.ModuleDefinition)) {
                        ModuleDefinition moduleDefinition = SBOLReader.parseModuleDefinition(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty.getValue()), nested);
                        definitionURI = moduleDefinition.getIdentity();
                        continue;
                    }
                    throw new SBOLValidationException("sbol-11702", module.getIdentity());
                }
                throw new SBOLValidationException("sbol-11702", module.getIdentity());
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", module.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", module.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", module.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Module submodule = new Module(module.getIdentity(), definitionURI);
        if (persistentIdentity != null) {
            submodule.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            submodule.setVersion(version);
        }
        if (displayId != null) {
            submodule.setDisplayId(displayId);
        }
        if (!mappings.isEmpty()) {
            submodule.setMapsTos(mappings);
        }
        if (name != null) {
            submodule.setName(name);
        }
        if (description != null) {
            submodule.setDescription(description);
        }
        submodule.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            submodule.setAnnotations(annotations);
        }
        return submodule;
    }

    private static MapsTo parseMapsTo(NestedDocument<QName> mapsTo, boolean inModule) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        URI remote = null;
        RefinementType refinement = null;
        URI local = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : mapsTo.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", mapsTo.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", mapsTo.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", mapsTo.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", mapsTo.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", mapsTo.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.MapsTo.refinement)) {
                if (!(namedProperty.getValue() instanceof Literal) || refinement != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10810", mapsTo.getIdentity());
                }
                String refinementStr = ((Literal)namedProperty.getValue()).getValue().toString();
                if (!refinementStr.startsWith("http://sbols.org/v2#")) {
                    System.out.println("Warning: namespace for refinement types should be http://sbols.org/v2#");
                    refinementStr = "http://sbols.org/v2#" + refinementStr;
                }
                try {
                    refinement = RefinementType.convertToRefinementType(URI.create(refinementStr));
                    continue;
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException("sbol-10810", mapsTo.getIdentity());
                }
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.MapsTo.hasRemote)) {
                if (!(namedProperty.getValue() instanceof Literal) || remote != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10805", mapsTo.getIdentity());
                }
                remote = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.MapsTo.hasLocal)) {
                if (!(namedProperty.getValue() instanceof Literal) || local != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10802", mapsTo.getIdentity());
                }
                local = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", mapsTo.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        MapsTo map = new MapsTo(mapsTo.getIdentity(), refinement, local, remote);
        if (displayId != null) {
            map.setDisplayId(displayId);
        }
        if (name != null) {
            map.setName(name);
        }
        if (description != null) {
            map.setDescription(description);
        }
        if (persistentIdentity != null) {
            map.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            map.setVersion(version);
        }
        map.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            map.setAnnotations(annotations);
        }
        return map;
    }

    private static Interaction parseInteraction(NestedDocument<QName> interaction, Map<URI, NestedDocument<QName>> nested) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        HashSet<URI> type = new HashSet<URI>();
        HashSet<Participation> participations = new HashSet<Participation>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : interaction.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", interaction.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", interaction.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", interaction.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Interaction.type)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-11902", interaction.getIdentity());
                }
                type.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Interaction.hasParticipations)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    NestedDocument nestedDocument = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.Participation.Participation)) {
                        throw new SBOLValidationException("sbol-11906", interaction.getIdentity());
                    }
                    participations.add(SBOLReader.parseParticipation((NestedDocument<QName>)((NestedDocument)namedProperty.getValue())));
                    continue;
                }
                URI uri = (URI)((Literal)namedProperty.getValue()).getValue();
                NestedDocument<QName> nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.Participation.Participation)) {
                    throw new SBOLValidationException("sbol-11906", interaction.getIdentity());
                }
                participations.add(SBOLReader.parseParticipation(nested.get(uri)));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", interaction.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", interaction.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", interaction.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Interaction i = new Interaction(interaction.getIdentity(), type);
        if (!participations.isEmpty()) {
            i.setParticipations(participations);
        }
        if (persistentIdentity != null) {
            i.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            i.setVersion(version);
        }
        if (displayId != null) {
            i.setDisplayId(displayId);
        }
        if (name != null) {
            i.setName(name);
        }
        if (description != null) {
            i.setDescription(description);
        }
        i.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            i.setAnnotations(annotations);
        }
        return i;
    }

    private static Participation parseParticipation(NestedDocument<QName> participation) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        HashSet<URI> roles = new HashSet<URI>();
        URI participant = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : participation.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", participation.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", participation.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", participation.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", participation.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", participation.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Participation.role)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-12004", participation.getIdentity());
                }
                roles.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Participation.hasParticipant)) {
                if (!(namedProperty.getValue() instanceof Literal) || participant != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-12002", participation.getIdentity());
                }
                participant = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", participation.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Participation p = new Participation(participation.getIdentity(), participant, roles);
        if (displayId != null) {
            p.setDisplayId(displayId);
        }
        if (name != null) {
            p.setName(name);
        }
        if (description != null) {
            p.setDescription(description);
        }
        if (persistentIdentity != null) {
            p.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            p.setVersion(version);
        }
        p.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            p.setAnnotations(annotations);
        }
        return p;
    }

    private static FunctionalComponent parseFunctionalComponent(SBOLDocument SBOLDoc, NestedDocument<QName> functionalComponent, Map<URI, NestedDocument<QName>> nested) throws SBOLValidationException {
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        AccessType access = null;
        DirectionType direction = null;
        URI functionalComponentURI = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        HashSet<MapsTo> mappings = new HashSet<MapsTo>();
        for (NamedProperty namedProperty : functionalComponent.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", functionalComponent.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", functionalComponent.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", functionalComponent.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentInstance.access)) {
                if (!(namedProperty.getValue() instanceof Literal) || access != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10607", functionalComponent.getIdentity());
                }
                String accessTypeStr = ((Literal)namedProperty.getValue()).getValue().toString();
                if (accessTypeStr.startsWith("http://www.sbolstandard.org/")) {
                    System.out.println("Warning: namespace for access types should be http://sbols.org/v2#");
                    accessTypeStr = accessTypeStr.replace("http://www.sbolstandard.org/", "http://sbols.org/v2#");
                }
                try {
                    access = AccessType.convertToAccessType(URI.create(accessTypeStr));
                    continue;
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException("sbol-10607", functionalComponent.getIdentity());
                }
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.FunctionalComponent.direction)) {
                if (!(namedProperty.getValue() instanceof Literal) || direction != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-11802", functionalComponent.getIdentity());
                }
                String directionTypeStr = ((Literal)namedProperty.getValue()).getValue().toString();
                if (directionTypeStr.startsWith("http://www.sbolstandard.org/")) {
                    System.out.println("Warning: namespace for direction types should be http://sbols.org/v2#");
                    directionTypeStr = directionTypeStr.replace("http://www.sbolstandard.org/", "http://sbols.org/v2#");
                    directionTypeStr = directionTypeStr.replace("input", "in");
                    directionTypeStr = directionTypeStr.replace("output", "out");
                }
                try {
                    direction = DirectionType.convertToDirectionType(URI.create(directionTypeStr));
                    continue;
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException("sbol-11802", functionalComponent.getIdentity());
                }
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentInstance.hasMapsTo)) {
                if (namedProperty.getValue() instanceof NestedDocument) {
                    NestedDocument nestedDocument = (NestedDocument)namedProperty.getValue();
                    if (nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.MapsTo.MapsTo)) {
                        throw new SBOLValidationException("sbol-10606", functionalComponent.getIdentity());
                    }
                    mappings.add(SBOLReader.parseMapsTo((NestedDocument<QName>)((NestedDocument)namedProperty.getValue()), false));
                    continue;
                }
                URI uri = (URI)((Literal)namedProperty.getValue()).getValue();
                NestedDocument<QName> nestedDocument = nested.get(uri);
                if (nestedDocument == null || nestedDocument.getType() == null || !((QName)nestedDocument.getType()).equals(Sbol2Terms.MapsTo.MapsTo)) {
                    throw new SBOLValidationException("sbol-10606", functionalComponent.getIdentity());
                }
                mappings.add(SBOLReader.parseMapsTo(nested.get(uri), false));
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.ComponentInstance.hasComponentDefinition)) {
                if (functionalComponentURI != null) {
                    throw new SBOLValidationException("sbol-10602", functionalComponent.getIdentity());
                }
                if (namedProperty.getValue() instanceof Literal) {
                    if (!(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                        throw new SBOLValidationException("sbol-10602", functionalComponent.getIdentity());
                    }
                    functionalComponentURI = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                    continue;
                }
                if (namedProperty.getValue() instanceof IdentifiableDocument) {
                    if (((QName)((IdentifiableDocument)namedProperty).getType()).equals(Sbol2Terms.ComponentDefinition.ComponentDefinition)) {
                        ComponentDefinition componentDefinition = SBOLReader.parseComponentDefinitions(SBOLDoc, (IdentifiableDocument<QName>)((IdentifiableDocument)namedProperty.getValue()), nested);
                        functionalComponentURI = componentDefinition.getIdentity();
                        continue;
                    }
                    throw new SBOLValidationException("sbol-10602", functionalComponent.getIdentity());
                }
                throw new SBOLValidationException("sbol-10602", functionalComponent.getIdentity());
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", functionalComponent.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", functionalComponent.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", functionalComponent.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        FunctionalComponent fc = new FunctionalComponent(functionalComponent.getIdentity(), access, functionalComponentURI, direction);
        if (persistentIdentity != null) {
            fc.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            fc.setVersion(version);
        }
        if (displayId != null) {
            fc.setDisplayId(displayId);
        }
        if (!mappings.isEmpty()) {
            fc.setMapsTos(mappings);
        }
        if (name != null) {
            fc.setName(name);
        }
        if (description != null) {
            fc.setDescription(description);
        }
        fc.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            fc.setAnnotations(annotations);
        }
        return fc;
    }

    private static Sequence parseSequences(SBOLDocument SBOLDoc, IdentifiableDocument<QName> topLevel) throws SBOLValidationException {
        Sequence oldS;
        String displayId = null;
        String name = null;
        String description = null;
        URI persistentIdentity = null;
        String version = null;
        String elements = null;
        URI encoding = null;
        HashSet<URI> wasDerivedFroms = new HashSet<URI>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (NamedProperty namedProperty : topLevel.getProperties()) {
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.persistentIdentity)) {
                if (!(namedProperty.getValue() instanceof Literal) || persistentIdentity != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10203", topLevel.getIdentity());
                }
                persistentIdentity = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.version)) {
                if (!(namedProperty.getValue() instanceof Literal) || version != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10206", topLevel.getIdentity());
                }
                version = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.displayId)) {
                if (!(namedProperty.getValue() instanceof Literal) || displayId != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10204", topLevel.getIdentity());
                }
                displayId = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Sequence.elements)) {
                if (!(namedProperty.getValue() instanceof Literal) || elements != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10402", topLevel.getIdentity());
                }
                elements = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Sequence.encoding)) {
                if (!(namedProperty.getValue() instanceof Literal) || encoding != null || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10403", topLevel.getIdentity());
                }
                encoding = URI.create(((Literal)namedProperty.getValue()).getValue().toString());
                if (!encoding.toString().equals("http://dx.doi.org/10.1021/bi00822a023")) continue;
                encoding = Sequence.IUPAC_DNA;
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.title)) {
                if (!(namedProperty.getValue() instanceof Literal) || name != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10212", topLevel.getIdentity());
                }
                name = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.description)) {
                if (!(namedProperty.getValue() instanceof Literal) || description != null || !(((Literal)namedProperty.getValue()).getValue() instanceof String)) {
                    throw new SBOLValidationException("sbol-10213", topLevel.getIdentity());
                }
                description = ((Literal)namedProperty.getValue()).getValue().toString();
                continue;
            }
            if (((QName)namedProperty.getName()).equals(Sbol2Terms.Identified.wasDerivedFrom)) {
                if (!(namedProperty.getValue() instanceof Literal) || !(((Literal)namedProperty.getValue()).getValue() instanceof URI)) {
                    throw new SBOLValidationException("sbol-10208", topLevel.getIdentity());
                }
                wasDerivedFroms.add(URI.create(((Literal)namedProperty.getValue()).getValue().toString()));
                continue;
            }
            annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
        }
        Sequence sequence = new Sequence(topLevel.getIdentity(), elements, encoding);
        if (persistentIdentity != null) {
            sequence.setPersistentIdentity(persistentIdentity);
        }
        if (version != null) {
            sequence.setVersion(version);
        }
        if (displayId != null) {
            sequence.setDisplayId(displayId);
        }
        if (name != null) {
            sequence.setName(name);
        }
        if (description != null) {
            sequence.setDescription(description);
        }
        sequence.setWasDerivedFroms(wasDerivedFroms);
        if (!annotations.isEmpty()) {
            sequence.setAnnotations(annotations);
        }
        if ((oldS = SBOLDoc.getSequence(topLevel.getIdentity())) == null) {
            SBOLDoc.addSequence(sequence);
        } else if (!sequence.equals(oldS)) {
            throw new SBOLValidationException("sbol-10202", sequence);
        }
        return sequence;
    }

    static class SBOLPair {
        private URI left;
        private URI right;

        public SBOLPair(URI left, URI right) {
            this.left = left;
            this.right = right;
        }

        public URI getLeft() {
            return this.left;
        }

        public void setLeft(URI left) {
            this.left = left;
        }

        public URI getRight() {
            return this.right;
        }

        public void setRight(URI right) {
            this.right = right;
        }
    }
}

