/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.smiles.SmilesParser;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.Collection;
import org.sbolstandard.core2.Component;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.Cut;
import org.sbolstandard.core2.EDAMOntology;
import org.sbolstandard.core2.FASTA;
import org.sbolstandard.core2.FunctionalComponent;
import org.sbolstandard.core2.GenBank;
import org.sbolstandard.core2.GenericTopLevel;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.Interaction;
import org.sbolstandard.core2.Location;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.Model;
import org.sbolstandard.core2.Module;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.Participation;
import org.sbolstandard.core2.Range;
import org.sbolstandard.core2.RefinementType;
import org.sbolstandard.core2.RestrictionType;
import org.sbolstandard.core2.SBOLConversionException;
import org.sbolstandard.core2.SBOLDocument;
import org.sbolstandard.core2.SBOLReader;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.SBOLWriter;
import org.sbolstandard.core2.Sequence;
import org.sbolstandard.core2.SequenceAnnotation;
import org.sbolstandard.core2.SequenceConstraint;
import org.sbolstandard.core2.SequenceOntology;
import org.sbolstandard.core2.SystemsBiologyOntology;
import org.sbolstandard.core2.TopLevel;
import org.sbolstandard.core2.URIcompliance;
import org.sbolstandard.core2.Version;

public class SBOLValidate {
    private static final String SBOLVersion = "2.0";
    private static final String libSBOLj_Version = "2.1.2";
    private static List<String> errors = null;
    private static final String IUPAC_DNA_PATTERN = "([ACGTURYSWKMBDHVN\\-\\.]*)";
    private static final Pattern iupacDNAparser = Pattern.compile("([ACGTURYSWKMBDHVN\\-\\.]*)");
    private static final String IUPAC_PROTEIN_PATTERN = "([ABCDEFGHIJKLMNOPQRSTUVWXYZ]*)";
    private static final Pattern iupacProteinParser = Pattern.compile("([ABCDEFGHIJKLMNOPQRSTUVWXYZ]*)");
    private static SmilesParser smilesParser = new SmilesParser(DefaultChemObjectBuilder.getInstance());

    public static void clearErrors() {
        errors = new ArrayList<String>();
    }

    public static List<String> getErrors() {
        return errors;
    }

    public static int getNumErrors() {
        return errors.size();
    }

    static void validateCompliance(SBOLDocument sbolDocument) {
        for (TopLevel topLevel : sbolDocument.getTopLevels()) {
            try {
                topLevel.isURIcompliant();
            }
            catch (SBOLValidationException e) {
                errors.add(e.getMessage());
            }
        }
    }

    private static void checkCollectionCompleteness(SBOLDocument sbolDocument, Collection collection) {
        for (URI member : collection.getMemberURIs()) {
            if (sbolDocument.getTopLevel(member) != null) continue;
            SBOLValidationException e = new SBOLValidationException("sbol-12103", collection);
            errors.add(e.getMessage());
        }
    }

    private static void checkComponentDefinitionCompleteness(SBOLDocument sbolDocument, ComponentDefinition componentDefinition) {
        for (URI sequenceURI : componentDefinition.getSequenceURIs()) {
            if (sbolDocument.getSequence(sequenceURI) != null) continue;
            errors.add(new SBOLValidationException("sbol-10513", componentDefinition).getMessage());
        }
        for (Component component : componentDefinition.getComponents()) {
            if (component.getDefinition() == null) {
                errors.add(new SBOLValidationException("sbol-10604", component).getMessage());
            }
            for (MapsTo mapsTo : component.getMapsTos()) {
                if (mapsTo.getRemote() == null) {
                    errors.add(new SBOLValidationException("sbol-10808", mapsTo).getMessage());
                    continue;
                }
                if (mapsTo.getRemote().getAccess().equals((Object)AccessType.PRIVATE)) {
                    errors.add(new SBOLValidationException("sbol-10807", mapsTo).getMessage());
                }
                if (!mapsTo.getRefinement().equals((Object)RefinementType.VERIFYIDENTICAL) || mapsTo.getLocal().getDefinitionURI().equals(mapsTo.getRemote().getDefinitionURI())) continue;
                errors.add(new SBOLValidationException("sbol-10811", mapsTo).getMessage());
            }
        }
    }

    static void checkComponentDefinitionMapsTos(ComponentDefinition componentDefinition, MapsTo mapsTo) throws SBOLValidationException {
        for (Component component : componentDefinition.getComponents()) {
            for (MapsTo mapsTo2 : component.getMapsTos()) {
                if (mapsTo == mapsTo2 || !mapsTo.getLocalURI().equals(mapsTo2.getLocalURI()) || !mapsTo.getRefinement().equals((Object)RefinementType.USEREMOTE) || !mapsTo2.getRefinement().equals((Object)RefinementType.USEREMOTE)) continue;
                throw new SBOLValidationException("sbol-10526", componentDefinition);
            }
        }
    }

    static void checkModuleDefinitionMapsTos(ModuleDefinition moduleDefinition, MapsTo mapsTo) throws SBOLValidationException {
        for (Module module : moduleDefinition.getModules()) {
            for (MapsTo mapsTo2 : module.getMapsTos()) {
                if (mapsTo == mapsTo2 || !mapsTo.getLocalURI().equals(mapsTo2.getLocalURI()) || !mapsTo.getRefinement().equals((Object)RefinementType.USEREMOTE) || !mapsTo2.getRefinement().equals((Object)RefinementType.USEREMOTE)) continue;
                throw new SBOLValidationException("sbol-11609", moduleDefinition);
            }
        }
        for (FunctionalComponent functionalComponent : moduleDefinition.getFunctionalComponents()) {
            for (MapsTo mapsTo2 : functionalComponent.getMapsTos()) {
                if (mapsTo == mapsTo2 || !mapsTo.getLocalURI().equals(mapsTo2.getLocalURI()) || !mapsTo.getRefinement().equals((Object)RefinementType.USEREMOTE) || !mapsTo2.getRefinement().equals((Object)RefinementType.USEREMOTE)) continue;
                throw new SBOLValidationException("sbol-11609", moduleDefinition);
            }
        }
    }

    private static void validateMapsTos(SBOLDocument sbolDocument) {
        for (ComponentDefinition componentDefinition : sbolDocument.getComponentDefinitions()) {
            for (Component component : componentDefinition.getComponents()) {
                for (MapsTo mapsTo : component.getMapsTos()) {
                    try {
                        SBOLValidate.checkComponentDefinitionMapsTos(componentDefinition, mapsTo);
                    }
                    catch (SBOLValidationException e) {
                        errors.add(e.getMessage());
                    }
                }
            }
        }
        for (ModuleDefinition moduleDefinition : sbolDocument.getModuleDefinitions()) {
            for (Module module : moduleDefinition.getModules()) {
                for (MapsTo mapsTo : module.getMapsTos()) {
                    try {
                        SBOLValidate.checkModuleDefinitionMapsTos(moduleDefinition, mapsTo);
                    }
                    catch (SBOLValidationException e) {
                        errors.add(e.getMessage());
                    }
                }
            }
            for (FunctionalComponent functionalComponent : moduleDefinition.getFunctionalComponents()) {
                for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
                    try {
                        SBOLValidate.checkModuleDefinitionMapsTos(moduleDefinition, mapsTo);
                    }
                    catch (SBOLValidationException e) {
                        errors.add(e.getMessage());
                    }
                }
            }
        }
    }

    private static void checkModuleDefinitionCompleteness(SBOLDocument sbolDocument, ModuleDefinition moduleDefinition) {
        for (URI modelURI : moduleDefinition.getModelURIs()) {
            if (sbolDocument.getModel(modelURI) != null) continue;
            errors.add(new SBOLValidationException("sbol-11608", moduleDefinition).getMessage());
        }
        for (FunctionalComponent functionalComponent : moduleDefinition.getFunctionalComponents()) {
            if (functionalComponent.getDefinition() == null) {
                errors.add(new SBOLValidationException("sbol-10604", functionalComponent).getMessage());
            }
            for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
                if (mapsTo.getRemote() == null) {
                    errors.add(new SBOLValidationException("sbol-10808", mapsTo).getMessage());
                    continue;
                }
                if (mapsTo.getRemote().getAccess().equals((Object)AccessType.PRIVATE)) {
                    errors.add(new SBOLValidationException("sbol-10807", mapsTo).getMessage());
                }
                if (!mapsTo.getRefinement().equals((Object)RefinementType.VERIFYIDENTICAL) || mapsTo.getLocal().getDefinitionURI().equals(mapsTo.getRemote().getDefinitionURI())) continue;
                errors.add(new SBOLValidationException("sbol-10811", mapsTo).getMessage());
            }
        }
        for (Module module : moduleDefinition.getModules()) {
            if (module.getDefinition() == null) {
                errors.add(new SBOLValidationException("sbol-11703", module).getMessage());
            }
            for (MapsTo mapsTo : module.getMapsTos()) {
                if (mapsTo.getRemote() == null) {
                    errors.add(new SBOLValidationException("sbol-10809", mapsTo).getMessage());
                    continue;
                }
                if (mapsTo.getRemote().getAccess().equals((Object)AccessType.PRIVATE)) {
                    errors.add(new SBOLValidationException("sbol-10807", mapsTo).getMessage());
                }
                if (!mapsTo.getRefinement().equals((Object)RefinementType.VERIFYIDENTICAL) || mapsTo.getLocal().getDefinitionURI().equals(mapsTo.getRemote().getDefinitionURI())) continue;
                errors.add(new SBOLValidationException("sbol-10811", mapsTo).getMessage());
            }
        }
    }

    private static void validateCompleteness(SBOLDocument sbolDocument) {
        for (Collection collection : sbolDocument.getCollections()) {
            SBOLValidate.checkCollectionCompleteness(sbolDocument, collection);
        }
        for (ComponentDefinition componentDefinition : sbolDocument.getComponentDefinitions()) {
            SBOLValidate.checkComponentDefinitionCompleteness(sbolDocument, componentDefinition);
        }
        for (ModuleDefinition moduleDefinition : sbolDocument.getModuleDefinitions()) {
            SBOLValidate.checkModuleDefinitionCompleteness(sbolDocument, moduleDefinition);
        }
    }

    static void checkComponentDefinitionCycle(SBOLDocument sbolDocument, ComponentDefinition componentDefinition, Set<URI> visited) throws SBOLValidationException {
        if (componentDefinition == null) {
            return;
        }
        visited.add(componentDefinition.getIdentity());
        for (Component component : componentDefinition.getComponents()) {
            ComponentDefinition cd = component.getDefinition();
            if (cd == null) continue;
            if (visited.contains(cd.getIdentity())) {
                throw new SBOLValidationException("sbol-10603", component);
            }
            try {
                SBOLValidate.checkComponentDefinitionCycle(sbolDocument, cd, visited);
            }
            catch (SBOLValidationException e) {
                throw new SBOLValidationException("sbol-10605", component);
            }
        }
        visited.remove(componentDefinition.getIdentity());
    }

    static void checkModuleDefinitionCycle(SBOLDocument sbolDocument, ModuleDefinition moduleDefinition, Set<URI> visited) throws SBOLValidationException {
        if (moduleDefinition == null) {
            return;
        }
        visited.add(moduleDefinition.getIdentity());
        for (Module module : moduleDefinition.getModules()) {
            ModuleDefinition md = module.getDefinition();
            if (md == null) continue;
            if (visited.contains(md.getIdentity())) {
                throw new SBOLValidationException("sbol-11704", module);
            }
            try {
                SBOLValidate.checkModuleDefinitionCycle(sbolDocument, md, visited);
            }
            catch (SBOLValidationException e) {
                throw new SBOLValidationException("sbol-11705", module);
            }
        }
        visited.remove(moduleDefinition.getIdentity());
    }

    static boolean checkWasDerivedFromVersion(SBOLDocument sbolDocument, Identified identified, URI wasDerivedFrom) {
        String wasDerivedFromPI = URIcompliance.extractPersistentId(wasDerivedFrom);
        if (wasDerivedFromPI == null || !wasDerivedFromPI.equals(identified.getPersistentIdentity().toString())) {
            return true;
        }
        TopLevel derivedFrom = sbolDocument.getTopLevel(wasDerivedFrom);
        return derivedFrom == null || !derivedFrom.isSetPersistentIdentity() || !identified.isSetPersistentIdentity() || !derivedFrom.getPersistentIdentity().equals(identified.getPersistentIdentity()) || !derivedFrom.isSetVersion() || !identified.isSetVersion() || !Version.isFirstVersionNewer(derivedFrom.getVersion(), identified.getVersion());
    }

    private static void validateWasDerivedFromVersion(SBOLDocument sbolDocument) {
        for (TopLevel topLevel : sbolDocument.getTopLevels()) {
            for (URI wasDerivedFrom : topLevel.getWasDerivedFroms()) {
                if (SBOLValidate.checkWasDerivedFromVersion(sbolDocument, topLevel, wasDerivedFrom)) continue;
                errors.add(new SBOLValidationException("sbol-10302", topLevel).getMessage());
            }
        }
    }

    static void checkWasDerivedFromCycle(SBOLDocument sbolDocument, Identified identified, URI wasDerivedFrom, Set<URI> visited) throws SBOLValidationException {
        visited.add(identified.getIdentity());
        TopLevel tl = sbolDocument.getTopLevel(wasDerivedFrom);
        if (tl != null) {
            if (visited.contains(tl.getIdentity())) {
                throw new SBOLValidationException("sbol-10303", identified);
            }
            if (tl.getWasDerivedFroms().size() == 0) {
                return;
            }
            for (URI wdf : tl.getWasDerivedFroms()) {
                try {
                    SBOLValidate.checkWasDerivedFromCycle(sbolDocument, tl, wdf, visited);
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException("sbol-10304", identified);
                }
            }
        }
        visited.remove(identified.getIdentity());
    }

    private static void validateCircularReferences(SBOLDocument sbolDocument) {
        for (TopLevel topLevel : sbolDocument.getTopLevels()) {
            for (URI wasDerivedFrom : topLevel.getWasDerivedFroms()) {
                try {
                    SBOLValidate.checkWasDerivedFromCycle(sbolDocument, topLevel, wasDerivedFrom, new HashSet<URI>());
                }
                catch (SBOLValidationException e) {
                    errors.add(e.getMessage());
                }
            }
        }
        for (ComponentDefinition componentDefinition : sbolDocument.getComponentDefinitions()) {
            try {
                SBOLValidate.checkComponentDefinitionCycle(sbolDocument, componentDefinition, new HashSet<URI>());
            }
            catch (SBOLValidationException e) {
                errors.add(e.getMessage());
            }
        }
        for (ModuleDefinition moduleDefinition : sbolDocument.getModuleDefinitions()) {
            try {
                SBOLValidate.checkModuleDefinitionCycle(sbolDocument, moduleDefinition, new HashSet<URI>());
            }
            catch (SBOLValidationException e) {
                errors.add(e.getMessage());
            }
        }
    }

    static void checkSequenceConstraint(ComponentDefinition componentDefinition, SequenceConstraint sequenceConstraint) throws SBOLValidationException {
        block7: {
            SequenceAnnotation saObject;
            SequenceAnnotation saSubject;
            block8: {
                block6: {
                    saSubject = componentDefinition.getSequenceAnnotation(sequenceConstraint.getSubject());
                    saObject = componentDefinition.getSequenceAnnotation(sequenceConstraint.getObject());
                    if (saSubject == null || saObject == null) {
                        return;
                    }
                    if (!sequenceConstraint.getRestriction().equals((Object)RestrictionType.PRECEDES)) break block6;
                    if (saObject.compareTo(saSubject) != -2147483647 && saObject.compareTo(saSubject) < 0) {
                        throw new SBOLValidationException("sbol-11409", sequenceConstraint);
                    }
                    break block7;
                }
                if (!sequenceConstraint.getRestriction().equals((Object)RestrictionType.SAME_ORIENTATION_AS)) break block8;
                for (Location locSubject : saSubject.getLocations()) {
                    for (Location locObject : saObject.getLocations()) {
                        if (locSubject.getOrientation().equals((Object)locObject.getOrientation())) continue;
                        throw new SBOLValidationException("sbol-11410", sequenceConstraint);
                    }
                }
                break block7;
            }
            if (!sequenceConstraint.getRestriction().equals((Object)RestrictionType.OPPOSITE_ORIENTATION_AS)) break block7;
            for (Location locSubject : saSubject.getLocations()) {
                for (Location locObject : saObject.getLocations()) {
                    if (!locSubject.getOrientation().equals((Object)locObject.getOrientation())) continue;
                    throw new SBOLValidationException("sbol-11411", sequenceConstraint);
                }
            }
        }
    }

    private static void checkInteractionTypeParticipationRole(Interaction interaction, URI type, URI role) {
        if (type.equals(SystemsBiologyOntology.INHIBITION)) {
            if (!(role.equals(SystemsBiologyOntology.INHIBITOR) || role.equals(SystemsBiologyOntology.INHIBITED) || role.equals(SystemsBiologyOntology.PROMOTER))) {
                errors.add(new SBOLValidationException("sbol-11907", interaction).getMessage());
            }
        } else if (type.equals(SystemsBiologyOntology.STIMULATION)) {
            if (!(role.equals(SystemsBiologyOntology.STIMULATOR) || role.equals(SystemsBiologyOntology.STIMULATED) || role.equals(SystemsBiologyOntology.PROMOTER))) {
                errors.add(new SBOLValidationException("sbol-11907", interaction).getMessage());
            }
        } else if (type.equals(SystemsBiologyOntology.NON_COVALENT_BINDING)) {
            if (!role.equals(SystemsBiologyOntology.REACTANT) && !role.equals(SystemsBiologyOntology.PRODUCT)) {
                errors.add(new SBOLValidationException("sbol-11907", interaction).getMessage());
            }
        } else if (type.equals(SystemsBiologyOntology.DEGRADATION)) {
            if (!role.equals(SystemsBiologyOntology.REACTANT)) {
                errors.add(new SBOLValidationException("sbol-11907", interaction).getMessage());
            }
        } else if (type.equals(SystemsBiologyOntology.BIOCHEMICAL_REACTION)) {
            if (!(role.equals(SystemsBiologyOntology.REACTANT) || role.equals(SystemsBiologyOntology.PRODUCT) || role.equals(SystemsBiologyOntology.MODIFIER))) {
                errors.add(new SBOLValidationException("sbol-11907", interaction).getMessage());
            }
        } else if (type.equals(SystemsBiologyOntology.GENETIC_PRODUCTION)) {
            if (!(role.equals(SystemsBiologyOntology.PROMOTER) || role.equals(SystemsBiologyOntology.TEMPLATE) || role.equals(SystemsBiologyOntology.PRODUCT))) {
                errors.add(new SBOLValidationException("sbol-11907", interaction).getMessage());
            }
        } else if (type.equals(SystemsBiologyOntology.CONTROL) && !role.equals(SystemsBiologyOntology.MODIFIER) && !role.equals(SystemsBiologyOntology.MODIFIED)) {
            errors.add(new SBOLValidationException("sbol-11907", interaction).getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void validateOntologyUsage(SBOLDocument sbolDocument) {
        SequenceOntology so = new SequenceOntology();
        SystemsBiologyOntology sbo = new SystemsBiologyOntology();
        EDAMOntology edam = new EDAMOntology();
        for (Sequence sequence : sbolDocument.getSequences()) {
            if (sequence.getEncoding().equals(Sequence.IUPAC_DNA) || sequence.getEncoding().equals(Sequence.IUPAC_RNA) || sequence.getEncoding().equals(Sequence.IUPAC_PROTEIN) || sequence.getEncoding().equals(Sequence.SMILES)) continue;
            errors.add(new SBOLValidationException("sbol-10407", sequence).getMessage());
        }
        for (ComponentDefinition compDef : sbolDocument.getComponentDefinitions()) {
            void var8_14;
            Object role2;
            int numBioPAXtypes = 0;
            for (URI uRI : compDef.getTypes()) {
                if (!uRI.equals(ComponentDefinition.DNA) && !uRI.equals(ComponentDefinition.RNA) && !uRI.equals(ComponentDefinition.PROTEIN) && !uRI.equals(ComponentDefinition.COMPLEX) && !uRI.equals(ComponentDefinition.SMALL_MOLECULE)) continue;
                ++numBioPAXtypes;
            }
            if (numBioPAXtypes == 0) {
                errors.add(new SBOLValidationException("sbol-10525", compDef).getMessage());
            } else if (numBioPAXtypes > 1) {
                errors.add(new SBOLValidationException("sbol-10503", compDef).getMessage());
            }
            int numSO = 0;
            for (Object role2 : compDef.getRoles()) {
                try {
                    if (!((URI)role2).equals(SequenceOntology.SEQUENCE_FEATURE) && !so.isDescendantOf((URI)role2, SequenceOntology.SEQUENCE_FEATURE)) continue;
                    ++numSO;
                }
                catch (Exception exception) {}
            }
            boolean bl = false;
            role2 = compDef.getTypes().iterator();
            while (role2.hasNext()) {
                URI type3 = (URI)role2.next();
                try {
                    if (!so.isDescendantOf(type3, SequenceOntology.TOPOLOGY_ATTRIBUTE)) continue;
                    ++var8_14;
                }
                catch (Exception exception) {}
            }
            int numStrand = 0;
            for (URI type : compDef.getTypes()) {
                try {
                    if (!so.isDescendantOf(type, SequenceOntology.STRAND_ATTRIBUTE)) continue;
                    ++numStrand;
                }
                catch (Exception exception) {}
            }
            if (compDef.getTypes().contains(ComponentDefinition.DNA) || compDef.getTypes().contains(ComponentDefinition.RNA)) {
                if (numSO != 1) {
                    errors.add(new SBOLValidationException("sbol-10527", compDef).getMessage());
                }
                if (var8_14 > true) {
                    errors.add(new SBOLValidationException("sbol-10528", compDef).getMessage());
                }
            } else if (!compDef.getTypes().contains(ComponentDefinition.RNA)) {
                if (numSO != 0) {
                    errors.add(new SBOLValidationException("sbol-10511", compDef).getMessage());
                }
                if (var8_14 != false || numStrand != 0) {
                    errors.add(new SBOLValidationException("sbol-10529", compDef).getMessage());
                }
            }
            for (Component c : compDef.getComponents()) {
                ComponentDefinition def = c.getDefinition();
                if (def == null) continue;
                numSO = 0;
                for (URI role3 : c.getRoles()) {
                    try {
                        if (!role3.equals(SequenceOntology.SEQUENCE_FEATURE) && !so.isDescendantOf(role3, SequenceOntology.SEQUENCE_FEATURE)) continue;
                        ++numSO;
                    }
                    catch (Exception exception) {}
                }
                if (!def.getTypes().contains(ComponentDefinition.DNA) && !def.getTypes().contains(ComponentDefinition.RNA)) {
                    if (numSO == 0) continue;
                    errors.add(new SBOLValidationException("sbol-10706", compDef).getMessage());
                    continue;
                }
                if (numSO <= 1) continue;
                errors.add(new SBOLValidationException("sbol-10707", compDef).getMessage());
            }
            for (SequenceConstraint sc : compDef.getSequenceConstraints()) {
                try {
                    RestrictionType.convertToRestrictionType(sc.getRestrictionURI());
                }
                catch (Exception e) {
                    errors.add(new SBOLValidationException("sbol-11412", sc).getMessage());
                }
            }
        }
        for (Model model : sbolDocument.getModels()) {
            try {
                if (!edam.isDescendantOf(model.getLanguage(), EDAMOntology.FORMAT)) {
                    errors.add(new SBOLValidationException("sbol-11507", model).getMessage());
                }
            }
            catch (Exception e) {
                errors.add(new SBOLValidationException("sbol-11507", model).getMessage());
            }
            try {
                if (sbo.isDescendantOf(model.getFramework(), SystemsBiologyOntology.MODELING_FRAMEWORK)) continue;
                errors.add(new SBOLValidationException("sbol-11511", model).getMessage());
            }
            catch (Exception e) {
                errors.add(new SBOLValidationException("sbol-11511", model).getMessage());
            }
        }
        for (ModuleDefinition modDef : sbolDocument.getModuleDefinitions()) {
            for (Interaction interaction : modDef.getInteractions()) {
                int n = 0;
                URI SBOtype = null;
                for (URI type4 : interaction.getTypes()) {
                    try {
                        if (!sbo.isDescendantOf(type4, SystemsBiologyOntology.OCCURRING_ENTITY_REPRESENTATION)) continue;
                        ++n;
                        SBOtype = type4;
                    }
                    catch (Exception e) {}
                }
                if (n != 1) {
                    errors.add(new SBOLValidationException("sbol-11905", interaction).getMessage());
                }
                for (Participation participation : interaction.getParticipations()) {
                    int numSBOrole = 0;
                    URI SBOrole = null;
                    for (URI role : participation.getRoles()) {
                        try {
                            if (!sbo.isDescendantOf(role, SystemsBiologyOntology.PARTICIPANT_ROLE)) continue;
                            ++numSBOrole;
                            SBOrole = role;
                        }
                        catch (Exception exception) {}
                    }
                    if (numSBOrole != 1) {
                        errors.add(new SBOLValidationException("sbol-12007", participation).getMessage());
                        continue;
                    }
                    SBOLValidate.checkInteractionTypeParticipationRole(interaction, SBOtype, SBOrole);
                }
            }
        }
    }

    private static void validateComponentDefinitionSequences(SBOLDocument sbolDocument) {
        for (ComponentDefinition componentDefinition : sbolDocument.getComponentDefinitions()) {
            if (componentDefinition.getSequences().size() < 1) continue;
            boolean foundNucleic = false;
            boolean foundProtein = false;
            boolean foundSmiles = false;
            int nucleicLength = -1;
            int proteinLength = -1;
            int smilesLength = -1;
            for (Sequence sequence : componentDefinition.getSequences()) {
                if (sequence.getEncoding().equals(Sequence.IUPAC_DNA) || sequence.getEncoding().equals(Sequence.IUPAC_RNA)) {
                    if (foundNucleic) {
                        if (nucleicLength != sequence.getElements().length()) {
                            errors.add(new SBOLValidationException("sbol-10518", componentDefinition).getMessage());
                        }
                    } else {
                        foundNucleic = true;
                        nucleicLength = sequence.getElements().length();
                    }
                    for (SequenceAnnotation sa : componentDefinition.getSequenceAnnotations()) {
                        for (Location location : sa.getLocations()) {
                            Cut cut;
                            if (location instanceof Range) {
                                Range range = (Range)location;
                                if (range.getStart() > 0 && range.getEnd() <= nucleicLength) continue;
                                errors.add(new SBOLValidationException("sbol-10523", componentDefinition).getMessage());
                                continue;
                            }
                            if (!(location instanceof Cut) || (cut = (Cut)location).getAt() >= 0 && cut.getAt() <= nucleicLength) continue;
                            errors.add(new SBOLValidationException("sbol-10523", componentDefinition).getMessage());
                        }
                    }
                    continue;
                }
                if (sequence.getEncoding().equals(Sequence.IUPAC_PROTEIN)) {
                    if (foundProtein) {
                        if (proteinLength == sequence.getElements().length()) continue;
                        errors.add(new SBOLValidationException("sbol-10518", componentDefinition).getMessage());
                        continue;
                    }
                    foundProtein = true;
                    proteinLength = sequence.getElements().length();
                    continue;
                }
                if (!sequence.getEncoding().equals(Sequence.SMILES)) continue;
                if (foundSmiles) {
                    if (smilesLength == sequence.getElements().length()) continue;
                    errors.add(new SBOLValidationException("sbol-10518", componentDefinition).getMessage());
                    continue;
                }
                foundSmiles = true;
                smilesLength = sequence.getElements().length();
            }
            if (componentDefinition.getTypes().contains(ComponentDefinition.DNA) && !foundNucleic) {
                errors.add(new SBOLValidationException("sbol-10516", componentDefinition).getMessage());
            } else if (componentDefinition.getTypes().contains(ComponentDefinition.RNA) && !foundNucleic) {
                errors.add(new SBOLValidationException("sbol-10516", componentDefinition).getMessage());
            } else if (componentDefinition.getTypes().contains(ComponentDefinition.PROTEIN) && !foundProtein) {
                errors.add(new SBOLValidationException("sbol-10516", componentDefinition).getMessage());
            } else if (componentDefinition.getTypes().contains(ComponentDefinition.SMALL_MOLECULE) && !foundSmiles) {
                errors.add(new SBOLValidationException("sbol-10516", componentDefinition).getMessage());
            }
            if (!foundNucleic || componentDefinition.getSequenceAnnotations().size() <= 0) continue;
            try {
                String impliedElements = componentDefinition.getImpliedNucleicAcidSequence();
                Sequence dnaSequence = componentDefinition.getSequenceByEncoding(Sequence.IUPAC_DNA);
                if (SBOLValidate.includesSequence(dnaSequence.getElements(), impliedElements)) continue;
                errors.add(new SBOLValidationException("sbol-10520", componentDefinition).getMessage());
            }
            catch (Exception e) {
                errors.add(new SBOLValidationException("sbol-10520", componentDefinition).getMessage());
            }
        }
    }

    private static boolean includesSequence(String specificSequence, String generalSequence) {
        specificSequence = specificSequence.toLowerCase();
        generalSequence = generalSequence.toLowerCase();
        block16: for (int i = 0; i < specificSequence.length(); ++i) {
            switch (generalSequence.charAt(i)) {
                case 'a': 
                case 'c': 
                case 'g': 
                case 't': 
                case 'u': {
                    if (specificSequence.charAt(i) == generalSequence.charAt(i)) continue block16;
                    return false;
                }
                case '.': {
                    if (specificSequence.charAt(i) == '.' || specificSequence.charAt(i) == '-') continue block16;
                    return false;
                }
                case '-': {
                    if (specificSequence.charAt(i) == '.' || specificSequence.charAt(i) == '-') continue block16;
                    return false;
                }
                case 'r': {
                    if (specificSequence.charAt(i) == 'r' || specificSequence.charAt(i) == 'a' || specificSequence.charAt(i) == 'g') continue block16;
                    return false;
                }
                case 'y': {
                    if (specificSequence.charAt(i) == 'y' || specificSequence.charAt(i) == 'c' || specificSequence.charAt(i) == 't') continue block16;
                    return false;
                }
                case 's': {
                    if (specificSequence.charAt(i) == 's' || specificSequence.charAt(i) == 'c' || specificSequence.charAt(i) == 'g') continue block16;
                    return false;
                }
                case 'w': {
                    if (specificSequence.charAt(i) == 'w' || specificSequence.charAt(i) == 'a' || specificSequence.charAt(i) == 't') continue block16;
                    return false;
                }
                case 'k': {
                    if (specificSequence.charAt(i) == 'k' || specificSequence.charAt(i) == 'g' || specificSequence.charAt(i) == 't') continue block16;
                    return false;
                }
                case 'm': {
                    if (specificSequence.charAt(i) == 'm' || specificSequence.charAt(i) == 'a' || specificSequence.charAt(i) == 'c') continue block16;
                    return false;
                }
                case 'b': {
                    if (specificSequence.charAt(i) == 'k' || specificSequence.charAt(i) == 'g' || specificSequence.charAt(i) == 't' || specificSequence.charAt(i) == 'c') continue block16;
                    return false;
                }
                case 'd': {
                    if (specificSequence.charAt(i) == 'd' || specificSequence.charAt(i) == 'g' || specificSequence.charAt(i) == 't' || specificSequence.charAt(i) == 'a') continue block16;
                    return false;
                }
                case 'h': {
                    if (specificSequence.charAt(i) == 'h' || specificSequence.charAt(i) == 'c' || specificSequence.charAt(i) == 't' || specificSequence.charAt(i) == 'a') continue block16;
                    return false;
                }
                case 'v': {
                    if (specificSequence.charAt(i) == 'v' || specificSequence.charAt(i) == 'g' || specificSequence.charAt(i) == 'c' || specificSequence.charAt(i) == 'a') continue block16;
                    return false;
                }
                case 'n': {
                    continue block16;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static void validateSequenceAnnotations(SBOLDocument sbolDocument) {
        for (ComponentDefinition componentDefinition : sbolDocument.getComponentDefinitions()) {
            for (SequenceAnnotation sequenceAnnotation : componentDefinition.getSequenceAnnotations()) {
                Object[] locations = sequenceAnnotation.getLocations().toArray();
                for (int i = 0; i < locations.length - 1; ++i) {
                    for (int j = i + 1; j < locations.length; ++j) {
                        Location location1 = (Location)locations[i];
                        Location location2 = (Location)locations[j];
                        if (location1.getIdentity().equals(location2.getIdentity())) continue;
                        if (location1 instanceof Range && location2 instanceof Range) {
                            if ((((Range)location1).getStart() < ((Range)location2).getStart() || ((Range)location1).getStart() > ((Range)location2).getEnd()) && (((Range)location2).getStart() < ((Range)location1).getStart() || ((Range)location2).getStart() > ((Range)location1).getEnd())) continue;
                            errors.add(new SBOLValidationException("sbol-10903", location1, location2).getMessage());
                            continue;
                        }
                        if (location1 instanceof Range && location2 instanceof Cut) {
                            if (((Range)location1).getEnd() <= ((Cut)location2).getAt() || ((Cut)location2).getAt() < ((Range)location1).getStart()) continue;
                            errors.add(new SBOLValidationException("sbol-10903", location1, location2).getMessage());
                            continue;
                        }
                        if (location2 instanceof Range && location1 instanceof Cut) {
                            if (((Range)location2).getEnd() <= ((Cut)location1).getAt() || ((Cut)location1).getAt() < ((Range)location2).getStart()) continue;
                            errors.add(new SBOLValidationException("sbol-10903", location1, location2).getMessage());
                            continue;
                        }
                        if (!(location2 instanceof Cut) || !(location1 instanceof Cut) || ((Cut)location2).getAt() != ((Cut)location1).getAt()) continue;
                        errors.add(new SBOLValidationException("sbol-10903", location1, location2).getMessage());
                    }
                }
            }
        }
    }

    static boolean checkSmilesEncoding(String sequence) {
        try {
            smilesParser.parseSmiles(sequence);
        }
        catch (InvalidSmilesException e) {
            return false;
        }
        return true;
    }

    static boolean checkSequenceEncoding(Sequence sequence) {
        if (sequence.getEncoding().equals(Sequence.IUPAC_DNA) || sequence.getEncoding().equals(Sequence.IUPAC_RNA)) {
            Matcher m = iupacDNAparser.matcher(sequence.getElements().toUpperCase());
            return m.matches();
        }
        if (sequence.getEncoding().equals(Sequence.IUPAC_PROTEIN)) {
            Matcher m = iupacProteinParser.matcher(sequence.getElements().toUpperCase());
            return m.matches();
        }
        if (sequence.getEncoding().equals(Sequence.SMILES)) {
            return SBOLValidate.checkSmilesEncoding(sequence.getElements());
        }
        return true;
    }

    private static void validatePersistentIdentityUniqueness(SBOLDocument sbolDocument) {
        HashMap<URI, Identified> elements = new HashMap<URI, Identified>();
        for (TopLevel topLevel : sbolDocument.getTopLevels()) {
            Object identified;
            Identified identified2;
            if (!topLevel.isSetPersistentIdentity()) continue;
            if (elements.get(topLevel.getPersistentIdentity()) != null) {
                Identified identified3 = (Identified)elements.get(topLevel.getPersistentIdentity());
                if (!topLevel.getClass().equals(identified3.getClass())) {
                    errors.add(new SBOLValidationException("sbol-10220", topLevel).getMessage());
                }
            }
            elements.put(topLevel.getPersistentIdentity(), topLevel);
            if (topLevel instanceof ComponentDefinition) {
                for (Component component : ((ComponentDefinition)topLevel).getComponents()) {
                    if (!component.isSetPersistentIdentity()) continue;
                    if (elements.get(component.getPersistentIdentity()) != null) {
                        Identified identified22 = (Identified)elements.get(component.getPersistentIdentity());
                        if (!component.getClass().equals(identified22.getClass())) {
                            errors.add(new SBOLValidationException("sbol-10220", component).getMessage());
                        }
                    }
                    elements.put(component.getPersistentIdentity(), component);
                    for (MapsTo m : component.getMapsTos()) {
                        if (!m.isSetPersistentIdentity()) continue;
                        if (elements.get(m.getPersistentIdentity()) != null) {
                            identified2 = (Identified)elements.get(m.getPersistentIdentity());
                            if (!m.getClass().equals(identified2.getClass())) {
                                errors.add(new SBOLValidationException("sbol-10220", m).getMessage());
                            }
                        }
                        elements.put(m.getPersistentIdentity(), m);
                    }
                }
                for (SequenceAnnotation sequenceAnnotation : ((ComponentDefinition)topLevel).getSequenceAnnotations()) {
                    if (!sequenceAnnotation.isSetPersistentIdentity()) continue;
                    if (elements.get(sequenceAnnotation.getPersistentIdentity()) != null) {
                        identified = (Identified)elements.get(sequenceAnnotation.getPersistentIdentity());
                        if (!sequenceAnnotation.getClass().equals(identified.getClass())) {
                            errors.add(new SBOLValidationException("sbol-10220", sequenceAnnotation).getMessage());
                        }
                    }
                    elements.put(sequenceAnnotation.getPersistentIdentity(), sequenceAnnotation);
                    for (Location l : sequenceAnnotation.getLocations()) {
                        if (!l.isSetPersistentIdentity()) continue;
                        if (elements.get(l.getPersistentIdentity()) != null) {
                            identified2 = (Identified)elements.get(l.getPersistentIdentity());
                            if (!l.getClass().equals(identified2.getClass())) {
                                errors.add(new SBOLValidationException("sbol-10220", l).getMessage());
                            }
                        }
                        elements.put(l.getPersistentIdentity(), l);
                    }
                }
                for (SequenceConstraint sequenceConstraint : ((ComponentDefinition)topLevel).getSequenceConstraints()) {
                    if (!sequenceConstraint.isSetPersistentIdentity()) continue;
                    if (elements.get(sequenceConstraint.getPersistentIdentity()) != null) {
                        identified = (Identified)elements.get(sequenceConstraint.getPersistentIdentity());
                        if (!sequenceConstraint.getClass().equals(identified.getClass())) {
                            errors.add(new SBOLValidationException("sbol-10220", sequenceConstraint).getMessage());
                        }
                    }
                    elements.put(sequenceConstraint.getPersistentIdentity(), sequenceConstraint);
                }
            }
            if (!(topLevel instanceof ModuleDefinition)) continue;
            for (FunctionalComponent functionalComponent : ((ModuleDefinition)topLevel).getFunctionalComponents()) {
                if (!functionalComponent.isSetPersistentIdentity()) continue;
                if (elements.get(functionalComponent.getPersistentIdentity()) != null) {
                    identified = (Identified)elements.get(functionalComponent.getPersistentIdentity());
                    if (!functionalComponent.getClass().equals(identified.getClass())) {
                        errors.add(new SBOLValidationException("sbol-10220", functionalComponent).getMessage());
                    }
                }
                elements.put(functionalComponent.getPersistentIdentity(), functionalComponent);
                for (MapsTo m : functionalComponent.getMapsTos()) {
                    if (!m.isSetPersistentIdentity()) continue;
                    if (elements.get(m.getPersistentIdentity()) != null) {
                        identified2 = (Identified)elements.get(m.getPersistentIdentity());
                        if (!m.getClass().equals(identified2.getClass())) {
                            errors.add(new SBOLValidationException("sbol-10220", m).getMessage());
                        }
                    }
                    elements.put(m.getPersistentIdentity(), m);
                }
            }
            for (Module module : ((ModuleDefinition)topLevel).getModules()) {
                if (!module.isSetPersistentIdentity()) continue;
                if (elements.get(module.getPersistentIdentity()) != null) {
                    identified = (Identified)elements.get(module.getPersistentIdentity());
                    if (!module.getClass().equals(identified.getClass())) {
                        errors.add(new SBOLValidationException("sbol-10220", module).getMessage());
                    }
                }
                elements.put(module.getPersistentIdentity(), module);
                for (MapsTo m : module.getMapsTos()) {
                    if (!m.isSetPersistentIdentity()) continue;
                    if (elements.get(m.getPersistentIdentity()) != null) {
                        identified2 = (Identified)elements.get(m.getPersistentIdentity());
                        if (!m.getClass().equals(identified2.getClass())) {
                            errors.add(new SBOLValidationException("sbol-10220", m).getMessage());
                        }
                    }
                    elements.put(m.getPersistentIdentity(), m);
                }
            }
            for (Interaction interaction : ((ModuleDefinition)topLevel).getInteractions()) {
                if (!interaction.isSetPersistentIdentity()) continue;
                if (elements.get(interaction.getPersistentIdentity()) != null) {
                    identified = (Identified)elements.get(interaction.getPersistentIdentity());
                    if (!interaction.getClass().equals(identified.getClass())) {
                        errors.add(new SBOLValidationException("sbol-10220", interaction).getMessage());
                    }
                }
                elements.put(interaction.getPersistentIdentity(), interaction);
                for (Participation p : interaction.getParticipations()) {
                    if (!p.isSetPersistentIdentity()) continue;
                    if (elements.get(p.getPersistentIdentity()) != null) {
                        identified2 = (Identified)elements.get(p.getPersistentIdentity());
                        if (!p.getClass().equals(identified2.getClass())) {
                            errors.add(new SBOLValidationException("sbol-10220", p).getMessage());
                        }
                    }
                    elements.put(p.getPersistentIdentity(), p);
                }
            }
        }
    }

    private static void validateURIuniqueness(SBOLDocument sbolDocument) {
        HashMap<URI, Identified> elements = new HashMap<URI, Identified>();
        for (TopLevel topLevel : sbolDocument.getTopLevels()) {
            Object identified;
            Identified identified2;
            MapsTo m;
            Identified identified3;
            if (elements.get(topLevel.getIdentity()) != null && !topLevel.equals(identified3 = (Identified)elements.get(topLevel.getIdentity()))) {
                errors.add(new SBOLValidationException("sbol-10202", topLevel).getMessage());
            }
            elements.put(topLevel.getIdentity(), topLevel);
            if (topLevel instanceof ComponentDefinition) {
                for (Component component : ((ComponentDefinition)topLevel).getComponents()) {
                    Object identified22;
                    if (elements.get(component.getIdentity()) != null && !component.equals(identified22 = (Identified)elements.get(component.getIdentity()))) {
                        errors.add(new SBOLValidationException("sbol-10202", component).getMessage());
                    }
                    elements.put(component.getIdentity(), component);
                    identified22 = component.getMapsTos().iterator();
                    while (identified22.hasNext()) {
                        m = (MapsTo)identified22.next();
                        if (elements.get(m.getIdentity()) != null && !m.equals(identified2 = (Identified)elements.get(m.getIdentity()))) {
                            errors.add(new SBOLValidationException("sbol-10202", m).getMessage());
                        }
                        elements.put(m.getIdentity(), m);
                    }
                }
                for (SequenceAnnotation sequenceAnnotation : ((ComponentDefinition)topLevel).getSequenceAnnotations()) {
                    if (elements.get(sequenceAnnotation.getIdentity()) != null && !sequenceAnnotation.equals(identified = (Identified)elements.get(sequenceAnnotation.getIdentity()))) {
                        errors.add(new SBOLValidationException("sbol-10202", sequenceAnnotation).getMessage());
                    }
                    elements.put(sequenceAnnotation.getIdentity(), sequenceAnnotation);
                    identified = sequenceAnnotation.getLocations().iterator();
                    while (identified.hasNext()) {
                        Location l = (Location)identified.next();
                        if (elements.get(l.getIdentity()) != null && !l.equals(identified2 = (Identified)elements.get(l.getIdentity()))) {
                            errors.add(new SBOLValidationException("sbol-10202", l).getMessage());
                        }
                        elements.put(l.getIdentity(), l);
                    }
                }
                for (SequenceConstraint sequenceConstraint : ((ComponentDefinition)topLevel).getSequenceConstraints()) {
                    if (elements.get(sequenceConstraint.getIdentity()) != null && !sequenceConstraint.equals(identified = (Identified)elements.get(sequenceConstraint.getIdentity()))) {
                        errors.add(new SBOLValidationException("sbol-10202", sequenceConstraint).getMessage());
                    }
                    elements.put(sequenceConstraint.getIdentity(), sequenceConstraint);
                }
            }
            if (!(topLevel instanceof ModuleDefinition)) continue;
            for (FunctionalComponent functionalComponent : ((ModuleDefinition)topLevel).getFunctionalComponents()) {
                if (elements.get(functionalComponent.getIdentity()) != null && !functionalComponent.equals(identified = (Identified)elements.get(functionalComponent.getIdentity()))) {
                    errors.add(new SBOLValidationException("sbol-10202", functionalComponent).getMessage());
                }
                elements.put(functionalComponent.getIdentity(), functionalComponent);
                identified = functionalComponent.getMapsTos().iterator();
                while (identified.hasNext()) {
                    m = (MapsTo)((Object)identified.next());
                    if (elements.get(m.getIdentity()) != null && !m.equals(identified2 = (Identified)elements.get(m.getIdentity()))) {
                        errors.add(new SBOLValidationException("sbol-10202", m).getMessage());
                    }
                    elements.put(m.getIdentity(), m);
                }
            }
            for (Module module : ((ModuleDefinition)topLevel).getModules()) {
                if (elements.get(module.getIdentity()) != null && !module.equals(identified = (Identified)elements.get(module.getIdentity()))) {
                    errors.add(new SBOLValidationException("sbol-10202", module).getMessage());
                }
                elements.put(module.getIdentity(), module);
                identified = module.getMapsTos().iterator();
                while (identified.hasNext()) {
                    m = (MapsTo)identified.next();
                    if (elements.get(m.getIdentity()) != null && !m.equals(identified2 = (Identified)elements.get(m.getIdentity()))) {
                        errors.add(new SBOLValidationException("sbol-10202", m).getMessage());
                    }
                    elements.put(m.getIdentity(), m);
                }
            }
            for (Interaction interaction : ((ModuleDefinition)topLevel).getInteractions()) {
                if (elements.get(interaction.getIdentity()) != null && !interaction.equals(identified = (Identified)elements.get(interaction.getIdentity()))) {
                    errors.add(new SBOLValidationException("sbol-10202", interaction).getMessage());
                }
                elements.put(interaction.getIdentity(), interaction);
                for (Participation p : interaction.getParticipations()) {
                    if (elements.get(p.getIdentity()) != null && !p.equals(identified2 = (Identified)elements.get(p.getIdentity()))) {
                        errors.add(new SBOLValidationException("sbol-10202", p).getMessage());
                    }
                    elements.put(p.getIdentity(), p);
                }
            }
        }
    }

    public static void validateSBOL(SBOLDocument sbolDocument, boolean complete, boolean compliant, boolean bestPractice) {
        SBOLValidate.clearErrors();
        SBOLValidate.validateWasDerivedFromVersion(sbolDocument);
        SBOLValidate.validateCircularReferences(sbolDocument);
        SBOLValidate.validateURIuniqueness(sbolDocument);
        SBOLValidate.validatePersistentIdentityUniqueness(sbolDocument);
        SBOLValidate.validateMapsTos(sbolDocument);
        if (compliant) {
            SBOLValidate.validateCompliance(sbolDocument);
        }
        if (complete) {
            SBOLValidate.validateCompleteness(sbolDocument);
        }
        if (bestPractice) {
            SBOLValidate.validateOntologyUsage(sbolDocument);
            SBOLValidate.validateSequenceAnnotations(sbolDocument);
            SBOLValidate.validateComponentDefinitionSequences(sbolDocument);
        }
    }

    private static void compareNamespaces(String file1, SBOLDocument doc1, String file2, SBOLDocument doc2) {
        for (QName namespace : doc1.getNamespaces()) {
            if (doc2.getNamespaces().contains(namespace)) continue;
            System.err.println("Namespace " + namespace.toString() + " not found in " + file2);
        }
        for (QName namespace : doc2.getNamespaces()) {
            if (doc1.getNamespaces().contains(namespace)) continue;
            System.err.println("Namespace " + namespace.toString() + " not found in " + file1);
        }
    }

    private static void compareCollections(String file1, SBOLDocument doc1, String file2, SBOLDocument doc2) {
        for (Collection collection1 : doc1.getCollections()) {
            Collection collection2 = doc2.getCollection(collection1.getIdentity());
            if (collection2 == null) {
                System.err.println("Collection " + collection1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (collection1.equals(collection2)) continue;
            System.err.println("Collection " + collection1.getIdentity() + " differ.");
        }
        for (Collection collection2 : doc2.getCollections()) {
            Collection collection1 = doc1.getCollection(collection2.getIdentity());
            if (collection1 != null) continue;
            System.err.println("Collection " + collection2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareMapsTos(String file1, Component component1, String file2, Component component2) {
        for (MapsTo mapsTo1 : component1.getMapsTos()) {
            MapsTo mapsTo2 = component2.getMapsTo(mapsTo1.getIdentity());
            if (mapsTo2 == null) {
                System.err.println("--->MapsTo " + mapsTo1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (mapsTo1.equals(mapsTo2)) continue;
            System.err.println("--->MapsTo " + mapsTo1.getIdentity() + " differ.");
        }
        for (MapsTo mapsTo2 : component2.getMapsTos()) {
            MapsTo mapsTo1 = component1.getMapsTo(mapsTo2.getIdentity());
            if (mapsTo1 != null) continue;
            System.err.println("--->MapsTo " + mapsTo2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareComponents(String file1, ComponentDefinition componentDefinition1, String file2, ComponentDefinition componentDefinition2) {
        for (Component component1 : componentDefinition1.getComponents()) {
            Component component2 = componentDefinition2.getComponent(component1.getIdentity());
            if (component2 == null) {
                System.err.println("->Component " + component1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (component1.equals(component2)) continue;
            System.err.println("->Component " + component1.getIdentity() + " differ.");
            SBOLValidate.compareMapsTos(file1, component1, file2, component2);
        }
        for (Component component2 : componentDefinition2.getComponents()) {
            Component component1 = componentDefinition1.getComponent(component2.getIdentity());
            if (component1 != null) continue;
            System.err.println("->Component " + component2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareLocations(String file1, SequenceAnnotation sequenceAnnotation1, String file2, SequenceAnnotation sequenceAnnotation2) {
        for (Location location1 : sequenceAnnotation1.getLocations()) {
            Location location2 = sequenceAnnotation2.getLocation(location1.getIdentity());
            if (location2 == null) {
                System.err.println("--->Location " + location1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (location1.equals(location2)) continue;
            System.err.println("--->Location " + location1.getIdentity() + " differ.");
        }
        for (Location location2 : sequenceAnnotation2.getLocations()) {
            Location location1 = sequenceAnnotation1.getLocation(location2.getIdentity());
            if (location1 != null) continue;
            System.err.println("--->Location " + location2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareSequenceAnnotations(String file1, ComponentDefinition componentDefinition1, String file2, ComponentDefinition componentDefinition2) {
        for (SequenceAnnotation sequenceAnnotation1 : componentDefinition1.getSequenceAnnotations()) {
            SequenceAnnotation sequenceAnnotation2 = componentDefinition2.getSequenceAnnotation(sequenceAnnotation1.getIdentity());
            if (sequenceAnnotation2 == null) {
                System.err.println("->SequenceAnnotation " + sequenceAnnotation1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (sequenceAnnotation1.equals(sequenceAnnotation2)) continue;
            System.err.println("->SequenceAnnotation " + sequenceAnnotation1.getIdentity() + " differ.");
            SBOLValidate.compareLocations(file1, sequenceAnnotation1, file2, sequenceAnnotation2);
        }
        for (SequenceAnnotation sequenceAnnotation2 : componentDefinition2.getSequenceAnnotations()) {
            SequenceAnnotation sequenceAnnotation1 = componentDefinition1.getSequenceAnnotation(sequenceAnnotation2.getIdentity());
            if (sequenceAnnotation1 != null) continue;
            System.err.println("->SequenceAnnotation " + sequenceAnnotation2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareSequenceConstraints(String file1, ComponentDefinition componentDefinition1, String file2, ComponentDefinition componentDefinition2) {
        for (SequenceConstraint sequenceConstraint1 : componentDefinition1.getSequenceConstraints()) {
            SequenceConstraint sequenceConstraint2 = componentDefinition2.getSequenceConstraint(sequenceConstraint1.getIdentity());
            if (sequenceConstraint2 == null) {
                System.err.println("->SequenceConstraint " + sequenceConstraint1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (sequenceConstraint1.equals(sequenceConstraint2)) continue;
            System.err.println("->SequenceConstraint " + sequenceConstraint1.getIdentity() + " differ.");
        }
        for (SequenceConstraint sequenceConstraint2 : componentDefinition2.getSequenceConstraints()) {
            SequenceConstraint sequenceConstraint1 = componentDefinition1.getSequenceConstraint(sequenceConstraint2.getIdentity());
            if (sequenceConstraint1 != null) continue;
            System.err.println("->SequenceConstraint " + sequenceConstraint2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareComponentDefinitions(String file1, SBOLDocument doc1, String file2, SBOLDocument doc2) {
        for (ComponentDefinition componentDefinition1 : doc1.getComponentDefinitions()) {
            ComponentDefinition componentDefinition2 = doc2.getComponentDefinition(componentDefinition1.getIdentity());
            if (componentDefinition2 == null) {
                System.err.println("ComponentDefinition " + componentDefinition1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (componentDefinition1.equals(componentDefinition2)) continue;
            System.err.println("ComponentDefinition " + componentDefinition1.getIdentity() + " differ.");
            SBOLValidate.compareComponents(file1, componentDefinition1, file2, componentDefinition2);
            SBOLValidate.compareSequenceAnnotations(file1, componentDefinition1, file2, componentDefinition2);
            SBOLValidate.compareSequenceConstraints(file1, componentDefinition1, file2, componentDefinition2);
        }
        for (ComponentDefinition componentDefinition2 : doc2.getComponentDefinitions()) {
            ComponentDefinition componentDefinition1 = doc1.getComponentDefinition(componentDefinition2.getIdentity());
            if (componentDefinition1 != null) continue;
            System.err.println("ComponentDefinition " + componentDefinition2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareSequences(String file1, SBOLDocument doc1, String file2, SBOLDocument doc2) {
        for (Sequence sequence1 : doc1.getSequences()) {
            Sequence sequence2 = doc2.getSequence(sequence1.getIdentity());
            if (sequence2 == null) {
                System.err.println("Sequence " + sequence1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (sequence1.equals(sequence2)) continue;
            System.err.println("Sequence " + sequence1.getIdentity() + " differ.");
        }
        for (Sequence sequence2 : doc2.getSequences()) {
            Sequence sequence1 = doc1.getSequence(sequence2.getIdentity());
            if (sequence1 != null) continue;
            System.err.println("Sequence " + sequence2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareMapsTos(String file1, FunctionalComponent functionalComponent1, String file2, FunctionalComponent functionalComponent2) {
        for (MapsTo mapsTo1 : functionalComponent1.getMapsTos()) {
            MapsTo mapsTo2 = functionalComponent2.getMapsTo(mapsTo1.getIdentity());
            if (mapsTo2 == null) {
                System.err.println("--->MapsTo " + mapsTo1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (mapsTo1.equals(mapsTo2)) continue;
            System.err.println("--->MapsTo " + mapsTo1.getIdentity() + " differ.");
        }
        for (MapsTo mapsTo2 : functionalComponent2.getMapsTos()) {
            MapsTo mapsTo1 = functionalComponent1.getMapsTo(mapsTo2.getIdentity());
            if (mapsTo1 != null) continue;
            System.err.println("--->MapsTo " + mapsTo2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareFunctionalComponents(String file1, ModuleDefinition moduleDefinition1, String file2, ModuleDefinition moduleDefinition2) {
        for (FunctionalComponent functionalComponent1 : moduleDefinition1.getFunctionalComponents()) {
            FunctionalComponent functionalComponent2 = moduleDefinition2.getFunctionalComponent(functionalComponent1.getIdentity());
            if (functionalComponent2 == null) {
                System.err.println("->FunctionalComponent " + functionalComponent1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (functionalComponent1.equals(functionalComponent2)) continue;
            System.err.println("->FunctionalComponent " + functionalComponent1.getIdentity() + " differ.");
            SBOLValidate.compareMapsTos(file1, functionalComponent1, file2, functionalComponent2);
        }
        for (FunctionalComponent functionalComponent2 : moduleDefinition2.getFunctionalComponents()) {
            FunctionalComponent functionalComponent1 = moduleDefinition1.getFunctionalComponent(functionalComponent2.getIdentity());
            if (functionalComponent1 != null) continue;
            System.err.println("->FunctionalComponent " + functionalComponent2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareMapsTos(String file1, Module module1, String file2, Module module2) {
        for (MapsTo mapsTo1 : module1.getMapsTos()) {
            MapsTo mapsTo2 = module2.getMapsTo(mapsTo1.getIdentity());
            if (mapsTo2 == null) {
                System.err.println("--->MapsTo " + mapsTo1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (mapsTo1.equals(mapsTo2)) continue;
            System.err.println("--->MapsTo " + mapsTo1.getIdentity() + " differ.");
        }
        for (MapsTo mapsTo2 : module2.getMapsTos()) {
            MapsTo mapsTo1 = module1.getMapsTo(mapsTo2.getIdentity());
            if (mapsTo1 != null) continue;
            System.err.println("--->MapsTo " + mapsTo2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareModules(String file1, ModuleDefinition moduleDefinition1, String file2, ModuleDefinition moduleDefinition2) {
        for (Module module1 : moduleDefinition1.getModules()) {
            Module module2 = moduleDefinition2.getModule(module1.getIdentity());
            if (module2 == null) {
                System.err.println("->Module " + module1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (module1.equals(module2)) continue;
            System.err.println("->Module " + module1.getIdentity() + " differ.");
            SBOLValidate.compareMapsTos(file1, module1, file2, module2);
        }
        for (Module module2 : moduleDefinition2.getModules()) {
            Module module1 = moduleDefinition1.getModule(module2.getIdentity());
            if (module1 != null) continue;
            System.err.println("->Module " + module2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareParticipations(String file1, Interaction interaction1, String file2, Interaction interaction2) {
        for (Participation participation1 : interaction1.getParticipations()) {
            Participation participation2 = interaction2.getParticipation(participation1.getIdentity());
            if (participation2 == null) {
                System.err.println("--->Participation " + participation1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (participation1.equals(participation2)) continue;
            System.err.println("--->Participation " + participation1.getIdentity() + " differ.");
        }
        for (Participation participation2 : interaction2.getParticipations()) {
            Participation participation1 = interaction1.getParticipation(participation2.getIdentity());
            if (participation1 != null) continue;
            System.err.println("--->Participation " + participation2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareInteractions(String file1, ModuleDefinition moduleDefinition1, String file2, ModuleDefinition moduleDefinition2) {
        for (Interaction interaction1 : moduleDefinition1.getInteractions()) {
            Interaction interaction2 = moduleDefinition2.getInteraction(interaction1.getIdentity());
            if (interaction2 == null) {
                System.err.println("->Interaction " + interaction1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (interaction1.equals(interaction2)) continue;
            System.err.println("->Interaction " + interaction1.getIdentity() + " differ.");
            SBOLValidate.compareParticipations(file1, interaction1, file1, interaction2);
        }
        for (Interaction interaction2 : moduleDefinition2.getInteractions()) {
            Interaction interaction1 = moduleDefinition1.getInteraction(interaction2.getIdentity());
            if (interaction1 != null) continue;
            System.err.println("->Interaction " + interaction2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareModuleDefinitions(String file1, SBOLDocument doc1, String file2, SBOLDocument doc2) {
        for (ModuleDefinition moduleDefinition1 : doc1.getModuleDefinitions()) {
            ModuleDefinition moduleDefinition2 = doc2.getModuleDefinition(moduleDefinition1.getIdentity());
            if (moduleDefinition2 == null) {
                System.err.println("ModuleDefinition " + moduleDefinition1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (moduleDefinition1.equals(moduleDefinition2)) continue;
            System.err.println("ModuleDefinition " + moduleDefinition1.getIdentity() + " differ.");
            SBOLValidate.compareFunctionalComponents(file1, moduleDefinition1, file2, moduleDefinition2);
            SBOLValidate.compareModules(file1, moduleDefinition1, file2, moduleDefinition2);
            SBOLValidate.compareInteractions(file1, moduleDefinition1, file2, moduleDefinition2);
        }
        for (ModuleDefinition moduleDefinition2 : doc2.getModuleDefinitions()) {
            ModuleDefinition moduleDefinition1 = doc1.getModuleDefinition(moduleDefinition2.getIdentity());
            if (moduleDefinition1 != null) continue;
            System.err.println("ModuleDefinition " + moduleDefinition2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareModels(String file1, SBOLDocument doc1, String file2, SBOLDocument doc2) {
        for (Model model1 : doc1.getModels()) {
            Model model2 = doc2.getModel(model1.getIdentity());
            if (model2 == null) {
                System.err.println("Model " + model1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (model1.equals(model2)) continue;
            System.err.println("Model " + model1.getIdentity() + " differ.");
        }
        for (Model model2 : doc2.getModels()) {
            Model model1 = doc1.getModel(model2.getIdentity());
            if (model1 != null) continue;
            System.err.println("Model " + model2.getIdentity() + " not found in " + file1);
        }
    }

    private static void compareGenericTopLevels(String file1, SBOLDocument doc1, String file2, SBOLDocument doc2) {
        for (GenericTopLevel genericTopLevel1 : doc1.getGenericTopLevels()) {
            GenericTopLevel genericTopLevel2 = doc2.getGenericTopLevel(genericTopLevel1.getIdentity());
            if (genericTopLevel2 == null) {
                System.err.println("GenericTopLevel " + genericTopLevel1.getIdentity() + " not found in " + file2);
                continue;
            }
            if (genericTopLevel1.equals(genericTopLevel2)) continue;
            System.err.println("GenericTopLevel " + genericTopLevel1.getIdentity() + " differ.");
        }
        for (GenericTopLevel genericTopLevel2 : doc2.getGenericTopLevels()) {
            GenericTopLevel genericTopLevel1 = doc1.getGenericTopLevel(genericTopLevel2.getIdentity());
            if (genericTopLevel1 != null) continue;
            System.err.println("GenericTopLevel " + genericTopLevel2.getIdentity() + " not found in " + file1);
        }
    }

    public static void compareDocuments(String file1, SBOLDocument doc1, String file2, SBOLDocument doc2) {
        SBOLValidate.compareNamespaces(file1, doc1, file2, doc2);
        SBOLValidate.compareCollections(file1, doc1, file2, doc2);
        SBOLValidate.compareComponentDefinitions(file1, doc1, file2, doc2);
        SBOLValidate.compareSequences(file1, doc1, file2, doc2);
        SBOLValidate.compareModuleDefinitions(file1, doc1, file2, doc2);
        SBOLValidate.compareModels(file1, doc1, file2, doc2);
        SBOLValidate.compareGenericTopLevels(file1, doc1, file2, doc2);
    }

    private static void usage() {
        System.err.println("libSBOLj version 2.1.2");
        System.err.println("Description: validates the contents of an SBOL 2.0 document, can compare two documents,\nand can convert to/from SBOL 1.1, GenBank, and FASTA formats.");
        System.err.println();
        System.err.println("Usage:");
        System.err.println("\tjava --jar libSBOLj.jar [options] <inputFile> [-o <outputFile> -e <compareFile>]");
        System.err.println();
        System.err.println("Options:");
        System.err.println("\t-l  <language> specfies language (SBOL1/SBOL2/GenBank/FASTA) for output (default=SBOL2)");
        System.err.println("\t-s  <topLevelURI> select only this object and those it references");
        System.err.println("\t-p  <URIprefix> used for converted objects");
        System.err.println("\t-v  <version> used for converted objects");
        System.err.println("\t-t  uses types in URIs");
        System.err.println("\t-n  allow non-compliant URIs");
        System.err.println("\t-i  allow SBOL document to be incomplete");
        System.err.println("\t-b  check best practices");
        System.err.println("\t-f  fail on first error");
        System.err.println("\t-d  display detailed error trace");
        System.exit(1);
    }

    public static void validate(String fileName, String URIPrefix, boolean complete, boolean compliant, boolean bestPractice, boolean typesInURI, String version, boolean keepGoing, String compareFile, String compareFileName, String mainFileName, String topLevelURIStr, boolean genBankOut, boolean sbolV1out, boolean fastaOut, String outputFile, boolean showDetail, boolean noOutput) {
        try {
            SBOLDocument doc = null;
            if (!URIPrefix.equals("")) {
                SBOLReader.setURIPrefix(URIPrefix);
            }
            if (!compliant) {
                SBOLReader.setCompliant(false);
            }
            SBOLReader.setTypesInURI(typesInURI);
            SBOLReader.setVersion(version);
            SBOLReader.setKeepGoing(keepGoing);
            SBOLWriter.setKeepGoing(keepGoing);
            if (FASTA.isFastaFile(fileName)) {
                System.out.println("Converting FASTA to SBOL Version 2");
            } else if (GenBank.isGenBankFile(fileName)) {
                System.out.println("Converting GenBank to SBOL Version 2");
            } else if (SBOLReader.getSBOLVersion(fileName).equals("v1")) {
                System.out.println("Converting SBOL Version 1 to SBOL Version 2");
            }
            doc = SBOLReader.read(fileName);
            doc.setTypesInURIs(typesInURI);
            if (!compareFile.equals("")) {
                File f;
                SBOLDocument doc2 = SBOLReader.read(compareFile);
                if (mainFileName.equals("")) {
                    f = new File(fileName);
                    mainFileName = f.getName();
                }
                if (compareFileName.equals("")) {
                    f = new File(compareFile);
                    compareFileName = f.getName();
                }
                SBOLValidate.compareDocuments(mainFileName, doc, compareFileName, doc2);
            }
            if (!topLevelURIStr.equals("")) {
                TopLevel topLevel = doc.getTopLevel(URI.create(topLevelURIStr));
                if (topLevel == null) {
                    System.err.println("TopLevel " + topLevelURIStr + " not found.");
                    return;
                }
                if (complete) {
                    doc = doc.createRecursiveCopy(topLevel);
                } else {
                    SBOLDocument newDoc = new SBOLDocument();
                    newDoc.createCopy(topLevel);
                    doc = newDoc;
                }
            }
            if (!URIPrefix.equals("") && doc.getTopLevels().size() > 0) {
                System.out.println("Updating URI prefix to: " + URIPrefix);
                if (version != null) {
                    System.out.println("Updating Version to: " + version);
                }
                doc = doc.changeURIPrefixVersion(URIPrefix, version);
            } else if (version != null) {
                System.err.println("Cannot change version without also changing the URI prefix.");
                return;
            }
            SBOLValidate.validateSBOL(doc, complete, compliant, bestPractice);
            if (SBOLValidate.getNumErrors() == 0 && SBOLReader.getNumErrors() == 0) {
                if (noOutput) {
                    System.out.println("Validation successful, no errors.");
                } else if (genBankOut) {
                    if (outputFile.equals("")) {
                        SBOLWriter.write(doc, System.out, "GENBANK");
                    } else {
                        System.out.println("Validation successful, no errors.");
                        SBOLWriter.write(doc, outputFile, "GENBANK");
                    }
                } else if (sbolV1out) {
                    if (outputFile.equals("")) {
                        SBOLWriter.write(doc, System.out, "RDFV1");
                    } else {
                        System.out.println("Validation successful, no errors.");
                        SBOLWriter.write(doc, outputFile, "RDFV1");
                    }
                    if (SBOLWriter.getNumErrors() != 0) {
                        for (String error : SBOLWriter.getErrors()) {
                            System.err.println(error);
                        }
                    }
                } else if (fastaOut) {
                    if (outputFile.equals("")) {
                        SBOLWriter.write(doc, System.out, "FASTA");
                    } else {
                        System.out.println("Validation successful, no errors.");
                        SBOLWriter.write(doc, outputFile, "FASTA");
                    }
                } else if (outputFile.equals("")) {
                    SBOLWriter.write(doc, System.out);
                } else {
                    System.out.println("Validation successful, no errors.");
                    SBOLWriter.write(doc, outputFile);
                }
            } else {
                if (SBOLValidate.getNumErrors() != 0) {
                    for (String error : SBOLValidate.getErrors()) {
                        System.err.println(error);
                        System.err.println();
                    }
                }
                if (SBOLReader.getNumErrors() != 0) {
                    for (String error : SBOLReader.getErrors()) {
                        System.err.println(error);
                        System.err.println();
                    }
                }
                System.err.println("Validation failed.\n");
            }
        }
        catch (SBOLValidationException e) {
            if (showDetail) {
                e.printStackTrace();
            }
            if (e.getMessage() != null) {
                System.err.println(e.getMessage() + "\nValidation failed.");
            } else {
                e.printStackTrace();
                System.err.println("\nValidation failed.");
            }
        }
        catch (SBOLConversionException e) {
            if (showDetail) {
                e.printStackTrace();
            }
            if (e.getMessage() != null) {
                System.err.println(e.getMessage() + "\nConversion failed.");
            } else {
                e.printStackTrace();
                System.err.println("\nConversion failed.");
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage() + "\nI/O exception.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        File file;
        boolean isDirectory;
        String fileName = "";
        String outputFile = "";
        String compareFile = "";
        String mainFileName = "";
        String compareFileName = "";
        String topLevelURIStr = "";
        String URIPrefix = "";
        String version = null;
        boolean complete = true;
        boolean compliant = true;
        boolean typesInURI = false;
        boolean bestPractice = false;
        boolean keepGoing = true;
        boolean showDetail = false;
        boolean genBankOut = false;
        boolean fastaOut = false;
        boolean sbolV1out = false;
        boolean noOutput = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-i")) {
                complete = false;
                continue;
            }
            if (args[i].equals("-t")) {
                typesInURI = true;
                continue;
            }
            if (args[i].equals("-b")) {
                bestPractice = true;
                continue;
            }
            if (args[i].equals("-n")) {
                compliant = false;
                continue;
            }
            if (args[i].equals("-f")) {
                keepGoing = false;
                continue;
            }
            if (args[i].equals("-d")) {
                showDetail = true;
                continue;
            }
            if (args[i].equals("-s")) {
                if (i + 1 >= args.length) {
                    SBOLValidate.usage();
                }
                topLevelURIStr = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-l")) {
                if (i + 1 >= args.length) {
                    SBOLValidate.usage();
                }
                if (args[i + 1].equals("SBOL1")) {
                    sbolV1out = true;
                } else if (args[i + 1].equals("GenBank")) {
                    genBankOut = true;
                } else if (args[i + 1].equals("FASTA")) {
                    fastaOut = true;
                } else if (!args[i + 1].equals("SBOL2")) {
                    SBOLValidate.usage();
                }
                ++i;
                continue;
            }
            if (args[i].equals("-o")) {
                if (i + 1 >= args.length) {
                    SBOLValidate.usage();
                }
                outputFile = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-no")) {
                noOutput = true;
                continue;
            }
            if (args[i].equals("-e")) {
                if (i + 1 >= args.length) {
                    SBOLValidate.usage();
                }
                compareFile = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-mf")) {
                if (i + 1 >= args.length) {
                    SBOLValidate.usage();
                }
                mainFileName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-cf")) {
                if (i + 1 >= args.length) {
                    SBOLValidate.usage();
                }
                compareFileName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-p")) {
                if (i + 1 >= args.length) {
                    SBOLValidate.usage();
                }
                URIPrefix = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-v")) {
                if (i + 1 >= args.length) {
                    SBOLValidate.usage();
                }
                version = args[i + 1];
                ++i;
                continue;
            }
            if (fileName.equals("")) {
                fileName = args[i];
                continue;
            }
            SBOLValidate.usage();
        }
        if (fileName.equals("")) {
            SBOLValidate.usage();
        }
        if (!(isDirectory = (file = new File(fileName)).isDirectory())) {
            SBOLValidate.validate(fileName, URIPrefix, complete, compliant, bestPractice, typesInURI, version, keepGoing, compareFile, compareFileName, mainFileName, topLevelURIStr, genBankOut, sbolV1out, fastaOut, outputFile, showDetail, noOutput);
        } else {
            for (File eachFile : file.listFiles()) {
                System.out.println(eachFile.getAbsolutePath());
                SBOLValidate.validate(eachFile.getAbsolutePath(), URIPrefix, complete, compliant, bestPractice, typesInURI, version, keepGoing, compareFile, compareFileName, mainFileName, topLevelURIStr, genBankOut, sbolV1out, fastaOut, outputFile, showDetail, noOutput);
            }
        }
    }
}

