/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationRule;

public class SBOLValidationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static String ruleBegin = "^\\[(\\w+)\\]\\s*$";
    private static String ruleId = "^id:\\s(sbol-\\d+)\\s*$";
    private static String ruleCondition = "^condition:\\s(\\w+\\s*\\w*)\\s*$";
    private static String ruleDescriptionBegin = "^description:\\s(.+)\\s*$";
    private static String ruleDescriptionBody = "^(?!reference:)(.+)$";
    private static String ruleReference = "^\\breference\\b:\\s(.+)";
    private static SBOLValidationRule currentRule;
    private static Map<String, SBOLValidationRule> validationRules;

    SBOLValidationException(String message, Identified ... objects) {
        this(message, Arrays.asList(objects));
    }

    SBOLValidationException(String message, URI identity) {
        super(SBOLValidationException.formatMessage(message, identity));
    }

    private SBOLValidationException(String message, Collection<? extends Identified> objects) {
        super(SBOLValidationException.formatMessage(message, objects));
    }

    SBOLValidationException(String message, Throwable cause, Identified ... objects) {
        this(message, cause, Arrays.asList(objects));
    }

    private SBOLValidationException(String message, Throwable cause, Collection<? extends Identified> objects) {
        super(SBOLValidationException.formatMessage(message, objects), cause);
    }

    SBOLValidationException(Throwable cause) {
        super(cause);
    }

    private static String formatMessage(String message, URI identity) {
        StringBuilder sb = new StringBuilder(message);
        if (message.startsWith("sbol-")) {
            String key;
            SBOLValidationRule rule;
            if (validationRules == null) {
                validationRules = new LinkedHashMap<String, SBOLValidationRule>();
                InputStreamReader f = new InputStreamReader(SBOLValidationRule.class.getResourceAsStream("/validation/rules2p1p0.txt"));
                try {
                    SBOLValidationException.parse(new BufferedReader(f));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((rule = validationRules.get(key = message.trim())) == null) {
                throw new RuntimeException("Rule ID does not exist.");
            }
            sb.append(": " + rule.getDescription() + "\n");
            sb.append("Reference: SBOL Version 2.1.0 " + rule.getReference() + "\n");
            sb.append(": " + identity.toString());
        } else {
            sb.append(": " + identity.toString());
        }
        return sb.toString();
    }

    private static String formatMessage(String message, Collection<? extends Identified> objects) {
        StringBuilder sb;
        block12: {
            block11: {
                sb = new StringBuilder(message);
                if (!message.startsWith("sbol-")) break block11;
                if (validationRules == null) {
                    validationRules = new LinkedHashMap<String, SBOLValidationRule>();
                    InputStreamReader f = new InputStreamReader(SBOLValidationRule.class.getResourceAsStream("/validation/rules2p1p0.txt"));
                    try {
                        SBOLValidationException.parse(new BufferedReader(f));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                String key = message.trim();
                SBOLValidationRule rule = validationRules.get(key);
                sb.append(": ");
                if (rule != null) {
                    sb.append(rule.getDescription());
                    sb.append("\nReference: SBOL Version 2.1.0 " + rule.getReference());
                }
                if (objects.isEmpty()) break block12;
                sb.append("\n: ");
                boolean bl = true;
                for (Identified identified : objects) {
                    boolean bl2;
                    if (bl2) {
                        bl2 = false;
                    } else {
                        sb.append(", ");
                    }
                    if (identified.getIdentity() == null) continue;
                    sb.append(identified.getIdentity());
                }
                break block12;
            }
            if (!objects.isEmpty()) {
                sb.append(": ");
                boolean first = true;
                for (Identified identified : objects) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    if (identified.getIdentity() == null) continue;
                    sb.append(identified.getIdentity());
                }
            }
        }
        return sb.toString();
    }

    static void writeRulesToXML(String filename) {
        BufferedWriter outputBW = null;
        try {
            File outputFile = new File(filename);
            FileWriter outputFW = new FileWriter(outputFile);
            outputBW = new BufferedWriter(outputFW);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String eol = System.getProperty("line.separator");
        String rule = "";
        rule = rule + "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + eol;
        rule = rule + "<rules>" + eol;
        try {
            outputBW.write(rule);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String key : validationRules.keySet()) {
            rule = rule + "<id>" + key + "</id>" + eol;
            rule = rule + "<category>" + validationRules.get(key).getRuleClass() + "</category>" + eol;
            rule = rule + "<condition>" + validationRules.get(key).getCondition() + "</condition>" + eol;
            rule = rule + "<description>" + validationRules.get(key).getDescription() + "</description>" + eol;
            rule = rule + "<reference>" + validationRules.get(key).getReference() + "</reference>" + eol;
        }
        rule = rule + "</rules>";
        System.out.println(rule);
        try {
            outputBW.write(rule);
            outputBW.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void parse(BufferedReader br) throws IOException {
        String line;
        String ruleDescription = "";
        while ((line = br.readLine()) != null) {
            if (line.matches(ruleBegin)) {
                Matcher mRuleBegin = Pattern.compile(ruleBegin).matcher(line);
                if (mRuleBegin == null || !mRuleBegin.matches()) continue;
                currentRule = new SBOLValidationRule(mRuleBegin.group(1));
                ruleDescription = "";
                continue;
            }
            if (line.matches(ruleId)) {
                Matcher mRuleId = Pattern.compile(ruleId).matcher(line);
                if (mRuleId == null || !mRuleId.matches()) continue;
                currentRule.setId(mRuleId.group(1));
                continue;
            }
            if (line.matches(ruleCondition)) {
                Matcher mRuleCondition = Pattern.compile(ruleCondition).matcher(line);
                if (mRuleCondition == null || !mRuleCondition.matches()) continue;
                currentRule.setCondition(mRuleCondition.group(1));
                continue;
            }
            if (line.matches(ruleDescriptionBegin)) {
                Matcher mRuleDescription = Pattern.compile(ruleDescriptionBegin).matcher(line);
                if (mRuleDescription == null || !mRuleDescription.matches()) continue;
                ruleDescription = mRuleDescription.group(1);
                continue;
            }
            if (line.matches(ruleDescriptionBody)) {
                Matcher mRuleDescriptionBody = Pattern.compile(ruleDescriptionBody).matcher(line);
                if (mRuleDescriptionBody == null || !mRuleDescriptionBody.matches()) continue;
                ruleDescription = ruleDescription.trim() + " " + mRuleDescriptionBody.group(1);
                continue;
            }
            if (!line.matches(ruleReference)) continue;
            currentRule.setDescription(ruleDescription);
            Matcher mRuleReference = Pattern.compile(ruleReference).matcher(line);
            if (mRuleReference == null || !mRuleReference.matches()) continue;
            currentRule.setReference(mRuleReference.group(1));
            validationRules.put(currentRule.getId(), currentRule);
            currentRule = null;
        }
        br.close();
    }

    String getRule() {
        if (!this.getMessage().startsWith("sbol-")) {
            return "";
        }
        return this.getMessage().split(":")[0];
    }

    static void printAllRules() {
        for (String key : validationRules.keySet()) {
            System.out.println(validationRules.get(key));
        }
    }
}

