/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.Annotation;
import org.sbolstandard.core2.Collection;
import org.sbolstandard.core2.Component;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.Cut;
import org.sbolstandard.core2.DirectionType;
import org.sbolstandard.core2.FASTA;
import org.sbolstandard.core2.FunctionalComponent;
import org.sbolstandard.core2.GenBank;
import org.sbolstandard.core2.GenericLocation;
import org.sbolstandard.core2.GenericTopLevel;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.Interaction;
import org.sbolstandard.core2.Location;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.Model;
import org.sbolstandard.core2.Module;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.OrientationType;
import org.sbolstandard.core2.Participation;
import org.sbolstandard.core2.Range;
import org.sbolstandard.core2.RefinementType;
import org.sbolstandard.core2.RestrictionType;
import org.sbolstandard.core2.RoleIntegrationType;
import org.sbolstandard.core2.SBOLConversionException;
import org.sbolstandard.core2.SBOLDocument;
import org.sbolstandard.core2.Sbol1Terms;
import org.sbolstandard.core2.Sbol2Terms;
import org.sbolstandard.core2.Sequence;
import org.sbolstandard.core2.SequenceAnnotation;
import org.sbolstandard.core2.SequenceConstraint;
import org.sbolstandard.core2.TopLevel;
import uk.ac.intbio.core.io.turtle.TurtleIo;
import uk.ac.ncl.intbio.core.datatree.Datatree;
import uk.ac.ncl.intbio.core.datatree.DocumentRoot;
import uk.ac.ncl.intbio.core.datatree.NamedProperty;
import uk.ac.ncl.intbio.core.datatree.NamespaceBinding;
import uk.ac.ncl.intbio.core.datatree.NestedDocument;
import uk.ac.ncl.intbio.core.datatree.TopLevelDocument;
import uk.ac.ncl.intbio.core.io.CoreIoException;
import uk.ac.ncl.intbio.core.io.json.JsonIo;
import uk.ac.ncl.intbio.core.io.json.StringifyQName;
import uk.ac.ncl.intbio.core.io.rdf.RdfIo;

public class SBOLWriter {
    public static boolean keepGoing = true;
    private static List<String> errors = new ArrayList<String>();

    public static boolean isKeepGoing() {
        return keepGoing;
    }

    public static void setKeepGoing(boolean keepGoing) {
        SBOLWriter.keepGoing = keepGoing;
    }

    public static void clearErrors() {
        errors = new ArrayList<String>();
    }

    public static List<String> getErrors() {
        return errors;
    }

    public static int getNumErrors() {
        return errors.size();
    }

    public static void write(SBOLDocument doc, File file) throws IOException, SBOLConversionException {
        FileOutputStream stream = new FileOutputStream(file);
        BufferedOutputStream buffer = new BufferedOutputStream(stream);
        SBOLWriter.write(doc, buffer);
        stream.close();
        buffer.close();
    }

    public static void write(SBOLDocument doc, File file, String fileType) throws IOException, SBOLConversionException {
        FileOutputStream stream = new FileOutputStream(file);
        BufferedOutputStream buffer = new BufferedOutputStream(stream);
        SBOLWriter.write(doc, buffer, fileType);
        stream.close();
        buffer.close();
    }

    public static void write(SBOLDocument doc, OutputStream out) throws SBOLConversionException {
        try {
            SBOLWriter.writeRDF(new OutputStreamWriter(out), (DocumentRoot<QName>)Datatree.DocumentRoot((Datatree.NamespaceBindings)Datatree.NamespaceBindings(doc.getNamespaceBindings()), (Datatree.TopLevelDocuments)Datatree.TopLevelDocuments(SBOLWriter.getTopLevelDocument(doc))));
        }
        catch (XMLStreamException e) {
            throw new SBOLConversionException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new SBOLConversionException(e);
        }
        catch (CoreIoException e) {
            throw new SBOLConversionException(e);
        }
    }

    public static void write(SBOLDocument doc, String filename) throws IOException, SBOLConversionException {
        SBOLWriter.write(doc, new File(filename));
    }

    public static void write(SBOLDocument doc, String filename, String fileType) throws IOException, SBOLConversionException {
        SBOLWriter.write(doc, new File(filename), fileType);
    }

    public static void write(SBOLDocument doc, OutputStream out, String fileType) throws SBOLConversionException, IOException {
        SBOLWriter.clearErrors();
        if (fileType.equals("FASTA")) {
            FASTA.write(doc, out);
        } else if (fileType.equals("GENBANK")) {
            GenBank.write(doc, out);
        } else {
            if (fileType.equals("JSON")) {
                try {
                    SBOLWriter.writeJSON(new OutputStreamWriter(out), (DocumentRoot<QName>)Datatree.DocumentRoot((Datatree.NamespaceBindings)Datatree.NamespaceBindings(doc.getNamespaceBindings()), (Datatree.TopLevelDocuments)Datatree.TopLevelDocuments(SBOLWriter.getTopLevelDocument(doc))));
                }
                catch (CoreIoException e) {
                    throw new SBOLConversionException(e);
                }
            }
            if (fileType.equals("TURTLE")) {
                try {
                    SBOLWriter.writeTurtle(new OutputStreamWriter(out), (DocumentRoot<QName>)Datatree.DocumentRoot((Datatree.NamespaceBindings)Datatree.NamespaceBindings(doc.getNamespaceBindings()), (Datatree.TopLevelDocuments)Datatree.TopLevelDocuments(SBOLWriter.getTopLevelDocument(doc))));
                }
                catch (CoreIoException e) {
                    throw new SBOLConversionException(e);
                }
            }
            if (fileType.equals("RDFV1")) {
                try {
                    SBOLWriter.writeRDF(new OutputStreamWriter(out), (DocumentRoot<QName>)Datatree.DocumentRoot((Datatree.NamespaceBindings)Datatree.NamespaceBindings(SBOLWriter.getNamespaceBindingsV1()), (Datatree.TopLevelDocuments)Datatree.TopLevelDocuments(SBOLWriter.convertToV1Document(doc))));
                }
                catch (XMLStreamException e) {
                    throw new SBOLConversionException(e);
                }
                catch (FactoryConfigurationError e) {
                    throw new SBOLConversionException(e);
                }
                catch (CoreIoException e) {
                    throw new SBOLConversionException(e);
                }
            }
            try {
                SBOLWriter.writeRDF(new OutputStreamWriter(out), (DocumentRoot<QName>)Datatree.DocumentRoot((Datatree.NamespaceBindings)Datatree.NamespaceBindings(doc.getNamespaceBindings()), (Datatree.TopLevelDocuments)Datatree.TopLevelDocuments(SBOLWriter.getTopLevelDocument(doc))));
            }
            catch (XMLStreamException e) {
                throw new SBOLConversionException(e);
            }
            catch (FactoryConfigurationError e) {
                throw new SBOLConversionException(e);
            }
            catch (CoreIoException e) {
                throw new SBOLConversionException(e);
            }
        }
    }

    private static void writeJSON(Writer stream, DocumentRoot<QName> document) throws CoreIoException {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonGenerator writer = Json.createGeneratorFactory(config).createGenerator(stream);
        JsonIo jsonIo = new JsonIo();
        jsonIo.createIoWriter(writer).write(StringifyQName.qname2string.mapDR(document));
        writer.flush();
        writer.close();
    }

    private static void writeRDF(Writer stream, DocumentRoot<QName> document) throws XMLStreamException, FactoryConfigurationError, CoreIoException {
        IndentingXMLStreamWriter xmlWriter = new IndentingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(stream));
        RdfIo rdfIo = new RdfIo();
        rdfIo.createIoWriter((XMLStreamWriter)xmlWriter).write(document);
        xmlWriter.flush();
        xmlWriter.close();
    }

    private static void writeTurtle(Writer stream, DocumentRoot<QName> document) throws CoreIoException {
        PrintWriter printWriter = new PrintWriter(stream);
        TurtleIo turtleIo = new TurtleIo();
        turtleIo.createIoWriter(printWriter).write(document);
        printWriter.flush();
    }

    private static void formatCollections(Set<Collection> collections, List<TopLevelDocument<QName>> topLevelDoc) {
        for (Collection c : collections) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonTopLevelData(list, c);
            for (URI member : c.getMemberURIs()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Collection.hasMembers, (URI)member));
            }
            topLevelDoc.add((TopLevelDocument<QName>)Datatree.TopLevelDocument((Object)Sbol2Terms.Collection.Collection, (URI)c.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
        }
    }

    private static void formatCommonIdentifiedData(List<NamedProperty<QName>> list, Identified t) {
        if (t.isSetPersistentIdentity()) {
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Identified.persistentIdentity, (URI)t.getPersistentIdentity()));
        }
        if (t.isSetDisplayId()) {
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Identified.displayId, (String)t.getDisplayId()));
        }
        if (t.isSetVersion()) {
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Identified.version, (String)t.getVersion()));
        }
        for (URI wasDerivedFrom : t.getWasDerivedFroms()) {
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Identified.wasDerivedFrom, (URI)wasDerivedFrom));
        }
        if (t.isSetName()) {
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Identified.title, (String)t.getName()));
        }
        if (t.isSetDescription()) {
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Identified.description, (String)t.getDescription()));
        }
        for (Annotation annotation : t.getAnnotations()) {
            if (((QName)annotation.getValue().getName()).getPrefix().equals("sbol")) continue;
            list.add(annotation.getValue());
        }
    }

    private static void formatCommonTopLevelData(List<NamedProperty<QName>> list, TopLevel t) {
        SBOLWriter.formatCommonIdentifiedData(list, t);
    }

    private static void formatComponentDefinitions(Set<ComponentDefinition> componentDefinitions, List<TopLevelDocument<QName>> topLevelDoc) {
        for (ComponentDefinition c : componentDefinitions) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonTopLevelData(list, c);
            for (URI types : c.getTypes()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentDefinition.type, (URI)types));
            }
            for (URI roles : c.getRoles()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentDefinition.roles, (URI)roles));
            }
            SBOLWriter.formatComponents(c.getComponents(), list);
            SBOLWriter.formatSequenceAnnotations(c.getSequenceAnnotations(), list);
            SBOLWriter.formatSequenceConstraints(c.getSequenceConstraints(), list);
            for (URI sUri : c.getSequenceURIs()) {
                SBOLWriter.formatSequence(sUri, list);
            }
            topLevelDoc.add((TopLevelDocument<QName>)Datatree.TopLevelDocument((Object)Sbol2Terms.ComponentDefinition.ComponentDefinition, (URI)c.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
        }
    }

    private static void formatFunctionalComponents(Set<FunctionalComponent> functionalInstantiation, List<NamedProperty<QName>> properties) {
        for (FunctionalComponent f : functionalInstantiation) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonIdentifiedData(list, f);
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentInstance.hasComponentDefinition, (URI)f.getDefinitionURI()));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentInstance.access, (URI)AccessType.convertToURI(f.getAccess())));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.FunctionalComponent.direction, (URI)DirectionType.convertToURI(f.getDirection())));
            List<NestedDocument<QName>> referenceList = SBOLWriter.getMapsTo(f.getMapsTos());
            for (NestedDocument<QName> n : referenceList) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentInstance.hasMapsTo, n));
            }
            properties.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ModuleDefinition.hasfunctionalComponent, (NestedDocument)Datatree.NestedDocument((Object)Sbol2Terms.FunctionalComponent.FunctionalComponent, (URI)f.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list))));
        }
    }

    private static void formatInteractions(Set<Interaction> interactions, List<NamedProperty<QName>> properties) {
        for (Interaction i : interactions) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonIdentifiedData(list, i);
            for (URI type : i.getTypes()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Interaction.type, (URI)type));
            }
            List<NestedDocument<QName>> participantList = SBOLWriter.formatParticipations(i.getParticipations());
            for (NestedDocument<QName> n : participantList) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Interaction.hasParticipations, n));
            }
            properties.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ModuleDefinition.hasInteractions, (NestedDocument)Datatree.NestedDocument((Object)Sbol2Terms.Interaction.Interaction, (URI)i.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list))));
        }
    }

    private static void formatModels(Set<Model> models, List<TopLevelDocument<QName>> topLevelDoc) {
        for (Model m : models) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonTopLevelData(list, m);
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Model.source, (URI)m.getSource()));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Model.language, (URI)m.getLanguage()));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Model.framework, (URI)m.getFramework()));
            topLevelDoc.add((TopLevelDocument<QName>)Datatree.TopLevelDocument((Object)Sbol2Terms.Model.Model, (URI)m.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
        }
    }

    private static void formatModelProperties(Set<URI> models, List<NamedProperty<QName>> list) {
        for (URI m : models) {
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ModuleDefinition.hasModels, (URI)m));
        }
    }

    private static void formatModule(Set<Module> module, List<NamedProperty<QName>> properties) {
        for (Module m : module) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonIdentifiedData(list, m);
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Module.hasDefinition, (URI)m.getDefinitionURI()));
            List<NestedDocument<QName>> referenceList = SBOLWriter.getMapsTo(m.getMapsTos());
            for (NestedDocument<QName> n : referenceList) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Module.hasMapsTo, n));
            }
            properties.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ModuleDefinition.hasModule, (NestedDocument)Datatree.NestedDocument((Object)Sbol2Terms.Module.Module, (URI)m.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list))));
        }
    }

    private static void formatModuleDefinitions(Set<ModuleDefinition> module, List<TopLevelDocument<QName>> topLevelDoc) {
        for (ModuleDefinition m : module) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonTopLevelData(list, m);
            for (URI role : m.getRoles()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ModuleDefinition.roles, (URI)role));
            }
            SBOLWriter.formatFunctionalComponents(m.getFunctionalComponents(), list);
            SBOLWriter.formatInteractions(m.getInteractions(), list);
            SBOLWriter.formatModelProperties(m.getModelURIs(), list);
            SBOLWriter.formatModule(m.getModules(), list);
            topLevelDoc.add((TopLevelDocument<QName>)Datatree.TopLevelDocument((Object)Sbol2Terms.ModuleDefinition.ModuleDefinition, (URI)m.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
        }
    }

    private static List<NestedDocument<QName>> formatParticipations(Set<Participation> participations) {
        ArrayList<NestedDocument<QName>> nestedDoc = new ArrayList<NestedDocument<QName>>();
        for (Participation p : participations) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonIdentifiedData(list, p);
            for (URI r : p.getRoles()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Participation.role, (URI)r));
            }
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Participation.hasParticipant, (URI)p.getParticipantURI()));
            nestedDoc.add((NestedDocument<QName>)Datatree.NestedDocument((Object)Sbol2Terms.Participation.Participation, (URI)p.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
        }
        return nestedDoc;
    }

    private static void formatSequence(URI sequence, List<NamedProperty<QName>> list) {
        list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentDefinition.hasSequence, (URI)sequence));
    }

    private static void formatSequenceAnnotations(Set<SequenceAnnotation> sequenceAnnotations, List<NamedProperty<QName>> properties) {
        for (SequenceAnnotation s : sequenceAnnotations) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonIdentifiedData(list, s);
            for (URI roles : s.getRoles()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.SequenceAnnotation.roles, (URI)roles));
            }
            for (Location location : s.getLocations()) {
                list.add(SBOLWriter.getLocation(location));
            }
            if (s.isSetComponent()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.SequenceAnnotation.hasComponent, (URI)s.getComponentURI()));
            }
            properties.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentDefinition.hasSequenceAnnotations, (NestedDocument)Datatree.NestedDocument((Object)Sbol2Terms.SequenceAnnotation.SequenceAnnotation, (URI)s.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list))));
        }
    }

    private static void formatSequenceConstraints(Set<SequenceConstraint> sequenceConstraint, List<NamedProperty<QName>> properties) {
        for (SequenceConstraint s : sequenceConstraint) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonIdentifiedData(list, s);
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.SequenceConstraint.restriction, (URI)s.getRestrictionURI()));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.SequenceConstraint.hasSubject, (URI)s.getSubjectURI()));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.SequenceConstraint.hasObject, (URI)s.getObjectURI()));
            properties.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentDefinition.hasSequenceConstraints, (NestedDocument)Datatree.NestedDocument((Object)Sbol2Terms.SequenceConstraint.SequenceConstraint, (URI)s.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list))));
        }
    }

    private static void formatSequences(Set<Sequence> sequences, List<TopLevelDocument<QName>> topLevelDoc) {
        for (Sequence s : sequences) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonTopLevelData(list, s);
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Sequence.elements, (String)s.getElements()));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Sequence.encoding, (URI)s.getEncoding()));
            topLevelDoc.add((TopLevelDocument<QName>)Datatree.TopLevelDocument((Object)Sbol2Terms.Sequence.Sequence, (URI)s.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
        }
    }

    private static void formatComponents(Set<Component> components, List<NamedProperty<QName>> properties) {
        for (Component s : components) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonIdentifiedData(list, s);
            for (URI roles : s.getRoles()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Component.roles, (URI)roles));
            }
            if (s.isSetRoleIntegration()) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Component.roleIntegration, (URI)RoleIntegrationType.convertToURI(s.getRoleIntegration())));
            }
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentInstance.access, (URI)AccessType.convertToURI(s.getAccess())));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentInstance.hasComponentDefinition, (URI)s.getDefinitionURI()));
            List<NestedDocument<QName>> referenceList = SBOLWriter.getMapsTo(s.getMapsTos());
            for (NestedDocument<QName> n : referenceList) {
                list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentInstance.hasMapsTo, n));
            }
            properties.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.ComponentDefinition.hasComponent, (NestedDocument)Datatree.NestedDocument((Object)Sbol2Terms.Component.Component, (URI)s.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list))));
        }
    }

    private static void formatGenericTopLevel(Set<GenericTopLevel> topLevels, List<TopLevelDocument<QName>> topLevelDoc) {
        for (GenericTopLevel t : topLevels) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonTopLevelData(list, t);
            topLevelDoc.add((TopLevelDocument<QName>)Datatree.TopLevelDocument((Object)t.getRDFType(), (URI)t.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
        }
    }

    private static NamedProperty<QName> getLocation(Location location) {
        ArrayList<NamedProperty<QName>> property = new ArrayList<NamedProperty<QName>>();
        SBOLWriter.formatCommonIdentifiedData(property, location);
        if (location instanceof Range) {
            Range range = (Range)location;
            property.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Range.start, (int)range.getStart()));
            property.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Range.end, (int)range.getEnd()));
            if (range.isSetOrientation()) {
                property.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Range.orientation, (URI)OrientationType.convertToURI(range.getOrientation())));
            }
            return Datatree.NamedProperty((Object)Sbol2Terms.Location.Location, (NestedDocument)Datatree.NestedDocument((Object)Sbol2Terms.Range.Range, (URI)range.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(property)));
        }
        if (location instanceof Cut) {
            Cut cut = (Cut)location;
            property.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Cut.at, (int)cut.getAt()));
            if (cut.isSetOrientation()) {
                property.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.Cut.orientation, (URI)OrientationType.convertToURI(cut.getOrientation())));
            }
            return Datatree.NamedProperty((Object)Sbol2Terms.Location.Location, (NestedDocument)Datatree.NestedDocument((Object)Sbol2Terms.Cut.Cut, (URI)cut.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(property)));
        }
        GenericLocation genericLocation = (GenericLocation)location;
        if (genericLocation.isSetOrientation()) {
            property.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.GenericLocation.orientation, (URI)OrientationType.convertToURI(genericLocation.getOrientation())));
        }
        return Datatree.NamedProperty((Object)Sbol2Terms.Location.Location, (NestedDocument)Datatree.NestedDocument((Object)Sbol2Terms.GenericLocation.GenericLocation, (URI)genericLocation.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(property)));
    }

    private static List<NestedDocument<QName>> getMapsTo(Set<MapsTo> references) {
        ArrayList<NestedDocument<QName>> nestedDoc = new ArrayList<NestedDocument<QName>>();
        for (MapsTo m : references) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            SBOLWriter.formatCommonIdentifiedData(list, m);
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.MapsTo.refinement, (URI)RefinementType.convertToURI(m.getRefinement())));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.MapsTo.hasRemote, (URI)m.getRemoteURI()));
            list.add((NamedProperty<QName>)Datatree.NamedProperty((Object)Sbol2Terms.MapsTo.hasLocal, (URI)m.getLocalURI()));
            nestedDoc.add((NestedDocument<QName>)Datatree.NestedDocument((Object)Sbol2Terms.MapsTo.MapsTo, (URI)m.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
        }
        return nestedDoc;
    }

    private static NestedDocument<QName> getSequenceV1(Sequence sequence) {
        ArrayList<NamedProperty> list = new ArrayList<NamedProperty>();
        list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNASequence.nucleotides, (String)sequence.getElements()));
        return Datatree.NestedDocument((Object)Sbol1Terms.DNASequence.DNASequence, (URI)sequence.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list));
    }

    private static NestedDocument<QName> getSequenceAnnotationV1(SequenceAnnotation sequenceAnnotation, ComponentDefinition componentDefinition) throws SBOLConversionException {
        ArrayList<NamedProperty> list = new ArrayList<NamedProperty>();
        for (SequenceConstraint sequenceConstraint : componentDefinition.getSequenceConstraints()) {
            if (!sequenceConstraint.getRestriction().equals((Object)RestrictionType.PRECEDES) || !sequenceConstraint.getSubjectURI().equals(sequenceAnnotation.getComponentURI())) continue;
            for (SequenceAnnotation annotation : componentDefinition.getSequenceAnnotations()) {
                if (!sequenceConstraint.getObjectURI().equals(annotation.getComponentURI())) continue;
                list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.precedes, (URI)annotation.getIdentity()));
            }
        }
        if (sequenceAnnotation.getLocations().size() != 1) {
            if (keepGoing) {
                errors.add("SBOL 1.1 only allows a single location.\n:" + sequenceAnnotation.getIdentity());
            } else {
                throw new SBOLConversionException("SBOL 1.1 only allows a single location.\n:" + sequenceAnnotation.getIdentity());
            }
        }
        for (Location location : sequenceAnnotation.getLocations()) {
            if (location instanceof Range) {
                Range range = (Range)location;
                list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.bioStart, (int)range.getStart()));
                list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.bioEnd, (int)range.getEnd()));
                if (!range.isSetOrientation()) continue;
                if (range.getOrientation() == OrientationType.INLINE) {
                    list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.strand, (String)"+"));
                    continue;
                }
                if (range.getOrientation() != OrientationType.REVERSECOMPLEMENT) continue;
                list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.strand, (String)"-"));
                continue;
            }
            if (location instanceof GenericLocation) {
                GenericLocation genericLocation = (GenericLocation)location;
                if (!genericLocation.isSetOrientation()) continue;
                if (genericLocation.getOrientation() == OrientationType.INLINE) {
                    list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.strand, (String)"+"));
                    continue;
                }
                if (genericLocation.getOrientation() != OrientationType.REVERSECOMPLEMENT) continue;
                list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.strand, (String)"-"));
                continue;
            }
            if (keepGoing) {
                errors.add("SBOL 1.1 only supports Ranges and GenericLocations.\n:" + sequenceAnnotation.getIdentity());
                continue;
            }
            throw new SBOLConversionException("SBOL 1.1 only supports Ranges and GenericLocations." + sequenceAnnotation.getIdentity());
        }
        if (sequenceAnnotation.isSetComponent()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.subComponent, SBOLWriter.getSubComponent(sequenceAnnotation.getComponent().getDefinition())));
        }
        return Datatree.NestedDocument((Object)Sbol1Terms.SequenceAnnotations.SequenceAnnotation, (URI)sequenceAnnotation.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list));
    }

    private static NestedDocument<QName> getComponentV1(Component component, ComponentDefinition componentDefinition) throws SBOLConversionException {
        ArrayList<NamedProperty> list = new ArrayList<NamedProperty>();
        for (SequenceConstraint sequenceConstraint : componentDefinition.getSequenceConstraints()) {
            if (!sequenceConstraint.getRestriction().equals((Object)RestrictionType.PRECEDES) || !sequenceConstraint.getSubjectURI().equals(component.getIdentity())) continue;
            SequenceAnnotation annotation = componentDefinition.getSequenceAnnotation(sequenceConstraint.getObject());
            if (annotation != null) {
                list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.precedes, (URI)annotation.getIdentity()));
                continue;
            }
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.precedes, (URI)sequenceConstraint.getObjectURI()));
        }
        list.add(Datatree.NamedProperty((Object)Sbol1Terms.SequenceAnnotations.subComponent, SBOLWriter.getSubComponent(component.getDefinition())));
        return Datatree.NestedDocument((Object)Sbol1Terms.SequenceAnnotations.SequenceAnnotation, (URI)component.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list));
    }

    private static NestedDocument<QName> getSubComponent(ComponentDefinition componentDefinition) throws SBOLConversionException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (componentDefinition == null) {
            throw new SBOLConversionException("ComponentDefinition not found.\n:");
        }
        if (!componentDefinition.getTypes().contains(ComponentDefinition.DNA)) {
            throw new SBOLConversionException("SBOL 1.1 only supports DNA ComponentDefinitions.\n:" + componentDefinition.getIdentity());
        }
        if (componentDefinition.isSetDisplayId()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.displayId, (String)componentDefinition.getDisplayId()));
        }
        if (componentDefinition.isSetName()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.name, (String)componentDefinition.getName()));
        }
        if (componentDefinition.isSetDescription()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.description, (String)componentDefinition.getDescription()));
        }
        for (Annotation annotation : componentDefinition.getAnnotations()) {
            if (((QName)annotation.getValue().getName()).getPrefix().equals("sbol")) continue;
            list.add(annotation.getValue());
        }
        for (URI role : componentDefinition.getRoles()) {
            URI purlRole = URI.create(role.toString().replace("http://identifiers.org/so/SO:", "http://purl.obolibrary.org/obo/SO_"));
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.type, (URI)purlRole));
        }
        Sequence sequence = componentDefinition.getSequenceByEncoding(Sequence.IUPAC_DNA);
        if (sequence == null && componentDefinition.getSequences().size() > 0 || componentDefinition.getSequences().size() > 1) {
            if (keepGoing) {
                errors.add("SBOL 1.1 only supports a single IUPAC_DNA Sequence.\n:" + componentDefinition.getIdentity());
            } else {
                throw new SBOLConversionException("SBOL 1.1 only supports a single IUPAC_DNA Sequence.\n:" + componentDefinition.getIdentity());
            }
        }
        if (sequence != null) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.dnaSequence, SBOLWriter.getSequenceV1(sequence)));
        }
        for (Component component : componentDefinition.getComponents()) {
            SequenceAnnotation sequenceAnnotation = componentDefinition.getSequenceAnnotation(component);
            if (sequenceAnnotation != null) {
                list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.annotations, SBOLWriter.getSequenceAnnotationV1(sequenceAnnotation, componentDefinition)));
                continue;
            }
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.annotations, SBOLWriter.getComponentV1(component, componentDefinition)));
        }
        for (SequenceAnnotation sequenceAnnotation : componentDefinition.getSequenceAnnotations()) {
            if (sequenceAnnotation.isSetComponent()) continue;
            if (keepGoing) {
                errors.add("Dropping SequenceAnnotation without a Component.\n:" + sequenceAnnotation.getIdentity());
                continue;
            }
            throw new SBOLConversionException("Dropping SequenceAnnotation without a Component.\n:" + sequenceAnnotation.getIdentity());
        }
        return Datatree.NestedDocument((Object)Sbol1Terms.DNAComponent.DNAComponent, (URI)componentDefinition.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list));
    }

    private static void formatDNAComponent(ComponentDefinition componentDefinition, List<TopLevelDocument<QName>> topLevelDoc) throws SBOLConversionException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (componentDefinition.isSetDisplayId()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.displayId, (String)componentDefinition.getDisplayId()));
        }
        if (componentDefinition.isSetName()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.name, (String)componentDefinition.getName()));
        }
        if (componentDefinition.isSetDescription()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.description, (String)componentDefinition.getDescription()));
        }
        for (Annotation annotation : componentDefinition.getAnnotations()) {
            if (((QName)annotation.getValue().getName()).getPrefix().equals("sbol")) continue;
            list.add(annotation.getValue());
        }
        for (URI role : componentDefinition.getRoles()) {
            URI purlRole = URI.create(role.toString().replace("http://identifiers.org/so/SO:", "http://purl.obolibrary.org/obo/SO_"));
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.type, (URI)purlRole));
        }
        Sequence sequence = componentDefinition.getSequenceByEncoding(Sequence.IUPAC_DNA);
        if (sequence == null && componentDefinition.getSequences().size() > 0 || componentDefinition.getSequences().size() > 1) {
            if (keepGoing) {
                errors.add("SBOL 1.1 only supports a single IUPAC_DNA Sequence.\n:" + componentDefinition.getIdentity());
            } else {
                throw new SBOLConversionException("SBOL 1.1 only supports a single IUPAC_DNA Sequence.\n:" + componentDefinition.getIdentity());
            }
        }
        if (sequence != null) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.dnaSequence, SBOLWriter.getSequenceV1(sequence)));
        }
        for (Component component : componentDefinition.getComponents()) {
            SequenceAnnotation sequenceAnnotation = componentDefinition.getSequenceAnnotation(component);
            if (sequenceAnnotation != null) {
                list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.annotations, SBOLWriter.getSequenceAnnotationV1(sequenceAnnotation, componentDefinition)));
                continue;
            }
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNAComponent.annotations, SBOLWriter.getComponentV1(component, componentDefinition)));
        }
        for (SequenceAnnotation sequenceAnnotation : componentDefinition.getSequenceAnnotations()) {
            if (sequenceAnnotation.isSetComponent()) continue;
            if (keepGoing) {
                errors.add("Dropping SequenceAnnotation without a Component.\n:" + sequenceAnnotation.getIdentity());
                continue;
            }
            throw new SBOLConversionException("Dropping SequenceAnnotation without a Component.\n:" + sequenceAnnotation.getIdentity());
        }
        topLevelDoc.add((TopLevelDocument<QName>)Datatree.TopLevelDocument((Object)Sbol1Terms.DNAComponent.DNAComponent, (URI)componentDefinition.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
    }

    private static void formatCollectionV1(Collection collection, List<TopLevelDocument<QName>> topLevelDoc) throws SBOLConversionException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (collection.isSetDisplayId()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.Collection.displayId, (String)collection.getDisplayId()));
        }
        if (collection.isSetName()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.Collection.name, (String)collection.getName()));
        }
        if (collection.isSetDescription()) {
            list.add(Datatree.NamedProperty((Object)Sbol1Terms.Collection.description, (String)collection.getDescription()));
        }
        for (Annotation annotation : collection.getAnnotations()) {
            if (((QName)annotation.getValue().getName()).getPrefix().equals("sbol")) continue;
            list.add(annotation.getValue());
        }
        for (TopLevel topLevel : collection.getMembers()) {
            if (topLevel instanceof ComponentDefinition) {
                ComponentDefinition componentDefinition = (ComponentDefinition)topLevel;
                list.add(Datatree.NamedProperty((Object)Sbol1Terms.Collection.component, SBOLWriter.getSubComponent(componentDefinition)));
                continue;
            }
            if (keepGoing) {
                errors.add("SBOL 1.1 only supports Collections of DNA ComponentDefinitions.\n:" + topLevel.getIdentity());
                continue;
            }
            throw new SBOLConversionException("SBOL 1.1 only supports Collections of DNA ComponentDefinitions.\n:" + topLevel.getIdentity());
        }
        topLevelDoc.add((TopLevelDocument<QName>)Datatree.TopLevelDocument((Object)Sbol1Terms.Collection.Collection, (URI)collection.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
    }

    private static void formatDNASequence(Sequence sequence, List<TopLevelDocument<QName>> topLevelDoc) {
        ArrayList<NamedProperty> list = new ArrayList<NamedProperty>();
        list.add(Datatree.NamedProperty((Object)Sbol1Terms.DNASequence.nucleotides, (String)sequence.getElements()));
        topLevelDoc.add((TopLevelDocument<QName>)Datatree.TopLevelDocument((Object)Sbol1Terms.DNASequence.DNASequence, (URI)sequence.getIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
    }

    private static List<NamespaceBinding> getNamespaceBindingsV1() {
        ArrayList<NamespaceBinding> bindings = new ArrayList<NamespaceBinding>();
        bindings.add(Datatree.NamespaceBinding((String)"http://sbols.org/v1#", (String)""));
        bindings.add(Datatree.NamespaceBinding((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (String)"rdf"));
        return bindings;
    }

    private static List<TopLevelDocument<QName>> convertToV1Document(SBOLDocument doc) throws SBOLConversionException {
        boolean skip;
        ArrayList<TopLevelDocument<QName>> topLevelDoc = new ArrayList<TopLevelDocument<QName>>();
        if (doc.getModuleDefinitions().size() > 0) {
            if (keepGoing) {
                errors.add("SBOL 1.1 does not support ModuleDefinitions.");
            } else {
                throw new SBOLConversionException("SBOL 1.1 does not support ModuleDefinitions.\n");
            }
        }
        if (doc.getModels().size() > 0) {
            if (keepGoing) {
                errors.add("SBOL 1.1 does not support Models.");
            } else {
                throw new SBOLConversionException("SBOL 1.1 does not support Models.\n");
            }
        }
        if (doc.getGenericTopLevels().size() > 0) {
            if (keepGoing) {
                errors.add("SBOL 1.1 does not support GenericTopLevels.");
            } else {
                throw new SBOLConversionException("SBOL 1.1 does not support GenericTopLevels.\n");
            }
        }
        for (Collection collection : doc.getCollections()) {
            SBOLWriter.formatCollectionV1(collection, topLevelDoc);
        }
        for (ComponentDefinition componentDefinition : doc.getRootComponentDefinitions()) {
            if (componentDefinition.getTypes().contains(ComponentDefinition.DNA)) {
                skip = false;
                for (Collection collection : doc.getCollections()) {
                    if (!collection.getMemberURIs().contains(componentDefinition.getIdentity())) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                SBOLWriter.formatDNAComponent(componentDefinition, topLevelDoc);
                continue;
            }
            if (keepGoing) {
                errors.add("SBOL 1.1 only supports DNA ComponentDefinitions.\n:" + componentDefinition.getIdentity());
                continue;
            }
            throw new SBOLConversionException("SBOL 1.1 only supports DNA ComponentDefinitions.\n:" + componentDefinition.getIdentity());
        }
        for (Sequence sequence : doc.getSequences()) {
            skip = false;
            for (ComponentDefinition componentDefinition : doc.getComponentDefinitions()) {
                if (!componentDefinition.getSequenceURIs().contains(sequence.getIdentity())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            SBOLWriter.formatDNASequence(sequence, topLevelDoc);
        }
        return topLevelDoc;
    }

    private static List<TopLevelDocument<QName>> getTopLevelDocument(SBOLDocument doc) {
        ArrayList<TopLevelDocument<QName>> topLevelDoc = new ArrayList<TopLevelDocument<QName>>();
        SBOLWriter.formatCollections(doc.getCollections(), topLevelDoc);
        SBOLWriter.formatModuleDefinitions(doc.getModuleDefinitions(), topLevelDoc);
        SBOLWriter.formatModels(doc.getModels(), topLevelDoc);
        SBOLWriter.formatComponentDefinitions(doc.getComponentDefinitions(), topLevelDoc);
        SBOLWriter.formatSequences(doc.getSequences(), topLevelDoc);
        SBOLWriter.formatGenericTopLevel(doc.getGenericTopLevels(), topLevelDoc);
        return topLevelDoc;
    }
}

