/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidate;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.TopLevel;
import org.sbolstandard.core2.URIcompliance;

public class Sequence
extends TopLevel {
    private String elements;
    private URI encoding;
    public static final URI IUPAC_DNA = URI.create("http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html");
    public static final URI IUPAC_RNA = URI.create("http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html");
    public static final URI IUPAC_PROTEIN = URI.create("http://www.chem.qmul.ac.uk/iupac/AminoAcid/");
    public static final URI SMILES = URI.create("http://www.opensmiles.org/opensmiles.html");

    Sequence(URI identity, String elements, URI encoding) throws SBOLValidationException {
        super(identity);
        this.setEncoding(encoding);
        this.setElements(elements);
    }

    private Sequence(Sequence sequence) throws SBOLValidationException {
        super(sequence);
        this.setEncoding(sequence.getEncoding());
        this.setElements(sequence.getElements());
    }

    void copy(Sequence sequence) throws SBOLValidationException {
        this.copy((Identified)sequence);
    }

    public String getElements() {
        return this.elements;
    }

    public void setElements(String elements) throws SBOLValidationException {
        if (elements == null) {
            throw new SBOLValidationException("sbol-10402", this);
        }
        this.elements = elements;
        if (!SBOLValidate.checkSequenceEncoding(this)) {
            throw new SBOLValidationException("sbol-10405", this);
        }
    }

    public URI getEncoding() {
        return this.encoding;
    }

    public void setEncoding(URI encoding) throws SBOLValidationException {
        if (encoding == null) {
            throw new SBOLValidationException("sbol-10403", this);
        }
        this.encoding = encoding;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sequence other = (Sequence)obj;
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        return !(this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding));
    }

    @Override
    Sequence deepCopy() throws SBOLValidationException {
        return new Sequence(this);
    }

    @Override
    Sequence copy(String URIprefix, String displayId, String version) throws SBOLValidationException {
        Sequence cloned = this.deepCopy();
        cloned.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        cloned.setDisplayId(displayId);
        cloned.setVersion(version);
        URI newIdentity = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        if (!this.getIdentity().equals(newIdentity)) {
            cloned.addWasDerivedFrom(this.getIdentity());
        } else {
            cloned.setWasDerivedFroms(this.getWasDerivedFroms());
        }
        cloned.setIdentity(newIdentity);
        return cloned;
    }

    @Override
    void checkDescendantsURIcompliance() {
    }

    public static String reverseComplement(String elements, URI type) {
        String reverse = "";
        for (int i = elements.length() - 1; i >= 0; --i) {
            if (elements.charAt(i) == 'a') {
                if (type.equals(ComponentDefinition.DNA)) {
                    reverse = reverse + 't';
                    continue;
                }
                reverse = reverse + 'u';
                continue;
            }
            if (elements.charAt(i) == 't' || elements.charAt(i) == 'u') {
                reverse = reverse + 'a';
                continue;
            }
            if (elements.charAt(i) == 'g') {
                reverse = reverse + 'c';
                continue;
            }
            if (elements.charAt(i) == 'c') {
                reverse = reverse + 'g';
                continue;
            }
            if (elements.charAt(i) == 'r') {
                reverse = reverse + 'y';
                continue;
            }
            if (elements.charAt(i) == 'y') {
                reverse = reverse + 'r';
                continue;
            }
            if (elements.charAt(i) == 's') {
                reverse = reverse + 'w';
                continue;
            }
            if (elements.charAt(i) == 'w') {
                reverse = reverse + 's';
                continue;
            }
            if (elements.charAt(i) == 'k') {
                reverse = reverse + 'm';
                continue;
            }
            if (elements.charAt(i) == 'm') {
                reverse = reverse + 'k';
                continue;
            }
            if (elements.charAt(i) == 'b') {
                reverse = reverse + 'v';
                continue;
            }
            if (elements.charAt(i) == 'v') {
                reverse = reverse + 'b';
                continue;
            }
            if (elements.charAt(i) == 'd') {
                reverse = reverse + 'h';
                continue;
            }
            if (elements.charAt(i) == 'h') {
                reverse = reverse + 'd';
                continue;
            }
            if (elements.charAt(i) == 'n') {
                reverse = reverse + 'n';
                continue;
            }
            if (elements.charAt(i) == '.') {
                reverse = reverse + '.';
                continue;
            }
            if (elements.charAt(i) != '-') continue;
            reverse = reverse + '-';
        }
        return reverse;
    }

    @Override
    public String toString() {
        return "Sequence [" + super.toString() + ", encoding=" + this.encoding + ", elements=" + this.elements + "]";
    }
}

