/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.Component;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.Cut;
import org.sbolstandard.core2.GenericLocation;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.Location;
import org.sbolstandard.core2.OrientationType;
import org.sbolstandard.core2.Range;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.URIcompliance;

public class SequenceAnnotation
extends Identified
implements Comparable<SequenceAnnotation> {
    private HashMap<URI, Location> locations = new HashMap();
    private URI component;
    private Set<URI> roles;
    private ComponentDefinition componentDefinition = null;

    SequenceAnnotation(URI identity, Set<Location> locations) throws SBOLValidationException {
        super(identity);
        this.setLocations(locations);
        this.roles = new HashSet<URI>();
    }

    private SequenceAnnotation(SequenceAnnotation sequenceAnnotation) throws SBOLValidationException {
        super(sequenceAnnotation);
        for (Location location : sequenceAnnotation.getLocations()) {
            this.addLocation(location.deepCopy());
        }
        if (sequenceAnnotation.isSetComponent()) {
            this.setComponent(sequenceAnnotation.getComponentURI());
        }
        this.roles = new HashSet<URI>();
        for (URI role : sequenceAnnotation.getRoles()) {
            this.addRole(URI.create(role.toString()));
        }
    }

    void copy(SequenceAnnotation sequenceAnnotation) throws SBOLValidationException {
        this.copy((Identified)sequenceAnnotation);
        for (Location location : sequenceAnnotation.getLocations()) {
            String displayId = location.getDisplayId();
            if (displayId == null) {
                displayId = URIcompliance.extractDisplayId(location.getIdentity());
            }
            if (location instanceof Range) {
                Range range = (Range)location;
                Range newRange = range.isSetOrientation() ? this.addRange(displayId, range.getStart(), range.getEnd(), range.getOrientation()) : this.addRange(displayId, range.getStart(), range.getEnd());
                newRange.copy(range);
                continue;
            }
            if (location instanceof Cut) {
                Cut cut = (Cut)location;
                Cut newCut = cut.isSetOrientation() ? this.addCut(displayId, cut.getAt(), cut.getOrientation()) : this.addCut(displayId, cut.getAt());
                newCut.copy(cut);
                continue;
            }
            if (!(location instanceof GenericLocation)) continue;
            GenericLocation genericLocation = (GenericLocation)location;
            GenericLocation newGenericLocation = genericLocation.isSetOrientation() ? this.addGenericLocation(displayId, genericLocation.getOrientation()) : this.addGenericLocation(displayId);
            newGenericLocation.copy(genericLocation);
        }
        Location location = this.getLocation("DUMMY__LOCATION");
        if (location != null) {
            this.removeLocation(location);
        }
        if (sequenceAnnotation.isSetComponent()) {
            this.setComponent(sequenceAnnotation.getComponent().getDisplayId());
        }
        this.roles = new HashSet<URI>();
        for (URI role : sequenceAnnotation.getRoles()) {
            this.addRole(URI.create(role.toString()));
        }
    }

    public GenericLocation addGenericLocation(String displayId) throws SBOLValidationException {
        URI identity = URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion());
        GenericLocation genericLocation = new GenericLocation(identity);
        genericLocation.setPersistentIdentity(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, ""));
        genericLocation.setDisplayId(displayId);
        genericLocation.setVersion(this.getVersion());
        this.addLocation(genericLocation);
        return genericLocation;
    }

    public GenericLocation addGenericLocation(String displayId, OrientationType orientation) throws SBOLValidationException {
        URI identity = URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion());
        GenericLocation genericLocation = new GenericLocation(identity);
        genericLocation.setPersistentIdentity(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, ""));
        genericLocation.setDisplayId(displayId);
        genericLocation.setVersion(this.getVersion());
        genericLocation.setOrientation(orientation);
        this.addLocation(genericLocation);
        return genericLocation;
    }

    public Cut addCut(String displayId, int at) throws SBOLValidationException {
        URI identity = URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion());
        Cut cut = new Cut(identity, at);
        cut.setPersistentIdentity(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, ""));
        cut.setDisplayId(displayId);
        cut.setVersion(this.getVersion());
        this.addLocation(cut);
        return cut;
    }

    public Cut addCut(String displayId, int at, OrientationType orientation) throws SBOLValidationException {
        URI identity = URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion());
        Cut cut = new Cut(identity, at);
        cut.setPersistentIdentity(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, ""));
        cut.setDisplayId(displayId);
        cut.setVersion(this.getVersion());
        cut.setOrientation(orientation);
        this.addLocation(cut);
        return cut;
    }

    public Range addRange(String displayId, int start, int end) throws SBOLValidationException {
        URI identity = URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion());
        Range range = new Range(identity, start, end);
        range.setPersistentIdentity(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, ""));
        range.setDisplayId(displayId);
        range.setVersion(this.getVersion());
        this.addLocation(range);
        return range;
    }

    public Range addRange(String displayId, int start, int end, OrientationType orientation) throws SBOLValidationException {
        URI identity = URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion());
        Range range = new Range(identity, start, end);
        range.setPersistentIdentity(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, ""));
        range.setDisplayId(displayId);
        range.setVersion(this.getVersion());
        range.setOrientation(orientation);
        this.addLocation(range);
        return range;
    }

    void addLocation(Location location) throws SBOLValidationException {
        this.addChildSafely(location, this.locations, "location", new Map[0]);
        location.setSBOLDocument(this.getSBOLDocument());
    }

    public boolean removeLocation(Location location) throws SBOLValidationException {
        if (this.locations.size() == 1 && this.locations.containsValue(location)) {
            throw new SBOLValidationException("sbol-10902", this);
        }
        return this.removeChildSafely(location, this.locations);
    }

    public Location getLocation(String displayId) {
        try {
            return this.locations.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public Location getLocation(URI locationURI) {
        return this.locations.get(locationURI);
    }

    public Set<Location> getLocations() {
        return new HashSet<Location>(this.locations.values());
    }

    public Set<Location> getPreciseLocations() {
        HashSet<Location> preciseLocations = new HashSet<Location>();
        for (Location location : this.locations.values()) {
            if (location instanceof GenericLocation) continue;
            preciseLocations.add(location);
        }
        return preciseLocations;
    }

    public List<Location> getSortedLocations() {
        ArrayList<Location> sortedLocations = new ArrayList<Location>();
        sortedLocations.addAll(this.getLocations());
        Collections.sort(sortedLocations);
        return sortedLocations;
    }

    void clearLocations() throws SBOLValidationException {
        Object[] valueSetArray;
        for (Object location : valueSetArray = this.locations.values().toArray()) {
            this.removeLocation((Location)location);
        }
    }

    private void setLocations(Set<Location> locations) throws SBOLValidationException {
        this.clearLocations();
        if (locations == null || locations.size() == 0) {
            throw new SBOLValidationException("sbol-10902", this);
        }
        for (Location location : locations) {
            this.addLocation(location);
        }
    }

    public boolean isSetComponent() {
        return this.component != null;
    }

    public URI getComponentURI() {
        return this.component;
    }

    public Component getComponent() {
        if (this.componentDefinition == null) {
            return null;
        }
        return this.componentDefinition.getComponent(this.component);
    }

    public void setComponent(String displayId) throws SBOLValidationException {
        URI componentURI = URIcompliance.createCompliantURI(this.componentDefinition.getPersistentIdentity().toString(), displayId, this.componentDefinition.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.componentDefinition != null && this.componentDefinition.getComponent(componentURI) == null) {
            this.componentDefinition.createComponent(displayId, AccessType.PUBLIC, displayId, "");
        }
        this.setComponent(componentURI);
    }

    public void setComponent(URI componentURI) throws SBOLValidationException {
        if (!this.roles.isEmpty()) {
            throw new SBOLValidationException("sbol-10909", this);
        }
        if (this.componentDefinition != null) {
            if (this.componentDefinition.getComponent(componentURI) == null) {
                throw new SBOLValidationException("sbol-10905", this);
            }
            for (SequenceAnnotation sa : this.componentDefinition.getSequenceAnnotations()) {
                if (sa.getIdentity().equals(this.getIdentity()) || !sa.isSetComponent() || !sa.getComponentURI().equals(componentURI)) continue;
                throw new SBOLValidationException("sbol-10522", this);
            }
        }
        this.component = componentURI;
    }

    public void unsetComponent() {
        this.component = null;
    }

    public boolean addRole(URI roleURI) throws SBOLValidationException {
        if (this.isSetComponent()) {
            throw new SBOLValidationException("sbol-10909", this);
        }
        return this.roles.add(roleURI);
    }

    public boolean removeRole(URI roleURI) {
        return this.roles.remove(roleURI);
    }

    public void setRoles(Set<URI> roles) throws SBOLValidationException {
        this.clearRoles();
        if (roles == null) {
            return;
        }
        for (URI role : roles) {
            this.addRole(role);
        }
    }

    public Set<URI> getRoles() {
        HashSet<URI> result = new HashSet<URI>();
        result.addAll(this.roles);
        return result;
    }

    public boolean containsRole(URI roleURI) {
        return this.roles.contains(roleURI);
    }

    public void clearRoles() {
        this.roles.clear();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (this.locations == null ? 0 : this.locations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceAnnotation other = (SequenceAnnotation)obj;
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        return !(this.locations == null ? other.locations != null : !this.locations.equals(other.locations));
    }

    @Override
    SequenceAnnotation deepCopy() throws SBOLValidationException {
        return new SequenceAnnotation(this);
    }

    void updateCompliantURI(String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!this.getIdentity().equals(URIcompliance.createCompliantURI(URIprefix, displayId, version))) {
            this.addWasDerivedFrom(this.getIdentity());
        }
        this.setIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, version));
        this.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        this.setDisplayId(displayId);
        this.setVersion(version);
        if (this.component != null) {
            String componentId = URIcompliance.extractDisplayId(this.component);
            this.setComponent(URIcompliance.createCompliantURI(URIprefix, componentId, version));
        }
        int count = 0;
        for (Location location : this.getLocations()) {
            if (!location.isSetDisplayId()) {
                location.setDisplayId("location" + ++count);
            }
            location.updateCompliantURI(this.getPersistentIdentity().toString(), location.getDisplayId(), version);
            this.removeChildSafely(location, this.locations);
            this.addLocation(location);
        }
    }

    public ComponentDefinition getComponentDefinition() {
        if (this.componentDefinition != null && this.isSetComponent()) {
            return this.componentDefinition.getComponent(this.component).getDefinition();
        }
        return null;
    }

    void setComponentDefinition(ComponentDefinition componentDefinition) {
        this.componentDefinition = componentDefinition;
    }

    @Override
    public String toString() {
        return "SequenceAnnotation [" + super.toString() + (this.roles.size() > 0 ? ", roles=" + this.roles : "") + ", locations=" + this.getLocations() + (this.isSetComponent() ? ", component=" + this.component : "") + "]";
    }

    @Override
    public int compareTo(SequenceAnnotation sa) {
        List<Location> sortedLocations1 = this.getSortedLocations();
        List<Location> sortedLocations2 = sa.getSortedLocations();
        if (sortedLocations1.size() > 0 && sortedLocations2.size() > 0) {
            return sortedLocations1.get(0).compareTo(sortedLocations2.get(0));
        }
        return 0;
    }
}

