/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.Component;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.RestrictionType;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.URIcompliance;

public class SequenceConstraint
extends Identified {
    private URI restriction;
    private URI subject;
    private URI object;
    private ComponentDefinition componentDefinition = null;

    SequenceConstraint(URI identity, URI restriction, URI subject, URI object) throws SBOLValidationException {
        super(identity);
        this.setRestriction(restriction);
        this.setSubject(subject);
        this.setObject(object);
    }

    SequenceConstraint(URI identity, RestrictionType restriction, URI subject, URI object) throws SBOLValidationException {
        super(identity);
        this.setRestriction(restriction);
        this.setSubject(subject);
        this.setObject(object);
    }

    private SequenceConstraint(SequenceConstraint sequenceConstraint) throws SBOLValidationException {
        super(sequenceConstraint);
        this.setRestriction(sequenceConstraint.getRestrictionURI());
        this.setSubject(sequenceConstraint.getSubjectURI());
        this.setObject(sequenceConstraint.getObjectURI());
    }

    void copy(SequenceConstraint sequenceConstraint) throws SBOLValidationException {
        this.copy((Identified)sequenceConstraint);
    }

    public RestrictionType getRestriction() {
        try {
            return RestrictionType.convertToRestrictionType(this.restriction);
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public URI getRestrictionURI() {
        return this.restriction;
    }

    public void setRestriction(RestrictionType restriction) throws SBOLValidationException {
        if (restriction == null) {
            throw new SBOLValidationException("sbol-11407", this);
        }
        try {
            this.restriction = RestrictionType.convertToURI(restriction);
        }
        catch (SBOLValidationException e) {
            throw new SBOLValidationException("sbol-11412", this);
        }
    }

    public void setRestriction(URI restrictionURI) throws SBOLValidationException {
        if (restrictionURI == null) {
            throw new SBOLValidationException("sbol-11407", this);
        }
        this.restriction = restrictionURI;
    }

    public URI getSubjectURI() {
        return this.subject;
    }

    public Component getSubject() {
        if (this.componentDefinition == null) {
            return null;
        }
        return this.componentDefinition.getComponent(this.subject);
    }

    public ComponentDefinition getSubjectDefinition() {
        if (this.componentDefinition != null) {
            return this.componentDefinition.getComponent(this.subject).getDefinition();
        }
        return null;
    }

    public void setSubject(URI subjectURI) throws SBOLValidationException {
        if (this.componentDefinition != null && this.componentDefinition.getComponent(subjectURI) == null) {
            throw new SBOLValidationException("sbol-11403", this);
        }
        if (subjectURI == null) {
            throw new SBOLValidationException("sbol-11402", this);
        }
        if (subjectURI.equals(this.object)) {
            throw new SBOLValidationException("sbol-11406", this);
        }
        this.subject = subjectURI;
    }

    public URI getObjectURI() {
        return this.object;
    }

    public Component getObject() {
        if (this.componentDefinition == null) {
            return null;
        }
        return this.componentDefinition.getComponent(this.object);
    }

    public ComponentDefinition getObjectDefinition() {
        if (this.componentDefinition != null) {
            return this.componentDefinition.getComponent(this.object).getDefinition();
        }
        return null;
    }

    public void setObject(URI objectURI) throws SBOLValidationException {
        if (this.componentDefinition != null && this.componentDefinition.getComponent(objectURI) == null) {
            throw new SBOLValidationException("sbol-11405", this);
        }
        if (objectURI == null) {
            throw new SBOLValidationException("sbol-11404", this);
        }
        if (objectURI == this.subject) {
            throw new SBOLValidationException("sbol-11402", this);
        }
        this.object = objectURI;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        result = 31 * result + (this.restriction == null ? 0 : this.restriction.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceConstraint other = (SequenceConstraint)obj;
        if (this.object == null ? other.object != null : !this.object.equals(other.object)) {
            return false;
        }
        if (!this.restriction.equals(other.restriction)) {
            return false;
        }
        return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
    }

    @Override
    SequenceConstraint deepCopy() throws SBOLValidationException {
        return new SequenceConstraint(this);
    }

    void updateCompliantURI(String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!this.getIdentity().equals(URIcompliance.createCompliantURI(URIprefix, displayId, version))) {
            this.addWasDerivedFrom(this.getIdentity());
        }
        this.setIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, version));
        this.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        this.setDisplayId(displayId);
        this.setVersion(version);
        String subjectId = URIcompliance.extractDisplayId(this.subject);
        this.setSubject(URIcompliance.createCompliantURI(URIprefix, subjectId, version));
        String objectId = URIcompliance.extractDisplayId(this.object);
        this.setObject(URIcompliance.createCompliantURI(URIprefix, objectId, version));
    }

    void setComponentDefinition(ComponentDefinition componentDefinition) {
        this.componentDefinition = componentDefinition;
    }

    @Override
    public String toString() {
        return "SequenceConstraint [" + super.toString() + ", restriction=" + this.getRestriction().toString() + ", subject=" + this.subject + ", object=" + this.object + "]";
    }
}

