/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.oboparser.obo.OBOOntology;
import org.oboparser.obo.OBOParser;
import org.oboparser.obo.OBOStanza;

public class SequenceOntology {
    private static final String URI_PREFIX = "http://identifiers.org/so/";
    public static final URI NAMESPACE = URI.create("http://identifiers.org/so/");
    private static OBOOntology sequenceOntology = null;
    public static final URI PROMOTER = SequenceOntology.type("SO:0000167");
    public static final URI OPERATOR = SequenceOntology.type("SO:0000057");
    public static final URI CDS = SequenceOntology.type("SO:0000316");
    public static final URI FIVE_PRIME_UTR = SequenceOntology.type("SO:0000204");
    public static final URI TERMINATOR = SequenceOntology.type("SO:0000141");
    public static final URI INSULATOR = SequenceOntology.type("SO:0000627");
    public static final URI ORIGIN_OF_REPLICATION = SequenceOntology.type("SO:0000296");
    public static final URI PRIMER_BINDING_SITE = SequenceOntology.type("SO:0005850");
    public static final URI RIBOSOME_ENTRY_SITE = SequenceOntology.type("SO:0000139");
    public static final URI GENE = SequenceOntology.type("SO:0000704");
    public static final URI MRNA = SequenceOntology.type("SO:0000234");
    public static final URI RESTRICTION_ENZYME_RECOGNITION_SITE = SequenceOntology.type("SO:0001687");
    public static final URI ENGINEERED_GENE = SequenceOntology.type("SO:0000280");
    public static final URI ENGINEERED_REGION = SequenceOntology.type("SO:0000804");
    public static final URI SEQUENCE_FEATURE = SequenceOntology.type("SO:0000110");
    public static final URI SGRNA = SequenceOntology.type("SO:0001998");
    public static final URI STRAND_ATTRIBUTE = SequenceOntology.type("SO:0000983");
    public static final URI SINGLE = SequenceOntology.type("SO:0000984");
    public static final URI DOUBLE = SequenceOntology.type("SO:0000985");
    public static final URI TOPOLOGY_ATTRIBUTE = SequenceOntology.type("SO:0000986");
    public static final URI LINEAR = SequenceOntology.type("SO:0000987");
    public static final URI CIRCULAR = SequenceOntology.type("SO:0000988");
    public static final URI DNA = SequenceOntology.type("SO:0000352");
    public static final URI RNA = SequenceOntology.type("SO:0000356");

    public SequenceOntology() {
        if (sequenceOntology == null) {
            OBOParser oboParser = new OBOParser();
            InputStreamReader f = new InputStreamReader(this.getClass().getResourceAsStream("/ontologies/SequenceOntology/so-xp.obo"));
            try {
                oboParser.parse(f);
                sequenceOntology = oboParser.getOntology();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static URI convertSeqOntologyV1(String term) {
        String v1SO = "http://purl.obolibrary.org/obo/SO_";
        String v2SO = "http://identifiers.org/so/SO:";
        String convertedSO = term;
        if (term.startsWith(v1SO)) {
            convertedSO = convertedSO.replace(v1SO, v2SO);
            return URI.create(convertedSO);
        }
        if (term.startsWith("SO:")) {
            convertedSO = convertedSO.replace("SO:", v2SO);
        } else if (term.startsWith("so:")) {
            convertedSO = convertedSO.replace("so:", v2SO);
        }
        return URI.create(convertedSO);
    }

    public final String getId(URI termURI) {
        String termURIstr = termURI.toString().trim();
        if (!termURIstr.startsWith(URI_PREFIX)) {
            try {
                throw new IllegalArgumentException("Illegal " + termURI.toString() + ". It does not begin with the URI prefix " + URI_PREFIX);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        int beginIndex = termURIstr.lastIndexOf("/") + 1;
        return termURIstr.substring(beginIndex, termURIstr.length());
    }

    public final String getId(String stanzaName) {
        ArrayList<String> IdList = new ArrayList<String>();
        for (OBOStanza stanza : sequenceOntology.getStanzas()) {
            if (!stanzaName.trim().equals(stanza.getName().trim())) continue;
            IdList.add(stanza.getId());
        }
        if (IdList.isEmpty()) {
            try {
                throw new IllegalArgumentException("Illegal name " + stanzaName + ". It does not exist.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return (String)IdList.get(0);
    }

    public final String getName(URI termURI) {
        String oboURIstr = termURI.toString().trim();
        if (!oboURIstr.startsWith(URI_PREFIX)) {
            try {
                throw new IllegalArgumentException("Illegal " + termURI.toString() + ". It does not contain URI prefix " + URI_PREFIX);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        int beginIndex = oboURIstr.lastIndexOf("/") + 1;
        String id = oboURIstr.substring(beginIndex, oboURIstr.length());
        OBOStanza oboStanza = sequenceOntology.getStanza(id);
        if (oboStanza == null) {
            try {
                throw new IllegalArgumentException("ID " + id + " does not exist.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return oboStanza.getName();
    }

    public final String getName(String stanzaId) {
        OBOStanza oboStanza = sequenceOntology.getStanza(stanzaId);
        if (oboStanza == null) {
            try {
                throw new IllegalArgumentException("Illegal ID " + stanzaId + " does not exist.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return oboStanza.getName();
    }

    public final URI getURIbyName(String stanzaName) {
        return this.getURIbyId(this.getId(stanzaName));
    }

    public final URI getURIbyId(String stanzaId) {
        if (stanzaId == null) {
            return null;
        }
        OBOStanza oboStanza = sequenceOntology.getStanza(stanzaId.trim());
        if (oboStanza == null) {
            try {
                throw new IllegalArgumentException("ID " + stanzaId + " does not exist.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return URI.create(URI_PREFIX + stanzaId);
    }

    public boolean isDescendantOf(String Id1, String Id2) {
        OBOStanza stanza1 = sequenceOntology.getStanza(Id1);
        OBOStanza stanza2 = sequenceOntology.getStanza(Id2);
        if (stanza1 == null) {
            try {
                throw new IllegalArgumentException("Illegal ID: " + Id1 + ". No match was found.");
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if (stanza2 == null) {
            try {
                throw new IllegalArgumentException("Illegal ID: " + Id2 + ". No match was found.");
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return sequenceOntology.isDescendantOf(stanza1, stanza2);
    }

    public final boolean isDescendantOf(URI childURI, URI parentURI) {
        String childId = this.getId(childURI);
        String parentId = this.getId(parentURI);
        if (childId == null || parentId == null) {
            return false;
        }
        return this.isDescendantOf(childId, parentId);
    }

    public Set<String> getDescendantsOf(String parentId) {
        OBOStanza stanza1 = sequenceOntology.getStanza(parentId);
        if (stanza1 == null) {
            try {
                throw new IllegalArgumentException("Illegal ID: " + parentId + ". No match was found.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return sequenceOntology.getDescendantsOf(stanza1);
    }

    public final Set<String> getDescendantsOf(URI parentURI) {
        String parentId = this.getId(parentURI);
        if (parentId == null) {
            return new HashSet<String>();
        }
        return this.getDescendantsOf(parentId);
    }

    public final Set<URI> getDescendantURIsOf(String parentId) {
        Set<String> descendents = this.getDescendantsOf(parentId);
        HashSet<URI> descendentURIs = new HashSet<URI>();
        for (String child : descendents) {
            descendentURIs.add(this.getURIbyId(child));
        }
        return descendentURIs;
    }

    public final Set<URI> getDescendantURIsOf(URI parentURI) {
        Set<String> descendents = this.getDescendantsOf(parentURI);
        HashSet<URI> descendentURIs = new HashSet<URI>();
        for (String child : descendents) {
            descendentURIs.add(this.getURIbyId(child));
        }
        return descendentURIs;
    }

    public final Set<String> getDescendantNamesOf(String parentId) {
        Set<String> descendents = this.getDescendantsOf(parentId);
        HashSet<String> descendentNames = new HashSet<String>();
        for (String child : descendents) {
            descendentNames.add(this.getName(child));
        }
        return descendentNames;
    }

    public final Set<String> getDescendantNamesOf(URI parentURI) {
        Set<String> descendents = this.getDescendantsOf(parentURI);
        HashSet<String> descendentNames = new HashSet<String>();
        for (String child : descendents) {
            descendentNames.add(this.getName(child));
        }
        return descendentNames;
    }

    private static final URI type(String id) {
        return URI.create(URI_PREFIX + id);
    }
}

