/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;

final class URIcompliance {
    private static final String delimiter = "[/|#|:]";
    private static final String URIprefixPattern = "\\b(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    private static final String displayIDpattern = "[a-zA-Z_]+[a-zA-Z0-9_]*";
    private static final String versionPattern = "[0-9]+[a-zA-Z0-9_\\.-]*";
    private static final String genericURIpattern1 = "((\\b(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])([/|#|:]([a-zA-Z_]+[a-zA-Z0-9_]*)){1,3})(/([0-9]+[a-zA-Z0-9_\\.-]*))?";
    private static final String genericURIpattern1b = "((\\b(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|][/|#|:])([a-zA-Z_]+[a-zA-Z0-9_]*){1,3})(/([0-9]+[a-zA-Z0-9_\\.-]*))?";
    private static final String namespacePattern = "((\\b(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|][/|#|:])([a-zA-Z_]+[a-zA-Z0-9_]*){1,3})(/([0-9]+[a-zA-Z0-9_\\.-]*))?";
    private static final String URI_REFERENCE_REGEX = "(([a-zA-Z][a-zA-Z0-9\\+\\-\\.]*:((((//((((([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\);:\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)\\@)?((((([a-zA-Z0-9](([a-zA-Z0-9\\-])*[a-zA-Z0-9])?)\\.)*([a-zA-Z](([a-zA-Z0-9\\-])*[a-zA-Z0-9])?)(\\.)?)|([0-9]+((\\.[0-9]+){3})))(:[0-9]*)?))?|([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\)$,;:\\@\\&=\\+]|(%[a-fA-F0-9]{2}))+)(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*)(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*))*)?)|(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*)(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*))*))(\\?([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\);/\\?:\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)?)|(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\);\\?:\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\);/\\?:\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)))|(((//((((([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\);:\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)\\@)?((((([a-zA-Z0-9](([a-zA-Z0-9\\-])*[a-zA-Z0-9])?)\\.)*([a-zA-Z](([a-zA-Z0-9\\-])*[a-zA-Z0-9])?)(\\.)?)|([0-9]+((\\.[0-9]+){3})))(:[0-9]*)?))?|([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\)$,;:\\@\\&=\\+]|(%[a-fA-F0-9]{2}))+)(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*)(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*))*)?)|(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*)(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*))*)|(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\);\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))+(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*)(/(([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*(;([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\):\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)*))*)?))(\\?([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\);/\\?:\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)?))?(\\#([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\);/\\?:\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*)?";

    URIcompliance() {
    }

    private static void validateIdVersion(String displayId, String version) throws SBOLValidationException {
        if (displayId != null && !URIcompliance.isDisplayIdValid(displayId)) {
            throw new SBOLValidationException("sbol-10204", new Identified[0]);
        }
        if (version != null && !URIcompliance.isVersionValid(version)) {
            throw new SBOLValidationException("sbol-10206", new Identified[0]);
        }
    }

    static URI createCompliantURI(String prefix, String displayId, String version) throws SBOLValidationException {
        if (prefix == null) {
            throw new IllegalArgumentException("The defaultURIprefix is not set. Please set it to a non-null value");
        }
        URIcompliance.validateIdVersion(displayId, version);
        if (!(prefix.endsWith("/") || prefix.endsWith(":") || prefix.endsWith("#"))) {
            prefix = prefix + "/";
        }
        if (version == null || version.equals("")) {
            return URI.create(prefix + displayId);
        }
        return URI.create(prefix + displayId + '/' + version);
    }

    static URI createCompliantURI(String prefix, String type, String displayId, String version, boolean useType) throws SBOLValidationException {
        if (prefix == null) {
            throw new IllegalArgumentException("The defaultURIprefix is not set. Please set it to a non-null value");
        }
        URIcompliance.validateIdVersion(displayId, version);
        if (!useType) {
            return URIcompliance.createCompliantURI(prefix, displayId, version);
        }
        if (!(prefix.endsWith("/") || prefix.endsWith(":") || prefix.endsWith("#"))) {
            prefix = prefix + "/";
        }
        if (version == null || version.equals("")) {
            return URI.create(prefix + type + '/' + displayId);
        }
        return URI.create(prefix + type + '/' + displayId + '/' + version);
    }

    static String extractPersistentId(URI objURI) {
        String URIstr = objURI.toString();
        Pattern r = Pattern.compile(genericURIpattern1);
        Matcher m = r.matcher(URIstr);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    static String extractURIprefix(URI objURI) {
        String URIstr = objURI.toString();
        Pattern r = Pattern.compile("((\\b(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|][/|#|:])([a-zA-Z_]+[a-zA-Z0-9_]*){1,3})(/([0-9]+[a-zA-Z0-9_\\.-]*))?");
        Matcher m = r.matcher(URIstr);
        if (m.matches()) {
            return m.group(2);
        }
        return null;
    }

    static String extractNamespace(URI objURI) {
        String URIstr = objURI.toString();
        Pattern r = Pattern.compile("((\\b(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|][/|#|:])([a-zA-Z_]+[a-zA-Z0-9_]*){1,3})(/([0-9]+[a-zA-Z0-9_\\.-]*))?");
        Matcher m = r.matcher(URIstr);
        if (m.matches()) {
            return m.group(2);
        }
        return null;
    }

    static String extractDisplayId(URI objURI) {
        String URIstr = objURI.toString();
        Pattern r = Pattern.compile(genericURIpattern1);
        Matcher m = r.matcher(URIstr);
        if (m.matches()) {
            return m.group(4);
        }
        return null;
    }

    static String extractVersion(URI objURI) {
        String URIstr = objURI.toString();
        Pattern r = Pattern.compile(genericURIpattern1);
        Matcher m = r.matcher(URIstr);
        if (m.matches() && m.groupCount() >= 6) {
            return m.group(6);
        }
        return null;
    }

    static final void isURIcompliant(Identified identified) throws SBOLValidationException {
        if (!identified.isSetDisplayId()) {
            throw new SBOLValidationException("sbol-10215", new Identified[0]);
        }
        if (!identified.isSetPersistentIdentity()) {
            throw new SBOLValidationException("sbol-10216", new Identified[0]);
        }
        if (!(identified.getPersistentIdentity().toString().endsWith("/" + identified.getDisplayId()) || identified.getPersistentIdentity().toString().endsWith("#" + identified.getDisplayId()) || identified.getPersistentIdentity().toString().endsWith(":" + identified.getDisplayId()))) {
            throw new SBOLValidationException("sbol-10216", new Identified[0]);
        }
        if (!identified.isSetVersion() ? !identified.getIdentity().toString().equals(identified.getPersistentIdentity().toString()) : !identified.getIdentity().toString().equals(identified.getPersistentIdentity().toString() + "/" + identified.getVersion())) {
            throw new SBOLValidationException("sbol-10218", new Identified[0]);
        }
    }

    static final boolean isChildURIformCompliant(URI parentURI, URI childURI) {
        String parentPersistentId = URIcompliance.extractPersistentId(parentURI);
        if (parentPersistentId == null) {
            return false;
        }
        String childDisplayId = URIcompliance.extractDisplayId(childURI);
        if (childDisplayId == null) {
            return false;
        }
        String parentVersion = URIcompliance.extractVersion(parentURI);
        if (parentVersion == null) {
            return childURI.toString().equals(parentPersistentId + "/" + childDisplayId);
        }
        return childURI.toString().equals(parentPersistentId + "/" + childDisplayId + "/" + parentVersion);
    }

    static final void isChildURIcompliant(Identified parent, Identified child) throws SBOLValidationException {
        try {
            URIcompliance.isURIcompliant(child);
        }
        catch (SBOLValidationException e) {
            if (e.getMessage().contains("sbol-10216")) {
                throw new SBOLValidationException("sbol-10217", new Identified[0]);
            }
            throw new SBOLValidationException(e.getMessage(), new Identified[0]);
        }
        if (!(child.getPersistentIdentity().toString().equals(parent.getPersistentIdentity() + "/" + child.getDisplayId()) || child.getPersistentIdentity().toString().equals(parent.getPersistentIdentity() + "#" + child.getDisplayId()) || child.getPersistentIdentity().toString().equals(parent.getPersistentIdentity() + ":" + child.getDisplayId()))) {
            throw new SBOLValidationException("sbol-10217", new Identified[0]);
        }
        if (parent.isSetVersion() ? !child.isSetVersion() || !child.getVersion().equals(parent.getVersion()) : child.isSetVersion()) {
            throw new SBOLValidationException("sbol-10219", new Identified[0]);
        }
    }

    static boolean isDisplayIdValid(String newDisplayId) {
        if (newDisplayId == null) {
            return false;
        }
        Pattern r = Pattern.compile(displayIDpattern);
        Matcher m = r.matcher(newDisplayId);
        return m.matches();
    }

    static boolean isVersionValid(String version) {
        if (version.equals("")) {
            return true;
        }
        Pattern r = Pattern.compile(versionPattern);
        Matcher m = r.matcher(version);
        return m.matches();
    }

    static boolean isURIprefixCompliant(String URIprefix) {
        Pattern r = Pattern.compile("\\b(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|][/|#|:]");
        Matcher m = r.matcher(URIprefix);
        return m.matches();
    }

    static boolean isValidURI(String URIstr) {
        Pattern r = Pattern.compile(URI_REFERENCE_REGEX);
        Matcher m = r.matcher(URIstr);
        return m.matches();
    }

    @SafeVarargs
    static boolean keyExistsInAnyMap(URI key, Map<URI, ?> ... maps) {
        for (Map<URI, ?> map : maps) {
            if (!map.keySet().contains(key)) continue;
            return true;
        }
        return false;
    }

    static String checkURIprefix(String URIprefix) throws SBOLValidationException {
        if (URIprefix == null) {
            throw new SBOLValidationException("sbol-10201", new Identified[0]);
        }
        if (!(URIprefix.endsWith("/") || URIprefix.endsWith(":") || URIprefix.endsWith("#"))) {
            URIprefix = URIprefix + "/";
        }
        if (!URIcompliance.isURIprefixCompliant(URIprefix)) {
            throw new SBOLValidationException("sbol-10201", new Identified[0]);
        }
        return URIprefix;
    }

    static String fixDisplayId(String displayId) {
        displayId = displayId.replaceAll("[^a-zA-Z0-9_]", "_");
        if (Character.isDigit((displayId = displayId.replace(" ", "_")).charAt(0))) {
            displayId = "_" + displayId;
        }
        return displayId;
    }
}

