/*
 * Decompiled with CFR 0.152.
 */
package org.synbiohub.frontend;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.sbolstandard.core2.SBOLDocument;
import org.sbolstandard.core2.SBOLReader;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.SBOLWriter;
import org.sbolstandard.core2.TopLevel;
import org.synbiohub.frontend.IdentifiedMetadata;
import org.synbiohub.frontend.NotFoundException;
import org.synbiohub.frontend.PermissionException;
import org.synbiohub.frontend.SearchCriteria;
import org.synbiohub.frontend.SearchQuery;
import org.synbiohub.frontend.SynBioHubException;

public class SynBioHubFrontend {
    PoolingHttpClientConnectionManager connectionManager;
    HttpClient client;
    String backendUrl;
    String uriPrefix;
    String user = null;

    public SynBioHubFrontend(String backendUrl, String uriPrefix) {
        this.backendUrl = backendUrl;
        this.uriPrefix = uriPrefix;
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public SynBioHubFrontend(String backendUrl) {
        this.backendUrl = backendUrl;
        this.uriPrefix = backendUrl;
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public String getBackendUrl() {
        return this.backendUrl;
    }

    public int getCount(String objectType) throws SynBioHubException {
        return this.fetchCount(this.backendUrl + "/" + objectType + "/count");
    }

    public SBOLDocument getSBOL(URI topLevelUri) throws SynBioHubException {
        if (!topLevelUri.toString().startsWith(this.uriPrefix)) {
            throw new SynBioHubException("Object URI does not start with correct URI prefix for this repository.");
        }
        String url = topLevelUri + "/sbol";
        url = url.replace(this.uriPrefix, this.backendUrl);
        SBOLDocument document = this.fetchFromSynBioHub(url);
        return document;
    }

    public void removeSBOL(URI topLevelUri) throws SynBioHubException {
        if (!topLevelUri.toString().startsWith(this.uriPrefix)) {
            throw new SynBioHubException("Object URI does not start with correct URI prefix for this repository.");
        }
        String url = topLevelUri + "/remove";
        url = url.replace(this.uriPrefix, this.backendUrl);
        this.fetchFromSynBioHub(url);
    }

    public ArrayList<IdentifiedMetadata> getMatchingComponentDefinitionMetadata(String name, Set<URI> roles, Set<URI> types, Set<URI> collections, Integer offset, Integer limit) throws SynBioHubException {
        SearchQuery query = new SearchQuery();
        query.setOffset(offset);
        query.setLimit(limit);
        SearchCriteria objectCriteria = new SearchCriteria();
        objectCriteria.setKey("objectType");
        objectCriteria.setValue("ComponentDefinition");
        query.addCriteria(objectCriteria);
        if (roles != null) {
            for (URI uri : roles) {
                SearchCriteria roleCriteria = new SearchCriteria();
                roleCriteria.setKey("role");
                roleCriteria.setValue(uri.toString());
                query.getCriteria().add(roleCriteria);
            }
        }
        if (types != null) {
            for (URI uri : types) {
                SearchCriteria typeCriteria = new SearchCriteria();
                typeCriteria.setKey("type");
                typeCriteria.setValue(uri.toString());
                query.getCriteria().add(typeCriteria);
            }
        }
        if (collections != null) {
            for (URI uri : collections) {
                SearchCriteria collectionCriteria = new SearchCriteria();
                collectionCriteria.setKey("collection");
                collectionCriteria.setValue(uri.toString());
                query.getCriteria().add(collectionCriteria);
            }
        }
        if (name != null) {
            SearchCriteria nameCriteria = new SearchCriteria();
            nameCriteria.setKey("name");
            nameCriteria.setValue(name);
            query.getCriteria().add(nameCriteria);
        }
        return this.search(query);
    }

    public ArrayList<IdentifiedMetadata> search(SearchQuery query) throws SynBioHubException {
        String url = this.backendUrl + "/remoteSearch/";
        String textQuery = "";
        boolean first = true;
        for (SearchCriteria criteria : query.getCriteria()) {
            if (criteria.getKey().equals("objectType")) {
                url = url + this.encodeUri(criteria.getKey() + "=" + criteria.getValue() + "&");
                continue;
            }
            if (criteria.getKey().equals("name")) {
                if (first) {
                    first = false;
                } else {
                    textQuery = " ";
                }
                textQuery = criteria.getValue();
                continue;
            }
            url = criteria.getKey().startsWith("http") ? url + this.encodeUri("<" + criteria.getKey() + ">=") : url + this.encodeUri(criteria.getKey() + "=");
            if (criteria.getValue().startsWith("http")) {
                url = url + this.encodeUri("<" + criteria.getValue() + ">&");
                continue;
            }
            url = url + this.encodeUri("'" + criteria.getValue() + "'&");
        }
        url = url + this.encodeUri(textQuery);
        if (query.getOffset() != null && query.getLimit() != null) {
            url = url + "/?offset=" + query.getOffset() + "&limit=" + query.getLimit();
        } else if (query.getOffset() != null) {
            url = url + "/?offset=" + query.getOffset();
        } else if (query.getLimit() != null) {
            url = url + "/?limit=" + query.getLimit();
        }
        Gson gson = new Gson();
        HttpGet request = new HttpGet(url);
        try {
            ArrayList metadataList;
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            this.checkResponseCode(response);
            InputStream inputStream = response.getEntity().getContent();
            ArrayList arrayList = metadataList = (ArrayList)gson.fromJson((Reader)new InputStreamReader(inputStream), new TypeToken<ArrayList<IdentifiedMetadata>>(){}.getType());
            return arrayList;
        }
        catch (Exception e) {
            throw new SynBioHubException(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    public ArrayList<IdentifiedMetadata> getRootCollectionMetadata() throws SynBioHubException {
        String url = this.backendUrl + "/rootCollections";
        Gson gson = new Gson();
        HttpGet request = new HttpGet(url);
        try {
            ArrayList metadataList;
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            this.checkResponseCode(response);
            InputStream inputStream = response.getEntity().getContent();
            ArrayList arrayList = metadataList = (ArrayList)gson.fromJson((Reader)new InputStreamReader(inputStream), new TypeToken<ArrayList<IdentifiedMetadata>>(){}.getType());
            return arrayList;
        }
        catch (Exception e) {
            throw new SynBioHubException(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    public ArrayList<IdentifiedMetadata> getSubCollectionMetadata(URI parentCollectionUri) throws SynBioHubException {
        if (!parentCollectionUri.toString().startsWith(this.uriPrefix)) {
            throw new SynBioHubException("Object URI does not start with correct URI prefix for this repository.");
        }
        String url = parentCollectionUri + "/subCollections";
        url = url.replace(this.uriPrefix, this.backendUrl);
        Gson gson = new Gson();
        HttpGet request = new HttpGet(url);
        try {
            ArrayList metadataList;
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            this.checkResponseCode(response);
            InputStream inputStream = response.getEntity().getContent();
            ArrayList arrayList = metadataList = (ArrayList)gson.fromJson((Reader)new InputStreamReader(inputStream), new TypeToken<ArrayList<IdentifiedMetadata>>(){}.getType());
            return arrayList;
        }
        catch (Exception e) {
            throw new SynBioHubException(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    public void logout() {
        this.user = null;
    }

    public void login(String email, String password) throws SynBioHubException {
        String url = this.backendUrl + "/remoteLogin";
        HttpPost request = new HttpPost(url);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("email", email));
        params.add(new BasicNameValuePair("password", password));
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            this.checkResponseCode(response);
            HttpEntity entity = response.getEntity();
            this.user = this.inputStreamToString(entity.getContent());
        }
        catch (Exception e) {
            throw new SynBioHubException(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    public void removeRegistryParts(SBOLDocument document) {
        for (TopLevel topLevel : document.getTopLevels()) {
            if (!topLevel.getIdentity().toString().startsWith(this.uriPrefix)) continue;
            try {
                document.removeTopLevel(topLevel);
            }
            catch (SBOLValidationException sBOLValidationException) {}
        }
    }

    public void submit(String id, String version, String name, String description, String citations, String collections, String overwrite_merge, SBOLDocument document) throws SynBioHubException {
        if (this.user == null) {
            Exception e = new Exception("Must be logged in to submit.");
            throw new SynBioHubException(e);
        }
        String url = this.backendUrl + "/remoteSubmit";
        HttpPost request = new HttpPost(url);
        MultipartEntity params = new MultipartEntity();
        try {
            params.addPart("id", (ContentBody)new StringBody(id));
            params.addPart("version", (ContentBody)new StringBody(version));
            params.addPart("name", (ContentBody)new StringBody(name));
            params.addPart("description", (ContentBody)new StringBody(description));
            params.addPart("citations", (ContentBody)new StringBody(citations));
            params.addPart("collectionChoices", (ContentBody)new StringBody(collections));
            params.addPart("overwrite_merge", (ContentBody)new StringBody(overwrite_merge));
            params.addPart("user", (ContentBody)new StringBody(this.user));
            params.addPart("file", (ContentBody)new StringBody(this.serializeDocument(document)));
        }
        catch (UnsupportedEncodingException e1) {
            throw new SynBioHubException(e1);
        }
        try {
            request.setEntity((HttpEntity)params);
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            this.checkResponseCode(response);
        }
        catch (Exception e) {
            throw new SynBioHubException(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    private String serializeDocument(SBOLDocument document) throws SynBioHubException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            SBOLWriter.write(document, outputStream);
            return outputStream.toString("UTF-8");
        }
        catch (Exception e) {
            throw new SynBioHubException("Error serializing SBOL document", e);
        }
    }

    private SBOLDocument fetchFromSynBioHub(String url) throws SynBioHubException {
        SBOLDocument document;
        HttpStream stream;
        try {
            stream = this.fetchContentAsInputStream(url);
        }
        catch (Exception e) {
            throw new SynBioHubException("Error connecting to SynBioHub endpoint", e);
        }
        try {
            document = SBOLReader.read(stream.inputStream);
        }
        catch (Exception e) {
            throw new SynBioHubException("Error reading SBOL", e);
        }
        finally {
            stream.request.releaseConnection();
        }
        return document;
    }

    private int fetchCount(String url) throws SynBioHubException {
        try {
            return Integer.parseInt(this.fetchContentAsString(url));
        }
        catch (Exception e) {
            throw new SynBioHubException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchContentAsString(String url) throws SynBioHubException, IOException {
        String str;
        HttpStream stream = this.fetchContentAsInputStream(url);
        try {
            str = this.inputStreamToString(stream.inputStream);
        }
        finally {
            stream.request.releaseConnection();
        }
        return str;
    }

    private String inputStreamToString(InputStream inputStream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer);
        return writer.toString();
    }

    private HttpStream fetchContentAsInputStream(String url) throws SynBioHubException, IOException {
        HttpGet request = new HttpGet(url);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            this.checkResponseCode(response);
            HttpStream res = new HttpStream();
            res.inputStream = response.getEntity().getContent();
            res.request = request;
            return res;
        }
        catch (SynBioHubException e) {
            request.releaseConnection();
            throw e;
        }
        catch (IOException e) {
            request.releaseConnection();
            throw e;
        }
    }

    private String encodeUri(String uri) {
        try {
            return URLEncoder.encode(uri, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?");
        }
    }

    private void checkResponseCode(HttpResponse response) throws SynBioHubException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 300) {
            switch (statusCode) {
                case 401: {
                    throw new PermissionException();
                }
                case 404: {
                    throw new NotFoundException();
                }
            }
            HttpEntity entity = response.getEntity();
            try {
                throw new SynBioHubException(this.inputStreamToString(entity.getContent()));
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new SynBioHubException(statusCode + "");
            }
        }
    }

    class HttpStream {
        public InputStream inputStream;
        public HttpRequestBase request;

        HttpStream() {
        }
    }
}

