/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert$;
import org.junit.ComparisonFailure;
import org.junit.function.ThrowingRunnable;
import org.junit.internal.ExactComparisonCriteria;
import org.junit.internal.InexactComparisonCriteria;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Assert$ {
    public static final Assert$ MODULE$;

    static {
        new Assert$();
    }

    public void assertTrue(String message, boolean condition) {
        if (!condition) {
            this.fail(message);
        }
    }

    public void assertTrue(boolean condition) {
        this.assertTrue(null, condition);
    }

    public void assertFalse(String message, boolean condition) {
        this.assertTrue(message, !condition);
    }

    public void assertFalse(boolean condition) {
        this.assertFalse(null, condition);
    }

    public void fail(String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public void fail() {
        this.fail(null);
    }

    public void assertEquals(String message, Object expected, Object actual) {
        if (!Objects.equals(expected, actual)) {
            Tuple2 tuple2 = new Tuple2(expected, actual);
            if (tuple2 != null) {
                Object expectedString = tuple2._1();
                Object actualString = tuple2._2();
                if (expectedString instanceof String) {
                    String string = (String)expectedString;
                    if (actualString instanceof String) {
                        String string2 = (String)actualString;
                        String cleanMsg = message == null ? "" : message;
                        throw new ComparisonFailure(cleanMsg, string, string2);
                    }
                }
            }
            this.failNotEquals(message, expected, actual);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void assertEquals(Object expected, Object actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertNotEquals(String message, Object unexpected, Object actual) {
        if (Objects.equals(unexpected, actual)) {
            this.failEquals(message, actual);
        }
    }

    public void assertNotEquals(Object unexpected, Object actual) {
        this.assertNotEquals(null, unexpected, actual);
    }

    private void failEquals(String message, Object actual) {
        String checkedMessage = message == null ? "Values should be different" : message;
        this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkedMessage, actual})));
    }

    public void assertNotEquals(String message, int unexpected, int actual) {
        if (unexpected == actual) {
            this.failEquals(message, BoxesRunTime.boxToInteger((int)actual));
        }
    }

    public void assertNotEquals(int unexpected, int actual) {
        this.assertNotEquals((String)null, unexpected, actual);
    }

    public void assertNotEquals(String message, long unexpected, long actual) {
        if (unexpected == actual) {
            this.failEquals(message, BoxesRunTime.boxToLong((long)actual));
        }
    }

    public void assertNotEquals(long unexpected, long actual) {
        this.assertNotEquals((String)null, unexpected, actual);
    }

    public void assertNotEquals(String message, double unexpected, double actual, double delta) {
        if (!this.doubleIsDifferent(unexpected, actual, delta)) {
            this.failEquals(message, BoxesRunTime.boxToDouble((double)actual));
        }
    }

    public void assertNotEquals(double unexpected, double actual, double delta) {
        this.assertNotEquals(null, unexpected, actual, delta);
    }

    public void assertNotEquals(float unexpected, float actual, float delta) {
        this.assertNotEquals((String)null, unexpected, actual, delta);
    }

    public void assertEquals(double expected, double actual) {
        this.fail("Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public void assertEquals(String message, double expected, double actual) {
        this.fail("Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public void assertEquals(int expected, int actual) {
        this.assertEquals((String)null, expected, actual);
    }

    public void assertEquals(String message, int expected, int actual) {
        this.assertEquals(message, BoxesRunTime.boxToInteger((int)expected), BoxesRunTime.boxToInteger((int)actual));
    }

    public void assertEquals(long expected, long actual) {
        this.assertEquals((String)null, expected, actual);
    }

    public void assertEquals(String message, long expected, long actual) {
        this.assertEquals(message, BoxesRunTime.boxToLong((long)expected), BoxesRunTime.boxToLong((long)actual));
    }

    public void assertArrayEquals(String message, Object[] expecteds, Object[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        this.assertArrayEquals(null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, boolean[] expecteds, boolean[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(boolean[] expecteds, boolean[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, byte[] expecteds, byte[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(byte[] expecteds, byte[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, char[] expecteds, char[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(char[] expecteds, char[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, short[] expecteds, short[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(short[] expecteds, short[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, int[] expecteds, int[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(int[] expecteds, int[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, long[] expecteds, long[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(long[] expecteds, long[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, double[] expecteds, double[] actuals, double delta) {
        new InexactComparisonCriteria(delta).arrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(double[] expecteds, double[] actuals, double delta) {
        this.assertArrayEquals(null, expecteds, actuals, delta);
    }

    public void assertArrayEquals(String message, float[] expecteds, float[] actuals, float delta) {
        new InexactComparisonCriteria(delta).arrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(float[] expecteds, float[] actuals, float delta) {
        this.assertArrayEquals((String)null, expecteds, actuals, delta);
    }

    private void internalArrayEquals(String message, Object expecteds, Object actuals) {
        new ExactComparisonCriteria().arrayEquals(message, expecteds, actuals);
    }

    public void assertEquals(String message, double expected, double actual, double delta) {
        if (this.doubleIsDifferent(expected, actual, delta)) {
            this.failNotEquals(message, BoxesRunTime.boxToDouble((double)expected), BoxesRunTime.boxToDouble((double)actual));
        }
    }

    public void assertEquals(String message, float expected, float actual, float delta) {
        if (this.floatIsDifferent(expected, actual, delta)) {
            this.failNotEquals(message, BoxesRunTime.boxToFloat((float)expected), BoxesRunTime.boxToFloat((float)actual));
        }
    }

    public void assertNotEquals(String message, float unexpected, float actual, float delta) {
        if (!this.floatIsDifferent(unexpected, actual, delta)) {
            this.failEquals(message, BoxesRunTime.boxToFloat((float)actual));
        }
    }

    private boolean doubleIsDifferent(double d1, double d2, double delta) {
        return Double.compare(d1, d2) != 0 && Math.abs(d1 - d2) > delta;
    }

    private boolean floatIsDifferent(float f1, float f2, float delta) {
        return Float.compare(f1, f2) != 0 && Math.abs(f1 - f2) > delta;
    }

    public void assertEquals(double expected, double actual, double delta) {
        this.assertEquals(null, expected, actual, delta);
    }

    public void assertEquals(float expected, float actual, float delta) {
        this.assertEquals((String)null, expected, actual, delta);
    }

    public void assertNotNull(String message, Object obj) {
        this.assertTrue(message, obj != null);
    }

    public void assertNotNull(Object obj) {
        this.assertNotNull(null, obj);
    }

    public void assertNull(String message, Object obj) {
        if (obj != null) {
            this.failNotNull(message, obj);
        }
    }

    public void assertNull(Object obj) {
        this.assertNull(null, obj);
    }

    private void failNotNull(String message, Object actual) {
        String formatted = message == null ? "" : new StringBuilder().append((Object)message).append((Object)" ").toString();
        this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "expected null, but was:<", "}>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formatted, actual})));
    }

    public void assertSame(String message, Object expected, Object actual) {
        if (expected != actual) {
            this.failNotSame(message, expected, actual);
        }
    }

    public void assertSame(Object expected, Object actual) {
        this.assertSame(null, expected, actual);
    }

    public void assertNotSame(String message, Object unexpected, Object actual) {
        if (unexpected == actual) {
            this.failSame(message);
        }
    }

    public void assertNotSame(Object unexpected, Object actual) {
        this.assertNotSame(null, unexpected, actual);
    }

    private void failSame(String message) {
        if (message == null) {
            this.fail("expected not same");
        } else {
            this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " expected not same"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})));
        }
    }

    private void failNotSame(String message, Object expected, Object actual) {
        if (message == null) {
            this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected same:<", "> was not:<", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, actual})));
        } else {
            this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " expected same:<", "> was not:<", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, expected, actual})));
        }
    }

    private void failNotEquals(String message, Object expected, Object actual) {
        this.fail(this.format(message, expected, actual));
    }

    /*
     * Unable to fully structure code
     */
    public String format(String message, Object expected, Object actual) {
        if (message == null) ** GOTO lbl-1000
        v0 = message;
        var5_4 = "";
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) lbl-1000:
        // 2 sources

        {
            v1 = "";
        } else {
            v1 = new StringBuilder().append((Object)message).append((Object)" ").toString();
        }
        formatted = v1;
        expectedString = String.valueOf(expected);
        actualString = String.valueOf(actual);
        v2 = expectedString;
        var8_8 = actualString;
        if (!(v2 != null ? v2.equals(var8_8) == false : var8_8 != null)) {
            expectedFormatted = this.formatClassAndValue(expected, expectedString);
            actualFormatted = this.formatClassAndValue(actual, actualString);
            v3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "expected: ", " but was: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formatted, expectedFormatted, actualFormatted}));
        } else {
            v3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "expected:<", "> but was:<", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formatted, expectedString, actualString}));
        }
        return v3;
    }

    private String formatClass(Class<?> value) {
        return value.getName();
    }

    private String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "<", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className, valueString}));
    }

    public <T> void assertThat(T actual, Matcher<T> matcher) {
        this.assertThat("", actual, matcher);
    }

    public <T> void assertThat(String reason, T actual, Matcher<T> matcher) {
        MatcherAssert$.MODULE$.assertThat(reason, actual, matcher);
    }

    public <T extends Throwable> T assertThrows(Class<T> expectedThrowable, ThrowingRunnable runnable) {
        return this.assertThrows(null, expectedThrowable, runnable);
    }

    public <T extends Throwable> T assertThrows(String message, Class<T> expectedThrowable, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && expectedThrowable.isInstance(throwable2 = throwable3)) {
                return (T)throwable2;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                String expected = this.formatClass(expectedThrowable);
                String actual = this.formatClass(throwable4.getClass());
                throw new AssertionError(new StringBuilder().append((Object)this.buildPrefix$1(message)).append((Object)this.format("unexpected exception type thrown;", expected, actual)).toString(), throwable4);
            }
            throw throwable;
        }
        throw new AssertionError((Object)new StringBuilder().append((Object)this.buildPrefix$1(message)).append((Object)String.format("expected %s to be thrown, but nothing was thrown", this.formatClass(expectedThrowable))).toString());
    }

    private final String buildPrefix$1(String message$1) {
        return message$1 == null || message$1.isEmpty() ? "" : new StringBuilder().append((Object)message$1).append((Object)": ").toString();
    }

    private Assert$() {
        MODULE$ = this;
    }
}

