/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal;

import java.util.Arrays;
import org.junit.Assert$;
import org.junit.internal.ArrayComparisonFailure;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i3Q!\u0001\u0002\u0002\u0002%\u0011!cQ8na\u0006\u0014\u0018n]8o\u0007JLG/\u001a:jC*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u000f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005\u0011\u0001\"\u0002\f\u0001\t\u00039\u0012aC1se\u0006LX)];bYN$B\u0001G\u000e)UA\u00111\"G\u0005\u000351\u0011A!\u00168ji\")A$\u0006a\u0001;\u00059Q.Z:tC\u001e,\u0007C\u0001\u0010&\u001d\ty2\u0005\u0005\u0002!\u00195\t\u0011E\u0003\u0002#\u0011\u00051AH]8pizJ!\u0001\n\u0007\u0002\rA\u0013X\rZ3g\u0013\t1sE\u0001\u0004TiJLgn\u001a\u0006\u0003I1AQ!K\u000bA\u0002)\t\u0011\"\u001a=qK\u000e$X\rZ:\t\u000b-*\u0002\u0019\u0001\u0006\u0002\u000f\u0005\u001cG/^1mg\")a\u0003\u0001C\u0005[Q)\u0001DL\u00181c!)A\u0004\fa\u0001;!)\u0011\u0006\fa\u0001\u0015!)1\u0006\fa\u0001\u0015!)!\u0007\fa\u0001g\u0005)q.\u001e;feB\u00111\u0002N\u0005\u0003k1\u0011qAQ8pY\u0016\fg\u000eC\u00038\u0001\u0011%\u0001(A\u0004jg\u0006\u0013(/Y=\u0015\u0005MJ\u0004\"\u0002\u001e7\u0001\u0004Q\u0011\u0001C3ya\u0016\u001cG/\u001a3\t\u000bq\u0002A\u0011B\u001f\u00023\u0005\u001c8/\u001a:u\u0003J\u0014\u0018-_:Be\u0016\u001c\u0016-\\3MK:<G\u000f\u001b\u000b\u0005}\u0005\u00135\t\u0005\u0002\f\u007f%\u0011\u0001\t\u0004\u0002\u0004\u0013:$\b\"B\u0015<\u0001\u0004Q\u0001\"B\u0016<\u0001\u0004Q\u0001\"\u0002#<\u0001\u0004i\u0012A\u00025fC\u0012,'\u000fC\u0003G\u0001\u0011%q)A\u0002hKR$2A\u0003%K\u0011\u0015IU\t1\u0001\u000b\u0003\r\t'O\u001d\u0005\u0006\u0017\u0016\u0003\rAP\u0001\u0002S\"\u0012Q)\u0014\t\u0003\u00179K!a\u0014\u0007\u0003\r%tG.\u001b8f\u0011\u0015\t\u0006\u0001\"\u0003S\u0003\u0019aWM\\4uQR\u0011ah\u0015\u0005\u0006\u0013B\u0003\rA\u0003\u0005\u0006+\u00021\tBV\u0001\u0014CN\u001cXM\u001d;FY\u0016lWM\u001c;t\u000bF,\u0018\r\u001c\u000b\u00041]C\u0006\"\u0002\u001eU\u0001\u0004Q\u0001\"B-U\u0001\u0004Q\u0011AB1diV\fG\u000e")
public abstract class ComparisonCriteria {
    public void arrayEquals(String message, Object expecteds, Object actuals) {
        this.arrayEquals(message, expecteds, actuals, true);
    }

    private void arrayEquals(String message, Object expecteds, Object actuals, boolean outer) {
        block0: {
            if (BoxesRunTime.equals((Object)expecteds, (Object)actuals) || Arrays.deepEquals(new Object[]{expecteds}, new Object[]{actuals})) break block0;
            String header = message == null ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message}));
            String exceptionMessage = outer ? header : "";
            int expectedsLength = this.assertArraysAreSameLength(expecteds, actuals, exceptionMessage);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), expectedsLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                Object expected = this.get(expecteds, i);
                Object actual = this.get(actuals, i);
                if (this.isArray(expected) && this.isArray(actual)) {
                    try {
                        this.arrayEquals(message, expected, actual, false);
                    }
                    catch (ArrayComparisonFailure e) {
                        e.addDimension(i);
                        throw e;
                    }
                    catch (AssertionError e) {
                        throw new ArrayComparisonFailure(header, e, i);
                    }
                }
                try {
                    this.assertElementsEqual(expected, actual);
                }
                catch (AssertionError e) {
                    throw new ArrayComparisonFailure(header, e, i);
                }
            });
        }
    }

    private boolean isArray(Object expected) {
        return ScalaRunTime$.MODULE$.isArray(expected, 1);
    }

    private int assertArraysAreSameLength(Object expecteds, Object actuals, String header) {
        int expectedsLength;
        block2: {
            int actualsLength;
            if (expecteds == null) {
                Assert$.MODULE$.fail(header + "expected array was null");
            }
            if (actuals == null) {
                Assert$.MODULE$.fail(header + "actual array was null");
            }
            if ((actualsLength = ScalaRunTime$.MODULE$.array_length(actuals)) == (expectedsLength = ScalaRunTime$.MODULE$.array_length(expecteds))) break block2;
            Assert$.MODULE$.fail(header + "array lengths differed, expected.length=" + expectedsLength + " actual.length=" + actualsLength);
        }
        return expectedsLength;
    }

    private Object get(Object arr, int i) {
        return ScalaRunTime$.MODULE$.array_apply(arr, i);
    }

    private int length(Object arr) {
        return ScalaRunTime$.MODULE$.array_length(arr);
    }

    public abstract void assertElementsEqual(Object var1, Object var2);
}

