/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.testing.adapter;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.scalajs.jsenv.Input;
import org.scalajs.jsenv.JSUtils$;
import org.scalajs.jsenv.UnsupportedInputException;
import org.scalajs.testing.common.IsolatedTestSet;
import org.scalajs.testing.common.Serializer$;
import org.scalajs.testing.common.TestBridgeMode;
import org.scalajs.testing.common.TestBridgeMode$TestBridgeModeSerializer$;
import sbt.testing.TaskDef;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class HTMLRunnerBuilder$ {
    public static final HTMLRunnerBuilder$ MODULE$;
    private final Regex tmpSuffixRE;

    static {
        new HTMLRunnerBuilder$();
    }

    private Regex tmpSuffixRE() {
        return this.tmpSuffixRE;
    }

    public URI org$scalajs$testing$adapter$HTMLRunnerBuilder$$tmpFile(String path, InputStream in) {
        try {
            String suffix = (String)this.tmpSuffixRE().findFirstIn((CharSequence)path).orNull(Predef$.MODULE$.conforms());
            File f = File.createTempFile("tmp-", suffix);
            f.deleteOnExit();
            Files.copy(in, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return f.toURI();
        }
        finally {
            in.close();
        }
    }

    public void writeToFile(File output, String title, Input input, List<List<String>> frameworkImplClassNames, List<TaskDef> taskDefs) {
        Input input2 = input;
        if (input2 instanceof Input.ScriptsToLoad) {
            List jsFiles;
            List list;
            Input.ScriptsToLoad scriptsToLoad = (Input.ScriptsToLoad)input2;
            List jsFiles2 = list = (jsFiles = scriptsToLoad.scripts());
            List jsFileURIs = (List)jsFiles2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final URI apply(Path f) {
                    URI uRI;
                    try {
                        uRI = f.toFile().toURI();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        uRI = HTMLRunnerBuilder$.MODULE$.org$scalajs$testing$adapter$HTMLRunnerBuilder$$tmpFile(((Object)f).toString(), Files.newInputStream(f, new OpenOption[0]));
                    }
                    return uRI;
                }
            }, List$.MODULE$.canBuildFrom());
            String name = "test-runner.css";
            URI cssURI = this.org$scalajs$testing$adapter$HTMLRunnerBuilder$$tmpFile(name, this.getClass().getResourceAsStream(name));
            IsolatedTestSet tests = new IsolatedTestSet(frameworkImplClassNames, taskDefs);
            String htmlContent = this.render(title, (Seq<URI>)jsFileURIs, cssURI, tests);
            Files.write(output.toPath(), (Iterable<? extends CharSequence>)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{htmlContent}))).asJava()), StandardCharsets.UTF_8, new OpenOption[0]);
            return;
        }
        throw new UnsupportedInputException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported input for the generation of an HTML runner: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input})));
    }

    private String render(String title, Seq<URI> jsFiles, URI css, IsolatedTestSet tests) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    <!DOCTYPE html>\n    <html>\n      <head>\n        <title>", "</title>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n        <link rel=\"stylesheet\" type=\"text/css\" href=\"", "\" />\n        <script type=\"text/javascript\">\n        ", "\n        </script>\n        ", "\n      </head>\n      <body></body>\n    </html>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.htmlEscaped(title), this.org$scalajs$testing$adapter$HTMLRunnerBuilder$$uristr$1(css), this.injectBridgeMode(tests), ((TraversableOnce)jsFiles.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(URI jsFile) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        <script type=\"text/javascript\" src=\"", "\"></script>\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HTMLRunnerBuilder$.MODULE$.org$scalajs$testing$adapter$HTMLRunnerBuilder$$uristr$1(jsFile)}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("")}));
    }

    private String injectBridgeMode(IsolatedTestSet tests) {
        TestBridgeMode.HTMLRunner mode = new TestBridgeMode.HTMLRunner(tests);
        String ser = Serializer$.MODULE$.serialize(mode, TestBridgeMode$TestBridgeModeSerializer$.MODULE$);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var __ScalaJSTestBridgeMode = \"", "\";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JSUtils$.MODULE$.escapeJS(ser)}));
    }

    private String htmlEscaped(String str) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(str)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TraversableLike<Object, Object> apply(char x0$1) {
                StringOps stringOps;
                char c = x0$1;
                switch (c) {
                    default: {
                        char c2 = c;
                        stringOps = Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToCharacter((char)c2));
                        break;
                    }
                    case '&': {
                        stringOps = new StringOps(Predef$.MODULE$.augmentString("&amp;"));
                        break;
                    }
                    case '\"': {
                        stringOps = new StringOps(Predef$.MODULE$.augmentString("&quot;"));
                        break;
                    }
                    case '>': {
                        stringOps = new StringOps(Predef$.MODULE$.augmentString("&gt;"));
                        break;
                    }
                    case '<': {
                        stringOps = new StringOps(Predef$.MODULE$.augmentString("&lt;"));
                    }
                }
                return stringOps;
            }
        }, Predef$.MODULE$.StringCanBuildFrom());
    }

    public final String org$scalajs$testing$adapter$HTMLRunnerBuilder$$uristr$1(URI uri) {
        return this.htmlEscaped(uri.toASCIIString());
    }

    private HTMLRunnerBuilder$() {
        MODULE$ = this;
        this.tmpSuffixRE = new StringOps(Predef$.MODULE$.augmentString("[a-zA-Z0-9-_.]*$")).r();
    }
}

