/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.testing.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.scalajs.testing.common.Serializer;
import org.scalajs.testing.common.Serializer$;
import org.scalajs.testing.common.Serializer$BooleanSerializer$;
import org.scalajs.testing.common.Serializer$DeserializeState$;
import org.scalajs.testing.common.Serializer$IntSerializer$;
import org.scalajs.testing.common.Serializer$SerializeState$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Serializer$ {
    public static final Serializer$ MODULE$;

    static {
        new Serializer$();
    }

    public <T> void serialize(T t, DataOutputStream out, Serializer<T> s) {
        s.serialize(t, out);
    }

    public <T> T deserialize(DataInputStream in, Serializer<T> s) {
        return s.deserialize(in);
    }

    public <T> String serialize(T t, Serializer<T> evidence$1) {
        return this.withOutputStream((Function1<DataOutputStream, BoxedUnit>)new Serializable(t, evidence$1){
            public static final long serialVersionUID = 0L;
            private final Object t$1;
            private final Serializer evidence$1$1;

            public final void apply(DataOutputStream x$1) {
                Serializer$.MODULE$.serialize(this.t$1, x$1, this.evidence$1$1);
            }
            {
                this.t$1 = t$1;
                this.evidence$1$1 = evidence$1$1;
            }
        });
    }

    public <T> T deserialize(String s, Serializer<T> evidence$2) {
        return this.withInputStream(s, (Function1<DataInputStream, T>)new Serializable(evidence$2){
            public static final long serialVersionUID = 0L;
            private final Serializer evidence$2$1;

            public final T apply(DataInputStream x$2) {
                return Serializer$.MODULE$.deserialize(x$2, this.evidence$2$1);
            }
            {
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    public <T> T withInputStream(String s, Function1<DataInputStream, T> body) {
        byte[] bytes = (byte[])Predef$.MODULE$.charArrayOps((char[])new StringOps(Predef$.MODULE$.augmentString(s)).toArray(ClassTag$.MODULE$.Char())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(char x$3) {
                return (byte)x$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            return (T)body.apply((Object)in);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String withOutputStream(Function1<DataOutputStream, BoxedUnit> body) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        try {
            body.apply((Object)dataOut);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        dataOut.close();
        return new String((char[])Predef$.MODULE$.byteArrayOps(byteOut.toByteArray()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final char apply(byte b) {
                return (char)(b & 0xFF);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())));
    }

    public <T> Serializer<List<T>> listSerializer(Serializer<T> evidence$3) {
        return new Serializer<List<T>>(evidence$3){
            public final Serializer evidence$3$1;

            public void serialize(List<T> x, DataOutputStream out) {
                Serializer$SerializeState$.MODULE$.write$extension(out, BoxesRunTime.boxToInteger((int)x.size()), Serializer$IntSerializer$.MODULE$);
                x.foreach((Function1)new Serializable(this, out){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.4 $outer;
                    private final DataOutputStream out$1;

                    public final void apply(T x$4) {
                        Serializer$SerializeState$.MODULE$.write$extension(this.out$1, x$4, this.$outer.evidence$3$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.out$1 = out$1;
                    }
                });
            }

            public List<T> deserialize(DataInputStream in) {
                return (List)List$.MODULE$.fill(BoxesRunTime.unboxToInt((Object)Serializer$DeserializeState$.MODULE$.read$extension(in, Serializer$IntSerializer$.MODULE$)), (Function0)new Serializable(this, in){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.4 $outer;
                    private final DataInputStream in$1;

                    public final T apply() {
                        return Serializer$DeserializeState$.MODULE$.read$extension(this.in$1, this.$outer.evidence$3$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.in$1 = in$1;
                    }
                });
            }
            {
                this.evidence$3$1 = evidence$3$1;
            }
        };
    }

    public <T> Serializer<Option<T>> optionSerializer(Serializer<T> evidence$4) {
        return new Serializer<Option<T>>(evidence$4){
            public final Serializer evidence$4$1;

            public void serialize(Option<T> x, DataOutputStream out) {
                Serializer$SerializeState$.MODULE$.write$extension(out, BoxesRunTime.boxToBoolean((boolean)x.isDefined()), Serializer$BooleanSerializer$.MODULE$);
                x.foreach((Function1)new Serializable(this, out){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.5 $outer;
                    private final DataOutputStream out$2;

                    public final void apply(T x$5) {
                        Serializer$SerializeState$.MODULE$.write$extension(this.out$2, x$5, this.$outer.evidence$4$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.out$2 = out$2;
                    }
                });
            }

            public Option<T> deserialize(DataInputStream in) {
                return BoxesRunTime.unboxToBoolean((Object)Serializer$DeserializeState$.MODULE$.read$extension(in, Serializer$BooleanSerializer$.MODULE$)) ? new Some(Serializer$DeserializeState$.MODULE$.read$extension(in, this.evidence$4$1)) : None$.MODULE$;
            }
            {
                this.evidence$4$1 = evidence$4$1;
            }
        };
    }

    private Serializer$() {
        MODULE$ = this;
    }
}

