/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.testing.adapter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import org.scalajs.jsenv.Input;
import org.scalajs.jsenv.JSUtils$;
import org.scalajs.jsenv.UnsupportedInputException;
import org.scalajs.testing.common.IsolatedTestSet;
import org.scalajs.testing.common.Serializer$;
import org.scalajs.testing.common.TestBridgeMode;
import org.scalajs.testing.common.TestBridgeMode$TestBridgeModeSerializer$;
import sbt.testing.TaskDef;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class HTMLRunnerBuilder$ {
    public static HTMLRunnerBuilder$ MODULE$;

    static {
        new HTMLRunnerBuilder$();
    }

    public void writeToFile(File output, String title, Seq<Input> input, List<List<String>> frameworkImplClassNames, List<TaskDef> taskDefs) {
        Path outputPath = output.toPath();
        Path artifactsDir = Files.createTempDirectory(outputPath.getParent(), ".html-artifacts", new FileAttribute[0]);
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Files.walkFileTree(artifactsDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        }));
        this.write(outputPath, artifactsDir, title, input, frameworkImplClassNames, taskDefs);
    }

    public void write(Path output, Path artifactsDir, String title, Seq<Input> input, List<List<String>> frameworkImplClassNames, List<TaskDef> taskDefs) {
        Path absoluteArtifacts = artifactsDir.toAbsolutePath();
        Path outputDir = output.toAbsolutePath().normalize().getParent();
        try {
            outputDir.relativize(absoluteArtifacts);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("cannot relativize `artifactsDir` with respect to `output`", e);
        }
        Seq loadJSTags = (Seq)((TraversableLike)input.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Input input = (Input)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (input instanceof Input.Script) {
                    Input.Script script = (Input.Script)input;
                    Path script2 = script.script();
                    return this.scriptTag$1(i, "text/javascript", script2, outputDir, absoluteArtifacts);
                }
            }
            if (tuple2 != null) {
                Input input = (Input)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (input instanceof Input.ESModule) {
                    Input.ESModule eSModule = (Input.ESModule)input;
                    Path module = eSModule.module();
                    return this.scriptTag$1(i, "module", module, outputDir, absoluteArtifacts);
                }
            }
            throw new UnsupportedInputException(new java.lang.StringBuilder(56).append("Unsupported input for the generation of an HTML runner: ").append(input).toString());
        }, Seq$.MODULE$.canBuildFrom());
        IsolatedTestSet tests = new IsolatedTestSet(frameworkImplClassNames, taskDefs);
        TestBridgeMode.HTMLRunner mode = new TestBridgeMode.HTMLRunner(tests);
        String bridgeModeStr = Serializer$.MODULE$.serialize(mode, TestBridgeMode$TestBridgeModeSerializer$.MODULE$);
        String name = "test-runner.css";
        Tuple2 tuple2 = this.artifactPath$1(name, absoluteArtifacts, outputDir);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String href = (String)tuple2._1();
        Path target = (Path)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)href, (Object)target);
        String href2 = (String)tuple22._1();
        Path target2 = (Path)tuple22._2();
        try (InputStream in = this.getClass().getResourceAsStream(name);){
            Files.copy(in, target2, StandardCopyOption.REPLACE_EXISTING);
        }
        String cssHref = href2;
        String htmlContent = new java.lang.StringBuilder(391).append("\n      <!DOCTYPE html>\n      <html>\n        <head>\n          <title>").append(this.htmlEscaped(title)).append("</title>\n          <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n          <link rel=\"stylesheet\" type=\"text/css\" href=\"").append(this.htmlEscaped(cssHref)).append("\" />\n          <script type=\"text/javascript\">\n            var __ScalaJSTestBridgeMode = \"").append(JSUtils$.MODULE$.escapeJS(bridgeModeStr)).append("\";\n          </script>\n          ").append(loadJSTags.mkString("\n")).append("\n        </head>\n        <body></body>\n      </html>\n    ").toString();
        Files.write(output, Arrays.asList((Object[])new String[]{htmlContent}), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private String htmlEscaped(String str) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(str)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> new StringOps(HTMLRunnerBuilder$.$anonfun$htmlEscaped$1(BoxesRunTime.unboxToChar((Object)x0$1))), Predef$.MODULE$.StringCanBuildFrom());
    }

    private String joinRelPath(Path p) {
        Predef$.MODULE$.require(p.getRoot() == null);
        Iterator<Path> partsIter = p.iterator();
        StringBuilder result = new StringBuilder();
        while (partsIter.hasNext()) {
            result.append((Object)partsIter.next());
            Object object = partsIter.hasNext() ? result.append('/') : BoxedUnit.UNIT;
        }
        return result.toString();
    }

    private final Tuple2 artifactPath$1(String name, Path absoluteArtifacts$1, Path outputDir$1) {
        Path path = absoluteArtifacts$1.resolve(name);
        Path relPath = outputDir$1.relativize(path);
        return new Tuple2((Object)this.joinRelPath(relPath), (Object)path);
    }

    private final String scriptTag$1(int index, String tpe, Path content, Path outputDir$1, Path absoluteArtifacts$1) {
        String string;
        try {
            string = this.joinRelPath(outputDir$1.relativize(content));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)index);
            Path arg$macro$2 = content.getFileName();
            Tuple2 tuple2 = this.artifactPath$1(new StringOps("input%s-%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})), absoluteArtifacts$1, outputDir$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String src = (String)tuple2._1();
            Path target = (Path)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)src, (Object)target);
            String src2 = (String)tuple22._1();
            Path target2 = (Path)tuple22._2();
            Files.copy(content, target2, StandardCopyOption.REPLACE_EXISTING);
            string = src2;
        }
        String src = string;
        return new java.lang.StringBuilder(38).append("<script defer type=\"").append(tpe).append("\" src=\"").append(this.htmlEscaped(src)).append("\"></script>").toString();
    }

    public static final /* synthetic */ String $anonfun$htmlEscaped$1(char x0$1) {
        char c = x0$1;
        switch (c) {
            case '<': {
                return Predef$.MODULE$.augmentString("&lt;");
            }
            case '>': {
                return Predef$.MODULE$.augmentString("&gt;");
            }
            case '\"': {
                return Predef$.MODULE$.augmentString("&quot;");
            }
            case '&': {
                return Predef$.MODULE$.augmentString("&amp;");
            }
        }
        return Predef$.MODULE$.augmentString(Character.toString(c));
    }

    private HTMLRunnerBuilder$() {
        MODULE$ = this;
    }
}

