/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.core.tools.javascript;

import java.io.BufferedReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import org.scalajs.core.ir.Position;
import org.scalajs.core.tools.io.VirtualJSFile;
import org.scalajs.core.tools.javascript.JSFileBuilder;
import org.scalajs.core.tools.javascript.JSTreeBuilder;
import org.scalajs.core.tools.javascript.Printers;
import org.scalajs.core.tools.javascript.SourceMapWriter;
import org.scalajs.core.tools.javascript.Trees;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u001b\t\u0001#j\u0015$jY\u0016\u0014U/\u001b7eKJ<\u0016\u000e\u001e5T_V\u00148-Z'ba^\u0013\u0018\u000e^3s\u0015\t\u0019A!\u0001\u0006kCZ\f7o\u0019:jaRT!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011\u0001B2pe\u0016T!!\u0003\u0006\u0002\u000fM\u001c\u0017\r\\1kg*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u000e\u0015N3\u0015\u000e\\3Ck&dG-\u001a:\t\u0013M\u0001!\u0011!Q\u0001\nQ\t\u0013!\u00018\u0011\u0005UqbB\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\tIB\"\u0001\u0004=e>|GO\u0010\u0006\u00027\u0005)1oY1mC&\u0011QDG\u0001\u0007!J,G-\u001a4\n\u0005}\u0001#AB*ue&twM\u0003\u0002\u001e5%\u0011!\u0005E\u0001\u0005]\u0006lW\rC\u0005%\u0001\t\u0005\t\u0015!\u0003&[\u0005\u0011qn\u001e\t\u0003M-j\u0011a\n\u0006\u0003Q%\n!![8\u000b\u0003)\nAA[1wC&\u0011Af\n\u0002\u0007/JLG/\u001a:\n\u00059\u0002\u0012\u0001D8viB,Ho\u0016:ji\u0016\u0014\b\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011C\u0019\u0002\u001fM|WO]2f\u001b\u0006\u0004xK]5uKJ,\u0012A\r\t\u0003\u001fMJ!\u0001\u000e\u0002\u0003\u001fM{WO]2f\u001b\u0006\u0004xK]5uKJD\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IAM\u0001\u0011g>,(oY3NCB<&/\u001b;fe\u0002BQ\u0001\u000f\u0001\u0005\u0002e\na\u0001P5oSRtD\u0003\u0002\u001e<yu\u0002\"a\u0004\u0001\t\u000bM9\u0004\u0019\u0001\u000b\t\u000b\u0011:\u0004\u0019A\u0013\t\u000bA:\u0004\u0019\u0001\u001a\t\u000b}\u0002A\u0011\t!\u0002\u000f\u0005$G\rT5oKR\u0011\u0011)\u0012\t\u0003\u0005\u000ek\u0011AG\u0005\u0003\tj\u0011A!\u00168ji\")aI\u0010a\u0001)\u0005!A.\u001b8f\u0011\u001dA\u0005A1A\u0005\u000e%\u000b1BT8u'\u0016dWm\u0019;fIV\t!jD\u0001L;\u0005y\u0010BB'\u0001A\u00035!*\u0001\u0007O_R\u001cV\r\\3di\u0016$\u0007\u0005C\u0003P\u0001\u0011\u0005\u0003+\u0001\bbI\u0012\u0004\u0016M\u001d;t\u001f\u001a4\u0015\u000e\\3\u0015\u0005ESFCA!S\u0011\u0015\u0019f\n1\u0001U\u0003!\u0019X\r\\3di>\u0014\b\u0003\u0002\"V)]K!A\u0016\u000e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\"Y\u0013\tI&DA\u0004C_>dW-\u00198\t\u000bms\u0005\u0019\u0001/\u0002\t\u0019LG.\u001a\t\u0003;~k\u0011A\u0018\u0006\u0003Q\u0011I!\u0001\u00190\u0003\u001bYK'\u000f^;bY*\u001bf)\u001b7f\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003%\tG\r\u001a&T)J,W\r\u0006\u0002BI\")Q-\u0019a\u0001M\u0006!AO]3f!\t9'N\u0004\u0002\u0010Q&\u0011\u0011NA\u0001\u0006)J,Wm]\u0005\u0003W2\u0014A\u0001\u0016:fK*\u0011\u0011N\u0001\u0005\u0006]\u0002!\te\\\u0001\tG>l\u0007\u000f\\3uKR\t\u0011\t")
public class JSFileBuilderWithSourceMapWriter
extends JSFileBuilder {
    private final SourceMapWriter sourceMapWriter;

    public SourceMapWriter sourceMapWriter() {
        return this.sourceMapWriter;
    }

    @Override
    public void addLine(String line) {
        super.addLine(line);
        this.sourceMapWriter().nextLine();
    }

    private final int NotSelected() {
        return -1;
    }

    @Override
    public void addPartsOfFile(VirtualJSFile file, Function1<String, Object> selector) {
        try (BufferedReader br = new BufferedReader(file.reader());){
            ArrayBuffer offsets = new ArrayBuffer();
            ArrayBuffer selectedLineLengths = new ArrayBuffer();
            String line = br.readLine();
            int selectedCount = 0;
            while (line != null) {
                ArrayBuffer arrayBuffer;
                if (BoxesRunTime.unboxToBoolean((Object)selector.apply((Object)line))) {
                    super.addLine(line);
                    offsets.$plus$eq((Object)BoxesRunTime.boxToInteger((int)selectedCount));
                    selectedLineLengths.$plus$eq((Object)BoxesRunTime.boxToInteger((int)line.length()));
                    ++selectedCount;
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    arrayBuffer = offsets.$plus$eq((Object)BoxesRunTime.boxToInteger((int)-1));
                }
                line = br.readLine();
            }
            URI sourceFile = file.toURI();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsets.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)lineNumber -> {
                block0: {
                    int offset = BoxesRunTime.unboxToInt((Object)offsets.apply(lineNumber));
                    if (offset == -1) break block0;
                    Position originalPos = new Position(sourceFile, lineNumber, 0);
                    this.sourceMapWriter().startNode(0, originalPos, (Option<String>)None$.MODULE$);
                    this.sourceMapWriter().endNode(BoxesRunTime.unboxToInt((Object)selectedLineLengths.apply(offset)));
                    this.sourceMapWriter().nextLine();
                }
            });
        }
    }

    @Override
    public void addJSTree(Trees.Tree tree) {
        Printers.JSTreePrinterWithSourceMap printer = new Printers.JSTreePrinterWithSourceMap(this.outputWriter(), this.sourceMapWriter());
        printer.printTopLevelTree(tree);
    }

    @Override
    public void complete() {
        JSTreeBuilder.complete$(this);
        this.sourceMapWriter().complete();
    }

    public JSFileBuilderWithSourceMapWriter(String n, Writer ow, SourceMapWriter sourceMapWriter) {
        this.sourceMapWriter = sourceMapWriter;
        super(n, ow);
    }
}

