/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.core.tools.linker.analyzer;

import org.scalajs.core.tools.linker.analyzer.Analysis;
import org.scalajs.core.tools.logging.Level;
import org.scalajs.core.tools.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public final class Analysis$ {
    public static Analysis$ MODULE$;

    static {
        new Analysis$();
    }

    public void logError(Analysis.Error error, Logger logger, Level level) {
        String string;
        Analysis.Error error2 = error;
        if (error2 instanceof Analysis.MissingJavaLangObjectClass) {
            string = "Fatal error: java.lang.Object is missing";
        } else if (error2 instanceof Analysis.CycleInInheritanceChain) {
            Analysis.CycleInInheritanceChain cycleInInheritanceChain = (Analysis.CycleInInheritanceChain)error2;
            List<Analysis.ClassInfo> cycle = cycleInInheritanceChain.cycle();
            string = new StringBuilder(50).append("Fatal error: cycle in inheritance chain involving ").append(((TraversableOnce)cycle.map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.displayName(), List$.MODULE$.canBuildFrom())).mkString(", ")).toString();
        } else if (error2 instanceof Analysis.MissingClass) {
            Analysis.MissingClass missingClass = (Analysis.MissingClass)error2;
            Analysis.ClassInfo info = missingClass.info();
            string = new StringBuilder(32).append("Referring to non-existent class ").append(info.displayName()).toString();
        } else if (error2 instanceof Analysis.NotAModule) {
            Analysis.NotAModule notAModule = (Analysis.NotAModule)error2;
            Analysis.ClassInfo info = notAModule.info();
            string = new StringBuilder(36).append("Cannot access module for non-module ").append(info.displayName()).toString();
        } else if (error2 instanceof Analysis.MissingMethod) {
            Analysis.MissingMethod missingMethod = (Analysis.MissingMethod)error2;
            Analysis.MethodInfo info = missingMethod.info();
            string = new StringBuilder(33).append("Referring to non-existent method ").append(info.fullDisplayName()).toString();
        } else if (error2 instanceof Analysis.ConflictingDefaultMethods) {
            Analysis.ConflictingDefaultMethods conflictingDefaultMethods = (Analysis.ConflictingDefaultMethods)error2;
            List<Analysis.MethodInfo> infos = conflictingDefaultMethods.infos();
            string = new StringBuilder(29).append("Conflicting default methods: ").append(((TraversableOnce)infos.map((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.fullDisplayName(), List$.MODULE$.canBuildFrom())).mkString(" ")).toString();
        } else {
            throw new MatchError((Object)error2);
        }
        String headMsg = string;
        logger.log(level, (Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> headMsg);
        Analysis.CallStackLogger csl = new Analysis.CallStackLogger(logger);
        csl.logCallStack(error.from(), level);
    }

    private Analysis$() {
        MODULE$ = this;
    }
}

