/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.compat;

import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class StringParsers$ {
    public static final StringParsers$ MODULE$;
    private final int intOverflowBoundary;
    private final int intOverflowDigit;
    private final long longOverflowBoundary;
    private final int longOverflowDigit;

    static {
        new StringParsers$();
    }

    private final int intOverflowBoundary() {
        return -214748364;
    }

    private final int intOverflowDigit() {
        return 9;
    }

    private final long longOverflowBoundary() {
        return -922337203685477580L;
    }

    private final int longOverflowDigit() {
        return 9;
    }

    private final int decValue(char ch) {
        return Character.digit(ch, 10);
    }

    private final Option<Object> stepToOverflow(String from2, int len, int agg, boolean isPositive, int min) {
        return this.rec$1(1, agg, from2, len, isPositive, min);
    }

    public final boolean scala$collection$compat$StringParsers$$isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public final Option<Object> parseBool(String from2) {
        return from2.equalsIgnoreCase("true") ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : (from2.equalsIgnoreCase("false") ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)) : None$.MODULE$);
    }

    public final Option<Object> parseByte(String from2) {
        Object object;
        int len = from2.length();
        if (len == 0) {
            object = None$.MODULE$;
        } else {
            char first = from2.charAt(0);
            int v = this.decValue(first);
            object = len == 1 ? (v > -1 ? new Some((Object)BoxesRunTime.boxToByte((byte)((byte)v))) : None$.MODULE$) : (v > -1 ? this.stepToOverflow(from2, len, -v, true, -128).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final byte apply(int x$1) {
                    return (byte)x$1;
                }
            }) : (first == '+' ? this.stepToOverflow(from2, len, 0, true, -128).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final byte apply(int x$2) {
                    return (byte)x$2;
                }
            }) : (first == '-' ? this.stepToOverflow(from2, len, 0, false, -128).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final byte apply(int x$3) {
                    return (byte)x$3;
                }
            }) : None$.MODULE$)));
        }
        return object;
    }

    public final Option<Object> parseShort(String from2) {
        Object object;
        int len = from2.length();
        if (len == 0) {
            object = None$.MODULE$;
        } else {
            char first = from2.charAt(0);
            int v = this.decValue(first);
            object = len == 1 ? (v > -1 ? new Some((Object)BoxesRunTime.boxToShort((short)((short)v))) : None$.MODULE$) : (v > -1 ? this.stepToOverflow(from2, len, -v, true, Short.MIN_VALUE).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final short apply(int x$4) {
                    return (short)x$4;
                }
            }) : (first == '+' ? this.stepToOverflow(from2, len, 0, true, Short.MIN_VALUE).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final short apply(int x$5) {
                    return (short)x$5;
                }
            }) : (first == '-' ? this.stepToOverflow(from2, len, 0, false, Short.MIN_VALUE).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final short apply(int x$6) {
                    return (short)x$6;
                }
            }) : None$.MODULE$)));
        }
        return object;
    }

    public final Option<Object> parseInt(String from2) {
        Object object;
        int len = from2.length();
        if (len == 0) {
            object = None$.MODULE$;
        } else {
            char first = from2.charAt(0);
            int v = this.decValue(first);
            object = len == 1 ? (v > -1 ? new Some((Object)BoxesRunTime.boxToInteger((int)v)) : None$.MODULE$) : (v > -1 ? this.step$1(1, -v, true, from2, len) : (first == '+' ? this.step$1(1, 0, true, from2, len) : (first == '-' ? this.step$1(1, 0, false, from2, len) : None$.MODULE$)));
        }
        return object;
    }

    public final Option<Object> parseLong(String from2) {
        Object object;
        int len = from2.length();
        if (len == 0) {
            object = None$.MODULE$;
        } else {
            char first = from2.charAt(0);
            long v = this.decValue(first);
            object = len == 1 ? (v > -1L ? new Some((Object)BoxesRunTime.boxToLong((long)v)) : None$.MODULE$) : (v > -1L ? this.step$2(1, -v, true, from2, len) : (first == '+' ? this.step$2(1, 0L, true, from2, len) : (first == '-' ? this.step$2(1, 0L, false, from2, len) : None$.MODULE$)));
        }
        return object;
    }

    public final boolean checkFloatFormat(String format) {
        boolean bl;
        int unspacedStart = new StringOps(Predef$.MODULE$.augmentString(format)).indexWhere((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char ch) {
                return ch > ' ';
            }
        });
        int unspacedEnd = new StringOps(Predef$.MODULE$.augmentString(format)).lastIndexWhere((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char ch) {
                return ch > ' ';
            }
        }) + 1;
        if (unspacedStart == -1 || unspacedStart >= unspacedEnd || unspacedEnd <= 0) {
            bl = false;
        } else {
            int unsigned;
            char startchar = format.charAt(unspacedStart);
            int n = unsigned = startchar == '-' || startchar == '+' ? unspacedStart + 1 : unspacedStart;
            if (unsigned >= unspacedEnd) {
                bl = false;
            } else if (format.charAt(unsigned) == 'N') {
                String string = format.substring(unsigned, unspacedEnd);
                String string2 = "NaN";
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            } else if (format.charAt(unsigned) == 'I') {
                String string = format.substring(unsigned, unspacedEnd);
                String string3 = "Infinity";
                bl = !(string != null ? !string.equals(string3) : string3 != null);
            } else {
                char endchar = format.charAt(unspacedEnd - 1);
                int desuffixed = endchar == 'f' || endchar == 'F' || endchar == 'd' || endchar == 'D' ? unspacedEnd - 1 : unspacedEnd;
                int len = desuffixed - unsigned;
                bl = len <= 0 ? false : (len >= 2 && (format.charAt(unsigned + 1) == 'x' || format.charAt(unsigned + 1) == 'X') ? format.charAt(unsigned) == '0' && this.isHexFloatLiteral$1(unsigned + 2, desuffixed, format) : this.isDecFloatLiteral$1(unsigned, desuffixed, format));
            }
        }
        return bl;
    }

    public Option<Object> parseFloat(String from2) {
        return this.checkFloatFormat(from2) ? new Some((Object)BoxesRunTime.boxToFloat((float)Float.parseFloat(from2))) : None$.MODULE$;
    }

    public Option<Object> parseDouble(String from2) {
        return this.checkFloatFormat(from2) ? new Some((Object)BoxesRunTime.boxToDouble((double)Double.parseDouble(from2))) : None$.MODULE$;
    }

    private final Option rec$1(int i, int agg, String from$3, int len$1, boolean isPositive$1, int min$1) {
        while (true) {
            int digit;
            block7: {
                Object object;
                block5: {
                    block6: {
                        block4: {
                            if (agg >= min$1) break block4;
                            object = None$.MODULE$;
                            break block5;
                        }
                        if (i != len$1) break block6;
                        object = isPositive$1 ? (agg == min$1 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)(-agg)))) : new Some((Object)BoxesRunTime.boxToInteger((int)agg));
                        break block5;
                    }
                    digit = this.decValue(from$3.charAt(i));
                    if (digit != -1) break block7;
                    object = None$.MODULE$;
                }
                return object;
            }
            agg = agg * 10 - digit;
            ++i;
        }
    }

    private final Option step$1(int i, int agg, boolean isPositive, String from$1, int len$2) {
        while (true) {
            int digit;
            block7: {
                Object object;
                block5: {
                    block6: {
                        block4: {
                            if (i != len$2) break block4;
                            object = isPositive ? (agg == Integer.MIN_VALUE ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)(-agg)))) : new Some((Object)BoxesRunTime.boxToInteger((int)agg));
                            break block5;
                        }
                        if (agg >= -214748364) break block6;
                        object = None$.MODULE$;
                        break block5;
                    }
                    digit = this.decValue(from$1.charAt(i));
                    if (digit != -1 && (agg != -214748364 || digit != 9)) break block7;
                    object = None$.MODULE$;
                }
                return object;
            }
            agg = agg * 10 - digit;
            ++i;
        }
    }

    private final Option step$2(int i, long agg, boolean isPositive, String from$2, int len$3) {
        while (true) {
            int digit;
            block7: {
                Object object;
                block5: {
                    block6: {
                        block4: {
                            if (i != len$3) break block4;
                            object = isPositive && agg == Long.MIN_VALUE ? None$.MODULE$ : (isPositive ? new Some((Object)BoxesRunTime.boxToLong((long)(-agg))) : new Some((Object)BoxesRunTime.boxToLong((long)agg)));
                            break block5;
                        }
                        if (agg >= -922337203685477580L) break block6;
                        object = None$.MODULE$;
                        break block5;
                    }
                    digit = this.decValue(from$2.charAt(i));
                    if (digit != -1 && (agg != -922337203685477580L || digit != 9)) break block7;
                    object = None$.MODULE$;
                }
                return object;
            }
            agg = agg * 10L - (long)digit;
            ++i;
        }
    }

    private final boolean rec$2(int i, String format$1, int end$1, Function1 pred$1) {
        boolean bl;
        block2: {
            while (true) {
                if (i >= end$1) {
                    bl = true;
                    break block2;
                }
                if (!BoxesRunTime.unboxToBoolean((Object)pred$1.apply((Object)BoxesRunTime.boxToCharacter((char)format$1.charAt(i))))) break;
                ++i;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean forAllBetween$1(int start, int end, Function1 pred, String format$1) {
        return this.rec$2(start, format$1, end, pred);
    }

    private final int rec$3(int i, String format$1, Function1 predicate$1, int until$1) {
        while (i < until$1 && BoxesRunTime.unboxToBoolean((Object)predicate$1.apply((Object)BoxesRunTime.boxToCharacter((char)format$1.charAt(i))))) {
            ++i;
        }
        return i;
    }

    private final int skipIndexWhile$1(Function1 predicate, int from2, int until, String format$1) {
        return this.rec$3(from2, format$1, predicate, until);
    }

    public final boolean scala$collection$compat$StringParsers$$isHexDigit$1(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean prefixOK$1(int startIndex, int endIndex, String format$1) {
        int len = endIndex - startIndex;
        if (len <= 0) return false;
        if (format$1.charAt(startIndex) == '.') {
            if (len <= 1) return false;
            if (!this.forAllBetween$1(startIndex + 1, endIndex, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char ch) {
                    return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isHexDigit$1(ch);
                }
            }, format$1)) return false;
            return true;
        }
        int noLeading = this.skipIndexWhile$1((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char ch) {
                return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isHexDigit$1(ch);
            }
        }, startIndex, endIndex, format$1);
        if (noLeading >= endIndex) return true;
        if (format$1.charAt(noLeading) != '.') return false;
        if (!this.forAllBetween$1(noLeading + 1, endIndex, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char ch) {
                return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isHexDigit$1(ch);
            }
        }, format$1)) return false;
        return true;
    }

    private final boolean postfixOK$1(int startIndex, int endIndex, String format$1) {
        char startchar;
        return startIndex < endIndex && (this.forAllBetween$1(startIndex, endIndex, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char c) {
                return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isDigit(c);
            }
        }, format$1) || ((startchar = format$1.charAt(startIndex)) == '+' || startchar == '-') && endIndex - startIndex > 1 && this.forAllBetween$1(startIndex + 1, endIndex, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char c) {
                return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isDigit(c);
            }
        }, format$1));
    }

    private final boolean isHexFloatLiteral$1(int startIndex, int endIndex, String format$1) {
        int pIndex = new StringOps(Predef$.MODULE$.augmentString(format$1)).indexWhere((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char ch) {
                return ch == 'p' || ch == 'P';
            }
        }, startIndex);
        return pIndex <= endIndex && this.prefixOK$1(startIndex, pIndex, format$1) && this.postfixOK$1(pIndex + 1, endIndex, format$1);
    }

    private final boolean isExp$1(char c) {
        return c == 'e' || c == 'E';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean expOK$1(int startIndex, int endIndex, String format$1) {
        if (startIndex >= endIndex) return false;
        char startChar = format$1.charAt(startIndex);
        if (startChar == '+' || startChar == '-') {
            if (endIndex <= startIndex + 1) return false;
            if (this.skipIndexWhile$1((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char c) {
                    return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isDigit(c);
                }
            }, startIndex + 1, endIndex, format$1) != endIndex) return false;
            return true;
        }
        if (this.skipIndexWhile$1((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char c) {
                return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isDigit(c);
            }
        }, startIndex, endIndex, format$1) != endIndex) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDecFloatLiteral$1(int startIndex, int endIndex, String format$1) {
        char startChar = format$1.charAt(startIndex);
        if (startChar == '.') {
            int noSignificant = this.skipIndexWhile$1((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char c) {
                    return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isDigit(c);
                }
            }, startIndex + 1, endIndex, format$1);
            if (noSignificant <= startIndex + 1) return false;
            if (noSignificant >= endIndex) return true;
            if (!this.isExp$1(format$1.charAt(noSignificant))) return false;
            if (!this.expOK$1(noSignificant + 1, endIndex, format$1)) return false;
            return true;
        }
        if (!this.scala$collection$compat$StringParsers$$isDigit(startChar)) return false;
        int noInt = this.skipIndexWhile$1((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char c) {
                return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isDigit(c);
            }
        }, startIndex, endIndex, format$1);
        if (noInt == endIndex) return true;
        if (format$1.charAt(noInt) == '.') {
            int noSignificant = this.skipIndexWhile$1((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char c) {
                    return StringParsers$.MODULE$.scala$collection$compat$StringParsers$$isDigit(c);
                }
            }, noInt + 1, endIndex, format$1);
            if (noSignificant >= endIndex) return true;
            if (!this.isExp$1(format$1.charAt(noSignificant))) return false;
            if (!this.expOK$1(noSignificant + 1, endIndex, format$1)) return false;
            return true;
        }
        if (!this.isExp$1(format$1.charAt(noInt))) return false;
        if (!this.expOK$1(noInt + 1, endIndex, format$1)) return false;
        return true;
    }

    private StringParsers$() {
        MODULE$ = this;
    }
}

