/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.decorators;

import java.util.Arrays;
import scala.Array$;
import scala.Predef$;
import scala.collection.mutable.BitSet;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m2A!\u0003\u0006\u0001#!Aa\u0003\u0001BC\u0002\u0013Eq\u0003\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u0019\u0011\u0015y\u0002\u0001\"\u0001!\u0011\u0015!\u0003\u0001\"\u0001&\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015q\u0003\u0001\"\u00030\u0011\u0015!\u0004\u0001\"\u00036\u0011\u00159\u0004\u0001\"\u00069\u0005YiU\u000f^1cY\u0016\u0014\u0015\u000e^*fi\u0012+7m\u001c:bi>\u0014(BA\u0006\r\u0003)!WmY8sCR|'o\u001d\u0006\u0003\u001b9\t!bY8mY\u0016\u001cG/[8o\u0015\u0005y\u0011!B:dC2\f7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u00039I!!\u0006\b\u0003\r\u0005s\u0017PU3g\u0003\t\u00117/F\u0001\u0019!\tIB$D\u0001\u001b\u0015\tYB\"A\u0004nkR\f'\r\\3\n\u0005uQ\"A\u0002\"jiN+G/A\u0002cg\u0002\na\u0001P5oSRtDCA\u0011$!\t\u0011\u0003!D\u0001\u000b\u0011\u001512\u00011\u0001\u0019\u00035!C.Z:tI1,7o\u001d\u0013fcR\u0011\u0001D\n\u0005\u0006O\u0011\u0001\r\u0001K\u0001\bg\"Lg\r\u001e\"z!\t\u0019\u0012&\u0003\u0002+\u001d\t\u0019\u0011J\u001c;\u0002'\u0011:'/Z1uKJ$sM]3bi\u0016\u0014H%Z9\u0015\u0005ai\u0003\"B\u0014\u0006\u0001\u0004A\u0013\u0001E:iS\u001a$H*\u001a4u\u0013:\u0004F.Y2f)\t\u00014\u0007\u0005\u0002\u0014c%\u0011!G\u0004\u0002\u0005+:LG\u000fC\u0003(\r\u0001\u0007\u0001&A\ttQ&4GOU5hQRLe\u000e\u00157bG\u0016$\"\u0001\r\u001c\t\u000b\u001d:\u0001\u0019\u0001\u0015\u0002\u001d\u0015t7/\u001e:f\u0007\u0006\u0004\u0018mY5usR\u0011\u0001'\u000f\u0005\u0006u!\u0001\r\u0001K\u0001\u0004S\u0012D\b")
public class MutableBitSetDecorator {
    private final BitSet bs;

    public BitSet bs() {
        return this.bs;
    }

    public BitSet $less$less$eq(int shiftBy) {
        if (this.bs().nwords() != 0 && (this.bs().nwords() != 1 || this.bs().word(0) != 0L)) {
            if (shiftBy > 0) {
                this.shiftLeftInPlace(shiftBy);
            } else if (shiftBy < 0) {
                this.shiftRightInPlace(-shiftBy);
            }
        }
        return this.bs();
    }

    public BitSet $greater$greater$eq(int shiftBy) {
        if (this.bs().nwords() != 0 && (this.bs().nwords() != 1 || this.bs().word(0) != 0L)) {
            if (shiftBy > 0) {
                this.shiftRightInPlace(shiftBy);
            } else if (shiftBy < 0) {
                this.shiftLeftInPlace(-shiftBy);
            }
        }
        return this.bs();
    }

    private void shiftLeftInPlace(int shiftBy) {
        int significantWordCount;
        for (significantWordCount = this.bs().nwords(); significantWordCount > 0 && this.bs().word(significantWordCount - 1) == 0L; --significantWordCount) {
        }
        if (significantWordCount > 0) {
            int bitOffset = shiftBy & 0x3F;
            int wordOffset = shiftBy >>> 6;
            if (bitOffset == 0) {
                int newSize = significantWordCount + wordOffset;
                Predef$.MODULE$.require(newSize <= 0x2000000);
                this.ensureCapacity(newSize);
                System.arraycopy(this.bs().elems(), 0, this.bs().elems(), wordOffset, significantWordCount);
            } else {
                int i;
                int revBitOffset = 64 - bitOffset;
                long extraBits = this.bs().elems()[significantWordCount - 1] >>> revBitOffset;
                int extraWordCount = extraBits == 0L ? 0 : 1;
                int newSize = significantWordCount + wordOffset + extraWordCount;
                Predef$.MODULE$.require(newSize <= 0x2000000);
                this.ensureCapacity(newSize);
                long previous = this.bs().elems()[i];
                for (i = significantWordCount - 1; i > 0; --i) {
                    long current = this.bs().elems()[i - 1];
                    this.bs().elems()[i + wordOffset] = current >>> revBitOffset | previous << bitOffset;
                    previous = current;
                }
                this.bs().elems()[wordOffset] = previous << bitOffset;
                if (extraWordCount != 0) {
                    this.bs().elems()[newSize - 1] = extraBits;
                }
            }
            Arrays.fill(this.bs().elems(), 0, wordOffset, 0L);
            return;
        }
    }

    private void shiftRightInPlace(int shiftBy) {
        int bitOffset = shiftBy & 0x3F;
        if (bitOffset == 0) {
            int wordOffset = shiftBy >>> 6;
            int newSize = this.bs().nwords() - wordOffset;
            if (newSize > 0) {
                System.arraycopy(this.bs().elems(), wordOffset, this.bs().elems(), 0, newSize);
                Arrays.fill(this.bs().elems(), newSize, this.bs().nwords(), 0L);
                return;
            }
            this.bs().clear();
            return;
        }
        int wordOffset = (shiftBy >>> 6) + 1;
        long extraBits = this.bs().elems()[this.bs().nwords() - 1] >>> bitOffset;
        int extraWordCount = extraBits == 0L ? 0 : 1;
        int newSize = this.bs().nwords() - wordOffset + extraWordCount;
        if (newSize > 0) {
            int revBitOffset = 64 - bitOffset;
            long previous = this.bs().elems()[wordOffset - 1];
            for (int i = wordOffset; i < this.bs().nwords(); ++i) {
                long current = this.bs().elems()[i];
                this.bs().elems()[i - wordOffset] = previous >>> bitOffset | current << revBitOffset;
                previous = current;
            }
            if (extraWordCount != 0) {
                this.bs().elems()[newSize - 1] = extraBits;
            }
            Arrays.fill(this.bs().elems(), newSize, this.bs().nwords(), 0L);
            return;
        }
        this.bs().clear();
    }

    public final void ensureCapacity(int idx) {
        Predef$.MODULE$.require(idx < 0x2000000);
        if (idx >= this.bs().nwords()) {
            int newlen = this.bs().nwords();
            while (idx >= newlen) {
                newlen = package$.MODULE$.min(newlen * 2, 0x2000000);
            }
            long[] elems1 = new long[newlen];
            Array$.MODULE$.copy((Object)this.bs().elems(), 0, (Object)elems1, 0, this.bs().nwords());
            this.bs().elems_$eq(elems1);
            return;
        }
    }

    public MutableBitSetDecorator(BitSet bs) {
        this.bs = bs;
    }
}

