/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.io.IOException;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.reflect.io.Directory;
import scala.reflect.io.Path;
import scala.reflect.io.Path$;
import scala.tools.partest.package$;

public final class FileManager$ {
    public static final FileManager$ MODULE$;

    static {
        new FileManager$();
    }

    public File getLogFile(File dir, String fileBase, String kind) {
        return new File(dir, new StringBuilder().append((Object)fileBase).append((Object)"-").append((Object)kind).append((Object)".log").toString());
    }

    public File getLogFile(File file, String kind) {
        File dir = file.getParentFile();
        String fileBase = package$.MODULE$.basename(file.getName());
        return this.getLogFile(dir, fileBase, kind);
    }

    public boolean logFileExists(File file, String kind) {
        return this.getLogFile(file, kind).canRead();
    }

    public boolean overwriteFileWith(File dest, File file) {
        return dest.isFile() && this.copyFile(file, dest);
    }

    public boolean copyFile(File from, File dest) {
        boolean bl;
        if (from.isDirectory()) {
            boolean bl2 = dest.isDirectory();
            Predef$ predef$ = Predef$.MODULE$;
            if (!bl2) {
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"cannot copy directory to file").toString());
            }
            Directory subDir = package$.MODULE$.Path().apply(dest).$div(package$.MODULE$.Directory().apply(Path$.MODULE$.string2path(from.getName())));
            subDir.createDirectory(subDir.createDirectory$default$1(), subDir.createDirectory$default$2());
            Object[] objectArray = from.listFiles();
            Predef$ predef$2 = Predef$.MODULE$;
            bl = new ArrayOps.ofRef(objectArray).toList().forall((Function1)new Serializable(subDir){
                public static final long serialVersionUID = 0L;
                private final Directory subDir$1;

                public final boolean apply(File x$1) {
                    return FileManager$.MODULE$.copyFile(x$1, package$.MODULE$.temporaryPath2File((Path)this.subDir$1));
                }
                {
                    this.subDir$1 = subDir$1;
                }
            });
        } else {
            File to = dest.isDirectory() ? new File(dest, from.getName()) : dest;
            try {
                package$.MODULE$.SFile().apply(Path$.MODULE$.jfile2path(to), package$.MODULE$.codec()).writeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package$.MODULE$.SFile().apply(Path$.MODULE$.jfile2path(from), package$.MODULE$.codec()).slurp()}));
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public void mapFile(File file, Function1<String, String> replace) {
        scala.reflect.io.File f = package$.MODULE$.SFile().apply(Path$.MODULE$.jfile2path(file), package$.MODULE$.codec());
        f.printlnAll((Seq)f.lines().toList().map(replace, List$.MODULE$.canBuildFrom()));
    }

    public Iterator<scala.reflect.io.File> jarsWithPrefix(Directory dir, String name) {
        return dir.files().filter((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(scala.reflect.io.File f) {
                return f.hasExtension("jar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])) && f.name().startsWith(this.name$1);
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    public Iterator<Directory> dirsWithPrefix(Directory dir, String name) {
        return dir.dirs().filter((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$2;

            public final boolean apply(Directory x$2) {
                return x$2.name().startsWith(this.name$2);
            }
            {
                this.name$2 = name$2;
            }
        });
    }

    public String joinPaths(List<Path> paths) {
        return package$.MODULE$.ClassPath().join((Seq)((SeqLike)paths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$3) {
                return package$.MODULE$.temporaryPath2File(x$3).getAbsolutePath();
            }
        }, List$.MODULE$.canBuildFrom())).distinct());
    }

    public String compareFiles(File original, File revised) {
        return this.compareContents((Seq<String>)Source$.MODULE$.fromFile(original, package$.MODULE$.codec()).getLines().toSeq(), (Seq<String>)Source$.MODULE$.fromFile(revised, package$.MODULE$.codec()).getLines().toSeq(), original.getName(), revised.getName());
    }

    public String compareContents(Seq<String> original, Seq<String> revised, String originalName, String revisedName) {
        Patch diff = DiffUtils.diff((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava()), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(revised).asJava()));
        return diff.getDeltas().isEmpty() ? "" : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(DiffUtils.generateUnifiedDiff((String)originalName, (String)revisedName, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava()), (Patch)diff, (int)1)).asScala()).mkString("\n");
    }

    public String compareContents$default$3() {
        return "a";
    }

    public String compareContents$default$4() {
        return "b";
    }

    private FileManager$() {
        MODULE$ = this;
    }
}

