/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.tools.partest.TestState;
import scala.tools.partest.nest.Colors;
import scala.tools.partest.nest.ConsoleRunnerSpec$;
import scala.tools.partest.nest.NestUI$;

public final class NestUI$ {
    public static final NestUI$ MODULE$;
    private final AtomicInteger testNum;
    private volatile String testNumberFmt;
    private boolean colorEnabled;
    private final Colors color;
    private final int NONE;
    private final int SOME;
    private final int MANY;
    private String _outline;
    private String _success;
    private String _failure;
    private String _warning;
    private String _default;
    private int dotCount;
    private final int DotWidth;
    private boolean _verbose;
    private boolean _debug;
    private boolean _terse;
    private boolean _diff;

    static {
        new NestUI$();
    }

    private AtomicInteger testNum() {
        return this.testNum;
    }

    private String testNumberFmt() {
        return this.testNumberFmt;
    }

    private void testNumberFmt_$eq(String x$1) {
        this.testNumberFmt = x$1;
    }

    private String testNumber() {
        String string = this.testNumberFmt();
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.testNum().getAndIncrement())}));
    }

    public void resetTestNumber(int max) {
        this.testNum().set(1);
        int width = max > 0 ? ((Object)BoxesRunTime.boxToInteger((int)max)).toString().length() : 3;
        this.testNumberFmt_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", "d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)width)})));
    }

    public int resetTestNumber$default$1() {
        return -1;
    }

    public boolean colorEnabled() {
        return this.colorEnabled;
    }

    public void colorEnabled_$eq(boolean x$1) {
        this.colorEnabled = x$1;
    }

    public Colors color() {
        return this.color;
    }

    public int NONE() {
        return this.NONE;
    }

    public int SOME() {
        return this.SOME;
    }

    public int MANY() {
        return this.MANY;
    }

    private String _outline() {
        return this._outline;
    }

    private void _outline_$eq(String x$1) {
        this._outline = x$1;
    }

    private String _success() {
        return this._success;
    }

    private void _success_$eq(String x$1) {
        this._success = x$1;
    }

    private String _failure() {
        return this._failure;
    }

    private void _failure_$eq(String x$1) {
        this._failure = x$1;
    }

    private String _warning() {
        return this._warning;
    }

    private void _warning_$eq(String x$1) {
        this._warning = x$1;
    }

    private String _default() {
        return this._default;
    }

    private void _default_$eq(String x$1) {
        this._default = x$1;
    }

    private int dotCount() {
        return this.dotCount;
    }

    private void dotCount_$eq(int x$1) {
        this.dotCount = x$1;
    }

    private int DotWidth() {
        return this.DotWidth;
    }

    public void leftFlush() {
        if (this.dotCount() != 0) {
            this.normal("\n");
            this.dotCount_$eq(0);
        }
    }

    public String statusLine(TestState state) {
        Function1<String, String> function1 = state instanceof TestState.Skip ? this.color().yellow() : (state instanceof TestState.Updated ? this.color().cyan() : (state.isOk() ? this.color().green() : this.color().red()));
        String word = (String)this.color().bold().apply(function1.apply((Object)state.shortStatus()));
        String arg$2 = this.testNumber();
        String arg$3 = state.testIdent();
        String arg$4 = state.reasonString();
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps("%s %s - %-40s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word, arg$2, arg$3, arg$4}));
    }

    public void reportTest(TestState state) {
        if (this._terse() && state.isOk()) {
            if (this.dotCount() >= this.DotWidth()) {
                this.outline("\n.");
                this.dotCount_$eq(1);
            } else {
                this.outline(".");
                this.dotCount_$eq(this.dotCount() + 1);
            }
        } else {
            this.echo(this.statusLine(state));
            if (!state.isOk() && this._diff()) {
                String differ = new StringBuilder().append((Object)((String)this.color().bold().apply(this.color().red().apply((Object)"% ")))).append((Object)"diff ").toString();
                Object[] objectArray = state.transcript();
                Predef$ predef$ = Predef$.MODULE$;
                Option option = new ArrayOps.ofRef(objectArray).find((Function1)new Serializable(differ){
                    public static final long serialVersionUID = 0L;
                    private final String differ$1;

                    public final boolean apply(String x$1) {
                        return x$1.startsWith(this.differ$1);
                    }
                    {
                        this.differ$1 = differ$1;
                    }
                });
                if (!option.isEmpty()) {
                    String string = (String)option.get();
                    MODULE$.echo(string);
                }
            }
        }
    }

    public synchronized void echo(String message) {
        this.leftFlush();
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)message).append((Object)"\n").toString());
    }

    public void chatty(String msg) {
        if (this.isVerbose()) {
            this.echo(msg);
        }
    }

    public void echoSkipped(String msg) {
        this.echo((String)this.color().yellow().apply((Object)msg));
    }

    public void echoPassed(String msg) {
        this.echo((String)this.color().bold().apply(this.color().green().apply((Object)msg)));
    }

    public void echoFailed(String msg) {
        this.echo((String)this.color().bold().apply(this.color().red().apply((Object)msg)));
    }

    public void echoMixed(String msg) {
        this.echo((String)this.color().bold().apply(this.color().yellow().apply((Object)msg)));
    }

    public void echoWarning(String msg) {
        this.echo((String)this.color().bold().apply(this.color().red().apply((Object)msg)));
    }

    public void initialize(int number) {
        if (this.MANY() == number) {
            this._outline_$eq("\u001b[1m\u001b[30m");
            this._success_$eq("\u001b[1m\u001b[32m");
            this._failure_$eq("\u001b[1m\u001b[31m");
            this._warning_$eq("\u001b[1m\u001b[33m");
            this._default_$eq("\u001b[0m");
        } else if (this.SOME() == number) {
            this._outline_$eq("\u001b[1m\u001b[30m");
            this._success_$eq("\u001b[0m");
            this._failure_$eq("\u001b[1m\u001b[30m");
            this._warning_$eq("\u001b[1m\u001b[30m");
            this._default_$eq("\u001b[0m");
        }
    }

    public void outline(String msg) {
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)this._outline()).append((Object)msg).append((Object)this._default()).toString());
    }

    public synchronized void outline(String msg, PrintWriter wr) {
        wr.print(new StringBuilder().append((Object)this._outline()).append((Object)msg).append((Object)this._default()).toString());
    }

    public void success(String msg) {
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)this._success()).append((Object)msg).append((Object)this._default()).toString());
    }

    public synchronized void success(String msg, PrintWriter wr) {
        wr.print(new StringBuilder().append((Object)this._success()).append((Object)msg).append((Object)this._default()).toString());
    }

    public void failure(String msg) {
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)this._failure()).append((Object)msg).append((Object)this._default()).toString());
    }

    public synchronized void failure(String msg, PrintWriter wr) {
        wr.print(new StringBuilder().append((Object)this._failure()).append((Object)msg).append((Object)this._default()).toString());
    }

    public void warning(String msg) {
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)this._warning()).append((Object)msg).append((Object)this._default()).toString());
    }

    public void normal(String msg) {
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)this._default()).append((Object)msg).toString());
    }

    public synchronized void normal(String msg, PrintWriter wr) {
        wr.print(new StringBuilder().append((Object)this._default()).append((Object)msg).toString());
    }

    public void usage() {
        Predef$.MODULE$.println((Object)ConsoleRunnerSpec$.MODULE$.programInfo().usage());
        Predef$.MODULE$.println((Object)ConsoleRunnerSpec$.MODULE$.helpMsg());
        throw package$.MODULE$.exit(1);
    }

    public boolean _verbose() {
        return this._verbose;
    }

    public void _verbose_$eq(boolean x$1) {
        this._verbose = x$1;
    }

    public boolean _debug() {
        return this._debug;
    }

    public void _debug_$eq(boolean x$1) {
        this._debug = x$1;
    }

    public boolean _terse() {
        return this._terse;
    }

    public void _terse_$eq(boolean x$1) {
        this._terse = x$1;
    }

    public boolean _diff() {
        return this._diff;
    }

    public void _diff_$eq(boolean x$1) {
        this._diff = x$1;
    }

    public boolean isVerbose() {
        return this._verbose();
    }

    public boolean isDebug() {
        return this._debug();
    }

    public boolean isTerse() {
        return this._terse();
    }

    public boolean isDiffy() {
        return this._diff();
    }

    public void setVerbose() {
        this._verbose_$eq(true);
    }

    public void setDebug() {
        this._debug_$eq(true);
    }

    public void setTerse() {
        this._terse_$eq(true);
    }

    public void setDiffOnFail() {
        this._diff_$eq(true);
    }

    public void verbose(String msg) {
        if (this.isVerbose()) {
            System.err.println(msg);
        }
    }

    public void debug(String msg) {
        if (this.isDebug()) {
            System.err.println(msg);
        }
    }

    private NestUI$() {
        MODULE$ = this;
        this.testNum = new AtomicInteger(1);
        this.testNumberFmt = "%3d";
        this.colorEnabled = package$.MODULE$.props().contains("partest.colors");
        this.color = new Colors((Function0<Object>)new anonfun.1());
        this.NONE = 0;
        this.SOME = 1;
        this.MANY = 2;
        this._outline = "";
        this._success = "";
        this._failure = "";
        this._warning = "";
        this._default = "";
        this.dotCount = 0;
        this.DotWidth = 72;
        this._verbose = false;
        this._debug = false;
        this._terse = false;
        this._diff = false;
    }
}

