/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.include.sax;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;
import scala.xml.include.CircularIncludeException;
import scala.xml.include.UnavailableResourceException;
import scala.xml.include.sax.EncodingHeuristics$;
import scala.xml.package$;

public class XIncludeFilter
extends XMLFilterImpl {
    private final Stack<URL> bases = new Stack();
    private final Stack<Locator> locators = new Stack();
    private int level = 0;
    private int depth = 0;
    private boolean atRoot = false;

    public final String XINCLUDE_NAMESPACE() {
        return "http://www.w3.org/2001/XInclude";
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locators.push(locator);
        String base = locator.getSystemId();
        try {
            this.bases.push(new URL(base));
        }
        catch (MalformedURLException e) {
            throw new UnsupportedOperationException("Unrecognized SYSTEM ID: " + base);
        }
        super.setDocumentLocator(locator);
    }

    public boolean insideIncludeElement() {
        return this.level != 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts1) {
        Attributes atts = atts1;
        if (this.level == 0) {
            URL parentBase;
            String base = atts.getValue("http://www.w3.org/XML/1998/namespace", "base");
            URL currentBase = parentBase = this.bases.peek();
            if (base != null) {
                try {
                    currentBase = new URL(parentBase, base);
                }
                catch (MalformedURLException e) {
                    throw new SAXException("Malformed base URL: " + currentBase, e);
                }
            }
            this.bases.push(currentBase);
            if (uri.equals("http://www.w3.org/2001/XInclude") && localName.equals("include")) {
                String href = atts.getValue("href");
                if (href == null) {
                    throw new SAXException("Missing href attribute");
                }
                String parse = atts.getValue("parse");
                if (parse == null) {
                    parse = "xml";
                }
                if (parse.equals("text")) {
                    String encoding = atts.getValue("encoding");
                    this.includeTextDocument(href, encoding);
                } else if (parse.equals("xml")) {
                    this.includeXMLDocument(href);
                } else {
                    throw new SAXException("Illegal value for parse attribute: " + parse);
                }
                ++this.level;
            } else {
                if (this.atRoot) {
                    AttributesImpl attsImpl = new AttributesImpl(atts);
                    attsImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "base", "xml:base", "CDATA", currentBase.toExternalForm());
                    atts = attsImpl;
                    this.atRoot = false;
                }
                super.startElement(uri, localName, qName, atts);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (uri.equals("http://www.w3.org/2001/XInclude") && localName.equals("include")) {
            --this.level;
        } else if (this.level == 0) {
            this.bases.pop();
            super.endElement(uri, localName, qName);
        }
    }

    @Override
    public void startDocument() {
        this.level = 0;
        if (this.depth == 0) {
            super.startDocument();
        }
        ++this.depth;
    }

    @Override
    public void endDocument() {
        this.locators.pop();
        this.bases.pop();
        --this.depth;
        if (this.depth == 0) {
            super.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.level == 0) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (this.level == 0) {
            super.endPrefixMapping(prefix);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.level == 0) {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.level == 0) {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        if (this.level == 0) {
            super.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) {
        if (this.level == 0) {
            super.skippedEntity(name);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getLocation() {
        void var1_1;
        String locationString = "";
        Locator locator = this.locators.peek();
        String publicID = "";
        String systemID = "";
        int column = -1;
        int line = -1;
        if (locator != null) {
            publicID = locator.getPublicId();
            systemID = locator.getSystemId();
            line = locator.getLineNumber();
            column = locator.getColumnNumber();
        }
        locationString = " in document included from " + publicID + " at " + systemID + " at line " + line + ", column " + column;
        return var1_1;
    }

    private void includeTextDocument(String url, String encoding1) {
        String encoding = encoding1;
        if (encoding == null || encoding.trim().equals("")) {
            encoding = "UTF-8";
        }
        URL source = null;
        try {
            URL base = this.bases.peek();
            source = new URL(base, url);
        }
        catch (MalformedURLException e) {
            UnavailableResourceException ex = new UnavailableResourceException("Unresolvable URL " + url + this.getLocation());
            ex.setRootCause(e);
            throw new SAXException("Unresolvable URL " + url + this.getLocation(), ex);
        }
        try {
            URLConnection uc = source.openConnection();
            BufferedInputStream in = new BufferedInputStream(uc.getInputStream());
            String encodingFromHeader = uc.getContentEncoding();
            String contentType = uc.getContentType();
            if (encodingFromHeader != null) {
                encoding = encodingFromHeader;
            } else if (contentType != null && ((contentType = contentType.toLowerCase()).equals("text/xml") || contentType.equals("application/xml") || contentType.startsWith("text/") && contentType.endsWith("+xml") || contentType.startsWith("application/") && contentType.endsWith("+xml"))) {
                encoding = EncodingHeuristics$.MODULE$.readEncodingFromStream(in);
            }
            InputStreamReader reader = new InputStreamReader((InputStream)in, encoding);
            char[] c = new char[1024];
            int charsRead = 0;
            while (true) {
                if ((charsRead = reader.read(c, 0, 1024)) > 0) {
                    this.characters(c, 0, charsRead);
                }
                if (charsRead != -1) {
                    continue;
                }
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SAXException("Unsupported encoding: " + encoding + this.getLocation(), e);
        }
        catch (IOException e) {
            throw new SAXException("Document not found: " + source.toExternalForm() + this.getLocation(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void includeXMLDocument(String url) {
        try {
            v0 = new URL(this.bases.peek(), url);
        }
        catch (MalformedURLException e) {
            ex = new UnavailableResourceException("Unresolvable URL " + url + this.getLocation());
            ex.setRootCause(e);
            throw new SAXException("Unresolvable URL " + url + this.getLocation(), ex);
        }
        source = v0;
        try {
            v1 = XMLReaderFactory.createXMLReader();
            ** GOTO lbl-1000
        }
        catch (SAXException e) {
            try {
                v1 = XMLReaderFactory.createXMLReader(package$.MODULE$.XercesClassName());
            }
            catch (SAXException v2) {
                System.err.println("Could not find an XML parser");
                return;
            }
            try lbl-1000:
            // 2 sources

            {
                parser = v1;
                parser.setContentHandler(this);
                resolver = this.getEntityResolver();
                if (resolver != null) {
                    parser.setEntityResolver(resolver);
                }
                previousLevel = this.level;
                this.level = 0;
                if (this.bases.contains(source)) {
                    throw new SAXException("Circular XInclude Reference", new CircularIncludeException("Circular XInclude Reference to " + source + this.getLocation()));
                }
                this.bases.push(source);
                this.atRoot = true;
                parser.parse(source.toExternalForm());
                this.level = previousLevel;
                this.bases.pop();
            }
            catch (IOException e) {
                throw new SAXException("Document not found: " + source.toExternalForm() + this.getLocation(), e);
            }
        }
    }
}

