/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.Range;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.HashTable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;

public abstract class FlatHashTable$class {
    private static final boolean tableDebug(FlatHashTable $this) {
        return false;
    }

    public static int capacity(FlatHashTable $this, int expectedSize) {
        return expectedSize == 0 ? 1 : HashTable$.MODULE$.powerOfTwo(expectedSize);
    }

    private static int initialCapacity(FlatHashTable $this) {
        return $this.capacity(FlatHashTable$.MODULE$.initialSize());
    }

    public static int randomSeed(FlatHashTable $this) {
        return FlatHashTable$.MODULE$.seedGenerator().get().nextInt();
    }

    public static int tableSizeSeed(FlatHashTable $this) {
        return Integer.bitCount($this.table().length - 1);
    }

    public static void init(FlatHashTable $this, ObjectInputStream in, Function1 f) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size2 = in.readInt();
        $this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size2 >= 0);
        $this.table_$eq(new Object[$this.capacity(FlatHashTable$.MODULE$.sizeForThreshold(size2, $this._loadFactor()))]);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), Predef$.MODULE$.refArrayOps($this.table()).size()));
        $this.seedvalue_$eq(in.readInt());
        boolean smDefined = in.readBoolean();
        if (smDefined) {
            $this.sizeMapInit($this.table().length);
        } else {
            $this.sizemap_$eq(null);
        }
        for (int index2 = 0; index2 < size2; ++index2) {
            Object elem2 = in.readObject();
            f.apply(elem2);
            $this.addEntry(elem2);
        }
    }

    public static void serializeTo(FlatHashTable $this, ObjectOutputStream out$1) {
        out$1.defaultWriteObject();
        out$1.writeInt($this._loadFactor());
        out$1.writeInt($this.tableSize());
        out$1.writeInt($this.seedvalue());
        out$1.writeBoolean($this.isSizeMapDefined());
        $this.iterator().foreach(new Serializable($this, out$1){
            public static final long serialVersionUID;
            private final ObjectOutputStream out$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object object) {
                this.out$1.writeObject(object);
            }
            {
                this.out$1 = flatHashTable;
            }
        });
    }

    public static Option findEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (entry != null && !(entry == elem2 ? true : (entry == null ? false : (entry instanceof Number ? BoxesRunTime.equalsNumObject((Number)entry, elem2) : (entry instanceof Character ? BoxesRunTime.equalsCharObject((Character)entry, elem2) : entry.equals(elem2)))))) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return entry == null ? None$.MODULE$ : new Some<Object>(entry);
    }

    public static boolean containsEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (entry != null && !(entry == elem2 ? true : (entry == null ? false : (entry instanceof Number ? BoxesRunTime.equalsNumObject((Number)entry, elem2) : (entry instanceof Character ? BoxesRunTime.equalsCharObject((Character)entry, elem2) : entry.equals(elem2)))))) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return entry != null;
    }

    public static boolean addEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (true) {
            if (entry == null) {
                $this.table()[h] = elem2;
                $this.tableSize_$eq($this.tableSize() + 1);
                $this.nnSizeMapAdd(h);
                if ($this.tableSize() >= $this.threshold()) {
                    FlatHashTable$class.growTable($this);
                }
                return true;
            }
            if (entry == elem2 ? true : (entry == null ? false : (entry instanceof Number ? BoxesRunTime.equalsNumObject((Number)entry, elem2) : (entry instanceof Character ? BoxesRunTime.equalsCharObject((Character)entry, elem2) : entry.equals(elem2))))) {
                return false;
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    public static Option removeEntry(FlatHashTable $this, Object elem2) {
        if (FlatHashTable$class.tableDebug($this)) {
            FlatHashTable$class.checkConsistent($this);
        }
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (entry != null) {
            if (entry == elem2 ? true : (entry == null ? false : (entry instanceof Number ? BoxesRunTime.equalsNumObject((Number)entry, elem2) : (entry instanceof Character ? BoxesRunTime.equalsCharObject((Character)entry, elem2) : entry.equals(elem2))))) {
                int h0 = h;
                int h1 = (h + 1) % $this.table().length;
                while (true) {
                    if ($this.table()[h1] == null) {
                        $this.table()[h0] = null;
                        $this.tableSize_$eq($this.tableSize() - 1);
                        $this.nnSizeMapRemove(h0);
                        if (FlatHashTable$class.tableDebug($this)) {
                            FlatHashTable$class.checkConsistent($this);
                        }
                        return new Some<Object>(entry);
                    }
                    int h2 = $this.index($this.elemHashCode($this.table()[h1]));
                    if (h2 != h1 && FlatHashTable$class.precedes$1($this, h2, h0)) {
                        $this.table()[h0] = $this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % $this.table().length;
                }
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return None$.MODULE$;
    }

    public static Iterator iterator(FlatHashTable $this) {
        return new AbstractIterator<A>($this){
            private int i;
            private final FlatHashTable $outer;

            private int i() {
                return this.i;
            }

            private void i_$eq(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                while (this.i() < this.$outer.table().length && this.$outer.table()[this.i()] == null) {
                    this.i_$eq(this.i() + 1);
                }
                return this.i() < this.$outer.table().length;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.$outer.table()[this.i() - 1];
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return (A)object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i = 0;
            }
        };
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset($this.table().length);
        $this.seedvalue_$eq($this.tableSizeSeed());
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), $this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (entry == null) continue;
            $this.addEntry(entry);
        }
        if (FlatHashTable$class.tableDebug($this)) {
            FlatHashTable$class.checkConsistent($this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkConsistent(FlatHashTable $this) {
        Serializable serializable2;
        int n = $this.table().length;
        int n2 = new RichInt(0).self();
        Range range2 = new Range(n2, n, 1);
        if (range2.validateRangeBoundaries((Function1<Object, Object>)((Object)(serializable2 = new Serializable($this){
            public static final long serialVersionUID;
            private final FlatHashTable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcVI$sp(int v1$1) {
                void message1;
                block3: {
                    block2: {
                        if (this.$outer.table()[v1$1] == null || this.$outer.containsEntry(this.$outer.table()[v1$1])) break block2;
                        Serializable serializable2 = new Serializable(this, v1$1){
                            public static final long serialVersionUID;
                            private final FlatHashTable$.anonfun.checkConsistent.1 $outer;
                            private final int v1$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append(this.v1$1).append((Object)" ").append(this.$outer.scala$collection$mutable$FlatHashTable$$anonfun$$$outer().table()[this.v1$1]).append((Object)" ").append((Object)Predef$.MODULE$.refArrayOps(this.$outer.scala$collection$mutable$FlatHashTable$$anonfun$$$outer().table()).mkString()).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.v1$1 = n;
                            }
                        };
                        if (!false) break block3;
                    }
                    return;
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)message1.apply()).toString());
            }

            public FlatHashTable scala$collection$mutable$FlatHashTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })))) {
            void $inlThis1;
            int terminal1 = $inlThis1.terminalElement();
            int step1 = $inlThis1.step();
            for (int i1 = $inlThis1.start(); i1 != terminal1; i1 += step1) {
                void f1;
                f1.apply$mcVI$sp(i1);
            }
        }
    }

    public static void nnSizeMapAdd(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int p = h >> $this.sizeMapBucketBitSize();
            int[] nArray = $this.sizemap();
            nArray[p] = nArray[p] + 1;
        }
    }

    public static void nnSizeMapRemove(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
        }
    }

    public static void nnSizeMapReset(FlatHashTable $this, int tableLength) {
        if ($this.sizemap() != null) {
            int nsize = $this.calcSizeMapSize(tableLength);
            if ($this.sizemap().length != nsize) {
                $this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill($this.sizemap(), 0);
            }
        }
    }

    public static final int totalSizeMapBuckets(FlatHashTable $this) {
        return ($this.table().length - 1) / $this.sizeMapBucketSize() + 1;
    }

    public static int calcSizeMapSize(FlatHashTable $this, int tableLength) {
        return (tableLength >> $this.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit(FlatHashTable $this, int tableLength) {
        $this.sizemap_$eq(new int[$this.calcSizeMapSize(tableLength)]);
    }

    public static void sizeMapInitAndRebuild(FlatHashTable $this) {
        $this.sizeMapInit($this.table().length);
        int totalbuckets = $this.totalSizeMapBuckets();
        int tableidx = 0;
        Object[] tbl = $this.table();
        int tableuntil = Predef$.MODULE$.intWrapper($this.sizeMapBucketSize()).min(tbl.length);
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsz = 0;
            while (tableidx < tableuntil) {
                if (tbl[tableidx] != null) {
                    ++currbucketsz;
                }
                ++tableidx;
            }
            $this.sizemap()[bucketidx] = currbucketsz;
            tableuntil += $this.sizeMapBucketSize();
        }
    }

    public static void printSizeMap(FlatHashTable $this) {
        Predef$.MODULE$.println(Predef$.MODULE$.intArrayOps($this.sizemap()).mkString("szmap: [", ", ", "]"));
    }

    public static void printContents(FlatHashTable $this) {
        Predef$.MODULE$.println(Predef$.MODULE$.refArrayOps($this.table()).mkString("[", ", ", "]"));
    }

    public static void sizeMapDisable(FlatHashTable $this) {
        $this.sizemap_$eq(null);
    }

    public static boolean isSizeMapDefined(FlatHashTable $this) {
        return $this.sizemap() != null;
    }

    public static boolean alwaysInitSizeMap(FlatHashTable $this) {
        return false;
    }

    public static final int index(FlatHashTable $this, int hcode) {
        int improved = $this.improve(hcode, $this.seedvalue());
        int ones = $this.table().length - 1;
        return improved >>> 32 - Integer.bitCount(ones) & ones;
    }

    public static void clearTable(FlatHashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset($this.table().length);
    }

    public static FlatHashTable.Contents hashTableContents(FlatHashTable $this) {
        return new FlatHashTable.Contents($this._loadFactor(), $this.table(), $this.tableSize(), $this.threshold(), $this.seedvalue(), $this.sizemap());
    }

    public static void initWithContents(FlatHashTable $this, FlatHashTable.Contents c) {
        if (c != null) {
            $this._loadFactor_$eq(c.loadFactor());
            $this.table_$eq(c.table());
            $this.tableSize_$eq(c.tableSize());
            $this.threshold_$eq(c.threshold());
            $this.seedvalue_$eq(c.seedvalue());
            $this.sizemap_$eq(c.sizemap());
        }
        if ($this.alwaysInitSizeMap() && $this.sizemap() == null) {
            $this.sizeMapInitAndRebuild();
        }
    }

    private static final boolean precedes$1(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    public static void $init$(FlatHashTable $this) {
        $this._loadFactor_$eq(FlatHashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new Object[FlatHashTable$class.initialCapacity($this)]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), FlatHashTable$class.initialCapacity($this)));
        $this.sizemap_$eq(null);
        $this.seedvalue_$eq($this.tableSizeSeed());
    }
}

