/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import scala.concurrent.forkjoin.ForkJoinPool;

public class ForkJoinWorkerThread
extends Thread {
    final ForkJoinPool.WorkQueue workQueue;
    final ForkJoinPool pool;

    protected ForkJoinWorkerThread(ForkJoinPool pool) {
        super(pool.nextWorkerName());
        this.setDaemon(true);
        Thread.UncaughtExceptionHandler ueh = pool.ueh;
        if (ueh != null) {
            this.setUncaughtExceptionHandler(ueh);
        }
        this.pool = pool;
        this.workQueue = new ForkJoinPool.WorkQueue(pool, this, pool.localMode);
        pool.registerWorker(this.workQueue);
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.workQueue.poolIndex;
    }

    protected void onStart() {
    }

    protected void onTermination(Throwable exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Throwable exception = null;
        try {
            this.onStart();
            this.pool.runWorker(this.workQueue);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        finally {
            try {
                this.onTermination(exception);
            }
            catch (Throwable ex) {
                if (exception == null) {
                    exception = ex;
                }
            }
            finally {
                this.pool.deregisterWorker(this, exception);
            }
        }
    }
}

