/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\tes!B\u0001\u0003\u0011\u0003I\u0011A\u0004$j]&$X\rR;sCRLwN\u001c\u0006\u0003\u0007\u0011\t\u0001\u0002Z;sCRLwN\u001c\u0006\u0003\u000b\u0019\t!bY8oGV\u0014(/\u001a8u\u0015\u00059\u0011!B:dC2\f7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o'\rYaB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011q\u0003G\u0007\u0002\r%\u0011\u0011D\u0002\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00067-!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%9QAH\u0006\t\u0004}\tqCR5oSR,G)\u001e:bi&|g.S:Pe\u0012,'/\u001a3\u0011\u0005\u0001\nS\"A\u0006\u0007\u000b\tZ\u0001\u0012A\u0012\u0003/\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]&\u001bxJ\u001d3fe\u0016$7cA\u0011\u000fIA\u0019Q%\f\u0019\u000f\u0005\u0019ZcBA\u0014+\u001b\u0005A#BA\u0015\t\u0003\u0019a$o\\8u}%\tq!\u0003\u0002-\r\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u00180\u0005!y%\u000fZ3sS:<'B\u0001\u0017\u0007!\tQ\u0011G\u0002\u0003\r\u0005\t\u00114CA\u00194!\tQA'\u0003\u00026\u0005\tAA)\u001e:bi&|g\u000e\u0003\u00058c\t\u0015\r\u0011\"\u00019\u0003\u0019aWM\\4uQV\t\u0011\b\u0005\u0002\u0018u%\u00111H\u0002\u0002\u0005\u0019>tw\r\u0003\u0005>c\t\u0005\t\u0015!\u0003:\u0003\u001daWM\\4uQ\u0002B\u0001bP\u0019\u0003\u0006\u0004%\t\u0001Q\u0001\u0005k:LG/F\u0001B!\t\u0011EI\u0004\u0002\u000b\u0007&\u0011AFA\u0005\u0003\u000b\u001a\u0013\u0001\u0002V5nKVs\u0017\u000e\u001e\u0006\u0003Y\tA\u0001\u0002S\u0019\u0003\u0002\u0003\u0006I!Q\u0001\u0006k:LG\u000f\t\u0005\u00067E\"\tA\u0013\u000b\u0004a-c\u0005\"B\u001cJ\u0001\u0004I\u0004\"B J\u0001\u0004\t\u0005B\u0002(2A\u0013%q*A\u0004c_VtG-\u001a3\u0015\u0005A\u001b\u0006CA\fR\u0013\t\u0011fAA\u0004C_>dW-\u00198\t\u000bQk\u0005\u0019A\u001d\u0002\u00075\f\u0007\u0010C\u0003Wc\u0011\u0005\u0001(A\u0004u_:\u000bgn\\:\t\u000ba\u000bD\u0011\u0001\u001d\u0002\u0011Q|W*[2s_NDQAW\u0019\u0005\u0002a\n\u0001\u0002^8NS2d\u0017n\u001d\u0005\u00069F\"\t\u0001O\u0001\ni>\u001cVmY8oINDQAX\u0019\u0005\u0002a\n\u0011\u0002^8NS:,H/Z:\t\u000b\u0001\fD\u0011\u0001\u001d\u0002\u000fQ|\u0007j\\;sg\")!-\rC\u0001q\u00051Ao\u001c#bsNDQ\u0001Z\u0019\u0005\u0002\u0015\fa\u0001^8V]&$HC\u00014j!\t9r-\u0003\u0002i\r\t1Ai\\;cY\u0016DQA[2A\u0002\u0005\u000b\u0011!\u001e\u0005\u0006YF\"\t!\\\u0001\bMJ|WNT8x+\u0005q\u0007C\u0001\u0006p\u0013\t\u0001(A\u0001\u0005EK\u0006$G.\u001b8f\u0011\u0019\u0011\u0018\u0007)C\u0005g\u0006QQO\\5u'R\u0014\u0018N\\4\u0016\u0003Q\u0004\"aD;\n\u0005Y\u0004\"AB*ue&tw\rC\u0003yc\u0011\u0005\u00130\u0001\u0005u_N#(/\u001b8h)\u0005!\b\"B>2\t\u0003a\u0018aB2p[B\f'/\u001a\u000b\u0004{\u0006\u0005\u0001CA\f\u007f\u0013\tyhAA\u0002J]RDa!a\u0001{\u0001\u0004\u0019\u0014!B8uQ\u0016\u0014\b\u0002CA\u0004c\u0001&I!!\u0003\u0002\u000fM\fg-Z!eIR)\u0011(a\u0003\u0002\u0010!9\u0011QBA\u0003\u0001\u0004I\u0014!A1\t\u000f\u0005E\u0011Q\u0001a\u0001s\u0005\t!\r\u0003\u0005\u0002\u0016E\u0002K\u0011BA\f\u0003\r\tG\r\u001a\u000b\u0006a\u0005e\u0011Q\u0004\u0005\b\u00037\t\u0019\u00021\u0001:\u0003-yG\u000f[3s\u0019\u0016tw\r\u001e5\t\u000f\u0005}\u00111\u0003a\u0001\u0003\u0006Iq\u000e\u001e5feVs\u0017\u000e\u001e\u0005\b\u0003G\tD\u0011AA\u0013\u0003\u0015!\u0003\u000f\\;t)\r\u0019\u0014q\u0005\u0005\b\u0003\u0007\t\t\u00031\u00014\u0011\u001d\tY#\rC\u0001\u0003[\ta\u0001J7j]V\u001cHcA\u001a\u00020!9\u00111AA\u0015\u0001\u0004\u0019\u0004bBA\u001ac\u0011\u0005\u0011QG\u0001\u0007IQLW.Z:\u0015\u0007M\n9\u0004C\u0004\u0002:\u0005E\u0002\u0019\u00014\u0002\r\u0019\f7\r^8s\u0011\u001d\ti$\rC\u0001\u0003\u007f\tA\u0001\n3jmR\u00191'!\u0011\t\u000f\u0005\r\u00131\ba\u0001M\u00069A-\u001b<jg>\u0014\b\u0002CA$c\u0001&I!!\u0013\u0002\u00135Lg.^:[KJ|W#\u00014\t\u000f\u0005u\u0012\u0007\"\u0001\u0002NQ\u0019a-a\u0014\t\u000f\u0005\r\u00131\na\u0001g!9\u00111E\u0019\u0005\u0002\u0005MCc\u0001\u0019\u0002V!9\u00111AA)\u0001\u0004\u0001\u0004bBA\u0016c\u0011\u0005\u0011\u0011\f\u000b\u0004a\u0005m\u0003bBA\u0002\u0003/\u0002\r\u0001\r\u0005\b\u0003?\nD\u0011AA1\u0003\u0011\u0001H.^:\u0015\u0007A\n\u0019\u0007C\u0004\u0002\u0004\u0005u\u0003\u0019\u0001\u0019\t\u000f\u0005\u001d\u0014\u0007\"\u0001\u0002j\u0005)Q.\u001b8vgR\u0019\u0001'a\u001b\t\u000f\u0005\r\u0011Q\ra\u0001a!9\u0011qN\u0019\u0005\u0002\u0005E\u0014aA7j]R\u0019\u0001'a\u001d\t\u000f\u0005\r\u0011Q\u000ea\u0001a!1A+\rC\u0001\u0003o\"2\u0001MA=\u0011\u001d\t\u0019!!\u001eA\u0002ABq!!\u00102\t\u0003\ti\bF\u00021\u0003\u007fBq!a\u0011\u0002|\u0001\u0007\u0011\bC\u0004\u00024E\"\t!a!\u0015\u0007A\n)\tC\u0004\u0002:\u0005\u0005\u0005\u0019A\u001d\t\u000f\u0005%\u0015\u0007\"\u0003\u0002\f\u000691/\u00194f\u001bVdG#B\u001d\u0002\u000e\u0006E\u0005bBAH\u0003\u000f\u0003\r!O\u0001\u0003?\u0006Dq!a%\u0002\b\u0002\u0007\u0011(\u0001\u0002`E\"9\u0011qS\u0019\u0005\u0002\u0005e\u0015a\u00013jmR\u0019\u0001'a'\t\u000f\u0005\r\u0013Q\u0013a\u0001s!9\u0011qT\u0019\u0005\u0002\u0005\u0005\u0016aA7vYR\u0019\u0001'a)\t\u000f\u0005e\u0012Q\u0014a\u0001s!9\u0011qU\u0019\u0005\u0002\u0005%\u0016\u0001D;oCJLx\fJ7j]V\u001cX#\u0001\u0019\t\u000f\u00055\u0016\u0007\"\u0002\u00020\u0006A\u0011n\u001d$j]&$X\rF\u0001Q\u0011\u001d\t\u0019,\rC!\u0003k\u000ba!Z9vC2\u001cHc\u0001)\u00028\"A\u00111AAY\u0001\u0004\tI\fE\u0002\u0018\u0003wK1!!0\u0007\u0005\r\te.\u001f\u0005\b\u0003\u0003\fD\u0011IAb\u0003!A\u0017m\u001d5D_\u0012,G#A?\t\rm\tC\u0011AAd)\u0005y\u0002BB>\"\t\u0003\tY\rF\u0003~\u0003\u001b\fy\rC\u0004\u0002\u000e\u0005%\u0007\u0019\u0001\u0019\t\u000f\u0005E\u0011\u0011\u001aa\u0001a!I\u00111[\u0011\u0002\u0002\u0013%\u0011Q[\u0001\fe\u0016\fGMU3t_24X\rF\u0001\u000f\u0011\u001d\tIn\u0003C\u0001\u00037\fQ!\u00199qYf$R\u0001MAo\u0003?DaaNAl\u0001\u0004I\u0004BB \u0002X\u0002\u0007\u0011\tC\u0004\u0002Z.!\t!a9\u0015\u000bA\n)/a:\t\r]\n\t\u000f1\u0001:\u0011\u001dy\u0014\u0011\u001da\u0001\u0003S\u0004B!a;\u0002r:\u0019q#!<\n\u0007\u0005=h!\u0001\u0004Qe\u0016$WMZ\u0005\u0004m\u0006M(bAAx\r!I\u0011q_\u0006C\u0002\u00135\u0011\u0011`\u0001\u0007[\u0006DxL\\:\u0016\u0005\u0005mxBAA\u007f=!yx\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0010\u0002\u0003B\u0001\u0017\u0001\u0006i!a?\u0002\u000f5\f\u0007p\u00188tA!I!QA\u0006C\u0002\u00135!qA\u0001\b[\u0006DxLq[t+\t\u0011Ia\u0004\u0002\u0003\fy9\u0001\u0005rN&HP;\u0010\u0002\u0003B\b\u0017\u0001\u0006iA!\u0003\u0002\u00115\f\u0007p\u0018b6h\u0002B\u0011Ba\u0005\f\u0005\u0004%iA!\u0006\u0002\r5\f\u0007pX7t+\t\u00119b\u0004\u0002\u0003\u001ay1\u0001bY>Q6ZH\u0001B!\b\fA\u00035!qC\u0001\b[\u0006Dx,\\:!\u0011%\u0011\tc\u0003b\u0001\n\u001b\u0011\u0019#A\u0003nCb|6/\u0006\u0002\u0003&=\u0011!q\u0005\u0010\u0006\u0005\u0015\n]\u0010\u0002\u0005\t\u0005WY\u0001\u0015!\u0004\u0003&\u00051Q.\u0019=`g\u0002B\u0011Ba\f\f\u0005\u0004%iA!\r\u0002\u000f5\f\u0007pX7j]V\u0011!1G\b\u0003\u0005kqB!C\u0015 h$A!\u0011H\u0006!\u0002\u001b\u0011\u0019$\u0001\u0005nCb|V.\u001b8!\u0011%\u0011id\u0003b\u0001\n\u001b\u0011y$A\u0003nCb|\u0006.\u0006\u0002\u0003B=\u0011!1\t\u0010\u0004O]y\u0010\u0002\u0003B$\u0017\u0001\u0006iA!\u0011\u0002\r5\f\u0007p\u00185!\u0011%\u0011Ye\u0003b\u0001\n\u001b\u0011i%A\u0003nCb|F-\u0006\u0002\u0003P=\u0011!\u0011\u000b\u0010\u0004\u0003\u0001~\u0010\u0002\u0003B+\u0017\u0001\u0006iAa\u0014\u0002\r5\f\u0007p\u00183!\u0011%\t\u0019nCA\u0001\n\u0013\t)\u000e")
public final class FiniteDuration
extends Duration {
    private final long length;
    private final TimeUnit unit;

    public static FiniteDuration apply(long l, String string2) {
        return FiniteDuration$.MODULE$.apply(l, string2);
    }

    public static FiniteDuration apply(long l, TimeUnit timeUnit) {
        return FiniteDuration$.MODULE$.apply(l, timeUnit);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public TimeUnit unit() {
        return this.unit;
    }

    private boolean bounded(long max2) {
        return -max2 <= this.length() && this.length() <= max2;
    }

    @Override
    public long toNanos() {
        return this.unit().toNanos(this.length());
    }

    @Override
    public long toMicros() {
        return this.unit().toMicros(this.length());
    }

    @Override
    public long toMillis() {
        return this.unit().toMillis(this.length());
    }

    @Override
    public long toSeconds() {
        return this.unit().toSeconds(this.length());
    }

    @Override
    public long toMinutes() {
        return this.unit().toMinutes(this.length());
    }

    @Override
    public long toHours() {
        return this.unit().toHours(this.length());
    }

    @Override
    public long toDays() {
        return this.unit().toDays(this.length());
    }

    @Override
    public double toUnit(TimeUnit u) {
        return (double)this.toNanos() / (double)TimeUnit.NANOSECONDS.convert(1L, u);
    }

    public Deadline fromNow() {
        return Deadline$.MODULE$.now().$plus(this);
    }

    private String unitString() {
        return new StringBuilder().append((Object)((String)Duration$.MODULE$.timeUnitName().apply(this.unit()))).append((Object)(this.length() == 1L ? "" : "s")).toString();
    }

    public String toString() {
        return new StringBuilder().append((Object)"").append(BoxesRunTime.boxToLong(this.length())).append((Object)" ").append((Object)this.unitString()).toString();
    }

    @Override
    public int compare(Duration other) {
        int n;
        Duration duration = other;
        if (duration instanceof FiniteDuration) {
            FiniteDuration x2 = (FiniteDuration)duration;
            n = new RichLong(Predef$.MODULE$.longWrapper(this.toNanos())).compare(BoxesRunTime.boxToLong(x2.toNanos()));
        } else {
            n = -other.compare(this);
        }
        return n;
    }

    private long safeAdd(long a, long b) {
        if (b > 0L && a > Long.MAX_VALUE - b || b < 0L && a < Long.MIN_VALUE - b) {
            throw new IllegalArgumentException("integer overflow");
        }
        return a + b;
    }

    private FiniteDuration add(long otherLength, TimeUnit otherUnit) {
        TimeUnit commonUnit = otherUnit.convert(1L, this.unit()) == 0L ? this.unit() : otherUnit;
        long totalLength = this.safeAdd(commonUnit.convert(this.length(), this.unit()), commonUnit.convert(otherLength, otherUnit));
        return new FiniteDuration(totalLength, commonUnit);
    }

    @Override
    public Duration $plus(Duration other) {
        Duration duration;
        Duration duration2 = other;
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration x2 = (FiniteDuration)duration2;
            duration = this.add(x2.length(), x2.unit());
        } else {
            duration = other;
        }
        return duration;
    }

    @Override
    public Duration $minus(Duration other) {
        Duration duration;
        Duration duration2 = other;
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration x2 = (FiniteDuration)duration2;
            duration = this.add(-x2.length(), x2.unit());
        } else {
            duration = other;
        }
        return duration;
    }

    @Override
    public Duration $times(double factor) {
        return Predef$.MODULE$.double2Double(factor).isInfinite() ? (Predef$.MODULE$.double2Double(factor).isNaN() ? Duration$.MODULE$.Undefined() : (factor > 0.0 ^ this.$less(Duration$.MODULE$.Zero()) ? Duration$.MODULE$.Inf() : Duration$.MODULE$.MinusInf())) : Duration$.MODULE$.fromNanos((double)this.toNanos() * factor);
    }

    @Override
    public Duration $div(double divisor) {
        return Predef$.MODULE$.double2Double(divisor).isInfinite() ? (Predef$.MODULE$.double2Double(divisor).isNaN() ? Duration$.MODULE$.Undefined() : Duration$.MODULE$.Zero()) : Duration$.MODULE$.fromNanos((double)this.toNanos() / divisor);
    }

    private double minusZero() {
        return -0.0;
    }

    @Override
    public double $div(Duration divisor) {
        return divisor.isFinite() ? (double)this.toNanos() / (double)divisor.toNanos() : (divisor == Duration$.MODULE$.Undefined() ? Double.NaN : (this.length() < 0L ^ divisor.$greater(Duration$.MODULE$.Zero()) ? 0.0 : this.minusZero()));
    }

    public FiniteDuration $plus(FiniteDuration other) {
        return this.add(other.length(), other.unit());
    }

    public FiniteDuration $minus(FiniteDuration other) {
        return this.add(-other.length(), other.unit());
    }

    public FiniteDuration plus(FiniteDuration other) {
        return this.$plus(other);
    }

    public FiniteDuration minus(FiniteDuration other) {
        return this.$minus(other);
    }

    public FiniteDuration min(FiniteDuration other) {
        return this.$less(other) ? this : other;
    }

    public FiniteDuration max(FiniteDuration other) {
        return this.$greater(other) ? this : other;
    }

    public FiniteDuration $div(long divisor) {
        return Duration$.MODULE$.fromNanos(this.toNanos() / divisor);
    }

    public FiniteDuration $times(long factor) {
        return new FiniteDuration(this.safeMul(this.length(), factor), this.unit());
    }

    private long safeMul(long _a, long _b) {
        long a = package$.MODULE$.abs(_a);
        long b = package$.MODULE$.abs(_b);
        if (Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(b) < 64) {
            throw new IllegalArgumentException("multiplication overflow");
        }
        long product2 = a * b;
        if (product2 < 0L) {
            throw new IllegalArgumentException("multiplication overflow");
        }
        return a == _a ^ b == _b ? -product2 : product2;
    }

    public FiniteDuration div(long divisor) {
        return this.$div(divisor);
    }

    public FiniteDuration mul(long factor) {
        return this.$times(factor);
    }

    @Override
    public FiniteDuration unary_$minus() {
        return Duration$.MODULE$.apply(-this.length(), this.unit());
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof FiniteDuration) {
            FiniteDuration x2 = (FiniteDuration)object;
            bl = this.toNanos() == x2.toNanos();
        } else {
            bl = super.equals(other);
        }
        return bl;
    }

    public int hashCode() {
        return (int)this.toNanos();
    }

    public FiniteDuration(long length, TimeUnit unit) {
        boolean bl;
        this.length = length;
        this.unit = unit;
        TimeUnit timeUnit = unit;
        TimeUnit timeUnit2 = TimeUnit.NANOSECONDS;
        TimeUnit timeUnit3 = timeUnit;
        if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null)) {
            TimeUnit x2 = timeUnit;
            bl = this.bounded(Long.MAX_VALUE);
        } else {
            TimeUnit timeUnit4 = TimeUnit.MICROSECONDS;
            TimeUnit timeUnit5 = timeUnit;
            if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null)) {
                TimeUnit x3 = timeUnit;
                bl = this.bounded(9223372036854775L);
            } else {
                TimeUnit timeUnit6 = TimeUnit.MILLISECONDS;
                TimeUnit timeUnit7 = timeUnit;
                if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null)) {
                    TimeUnit x4 = timeUnit;
                    bl = this.bounded(9223372036854L);
                } else {
                    TimeUnit timeUnit8 = TimeUnit.SECONDS;
                    TimeUnit timeUnit9 = timeUnit;
                    if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null)) {
                        TimeUnit x5 = timeUnit;
                        bl = this.bounded(9223372036L);
                    } else {
                        TimeUnit timeUnit10 = TimeUnit.MINUTES;
                        TimeUnit timeUnit11 = timeUnit;
                        if (!(timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null)) {
                            TimeUnit x6 = timeUnit;
                            bl = this.bounded(153722867L);
                        } else {
                            TimeUnit timeUnit12 = TimeUnit.HOURS;
                            TimeUnit timeUnit13 = timeUnit;
                            if (!(timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null)) {
                                TimeUnit x7 = timeUnit;
                                bl = this.bounded(2562047L);
                            } else {
                                TimeUnit timeUnit14 = TimeUnit.DAYS;
                                TimeUnit timeUnit15 = timeUnit;
                                if (!(timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null)) {
                                    TimeUnit x8 = timeUnit;
                                    bl = this.bounded(106751L);
                                } else {
                                    long v = TimeUnit.DAYS.convert(length, unit);
                                    bl = -106751L <= v && v <= 106751L;
                                }
                            }
                        }
                    }
                }
            }
        }
        Predef$.MODULE$.require(bl, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Duration is limited to +-(2^63-1)ns (ca. 292 years)";
            }
        }));
    }
}

