/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2002-2013, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// DO NOT EDIT, CHANGES WILL BE LOST.

package scala

import scala.language.implicitConversions

/** `Char`, a 16-bit unsigned integer (equivalent to Java's `char` primitive type) is a
 *  subtype of [[scala.AnyVal]]. Instances of `Char` are not
 *  represented by an object in the underlying runtime system.
 *
 *  There is an implicit conversion from [[scala.Char]] => [[scala.runtime.RichChar]]
 *  which provides useful non-primitive operations.
 */
final abstract class Char private extends AnyVal {
  def toByte: Byte
  def toShort: Short
  def toChar: Char
  def toInt: Int
  def toLong: Long
  def toFloat: Float
  def toDouble: Double

  /**
 * Returns the bitwise negation of this value.
 * @example {{{
 * ~5 == -6
 * // in binary: ~00000101 ==
 * //             11111010
 * }}}
 */
  def unary_~ : Int
  /**
 * Returns this value, unmodified.
 */
  def unary_+ : Int
  /**
 * Returns the negation of this value.
 */
  def unary_- : Int

  def +(x: String): String

  /**
  * Returns this value bit-shifted left by the specified number of bits,
  *         filling in the new right bits with zeroes.
  * @example {{{ 6 << 3 == 48 // in binary: 0110 << 3 == 0110000 }}}
  */
  def <<(x: Int): Int
  /**
  * Returns this value bit-shifted left by the specified number of bits,
  *         filling in the new right bits with zeroes.
  * @example {{{ 6 << 3 == 48 // in binary: 0110 << 3 == 0110000 }}}
  */
  def <<(x: Long): Int
  /**
  * Returns this value bit-shifted right by the specified number of bits,
  *         filling the new left bits with zeroes.
  * @example {{{ 21 >>> 3 == 2 // in binary: 010101 >>> 3 == 010 }}}
  * @example {{{
  * -21 >>> 3 == 536870909
  * // in binary: 11111111 11111111 11111111 11101011 >>> 3 ==
  * //            00011111 11111111 11111111 11111101
  * }}}
  */
  def >>>(x: Int): Int
  /**
  * Returns this value bit-shifted right by the specified number of bits,
  *         filling the new left bits with zeroes.
  * @example {{{ 21 >>> 3 == 2 // in binary: 010101 >>> 3 == 010 }}}
  * @example {{{
  * -21 >>> 3 == 536870909
  * // in binary: 11111111 11111111 11111111 11101011 >>> 3 ==
  * //            00011111 11111111 11111111 11111101
  * }}}
  */
  def >>>(x: Long): Int
  /**
  * Returns this value bit-shifted left by the specified number of bits,
  *         filling in the right bits with the same value as the left-most bit of this.
  *         The effect of this is to retain the sign of the value.
  * @example {{{
  * -21 >> 3 == -3
  * // in binary: 11111111 11111111 11111111 11101011 >> 3 ==
  * //            11111111 11111111 11111111 11111101
  * }}}
  */
  def >>(x: Int): Int
  /**
  * Returns this value bit-shifted left by the specified number of bits,
  *         filling in the right bits with the same value as the left-most bit of this.
  *         The effect of this is to retain the sign of the value.
  * @example {{{
  * -21 >> 3 == -3
  * // in binary: 11111111 11111111 11111111 11101011 >> 3 ==
  * //            11111111 11111111 11111111 11111101
  * }}}
  */
  def >>(x: Long): Int

  /**
  * Returns `true` if this value is equal to x, `false` otherwise.
  */
  def ==(x: Byte): Boolean
  /**
  * Returns `true` if this value is equal to x, `false` otherwise.
  */
  def ==(x: Short): Boolean
  /**
  * Returns `true` if this value is equal to x, `false` otherwise.
  */
  def ==(x: Char): Boolean
  /**
  * Returns `true` if this value is equal to x, `false` otherwise.
  */
  def ==(x: Int): Boolean
  /**
  * Returns `true` if this value is equal to x, `false` otherwise.
  */
  def ==(x: Long): Boolean
  /**
  * Returns `true` if this value is equal to x, `false` otherwise.
  */
  def ==(x: Float): Boolean
  /**
  * Returns `true` if this value is equal to x, `false` otherwise.
  */
  def ==(x: Double): Boolean

  /**
  * Returns `true` if this value is not equal to x, `false` otherwise.
  */
  def !=(x: Byte): Boolean
  /**
  * Returns `true` if this value is not equal to x, `false` otherwise.
  */
  def !=(x: Short): Boolean
  /**
  * Returns `true` if this value is not equal to x, `false` otherwise.
  */
  def !=(x: Char): Boolean
  /**
  * Returns `true` if this value is not equal to x, `false` otherwise.
  */
  def !=(x: Int): Boolean
  /**
  * Returns `true` if this value is not equal to x, `false` otherwise.
  */
  def !=(x: Long): Boolean
  /**
  * Returns `true` if this value is not equal to x, `false` otherwise.
  */
  def !=(x: Float): Boolean
  /**
  * Returns `true` if this value is not equal to x, `false` otherwise.
  */
  def !=(x: Double): Boolean

  /**
  * Returns `true` if this value is less than x, `false` otherwise.
  */
  def <(x: Byte): Boolean
  /**
  * Returns `true` if this value is less than x, `false` otherwise.
  */
  def <(x: Short): Boolean
  /**
  * Returns `true` if this value is less than x, `false` otherwise.
  */
  def <(x: Char): Boolean
  /**
  * Returns `true` if this value is less than x, `false` otherwise.
  */
  def <(x: Int): Boolean
  /**
  * Returns `true` if this value is less than x, `false` otherwise.
  */
  def <(x: Long): Boolean
  /**
  * Returns `true` if this value is less than x, `false` otherwise.
  */
  def <(x: Float): Boolean
  /**
  * Returns `true` if this value is less than x, `false` otherwise.
  */
  def <(x: Double): Boolean

  /**
  * Returns `true` if this value is less than or equal to x, `false` otherwise.
  */
  def <=(x: Byte): Boolean
  /**
  * Returns `true` if this value is less than or equal to x, `false` otherwise.
  */
  def <=(x: Short): Boolean
  /**
  * Returns `true` if this value is less than or equal to x, `false` otherwise.
  */
  def <=(x: Char): Boolean
  /**
  * Returns `true` if this value is less than or equal to x, `false` otherwise.
  */
  def <=(x: Int): Boolean
  /**
  * Returns `true` if this value is less than or equal to x, `false` otherwise.
  */
  def <=(x: Long): Boolean
  /**
  * Returns `true` if this value is less than or equal to x, `false` otherwise.
  */
  def <=(x: Float): Boolean
  /**
  * Returns `true` if this value is less than or equal to x, `false` otherwise.
  */
  def <=(x: Double): Boolean

  /**
  * Returns `true` if this value is greater than x, `false` otherwise.
  */
  def >(x: Byte): Boolean
  /**
  * Returns `true` if this value is greater than x, `false` otherwise.
  */
  def >(x: Short): Boolean
  /**
  * Returns `true` if this value is greater than x, `false` otherwise.
  */
  def >(x: Char): Boolean
  /**
  * Returns `true` if this value is greater than x, `false` otherwise.
  */
  def >(x: Int): Boolean
  /**
  * Returns `true` if this value is greater than x, `false` otherwise.
  */
  def >(x: Long): Boolean
  /**
  * Returns `true` if this value is greater than x, `false` otherwise.
  */
  def >(x: Float): Boolean
  /**
  * Returns `true` if this value is greater than x, `false` otherwise.
  */
  def >(x: Double): Boolean

  /**
  * Returns `true` if this value is greater than or equal to x, `false` otherwise.
  */
  def >=(x: Byte): Boolean
  /**
  * Returns `true` if this value is greater than or equal to x, `false` otherwise.
  */
  def >=(x: Short): Boolean
  /**
  * Returns `true` if this value is greater than or equal to x, `false` otherwise.
  */
  def >=(x: Char): Boolean
  /**
  * Returns `true` if this value is greater than or equal to x, `false` otherwise.
  */
  def >=(x: Int): Boolean
  /**
  * Returns `true` if this value is greater than or equal to x, `false` otherwise.
  */
  def >=(x: Long): Boolean
  /**
  * Returns `true` if this value is greater than or equal to x, `false` otherwise.
  */
  def >=(x: Float): Boolean
  /**
  * Returns `true` if this value is greater than or equal to x, `false` otherwise.
  */
  def >=(x: Double): Boolean

  /**
  * Returns the bitwise OR of this value and `x`.
  * @example {{{
  * (0xf0 | 0xaa) == 0xfa
  * // in binary:   11110000
  * //            | 10101010
  * //              --------
  * //              11111010
  * }}}
  */
  def |(x: Byte): Int
  /**
  * Returns the bitwise OR of this value and `x`.
  * @example {{{
  * (0xf0 | 0xaa) == 0xfa
  * // in binary:   11110000
  * //            | 10101010
  * //              --------
  * //              11111010
  * }}}
  */
  def |(x: Short): Int
  /**
  * Returns the bitwise OR of this value and `x`.
  * @example {{{
  * (0xf0 | 0xaa) == 0xfa
  * // in binary:   11110000
  * //            | 10101010
  * //              --------
  * //              11111010
  * }}}
  */
  def |(x: Char): Int
  /**
  * Returns the bitwise OR of this value and `x`.
  * @example {{{
  * (0xf0 | 0xaa) == 0xfa
  * // in binary:   11110000
  * //            | 10101010
  * //              --------
  * //              11111010
  * }}}
  */
  def |(x: Int): Int
  /**
  * Returns the bitwise OR of this value and `x`.
  * @example {{{
  * (0xf0 | 0xaa) == 0xfa
  * // in binary:   11110000
  * //            | 10101010
  * //              --------
  * //              11111010
  * }}}
  */
  def |(x: Long): Long

  /**
  * Returns the bitwise AND of this value and `x`.
  * @example {{{
  * (0xf0 & 0xaa) == 0xa0
  * // in binary:   11110000
  * //            & 10101010
  * //              --------
  * //              10100000
  * }}}
  */
  def &(x: Byte): Int
  /**
  * Returns the bitwise AND of this value and `x`.
  * @example {{{
  * (0xf0 & 0xaa) == 0xa0
  * // in binary:   11110000
  * //            & 10101010
  * //              --------
  * //              10100000
  * }}}
  */
  def &(x: Short): Int
  /**
  * Returns the bitwise AND of this value and `x`.
  * @example {{{
  * (0xf0 & 0xaa) == 0xa0
  * // in binary:   11110000
  * //            & 10101010
  * //              --------
  * //              10100000
  * }}}
  */
  def &(x: Char): Int
  /**
  * Returns the bitwise AND of this value and `x`.
  * @example {{{
  * (0xf0 & 0xaa) == 0xa0
  * // in binary:   11110000
  * //            & 10101010
  * //              --------
  * //              10100000
  * }}}
  */
  def &(x: Int): Int
  /**
  * Returns the bitwise AND of this value and `x`.
  * @example {{{
  * (0xf0 & 0xaa) == 0xa0
  * // in binary:   11110000
  * //            & 10101010
  * //              --------
  * //              10100000
  * }}}
  */
  def &(x: Long): Long

  /**
  * Returns the bitwise XOR of this value and `x`.
  * @example {{{
  * (0xf0 ^ 0xaa) == 0x5a
  * // in binary:   11110000
  * //            ^ 10101010
  * //              --------
  * //              01011010
  * }}}
  */
  def ^(x: Byte): Int
  /**
  * Returns the bitwise XOR of this value and `x`.
  * @example {{{
  * (0xf0 ^ 0xaa) == 0x5a
  * // in binary:   11110000
  * //            ^ 10101010
  * //              --------
  * //              01011010
  * }}}
  */
  def ^(x: Short): Int
  /**
  * Returns the bitwise XOR of this value and `x`.
  * @example {{{
  * (0xf0 ^ 0xaa) == 0x5a
  * // in binary:   11110000
  * //            ^ 10101010
  * //              --------
  * //              01011010
  * }}}
  */
  def ^(x: Char): Int
  /**
  * Returns the bitwise XOR of this value and `x`.
  * @example {{{
  * (0xf0 ^ 0xaa) == 0x5a
  * // in binary:   11110000
  * //            ^ 10101010
  * //              --------
  * //              01011010
  * }}}
  */
  def ^(x: Int): Int
  /**
  * Returns the bitwise XOR of this value and `x`.
  * @example {{{
  * (0xf0 ^ 0xaa) == 0x5a
  * // in binary:   11110000
  * //            ^ 10101010
  * //              --------
  * //              01011010
  * }}}
  */
  def ^(x: Long): Long

  /**
  * Returns the sum of this value and `x`.
  */
  def +(x: Byte): Int
  /**
  * Returns the sum of this value and `x`.
  */
  def +(x: Short): Int
  /**
  * Returns the sum of this value and `x`.
  */
  def +(x: Char): Int
  /**
  * Returns the sum of this value and `x`.
  */
  def +(x: Int): Int
  /**
  * Returns the sum of this value and `x`.
  */
  def +(x: Long): Long
  /**
  * Returns the sum of this value and `x`.
  */
  def +(x: Float): Float
  /**
  * Returns the sum of this value and `x`.
  */
  def +(x: Double): Double

  /**
  * Returns the difference of this value and `x`.
  */
  def -(x: Byte): Int
  /**
  * Returns the difference of this value and `x`.
  */
  def -(x: Short): Int
  /**
  * Returns the difference of this value and `x`.
  */
  def -(x: Char): Int
  /**
  * Returns the difference of this value and `x`.
  */
  def -(x: Int): Int
  /**
  * Returns the difference of this value and `x`.
  */
  def -(x: Long): Long
  /**
  * Returns the difference of this value and `x`.
  */
  def -(x: Float): Float
  /**
  * Returns the difference of this value and `x`.
  */
  def -(x: Double): Double

  /**
  * Returns the product of this value and `x`.
  */
  def *(x: Byte): Int
  /**
  * Returns the product of this value and `x`.
  */
  def *(x: Short): Int
  /**
  * Returns the product of this value and `x`.
  */
  def *(x: Char): Int
  /**
  * Returns the product of this value and `x`.
  */
  def *(x: Int): Int
  /**
  * Returns the product of this value and `x`.
  */
  def *(x: Long): Long
  /**
  * Returns the product of this value and `x`.
  */
  def *(x: Float): Float
  /**
  * Returns the product of this value and `x`.
  */
  def *(x: Double): Double

  /**
  * Returns the quotient of this value and `x`.
  */
  def /(x: Byte): Int
  /**
  * Returns the quotient of this value and `x`.
  */
  def /(x: Short): Int
  /**
  * Returns the quotient of this value and `x`.
  */
  def /(x: Char): Int
  /**
  * Returns the quotient of this value and `x`.
  */
  def /(x: Int): Int
  /**
  * Returns the quotient of this value and `x`.
  */
  def /(x: Long): Long
  /**
  * Returns the quotient of this value and `x`.
  */
  def /(x: Float): Float
  /**
  * Returns the quotient of this value and `x`.
  */
  def /(x: Double): Double

  /**
  * Returns the remainder of the division of this value by `x`.
  */
  def %(x: Byte): Int
  /**
  * Returns the remainder of the division of this value by `x`.
  */
  def %(x: Short): Int
  /**
  * Returns the remainder of the division of this value by `x`.
  */
  def %(x: Char): Int
  /**
  * Returns the remainder of the division of this value by `x`.
  */
  def %(x: Int): Int
  /**
  * Returns the remainder of the division of this value by `x`.
  */
  def %(x: Long): Long
  /**
  * Returns the remainder of the division of this value by `x`.
  */
  def %(x: Float): Float
  /**
  * Returns the remainder of the division of this value by `x`.
  */
  def %(x: Double): Double

  override def getClass(): Class[Char] = null
}

object Char extends AnyValCompanion {
  /** The smallest value representable as a Char.
   */
  final val MinValue = java.lang.Character.MIN_VALUE

  /** The largest value representable as a Char.
   */
  final val MaxValue = java.lang.Character.MAX_VALUE

  /** Transform a value type into a boxed reference type.
   *
   *  Runtime implementation determined by `scala.runtime.BoxesRunTime.boxToCharacter`. See [[https://github.com/scala/scala src/library/scala/runtime/BoxesRunTime.java]].
   *
   *  @param  x   the Char to be boxed
   *  @return     a java.lang.Character offering `x` as its underlying value.
   */
  def box(x: Char): java.lang.Character = java.lang.Character.valueOf(x)

  /** Transform a boxed type into a value type.  Note that this
   *  method is not typesafe: it accepts any Object, but will throw
   *  an exception if the argument is not a java.lang.Character.
   *
   *  Runtime implementation determined by `scala.runtime.BoxesRunTime.unboxToChar`. See [[https://github.com/scala/scala src/library/scala/runtime/BoxesRunTime.java]].
   *
   *  @param  x   the java.lang.Character to be unboxed.
   *  @throws     ClassCastException  if the argument is not a java.lang.Character
   *  @return     the Char resulting from calling charValue() on `x`
   */
  def unbox(x: java.lang.Object): Char = x.asInstanceOf[java.lang.Character].charValue()

  /** The String representation of the scala.Char companion object.
   */
  override def toString = "object scala.Char"

  /** Language mandated coercions from Char to "wider" types.
   */
  implicit def char2int(x: Char): Int = x.toInt
  implicit def char2long(x: Char): Long = x.toLong
  implicit def char2float(x: Char): Float = x.toFloat
  implicit def char2double(x: Char): Double = x.toDouble
}

