/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.AbstractSeq;
import scala.collection.CustomParallelizable;
import scala.collection.CustomParallelizable$class;
import scala.collection.GenSeqLike$class;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$class;
import scala.collection.IndexedSeqLike$class;
import scala.collection.Iterator;
import scala.collection.TraversableOnce$class;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.Iterable$class;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range$;
import scala.collection.immutable.Seq$class;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Traversable$class;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.immutable.ParRange;
import scala.math.Numeric;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0011]c\u0001B\u0001\u0003\u0001%\u0011QAU1oO\u0016T!a\u0001\u0003\u0002\u0013%lW.\u001e;bE2,'BA\u0003\u0007\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u000f\u0005)1oY1mC\u000e\u00011#\u0002\u0001\u000b%Y\u0001\u0003cA\u0006\r\u001d5\tA!\u0003\u0002\u000e\t\tY\u0011IY:ue\u0006\u001cGoU3r!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0002J]R\u00042a\u0005\u000b\u000f\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0005\u0017]q\u0011$\u0003\u0002\u0019\t\t!2)^:u_6\u0004\u0016M]1mY\u0016d\u0017N_1cY\u0016\u0004\"A\u0007\u0010\u000e\u0003mQ!a\u0001\u000f\u000b\u0005u!\u0011\u0001\u00039be\u0006dG.\u001a7\n\u0005}Y\"\u0001\u0003)beJ\u000bgnZ3\u0011\u0005=\t\u0013B\u0001\u0012\u0007\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!!\u0003A!b\u0001\n\u0003)\u0013!B:uCJ$X#\u0001\b\t\u0011\u001d\u0002!\u0011!Q\u0001\n9\taa\u001d;beR\u0004\u0003\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002\u0007\u0015tG\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003\u000f\u0003\u0011)g\u000e\u001a\u0011\t\u00115\u0002!Q1A\u0005\u0002\u0015\nAa\u001d;fa\"Aq\u0006\u0001B\u0001B\u0003%a\"A\u0003ti\u0016\u0004\b\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0005gQ*d\u0007\u0005\u0002\u0014\u0001!)A\u0005\ra\u0001\u001d!)\u0011\u0006\ra\u0001\u001d!)Q\u0006\ra\u0001\u001d!)\u0001\b\u0001C!s\u0005\u0019\u0001/\u0019:\u0016\u0003eAQa\u000f\u0001\u0005\nq\n1aZ1q+\u0005i\u0004CA\b?\u0013\tydA\u0001\u0003M_:<\u0007\"B!\u0001\t\u0013\u0011\u0015aB5t\u000bb\f7\r^\u000b\u0002\u0007B\u0011q\u0002R\u0005\u0003\u000b\u001a\u0011qAQ8pY\u0016\fg\u000eC\u0003H\u0001\u0011%!)A\u0004iCN\u001cF/\u001e2\t\u000b%\u0003A\u0011\u0002\u001f\u0002\u00151|gn\u001a'f]\u001e$\b\u000eC\u0004L\u0001\t\u0007IQ\t\"\u0002\u000f%\u001cX)\u001c9us\"1Q\n\u0001Q\u0001\u000e\r\u000b\u0001\"[:F[B$\u0018\u0010\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0002&\u0003AqW/\u001c*b]\u001e,W\t\\3nK:$8\u000f\u000b\u0003O#R3\u0006CA\bS\u0013\t\u0019fA\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0013!V\u00018)\"L7\u000fI7fi\"|G\rI<jY2\u0004#-\u001a\u0011nC\u0012,\u0007\u0005\u001d:jm\u0006$X\r\f\u0011vg\u0016\u0004\u0003\r\\3oORD\u0007\rI5ogR,\u0017\r\u001a\u0018\"\u0003]\u000bAA\r\u00182c!1\u0011\f\u0001Q\u0001\u000e9\t\u0011C\\;n%\u0006tw-Z#mK6,g\u000e^:!\u0011\u001dY\u0006A1A\u0005\u0006\u0015\n1\u0002\\1ti\u0016cW-\\3oi\"\"!,U/WC\u0005q\u0016!\u000e+iSN\u0004S.\u001a;i_\u0012\u0004s/\u001b7mA\t,\u0007%\\1eK\u0002\u0002(/\u001b<bi\u0016d\u0003%^:fA\u0001d\u0017m\u001d;aA%t7\u000f^3bI:Ba\u0001\u0019\u0001!\u0002\u001bq\u0011\u0001\u00047bgR,E.Z7f]R\u0004\u0003b\u00022\u0001\u0005\u0004%)!J\u0001\u0010i\u0016\u0014X.\u001b8bY\u0016cW-\\3oi\"\"\u0011-\u00153WC\u0005)\u0017!\t+iSN\u0004S.\u001a;i_\u0012\u0004s/\u001b7mA\t,\u0007%\\1eK\u0002\u0002(/\u001b<bi\u0016t\u0003BB4\u0001A\u00035a\"\u0001\tuKJl\u0017N\\1m\u000b2,W.\u001a8uA!)\u0011\u000e\u0001C!K\u0005!A.Y:u\u0011\u0015Y\u0007\u0001\"\u0011&\u0003\u0011AW-\u00193\t\u000b5\u0004A\u0011\t8\u0002\u00075Lg.\u0006\u0002pwR\u0011a\u0002\u001d\u0005\u0006c2\u0004\u001dA]\u0001\u0004_J$\u0007cA:ws:\u0011q\u0002^\u0005\u0003k\u001a\tq\u0001]1dW\u0006<W-\u0003\u0002xq\nAqJ\u001d3fe&twM\u0003\u0002v\rA\u0011!p\u001f\u0007\u0001\t\u0015aHN1\u0001~\u0005\t\t\u0015'\u0005\u0002\u000f}B\u0011qb`\u0005\u0004\u0003\u00031!aA!os\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0011aA7bqV!\u0011\u0011BA\t)\rq\u00111\u0002\u0005\bc\u0006\r\u00019AA\u0007!\u0011\u0019h/a\u0004\u0011\u0007i\f\t\u0002\u0002\u0004}\u0003\u0007\u0011\r! \u0005\b\u0003+\u0001A\u0011CA\f\u0003\u0011\u0019w\u000e]=\u0015\u000fM\nI\"a\u0007\u0002\u001e!1A%a\u0005A\u00029Aa!KA\n\u0001\u0004q\u0001BB\u0017\u0002\u0014\u0001\u0007a\u0002C\u0004\u0002\"\u0001!\t!a\t\u0002\u0005\tLHcA\u001a\u0002&!1Q&a\bA\u00029Aa!!\u000b\u0001\t\u0003\u0011\u0015aC5t\u0013:\u001cG.^:jm\u0016Da!!\f\u0001\t\u0003*\u0013\u0001B:ju\u0016Da!!\r\u0001\t\u0003*\u0013A\u00027f]\u001e$\b\u000eC\u0004\u00026\u0001!I!a\u000e\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u000b\u0003\u0003s\u0001B!a\u000f\u0002B9\u0019q\"!\u0010\n\u0007\u0005}b!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\n)E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u007f1\u0001bBA%\u0001\u0011%\u00111J\u0001\u0005M\u0006LG\u000e\u0006\u0002\u0002NA\u0019q\"a\u0014\n\u0007\u0005EcAA\u0004O_RD\u0017N\\4\t\u001d\u0005U\u0003\u0001\"A\u0001\u0006\u0003\u0005\t\u0011\"\u0003\u0002X\u0005\u00194oY1mC\u0012\u001aw\u000e\u001c7fGRLwN\u001c\u0013j[6,H/\u00192mK\u0012\u0012\u0016M\\4fI\u00112\u0018\r\\5eCR,W*\u0019=MK:<G\u000f\u001b\u000b\u0003\u00033\u00022aDA.\u0013\r\tiF\u0002\u0002\u0005+:LG\u000fC\u0004\u0002b\u0001!)!a\u0019\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00079\t)\u0007C\u0004\u0002h\u0005}\u0003\u0019\u0001\b\u0002\u0007%$\u0007\u0010C\u0004\u0002l\u0001!)%!\u001c\u0002\u000f\u0019|'/Z1dQV!\u0011qNA?)\u0011\tI&!\u001d\t\u0011\u0005M\u0014\u0011\u000ea\u0001\u0003k\n\u0011A\u001a\t\u0007\u001f\u0005]d\"a\u001f\n\u0007\u0005edAA\u0005Gk:\u001cG/[8ocA\u0019!0! \u0005\u0019\u0005}\u0014\u0011\u000eQ\u0001\u0002\u0003\u0015\r!!!\u0003\u0003U\u000b2!!\u0014\u007fQ\u0019\ti(!\"\u0002\fB\u0019q\"a\"\n\u0007\u0005%eAA\u0006ta\u0016\u001c\u0017.\u00197ju\u0016$\u0017g\u0002\u0013\u0002\u000e\u0006=\u0015\u0011\u0013\b\u0004\u001f\u0005=\u0015bAAI\r\u0005!QK\\5uQ\u0011\tI'!&\u0011\u0007=\t9*C\u0002\u0002\u001a\u001a\u0011a!\u001b8mS:,\u0007bBAO\u0001\u0011\u0015\u0013qT\u0001\u0005i\u0006\\W\rF\u00024\u0003CCq!a)\u0002\u001c\u0002\u0007a\"A\u0001o\u0011\u001d\t9\u000b\u0001C#\u0003S\u000bA\u0001\u001a:paR\u00191'a+\t\u000f\u0005\r\u0016Q\u0015a\u0001\u001d!9\u0011q\u0016\u0001\u0005B\u0005E\u0016!B:mS\u000e,G#B\u001a\u00024\u0006]\u0006bBA[\u0003[\u0003\rAD\u0001\u0005MJ|W\u000eC\u0004\u0002:\u00065\u0006\u0019\u0001\b\u0002\u000bUtG/\u001b7\t\u000f\u0005u\u0006\u0001\"\u0012\u0002@\u0006!\u0011N\\5u+\u0005\u0019\u0004bBAb\u0001\u0011\u0015\u0013qX\u0001\u0005i\u0006LG\u000eC\u0004\u0002H\u0002!I!!3\u0002\u0019\u0005\u0014x\rV1lK^C\u0017\u000e\\3\u0015\u0007u\nY\r\u0003\u0005\u0002N\u0006\u0015\u0007\u0019AAh\u0003\u0005\u0001\b#B\b\u0002x9\u0019\u0005bBAj\u0001\u0011%\u0011Q[\u0001\u000fY>\u001c\u0017\r^5p]\u00063G/\u001a:O)\rq\u0011q\u001b\u0005\b\u0003G\u000b\t\u000e1\u0001\u000f\u0011\u001d\tY\u000e\u0001C\u0005\u0003;\fQB\\3x\u000b6\u0004H/\u001f*b]\u001e,GcA\u001a\u0002`\"9\u0011\u0011]Am\u0001\u0004q\u0011!\u0002<bYV,\u0007bBAs\u0001\u0011\u0015\u0013q]\u0001\ni\u0006\\Wm\u00165jY\u0016$2aMAu\u0011!\ti-a9A\u0002\u0005=\u0007bBAw\u0001\u0011\u0015\u0013q^\u0001\nIJ|\u0007o\u00165jY\u0016$2aMAy\u0011!\ti-a;A\u0002\u0005=\u0007bBA{\u0001\u0011\u0015\u0013q_\u0001\u0005gB\fg\u000e\u0006\u0003\u0002z\u0006}\b#B\b\u0002|N\u001a\u0014bAA\u007f\r\t1A+\u001e9mKJB\u0001\"!4\u0002t\u0002\u0007\u0011q\u001a\u0005\b\u0005\u0007\u0001AQ\tB\u0003\u0003\u001d\u0019\b\u000f\\5u\u0003R$B!!?\u0003\b!9\u00111\u0015B\u0001\u0001\u0004q\u0001b\u0002B\u0006\u0001\u0011\u0015#QB\u0001\ni\u0006\\WMU5hQR$2a\rB\b\u0011\u001d\t\u0019K!\u0003A\u00029AqAa\u0005\u0001\t\u000b\u0012)\"A\u0005ee>\u0004(+[4iiR\u00191Ga\u0006\t\u000f\u0005\r&\u0011\u0003a\u0001\u001d!9!1\u0004\u0001\u0005F\u0005}\u0016a\u0002:fm\u0016\u00148/\u001a\u0005\b\u0005?\u0001A\u0011AA`\u0003%Ign\u00197vg&4X\rC\u0004\u0003$\u0001!)A!\n\u0002\u0011\r|g\u000e^1j]N$2a\u0011B\u0014\u0011\u001d\u0011IC!\tA\u00029\t\u0011\u0001\u001f\u0005\b\u0005[\u0001AQ\tB\u0018\u0003\r\u0019X/\\\u000b\u0005\u0005c\u0011y\u0004F\u0002\u000f\u0005gA\u0001B!\u000e\u0003,\u0001\u000f!qG\u0001\u0004]Vl\u0007#B:\u0003:\tu\u0012b\u0001B\u001eq\n9a*^7fe&\u001c\u0007c\u0001>\u0003@\u00119!\u0011\tB\u0016\u0005\u0004i(!\u0001\"\t\u000f\t\u0015\u0003\u0001\"\u0011\u0002@\u0006QAo\\%uKJ\f'\r\\3\t\u000f\t%\u0003\u0001\"\u0011\u0002@\u0006)Ao\\*fc\"9!Q\n\u0001\u0005B\t=\u0013AB3rk\u0006d7\u000fF\u0002D\u0005#BqAa\u0015\u0003L\u0001\u0007a0A\u0003pi\",'\u000fC\u0004\u0003X\u0001!\tE!\u0017\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000f)\u000f\u0001\u0011iFa\u0019\u0003hA\u0019qBa\u0018\n\u0007\t\u0005dAA\u000beKB\u0014XmY1uK\u0012Le\u000e[3sSR\fgnY3\"\u0005\t\u0015\u0014\u0001\u0012+iK\u0002JW\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004C-\u001a;bS2\u001c\be\u001c4!%\u0006tw-\u001a\u0011nC.,7\u000fI5oQ\u0016\u0014\u0018\u000e^5oO\u00022'o\\7!SR\u0004SO\\<jg\u0016t\u0013E\u0001B5\u0003\u0019\u0011d&M\u0019/a!:\u0001A!\u001c\u0002b\nM\u0004cA\b\u0003p%\u0019!\u0011\u000f\u0004\u0003!M+'/[1m-\u0016\u00148/[8o+&#e\u0004C5<HS[[CM\u0007\b\u000f\t]$\u0001#\u0001\u0003z\u0005)!+\u00198hKB\u00191Ca\u001f\u0007\r\u0005\u0011\u0001\u0012\u0001B?'\u0015\u0011YHa !!\ry!\u0011Q\u0005\u0004\u0005\u00073!AB!osJ+g\rC\u00042\u0005w\"\tAa\"\u0015\u0005\te\u0004B\u0003BF\u0005w\u0012\r\u0011\"\u0001\u0003K\u0005IQ*\u0011-`!JKe\n\u0016\u0005\t\u0005\u001f\u0013Y\b)A\u0005\u001d\u0005QQ*\u0011-`!JKe\n\u0016\u0011\t\u0011\tM%1\u0010C\u0001\u0005+\u000bQaY8v]R$\u0012B\u0004BL\u00053\u0013YJ!(\t\r\u0011\u0012\t\n1\u0001\u000f\u0011\u0019I#\u0011\u0013a\u0001\u001d!1QF!%A\u00029Aq!!\u000b\u0003\u0012\u0002\u00071\t\u0003\u0005\u0003\u0014\nmD\u0011\u0001BQ)\u001dq!1\u0015BS\u0005OCa\u0001\nBP\u0001\u0004q\u0001BB\u0015\u0003 \u0002\u0007a\u0002\u0003\u0004.\u0005?\u0003\rA\u0004\u0004\b\u0005W\u0013Y\b\u0001BW\u0005%Ien\u00197vg&4XmE\u0002\u0003*NB!\u0002\nBU\u0005\u0003\u0005\u000b\u0011\u0002\b$\u0011)I#\u0011\u0016B\u0001B\u0003%a\u0002\u000b\u0005\u000b[\t%&\u0011!Q\u0001\n9a\u0003bB\u0019\u0003*\u0012\u0005!q\u0017\u000b\t\u0005s\u0013iLa0\u0003BB!!1\u0018BU\u001b\t\u0011Y\b\u0003\u0004%\u0005k\u0003\rA\u0004\u0005\u0007S\tU\u0006\u0019\u0001\b\t\r5\u0012)\f1\u0001\u000f\u0011\u001d\tIC!+\u0005B\tC\u0001\"!\u0006\u0003*\u0012E#q\u0019\u000b\bg\t%'1\u001aBg\u0011\u0019!#Q\u0019a\u0001\u001d!1\u0011F!2A\u00029Aa!\fBc\u0001\u0004q\u0001\u0002CA1\u0005w\"\tA!5\u0015\u000fM\u0012\u0019N!6\u0003X\"1AEa4A\u00029Aa!\u000bBh\u0001\u0004q\u0001BB\u0017\u0003P\u0002\u0007a\u0002\u0003\u0005\u0002b\tmD\u0011\u0001Bn)\u0015\u0019$Q\u001cBp\u0011\u0019!#\u0011\u001ca\u0001\u001d!1\u0011F!7A\u00029A\u0001Ba\b\u0003|\u0011\u0005!1\u001d\u000b\t\u0005K\u0014IOa;\u0003nB!!q\u001dBU\u001d\r\u0019\"Q\u000f\u0005\u0007I\t\u0005\b\u0019\u0001\b\t\r%\u0012\t\u000f1\u0001\u000f\u0011\u0019i#\u0011\u001da\u0001\u001d!A!q\u0004B>\t\u0003\u0011\t\u0010\u0006\u0004\u0003f\nM(Q\u001f\u0005\u0007I\t=\b\u0019\u0001\b\t\r%\u0012y\u000f1\u0001\u000f\u000f!\u0011IPa\u001f\t\u0002\tm\u0018A\u0002\"jO&sG\u000f\u0005\u0003\u0003<\nuh\u0001\u0003B\u0000\u0005wB\ta!\u0001\u0003\r\tKw-\u00138u'\u0011\u0011iPa \t\u000fE\u0012i\u0010\"\u0001\u0004\u0006Q\u0011!1 \u0005\t\u0003C\u0012i\u0010\"\u0001\u0004\nQA11BB\u000f\u0007?\u0019\t\u0003\u0005\u0004\u0004\u000e\rM1\u0011\u0004\b\u0004'\r=\u0011bAB\t\u0005\u0005aa*^7fe&\u001c'+\u00198hK&!1QCB\f\u0005%)\u0005p\u00197vg&4XMC\u0002\u0004\u0012\t\u00012a]B\u000e\u0013\r\u0011y\u0010\u001f\u0005\bI\r\u001d\u0001\u0019AB\r\u0011\u001dI3q\u0001a\u0001\u00073Aq!LB\u0004\u0001\u0004\u0019I\u0002\u0003\u0005\u0003 \tuH\u0011AB\u0013)!\u00199ca\u000b\u0004.\r=\u0002CBB\u0007\u0007S\u0019I\"\u0003\u0003\u0003,\u000e]\u0001b\u0002\u0013\u0004$\u0001\u00071\u0011\u0004\u0005\bS\r\r\u0002\u0019AB\r\u0011\u001di31\u0005a\u0001\u000739\u0001ba\r\u0003|!\u00051QG\u0001\u0005\u0019>tw\r\u0005\u0003\u0003<\u000e]baB \u0003|!\u00051\u0011H\n\u0005\u0007o\u0011y\bC\u00042\u0007o!\ta!\u0010\u0015\u0005\rU\u0002\u0002CA1\u0007o!\ta!\u0011\u0015\u0011\r\r3QIB$\u0007\u0013\u0002Ra!\u0004\u0004\u0014uBa\u0001JB \u0001\u0004i\u0004BB\u0015\u0004@\u0001\u0007Q\b\u0003\u0004.\u0007\u007f\u0001\r!\u0010\u0005\t\u0005?\u00199\u0004\"\u0001\u0004NQA1qJB)\u0007'\u001a)\u0006E\u0003\u0004\u000e\r%R\b\u0003\u0004%\u0007\u0017\u0002\r!\u0010\u0005\u0007S\r-\u0003\u0019A\u001f\t\r5\u001aY\u00051\u0001>\u000f!\u0019IFa\u001f\t\u0002\rm\u0013A\u0003\"jO\u0012+7-[7bYB!!1XB/\r!\u0019yFa\u001f\t\u0002\r\u0005$A\u0003\"jO\u0012+7-[7bYN!1Q\fB@\u0011\u001d\t4Q\fC\u0001\u0007K\"\"aa\u0017\t\u0015\r%4Q\fb\u0001\n\u0007\u0019Y'\u0001\tcS\u001e$UmY!t\u0013:$Xm\u001a:bYV\u00111Q\u000e\b\u0005\u0007_\u001a9I\u0004\u0003\u0004r\r\u0005e\u0002BB:\u0007{rAa!\u001e\u0004|5\u00111q\u000f\u0006\u0004\u0007sB\u0011A\u0002\u001fs_>$h(C\u0001\b\u0013\r\u0019yHB\u0001\u0005[\u0006$\b.\u0003\u0003\u0004\u0004\u000e\u0015\u0015a\u0002(v[\u0016\u0014\u0018n\u0019\u0006\u0004\u0007\u007f2\u0011\u0002BBE\u0007\u0017\u000baCQ5h\t\u0016\u001c\u0017.\\1m\u0003NLe-\u00138uK\u001e\u0014\u0018\r\u001c\u0006\u0005\u0007\u0007\u001b)\tC\u0005\u0004\u0010\u000eu\u0003\u0015!\u0003\u0004n\u0005\t\"-[4EK\u000e\f5/\u00138uK\u001e\u0014\u0018\r\u001c\u0011\t\u0011\u0005\u00054Q\fC\u0001\u0007'#\u0002b!&\u0004\u001c\u000eu5q\u0014\t\u0007\u0007\u001b\u0019\u0019ba&\u0011\u0007M\u001cI*C\u0002\u0004`aDq\u0001JBI\u0001\u0004\u00199\nC\u0004*\u0007#\u0003\raa&\t\u000f5\u001a\t\n1\u0001\u0004\u0018\"A!qDB/\t\u0003\u0019\u0019\u000b\u0006\u0005\u0004&\u000e\u001d6\u0011VBV!\u0019\u0019ia!\u000b\u0004\u0018\"9Ae!)A\u0002\r]\u0005bB\u0015\u0004\"\u0002\u00071q\u0013\u0005\b[\r\u0005\u0006\u0019ABL\u000f!\u0019yKa\u001f\t\u0002\rE\u0016A\u0002#pk\ndW\r\u0005\u0003\u0003<\u000eMf\u0001CB[\u0005wB\taa.\u0003\r\u0011{WO\u00197f'\u0011\u0019\u0019La \t\u000fE\u001a\u0019\f\"\u0001\u0004<R\u00111\u0011\u0017\u0005\u000b\u0007S\u001a\u0019L1A\u0005\u0004\r-\u0004\"CBH\u0007g\u0003\u000b\u0011BB7\u0011)\u0019\u0019ma-C\u0002\u0013\r1QY\u0001\u0011I>,(\r\\3Bg&sG/Z4sC2,\"aa2\u000f\t\r=4\u0011Z\u0005\u0005\u0007\u0017\u001cY)\u0001\nE_V\u0014G.Z!t\u0013\u001aLe\u000e^3he\u0006d\u0007\"CBh\u0007g\u0003\u000b\u0011BBd\u0003E!w.\u001e2mK\u0006\u001b\u0018J\u001c;fOJ\fG\u000e\t\u0005\t\u0007'\u001c\u0019\f\"\u0001\u0004V\u0006!Ao\u001c\"E)\u0011\u00199ja6\t\u0011\t%2\u0011\u001ba\u0001\u00073\u00042aDBn\u0013\r\u0019)L\u0002\u0005\t\u0003C\u001a\u0019\f\"\u0001\u0004`RA1\u0011]Bt\u0007S\u001cY\u000fE\u0003\u0014\u0007G\u001cI.C\u0002\u0004f\n\u0011ABT;nKJL7MU1oO\u0016Dq\u0001JBo\u0001\u0004\u0019I\u000eC\u0004*\u0007;\u0004\ra!7\t\u000f5\u001ai\u000e1\u0001\u0004Z\"A!qDBZ\t\u0003\u0019y\u000f\u0006\u0005\u0004b\u000eE81_B{\u0011\u001d!3Q\u001ea\u0001\u00073Dq!KBw\u0001\u0004\u0019I\u000eC\u0004.\u0007[\u0004\ra!7\u0007\u000f\re(1\u0010\u0001\u0004|\n9\u0001+\u0019:uS\u0006dWCBB\u007f\t\u000b!Ya\u0005\u0003\u0004x\n}\u0004bCA:\u0007o\u0014\t\u0011)A\u0005\t\u0003\u0001raDA<\t\u0007!I\u0001E\u0002{\t\u000b!\u0001\u0002b\u0002\u0004x\n\u0007\u0011\u0011\u0011\u0002\u0002)B\u0019!\u0010b\u0003\u0005\u0011\u0005}4q\u001fb\u0001\u0003\u0003Cq!MB|\t\u0003!y\u0001\u0006\u0003\u0005\u0012\u0011M\u0001\u0003\u0003B^\u0007o$\u0019\u0001\"\u0003\t\u0011\u0005MDQ\u0002a\u0001\t\u0003A\u0001\"!\t\u0004x\u0012\u0005Aq\u0003\u000b\u0005\t\u0013!I\u0002\u0003\u0005\u0003*\u0011U\u0001\u0019\u0001C\u0002\u000f!!iBa\u001f\t\u0002\u0011}\u0011aA%oiB!!1\u0018C\u0011\r\u001d\t\"1\u0010E\u0001\tG\u0019B\u0001\"\t\u0003\u0000!9\u0011\u0007\"\t\u0005\u0002\u0011\u001dBC\u0001C\u0010\u0011!\t\t\u0007\"\t\u0005\u0002\u0011-B\u0003\u0003C\u0017\t_!\t\u0004b\r\u0011\u000b\r511\u0003\b\t\r\u0011\"I\u00031\u0001\u000f\u0011\u0019IC\u0011\u0006a\u0001\u001d!1Q\u0006\"\u000bA\u00029A\u0001Ba\b\u0005\"\u0011\u0005Aq\u0007\u000b\t\ts!Y\u0004\"\u0010\u0005@A)1QBB\u0015\u001d!1A\u0005\"\u000eA\u00029Aa!\u000bC\u001b\u0001\u0004q\u0001BB\u0017\u00056\u0001\u0007a\u0002\u0003\u0006\u0005D\tm\u0014\u0011!C\u0005\t\u000b\n1B]3bIJ+7o\u001c7wKR\u0011Aq\t\t\u0005\t\u0013\"\u0019&\u0004\u0002\u0005L)!AQ\nC(\u0003\u0011a\u0017M\\4\u000b\u0005\u0011E\u0013\u0001\u00026bm\u0006LA\u0001\"\u0016\u0005L\t1qJ\u00196fGR\u0004")
public class Range
extends AbstractSeq<Object>
implements scala.collection.immutable.IndexedSeq<Object>,
CustomParallelizable<Object, ParRange>,
Serializable {
    public static final long serialVersionUID = 7618862778670199309L;
    private final int start;
    private final int end;
    private final int step;
    private final boolean isEmpty;
    private final int numRangeElements;
    private final int lastElement;
    private final int terminalElement;

    @Override
    public Combiner<Object, ParRange> parCombiner() {
        return CustomParallelizable$class.parCombiner(this);
    }

    @Override
    public GenericCompanion<scala.collection.immutable.IndexedSeq> companion() {
        return scala.collection.immutable.IndexedSeq$class.companion(this);
    }

    @Override
    public scala.collection.immutable.IndexedSeq<Object> toIndexedSeq() {
        return scala.collection.immutable.IndexedSeq$class.toIndexedSeq(this);
    }

    @Override
    public scala.collection.immutable.IndexedSeq<Object> seq() {
        return scala.collection.immutable.IndexedSeq$class.seq(this);
    }

    @Override
    public int hashCode() {
        return IndexedSeqLike$class.hashCode(this);
    }

    @Override
    public IndexedSeq<Object> thisCollection() {
        return IndexedSeqLike$class.thisCollection(this);
    }

    @Override
    public IndexedSeq toCollection(Object repr) {
        return IndexedSeqLike$class.toCollection(this, repr);
    }

    @Override
    public Iterator<Object> iterator() {
        return IndexedSeqLike$class.iterator(this);
    }

    @Override
    public <A1> Buffer<A1> toBuffer() {
        return IndexedSeqLike$class.toBuffer(this);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    @Override
    public ParRange par() {
        return new ParRange(this);
    }

    private long gap() {
        return (long)this.end() - (long)this.start();
    }

    private boolean isExact() {
        return this.gap() % (long)this.step() == 0L;
    }

    private boolean hasStub() {
        return this.isInclusive() || !this.isExact();
    }

    private long longLength() {
        return this.gap() / (long)this.step() + (long)(this.hasStub() ? 1 : 0);
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public final int numRangeElements() {
        return this.numRangeElements;
    }

    public final int lastElement() {
        return this.lastElement;
    }

    public final int terminalElement() {
        return this.terminalElement;
    }

    @Override
    public int last() {
        if (this.isEmpty()) {
            return BoxesRunTime.unboxToInt(Nil$.MODULE$.last());
        }
        return this.lastElement();
    }

    @Override
    public int head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public <A1> int min(Ordering<A1> ord) {
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this.head();
            }
            return this.last();
        }
        return BoxesRunTime.unboxToInt(TraversableOnce$class.min(this, ord));
    }

    @Override
    public <A1> int max(Ordering<A1> ord) {
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this.last();
            }
            return this.head();
        }
        return BoxesRunTime.unboxToInt(TraversableOnce$class.max(this, ord));
    }

    public Range copy(int start, int end, int step) {
        return new Range(start, end, step);
    }

    public Range by(int step) {
        return this.copy(this.start(), this.end(), step);
    }

    public boolean isInclusive() {
        return false;
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public int length() {
        if (this.numRangeElements() < 0) {
            throw this.fail();
        }
        return this.numRangeElements();
    }

    private String description() {
        Predef$ predef$ = Predef$.MODULE$;
        String string = "%d %s %d by %s";
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        String string2 = string;
        return new StringOps(string2).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.start()), this.isInclusive() ? "to" : "until", BoxesRunTime.boxToInteger(this.end()), BoxesRunTime.boxToInteger(this.step())}));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(new StringBuilder().append((Object)this.description()).append((Object)": seqs cannot contain more than Int.MaxValue elements.").toString());
    }

    public void scala$collection$immutable$Range$$validateMaxLength() {
        if (this.numRangeElements() < 0) {
            throw this.fail();
        }
    }

    @Override
    public final int apply(int idx) {
        return this.apply$mcII$sp(idx);
    }

    @Override
    public final <U> void foreach(Function1<Object, U> f) {
        this.scala$collection$immutable$Range$$validateMaxLength();
        boolean isCommonCase = this.start() != Integer.MIN_VALUE || this.end() != Integer.MIN_VALUE;
        int i = this.start();
        int count = 0;
        int terminal = this.terminalElement();
        int step = this.step();
        while (true) {
            boolean bl = isCommonCase ? i != terminal : count < this.numRangeElements();
            if (!bl) break;
            f.apply(BoxesRunTime.boxToInteger(i));
            ++count;
            i += step;
        }
    }

    @Override
    public final Range take(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this.newEmptyRange(this.start());
        }
        if (n >= this.numRangeElements() && this.numRangeElements() >= 0) {
            return this;
        }
        return new Inclusive(this.start(), this.locationAfterN(n - 1), this.step());
    }

    @Override
    public final Range drop(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (n >= this.numRangeElements() && this.numRangeElements() >= 0) {
            return this.newEmptyRange(this.end());
        }
        return this.copy(this.locationAfterN(n), this.end(), this.step());
    }

    @Override
    public Range slice(int from, int until) {
        if (from <= 0) {
            return this.take(until);
        }
        if (until >= this.numRangeElements() && this.numRangeElements() >= 0) {
            return this.drop(from);
        }
        int fromValue = this.locationAfterN(from);
        if (from >= until) {
            return this.newEmptyRange(fromValue);
        }
        return new Inclusive(fromValue, this.locationAfterN(until - 1), this.step());
    }

    @Override
    public final Range init() {
        Object object = this.isEmpty() ? Nil$.MODULE$.init() : BoxedUnit.UNIT;
        return this.dropRight(1);
    }

    @Override
    public final Range tail() {
        Object object = this.isEmpty() ? Nil$.MODULE$.tail() : BoxedUnit.UNIT;
        return this.drop(1);
    }

    private long argTakeWhile(Function1<Object, Object> p) {
        int current;
        if (this.isEmpty()) {
            return this.start();
        }
        int stop = this.last();
        for (current = this.start(); current != stop && p.apply$mcZI$sp(current); current += this.step()) {
        }
        if (current != stop || !p.apply$mcZI$sp(current)) {
            return current;
        }
        return (long)current + (long)this.step();
    }

    private int locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    private Range newEmptyRange(int value) {
        return new Range(value, value, this.step());
    }

    @Override
    public final Range takeWhile(Function1<Object, Object> p) {
        long stop = this.argTakeWhile(p);
        if (stop == (long)this.start()) {
            return this.newEmptyRange(this.start());
        }
        int x = (int)(stop - (long)this.step());
        if (x == this.last()) {
            return this;
        }
        return new Inclusive(this.start(), x, this.step());
    }

    @Override
    public final Range dropWhile(Function1<Object, Object> p) {
        long stop = this.argTakeWhile(p);
        if (stop == (long)this.start()) {
            return this;
        }
        int x = (int)(stop - (long)this.step());
        if (x == this.last()) {
            return this.newEmptyRange(this.last());
        }
        return new Inclusive(x + this.step(), this.last(), this.step());
    }

    @Override
    public final Tuple2<Range, Range> span(Function1<Object, Object> p) {
        long border = this.argTakeWhile(p);
        if (border == (long)this.start()) {
            return new Tuple2<Range, Range>(this.newEmptyRange(this.start()), this);
        }
        int x = (int)(border - (long)this.step());
        if (x == this.last()) {
            return new Tuple2<Range, Range>(this, this.newEmptyRange(this.last()));
        }
        return new Tuple2<Range, Range>(new Inclusive(this.start(), x, this.step()), new Inclusive(x + this.step(), this.last(), this.step()));
    }

    @Override
    public final Tuple2<Range, Range> splitAt(int n) {
        return new Tuple2<Range, Range>(this.take(n), this.drop(n));
    }

    @Override
    public final Range takeRight(int n) {
        if (n <= 0) {
            return this.newEmptyRange(this.start());
        }
        if (this.numRangeElements() >= 0) {
            return this.drop(this.numRangeElements() - n);
        }
        int y = this.last();
        long x = (long)y - (long)this.step() * (long)(n - 1);
        if (this.step() > 0 && x < (long)this.start() || this.step() < 0 && x > (long)this.start()) {
            return this;
        }
        return new Inclusive((int)x, y, this.step());
    }

    @Override
    public final Range dropRight(int n) {
        if (n <= 0) {
            return this;
        }
        if (this.numRangeElements() >= 0) {
            return this.take(this.numRangeElements() - n);
        }
        int y = this.last() - this.step() * n;
        if (this.step() > 0 && y < this.start() || this.step() < 0 && y > this.start()) {
            return this.newEmptyRange(this.start());
        }
        return new Inclusive(this.start(), y, this.step());
    }

    @Override
    public final Range reverse() {
        if (this.isEmpty()) {
            return this;
        }
        return new Inclusive(this.last(), this.start(), -this.step());
    }

    public Range inclusive() {
        if (this.isInclusive()) {
            return this;
        }
        return new Inclusive(this.start(), this.end(), this.step());
    }

    @Override
    public final boolean contains(int x) {
        if (x == this.end() && !this.isInclusive()) {
            return false;
        }
        if (this.step() > 0) {
            if (x < this.start() || x > this.end()) {
                return false;
            }
            return this.step() == 1 || (x - this.start()) % this.step() == 0;
        }
        if (x < this.end() || x > this.start()) {
            return false;
        }
        return this.step() == -1 || (x - this.start()) % this.step() == 0;
    }

    @Override
    public final <B> int sum(Numeric<B> num) {
        if (num == Numeric$IntIsIntegral$.MODULE$) {
            if (this.isEmpty()) {
                return 0;
            }
            if (this.numRangeElements() == 1) {
                return this.head();
            }
            return (int)((long)this.numRangeElements() * (long)(this.head() + this.last()) / 2L);
        }
        if (this.isEmpty()) {
            return num.toInt(num.zero());
        }
        Object acc = num.zero();
        for (int i = this.head(); i != this.terminalElement(); i += this.step()) {
            acc = num.plus(acc, BoxesRunTime.boxToInteger(i));
        }
        return num.toInt(acc);
    }

    @Override
    public Range toIterable() {
        return this;
    }

    @Override
    public Range toSeq() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        int l0;
        Range range;
        Object object = other;
        boolean bl = object instanceof Range ? (range = (Range)object).canEqual(this) && (this.isEmpty() ? range.isEmpty() : range.nonEmpty() && this.start() == range.start() && (l0 = this.last()) == range.last() && (this.start() == l0 || this.step() == range.step())) : GenSeqLike$class.equals(this, other);
        return bl;
    }

    @Override
    public String toString() {
        String endStr = this.numRangeElements() > Range$.MODULE$.MAX_PRINT() || !this.isEmpty() && this.numRangeElements() < 0 ? ", ... )" : ")";
        return this.take(Range$.MODULE$.MAX_PRINT()).mkString("Range(", ", ", endStr);
    }

    public final void foreach$mVc$sp(Function1<Object, BoxedUnit> f) {
        this.scala$collection$immutable$Range$$validateMaxLength();
        boolean isCommonCase = this.start() != Integer.MIN_VALUE || this.end() != Integer.MIN_VALUE;
        int i = this.start();
        int count = 0;
        int terminal = this.terminalElement();
        int step = this.step();
        while (true) {
            boolean bl = isCommonCase ? i != terminal : count < this.numRangeElements();
            if (!bl) break;
            f.apply$mcVI$sp(i);
            ++count;
            i += step;
        }
    }

    @Override
    public int apply$mcII$sp(int idx) {
        this.scala$collection$immutable$Range$$validateMaxLength();
        if (idx < 0 || idx >= this.numRangeElements()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(idx)).toString());
        }
        return this.start() + this.step() * idx;
    }

    public Range(int start, int end, int step) {
        int n;
        long len;
        this.start = start;
        this.end = end;
        this.step = step;
        Traversable$class.$init$(this);
        Iterable$class.$init$(this);
        Seq$class.$init$(this);
        IndexedSeqLike$class.$init$(this);
        IndexedSeq$class.$init$(this);
        scala.collection.immutable.IndexedSeq$class.$init$(this);
        CustomParallelizable$class.$init$(this);
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !this.isInclusive();
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        int n2 = this.isEmpty() ? 0 : (this.numRangeElements = (len = this.longLength()) > Integer.MAX_VALUE ? -1 : (int)len);
        if (this.isEmpty()) {
            n = start - step;
        } else {
            int n3 = step;
            switch (n3) {
                case 1: {
                    if (this.isInclusive()) {
                        n = end;
                        break;
                    }
                    n = end - 1;
                    break;
                }
                case -1: {
                    if (this.isInclusive()) {
                        n = end;
                        break;
                    }
                    n = end + 1;
                    break;
                }
                default: {
                    int remainder = (int)(this.gap() % (long)step);
                    n = remainder != 0 ? end - remainder : (this.isInclusive() ? end : end - step);
                }
            }
        }
        this.lastElement = n;
        this.terminalElement = this.lastElement() + step;
    }

    public static class Inclusive
    extends Range {
        @Override
        public boolean isInclusive() {
            return true;
        }

        @Override
        public Range copy(int start, int end, int step) {
            return new Inclusive(start, end, step);
        }

        public Inclusive(int start, int end, int step) {
            super(start, end, step);
        }
    }

    public static class Partial<T, U> {
        private final Function1<T, U> f;

        public U by(T x) {
            return this.f.apply(x);
        }

        public Partial(Function1<T, U> f) {
            this.f = f;
        }
    }
}

