/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Map;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.RedBlackTree;
import scala.collection.immutable.RedBlackTree$BlackTree$;
import scala.collection.immutable.RedBlackTree$NList$;
import scala.collection.immutable.RedBlackTree$RedTree$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;
import scala.sys.package$;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    static {
        new RedBlackTree$();
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return this.lookup(tree, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$2) {
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$2);
        Option option = tree2 == null ? None$.MODULE$ : new Some<B>(tree2.value());
        return option;
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        while (true) {
            if (tree == null) {
                return null;
            }
            int cmp = ordering.compare(x, tree.key());
            if (cmp < 0) {
                tree = tree.left();
                continue;
            }
            if (cmp <= 0) break;
            tree = tree.right();
        }
        return tree;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        if (tree == null) {
            return 0;
        }
        return tree.count();
    }

    public <A> int countInRange(RedBlackTree.Tree<A, ?> tree, Option<A> from, Option<A> to, Ordering<A> ordering) {
        int n;
        block6: {
            while (true) {
                Option<A> option;
                Option<A> option2;
                if (tree == null) {
                    return 0;
                }
                Tuple2<Option<A>, Option<A>> tuple2 = new Tuple2<Option<A>, Option<A>>(from, to);
                if (tuple2 != null) {
                    Option<A> option3 = tuple2._1();
                    Option<A> option4 = tuple2._2();
                    if (None$.MODULE$.equals(option3) && None$.MODULE$.equals(option4)) {
                        n = tree.count();
                        break block6;
                    }
                }
                if (tuple2 != null && (option2 = tuple2._1()) instanceof Some) {
                    Some some = (Some)option2;
                    Object lb = some.x();
                    if (ordering.lt(tree.key(), lb)) {
                        tree = tree.right();
                        continue;
                    }
                }
                if (tuple2 == null || !((option = tuple2._2()) instanceof Some)) break;
                Some some = (Some)option;
                Object ub = some.x();
                if (!ordering.gteq(tree.key(), ub)) break;
                tree = tree.left();
            }
            n = 1 + this.countInRange(tree.left(), from, None$.MODULE$, ordering) + this.countInRange(tree.right(), None$.MODULE$, to, ordering);
        }
        return n;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$3));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree, k, evidence$4));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$5) {
        Tuple2<Option<A>, Option<A>> tuple2 = new Tuple2<Option<A>, Option<A>>(from, until);
        if (tuple2 != null) {
            Option<A> option = tuple2._1();
            Option<A> option2 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object from2 = some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object until2 = some2.x();
                    return this.range(tree, from2, until2, evidence$5);
                }
            }
        }
        if (tuple2 != null) {
            Option<A> option = tuple2._1();
            Option<A> option3 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object from3 = some.x();
                if (None$.MODULE$.equals(option3)) {
                    return this.from(tree, from3, evidence$5);
                }
            }
        }
        if (tuple2 != null) {
            Option<A> option = tuple2._1();
            Option<A> option4 = tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                Object until3 = some.x();
                return this.until(tree, until3, evidence$5);
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Option<A> option = tuple2._1();
        Option<A> option5 = tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError(tuple2);
        if (!None$.MODULE$.equals(option5)) throw new MatchError(tuple2);
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree, from, until, evidence$6));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree, from, evidence$7));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree, to, evidence$8));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree, key, evidence$9));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.left() != null) {
            result = result.left();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.right() != null) {
            result = result.right();
        }
        return var2_2;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        if (tree != null) {
            this._foreach(tree, f);
        }
    }

    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreach(tree.left(), f);
            }
            f.apply(new Tuple2<A, B>(tree.key(), tree.value()));
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        if (tree != null) {
            this._foreachKey(tree, f);
        }
    }

    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachKey(tree.left(), f);
            }
            f.apply(tree.key());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$13) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, evidence$13);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$14) {
        return new RedBlackTree.KeysIterator(tree, start, evidence$14);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$15) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, evidence$15);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            int count;
            if (n < (count = this.count(tree.left()))) {
                tree = tree.left();
                continue;
            }
            if (n <= count) break;
            n = n - count - 1;
            tree = tree.right();
        }
        return tree;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || this.isBlackTree(tree);
    }

    private boolean isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.RedTree;
    }

    private boolean isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.BlackTree;
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        if (t == null) {
            return null;
        }
        return t.black();
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, RedBlackTree.Tree<A, B> l, RedBlackTree.Tree<A, B> r) {
        void apply_value;
        void apply_left;
        void apply_right;
        if (isBlack) {
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B> tree = r;
            RedBlackTree.Tree<A, B> tree2 = l;
            B b = v;
            A a = k;
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(a, b, tree2, tree);
            return blackTree;
        }
        RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
        RedBlackTree.Tree<A, B> tree = r;
        void var15_13 = apply_right;
        void var14_14 = apply_left;
        void var13_15 = apply_value;
        if (redBlackTree$RedTree$ == null) {
            throw null;
        }
        RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
        RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>(var13_15, var14_14, (RedBlackTree.Tree<void, void>)var15_13, (RedBlackTree.Tree<void, void>)tree);
        return redTree;
    }

    /*
     * WARNING - void declaration
     */
    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceLeft(boolean isBlack, A z, B zv, RedBlackTree.Tree<A, B1> l, RedBlackTree.Tree<A, B1> d) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        RedBlackTree$ apply_this;
        void apply_value;
        void apply_left;
        void apply_right;
        if (this.isRedTree(l) && this.isRedTree(l.left())) {
            RedBlackTree.BlackTree<void, void> blackTree;
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree = l.left().right();
            RedBlackTree.Tree<A, B1> tree2 = l.left().left();
            B1 B1 = l.left().value();
            A a = l.left().key();
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree<A, B1> blackTree2 = new RedBlackTree.BlackTree<A, B1>(a, B1, tree2, tree);
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$3 = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree3 = d;
            RedBlackTree.Tree tree4 = apply_right.right();
            void var14_14 = apply_left;
            void var13_15 = apply_value;
            if (redBlackTree$BlackTree$3 == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$4 = redBlackTree$BlackTree$3;
            RedBlackTree.BlackTree<void, void> blackTree3 = blackTree = new RedBlackTree.BlackTree<void, void>(var13_15, var14_14, tree4, tree3);
            RedBlackTree.BlackTree<A, B1> blackTree4 = blackTree2;
            B1 B12 = l.value();
            A a2 = l.key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>((void)a2, (void)B12, (RedBlackTree.Tree<void, void>)blackTree4, (RedBlackTree.Tree<void, void>)blackTree3);
            return redTree;
        }
        if (apply_this.isRedTree((RedBlackTree.Tree<?, ?>)apply_right) && apply_this.isRedTree(apply_right.right())) {
            RedBlackTree.BlackTree<void, void> blackTree;
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree tree = apply_right.right().left();
            RedBlackTree.Tree tree5 = apply_right.left();
            Object b = apply_right.value();
            Object a = apply_right.key();
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$5 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree blackTree5 = new RedBlackTree.BlackTree(a, b, tree5, tree);
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$6 = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree6 = d;
            RedBlackTree.Tree tree7 = apply_right.right().right();
            void var32_32 = apply_left;
            void var31_33 = apply_value;
            if (redBlackTree$BlackTree$6 == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$7 = redBlackTree$BlackTree$6;
            RedBlackTree.BlackTree<void, void> blackTree6 = blackTree = new RedBlackTree.BlackTree<void, void>(var31_33, var32_32, tree7, tree6);
            RedBlackTree.BlackTree blackTree7 = blackTree5;
            Object b2 = apply_right.right().value();
            Object a3 = apply_right.right().key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$3 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>((void)a3, (void)b2, blackTree7, (RedBlackTree.Tree<void, void>)blackTree6);
            return redTree;
        }
        return this.mkTree((boolean)var1_1, var2_2, var3_3, (RedBlackTree.Tree<A, B>)var4_4, d);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceRight(boolean isBlack, A x, B xv, RedBlackTree.Tree<A, B1> a, RedBlackTree.Tree<A, B1> r) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        RedBlackTree$ apply_this;
        if (this.isRedTree(r) && this.isRedTree(r.left())) {
            RedBlackTree.BlackTree<A, B1> blackTree;
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree = r.left().left();
            RedBlackTree.Tree<A, B1> tree2 = a;
            B b = xv;
            A a2 = x;
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree<A, B> blackTree2 = new RedBlackTree.BlackTree<A, B>(a2, b, tree2, tree);
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$3 = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree3 = r.right();
            RedBlackTree.Tree<A, B1> tree4 = r.left().right();
            B1 B1 = r.value();
            A a3 = r.key();
            if (redBlackTree$BlackTree$3 == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$4 = redBlackTree$BlackTree$3;
            RedBlackTree.BlackTree<A, B1> blackTree3 = blackTree = new RedBlackTree.BlackTree<A, B1>(a3, B1, tree4, tree3);
            RedBlackTree.BlackTree<A, B> blackTree4 = blackTree2;
            B1 B12 = r.left().value();
            A a4 = r.left().key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<A, B1> redTree = new RedBlackTree.RedTree<A, B1>(a4, B12, blackTree4, blackTree3);
            return redTree;
        }
        if (apply_this.isRedTree(r) && apply_this.isRedTree(r.right())) {
            RedBlackTree.BlackTree<A, B1> blackTree;
            void apply_value;
            void apply_left;
            void apply_right;
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree = r.left();
            void var27_25 = apply_right;
            void var26_26 = apply_left;
            void var25_27 = apply_value;
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$5 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree<void, void> blackTree5 = new RedBlackTree.BlackTree<void, void>(var25_27, var26_26, (RedBlackTree.Tree<void, void>)var27_25, (RedBlackTree.Tree<void, void>)tree);
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$6 = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree5 = r.right().right();
            RedBlackTree.Tree<A, B1> tree6 = r.right().left();
            B1 B1 = r.right().value();
            A a5 = r.right().key();
            if (redBlackTree$BlackTree$6 == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$7 = redBlackTree$BlackTree$6;
            RedBlackTree.BlackTree<A, B1> blackTree6 = blackTree = new RedBlackTree.BlackTree<A, B1>(a5, B1, tree6, tree5);
            RedBlackTree.BlackTree<void, void> blackTree7 = blackTree5;
            B1 B13 = r.value();
            A a6 = r.key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$3 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>((void)a6, (void)B13, (RedBlackTree.Tree<void, void>)blackTree7, (RedBlackTree.Tree<void, void>)blackTree6);
            return redTree;
        }
        return this.mkTree((boolean)var1_1, var2_2, var3_3, (RedBlackTree.Tree<A, B>)var4_4, r);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering) {
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        if (tree == null) {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree.Tree tree2 = null;
            RedBlackTree.Tree tree3 = null;
            B1 B1 = v;
            A a = k;
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<A, B1> redTree = new RedBlackTree.RedTree<A, B1>(a, B1, tree3, tree2);
            return redTree;
        }
        int cmp = ordering.compare(var2_2, var1_1.key());
        if (cmp < 0) {
            return this.balanceLeft(this.isBlackTree((RedBlackTree.Tree<?, ?>)var1_1), var1_1.key(), var1_1.value(), this.upd(var1_1.left(), var2_2, var3_3, (boolean)var4_4, ordering), var1_1.right());
        }
        if (cmp > 0) {
            return this.balanceRight(this.isBlackTree((RedBlackTree.Tree<?, ?>)var1_1), var1_1.key(), var1_1.value(), var1_1.left(), this.upd(var1_1.right(), var2_2, var3_3, (boolean)var4_4, ordering));
        }
        if (var4_4 != false || !BoxesRunTime.equals(var2_2, var1_1.key())) {
            return this.mkTree(this.isBlackTree((RedBlackTree.Tree<?, ?>)var1_1), var2_2, var3_3, var1_1.left(), var1_1.right());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree, int idx, A k, B1 v, boolean overwrite) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        if (tree == null) {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree.Tree tree2 = null;
            RedBlackTree.Tree tree3 = null;
            B1 B1 = v;
            A a = k;
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<A, B1> redTree = new RedBlackTree.RedTree<A, B1>(a, B1, tree3, tree2);
            return redTree;
        }
        int rank = this.count(var1_1.left()) + 1;
        if (var2_2 < rank) {
            return this.balanceLeft(this.isBlackTree((RedBlackTree.Tree<?, ?>)var1_1), var1_1.key(), var1_1.value(), this.updNth(var1_1.left(), (int)var2_2, var3_3, var4_4, overwrite), var1_1.right());
        }
        if (var2_2 > rank) {
            return this.balanceRight(this.isBlackTree((RedBlackTree.Tree<?, ?>)var1_1), var1_1.key(), var1_1.value(), var1_1.left(), this.updNth(var1_1.right(), (int)(var2_2 - rank), var3_3, var4_4, overwrite));
        }
        if (overwrite) {
            return this.mkTree(this.isBlackTree((RedBlackTree.Tree<?, ?>)var1_1), var3_3, var4_4, var1_1.left(), var1_1.right());
        }
        return var1_1;
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        int cmp = ordering.compare(k, tree.key());
        if (cmp < 0) {
            return this.delLeft$1(tree, k, ordering);
        }
        if (cmp > 0) {
            return this.delRight$1(tree, k, ordering);
        }
        return this.append$1(tree.left(), tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doFrom(tree.right(), from, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        if (newLeft == tree.left()) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(tree.right(), tree.key(), tree.value(), false, ordering);
        }
        return this.rebalance(tree, newLeft, tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(to, tree.key())) {
            return this.doTo(tree.left(), to, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree.right(), to, ordering);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.left(), tree.key(), tree.value(), false, ordering);
        }
        return this.rebalance(tree, tree.left(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doUntil(tree.left(), until, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.left(), tree.key(), tree.value(), false, ordering);
        }
        return this.rebalance(tree, tree.left(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doRange(tree.right(), from, until, ordering);
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doRange(tree.left(), from, until, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        if (newLeft == tree.left() && newRight == tree.right()) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(newRight, tree.key(), tree.value(), false, ordering);
        }
        if (newRight == null) {
            return this.upd(newLeft, tree.key(), tree.value(), false, ordering);
        }
        return this.rebalance(tree, newLeft, newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return tree;
        }
        if (n >= this.count(tree)) {
            return null;
        }
        int count = this.count(tree.left());
        if (n > count) {
            return this.doDrop(tree.right(), n - count - 1);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), n);
        if (newLeft == tree.left()) {
            return tree;
        }
        if (newLeft == null) {
            return this.updNth(tree.right(), n - count - 1, tree.key(), tree.value(), false);
        }
        return this.rebalance(tree, newLeft, tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return null;
        }
        if (n >= this.count(tree)) {
            return tree;
        }
        int count = this.count(tree.left());
        if (n <= count) {
            return this.doTake(tree.left(), n);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), n - count - 1);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.updNth(tree.left(), n, tree.key(), tree.value(), false);
        }
        return this.rebalance(tree, tree.left(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from, int until) {
        if (tree == null) {
            return null;
        }
        int count = this.count(tree.left());
        if (from > count) {
            return this.doSlice(tree.right(), from - count - 1, until - count - 1);
        }
        if (until <= count) {
            return this.doSlice(tree.left(), from, until);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), from);
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), until - count - 1);
        if (newLeft == tree.left() && newRight == tree.right()) {
            return tree;
        }
        if (newLeft == null) {
            return this.updNth(newRight, from - count - 1, tree.key(), tree.value(), false);
        }
        if (newRight == null) {
            return this.updNth(newLeft, until, tree.key(), tree.value(), false);
        }
        return this.rebalance(tree, newLeft, newRight);
    }

    private <A, B> Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> compareDepth(RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return this.unzipBoth$1(left, right, null, null, 0);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Tree<A, B> rebalance(RedBlackTree.Tree<A, B> tree2, RedBlackTree.Tree<A, B> newLeft, RedBlackTree.Tree<A, B> newRight) {
        RedBlackTree.RedTree redTree;
        void apply_key;
        RedBlackTree$ apply_this;
        RedBlackTree.Tree<A, B> blkNewRight;
        RedBlackTree.Tree<A, B> blkNewLeft = this.blacken(newLeft);
        Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> tuple4 = this.compareDepth(blkNewLeft, blkNewRight = this.blacken(newRight));
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        RedBlackTree.NList<RedBlackTree.Tree<A, B>> zipper = tuple4._1();
        boolean levelled = BoxesRunTime.unboxToBoolean(tuple4._2());
        boolean leftMost = BoxesRunTime.unboxToBoolean(tuple4._3());
        int smallerDepth = BoxesRunTime.unboxToInt(tuple4._4());
        Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Boolean, Boolean, Integer> tuple42 = new Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Boolean, Boolean, Integer>(zipper, BoxesRunTime.boxToBoolean(levelled), BoxesRunTime.boxToBoolean(leftMost), BoxesRunTime.boxToInteger(smallerDepth));
        Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Boolean, Boolean, Integer> tuple43 = tuple42;
        RedBlackTree.NList<RedBlackTree.Tree<A, B>> zipper2 = tuple43._1();
        boolean levelled2 = BoxesRunTime.unboxToBoolean(tuple43._2());
        boolean leftMost2 = BoxesRunTime.unboxToBoolean(tuple43._3());
        int smallerDepth2 = BoxesRunTime.unboxToInt(tuple43._4());
        if (levelled2) {
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B> tree3 = blkNewRight;
            RedBlackTree.Tree<A, B> tree4 = blkNewLeft;
            B b = tree2.value();
            A a = tree2.key();
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(a, b, tree4, tree3);
            return blackTree;
        }
        RedBlackTree.NList zipFrom = apply_this.findDepth$1(zipper2, smallerDepth2);
        if (leftMost2) {
            RedBlackTree.RedTree redTree2;
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree.Tree tree5 = (RedBlackTree.Tree)zipFrom.head();
            RedBlackTree.Tree<A, B> tree6 = blkNewLeft;
            Object b = apply_key.value();
            Object a = apply_key.key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
            redTree = redTree2 = new RedBlackTree.RedTree(a, b, tree6, tree5);
        } else {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree.Tree<A, B> tree7 = blkNewRight;
            RedBlackTree.Tree tree8 = (RedBlackTree.Tree)zipFrom.head();
            Object b = apply_key.value();
            Object a = apply_key.key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$3 = redBlackTree$RedTree$;
            RedBlackTree.RedTree redTree3 = new RedBlackTree.RedTree(a, b, tree8, tree7);
            redTree = redTree3;
        }
        RedBlackTree.RedTree union = redTree;
        RedBlackTree.Tree zippedTree = RedBlackTree$NList$.MODULE$.foldLeft(zipFrom.tail(), union, (JFunction2 & java.io.Serializable & Serializable)(tree, node) -> {
            if (leftMost2) {
                return this.balanceLeft(this.isBlackTree((RedBlackTree.Tree<?, ?>)node), node.key(), node.value(), (RedBlackTree.Tree)tree, node.right());
            }
            return this.balanceRight(this.isBlackTree((RedBlackTree.Tree<?, ?>)node), node.key(), node.value(), node.left(), (RedBlackTree.Tree)tree);
        });
        return zippedTree;
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree balance$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        void apply_key;
        void apply_value;
        void apply_right;
        void apply_left;
        RedBlackTree$ apply_this;
        if (this.isRedTree(tl)) {
            if (this.isRedTree(tr)) {
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                RedBlackTree.Tree tree = tr.black();
                RedBlackTree.Tree tree2 = tl.black();
                Object object = xv;
                Object object2 = x;
                if (redBlackTree$RedTree$ == null) {
                    throw null;
                }
                RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
                RedBlackTree.RedTree<Object, Object> redTree = new RedBlackTree.RedTree<Object, Object>(object2, object, tree2, tree);
                return redTree;
            }
            if (apply_this.isRedTree(apply_left.left())) {
                RedBlackTree.BlackTree<void, void> blackTree;
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                void var15_11 = apply_right;
                RedBlackTree.Tree tree = apply_left.right();
                void var13_13 = apply_value;
                void var12_14 = apply_key;
                if (redBlackTree$BlackTree$ == null) {
                    throw null;
                }
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = redBlackTree$BlackTree$;
                RedBlackTree.BlackTree<void, void> blackTree2 = blackTree = new RedBlackTree.BlackTree<void, void>(var12_14, var13_13, tree, (RedBlackTree.Tree<void, void>)var15_11);
                RedBlackTree.Tree tree3 = apply_left.left().black();
                Object b = apply_left.value();
                Object a = apply_left.key();
                if (redBlackTree$RedTree$ == null) {
                    throw null;
                }
                RedBlackTree$RedTree$ redBlackTree$RedTree$3 = redBlackTree$RedTree$;
                RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>((void)a, (void)b, tree3, (RedBlackTree.Tree<void, void>)blackTree2);
                return redTree;
            }
            if (apply_this.isRedTree(apply_left.right())) {
                RedBlackTree.BlackTree<void, void> blackTree;
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree = apply_left.right().left();
                RedBlackTree.Tree tree4 = apply_left.left();
                Object b = apply_left.value();
                Object a = apply_left.key();
                if (redBlackTree$BlackTree$ == null) {
                    throw null;
                }
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$3 = redBlackTree$BlackTree$;
                RedBlackTree.BlackTree blackTree3 = new RedBlackTree.BlackTree(a, b, tree4, tree);
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$4 = RedBlackTree$BlackTree$.MODULE$;
                void var33_29 = apply_right;
                RedBlackTree.Tree tree5 = apply_left.right().right();
                void var31_31 = apply_value;
                void var30_32 = apply_key;
                if (redBlackTree$BlackTree$4 == null) {
                    throw null;
                }
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$5 = redBlackTree$BlackTree$4;
                RedBlackTree.BlackTree<void, void> blackTree4 = blackTree = new RedBlackTree.BlackTree<void, void>(var30_32, var31_31, tree5, (RedBlackTree.Tree<void, void>)var33_29);
                RedBlackTree.BlackTree blackTree5 = blackTree3;
                Object b2 = apply_left.right().value();
                Object a2 = apply_left.right().key();
                if (redBlackTree$RedTree$ == null) {
                    throw null;
                }
                RedBlackTree$RedTree$ redBlackTree$RedTree$4 = redBlackTree$RedTree$;
                RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>((void)a2, (void)b2, blackTree5, (RedBlackTree.Tree<void, void>)blackTree4);
                return redTree;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            void var45_41 = apply_right;
            void var44_42 = apply_left;
            void var43_43 = apply_value;
            void var42_44 = apply_key;
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$6 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree<void, void> blackTree = new RedBlackTree.BlackTree<void, void>(var42_44, var43_43, (RedBlackTree.Tree<void, void>)var44_42, (RedBlackTree.Tree<void, void>)var45_41);
            return blackTree;
        }
        if (apply_this.isRedTree((RedBlackTree.Tree<?, ?>)apply_right)) {
            if (apply_this.isRedTree(apply_right.right())) {
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree = apply_right.left();
                void var50_48 = apply_left;
                void var49_49 = apply_value;
                void var48_50 = apply_key;
                if (redBlackTree$BlackTree$ == null) {
                    throw null;
                }
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$7 = redBlackTree$BlackTree$;
                RedBlackTree.BlackTree<void, void> blackTree = new RedBlackTree.BlackTree<void, void>(var48_50, var49_49, (RedBlackTree.Tree<void, void>)var50_48, tree);
                RedBlackTree.Tree tree6 = apply_right.right().black();
                RedBlackTree.BlackTree<void, void> blackTree6 = blackTree;
                Object b = apply_right.value();
                Object a = apply_right.key();
                if (redBlackTree$RedTree$ == null) {
                    throw null;
                }
                RedBlackTree$RedTree$ redBlackTree$RedTree$5 = redBlackTree$RedTree$;
                RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>((void)a, (void)b, (RedBlackTree.Tree<void, void>)blackTree6, tree6);
                return redTree;
            }
            if (apply_this.isRedTree(apply_right.left())) {
                RedBlackTree.BlackTree blackTree;
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree = apply_right.left().left();
                void var62_60 = apply_left;
                void var61_61 = apply_value;
                void var60_62 = apply_key;
                if (redBlackTree$BlackTree$ == null) {
                    throw null;
                }
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$8 = redBlackTree$BlackTree$;
                RedBlackTree.BlackTree<void, void> blackTree7 = new RedBlackTree.BlackTree<void, void>(var60_62, var61_61, (RedBlackTree.Tree<void, void>)var62_60, tree);
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$9 = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree7 = apply_right.right();
                RedBlackTree.Tree tree8 = apply_right.left().right();
                Object b = apply_right.value();
                Object a = apply_right.key();
                if (redBlackTree$BlackTree$9 == null) {
                    throw null;
                }
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$10 = redBlackTree$BlackTree$9;
                RedBlackTree.BlackTree blackTree8 = blackTree = new RedBlackTree.BlackTree(a, b, tree8, tree7);
                RedBlackTree.BlackTree<void, void> blackTree9 = blackTree7;
                Object b3 = apply_right.left().value();
                Object a3 = apply_right.left().key();
                if (redBlackTree$RedTree$ == null) {
                    throw null;
                }
                RedBlackTree$RedTree$ redBlackTree$RedTree$6 = redBlackTree$RedTree$;
                RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>((void)a3, (void)b3, (RedBlackTree.Tree<void, void>)blackTree9, blackTree8);
                return redTree;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            void var81_77 = apply_right;
            void var80_78 = apply_left;
            void var79_79 = apply_value;
            void var78_80 = apply_key;
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$11 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree<void, void> blackTree = new RedBlackTree.BlackTree<void, void>(var78_80, var79_79, (RedBlackTree.Tree<void, void>)var80_78, (RedBlackTree.Tree<void, void>)var81_77);
            return blackTree;
        }
        RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
        void var87_83 = apply_right;
        void var86_84 = apply_left;
        void var85_85 = apply_value;
        void var84_86 = apply_key;
        if (redBlackTree$BlackTree$ == null) {
            throw null;
        }
        RedBlackTree$BlackTree$ redBlackTree$BlackTree$12 = redBlackTree$BlackTree$;
        RedBlackTree.BlackTree<void, void> blackTree = new RedBlackTree.BlackTree<void, void>(var84_86, var85_85, (RedBlackTree.Tree<void, void>)var86_84, (RedBlackTree.Tree<void, void>)var87_83);
        return blackTree;
    }

    private final RedBlackTree.Tree subl$1(RedBlackTree.Tree t) {
        if (t instanceof RedBlackTree.BlackTree) {
            return t.red();
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"Defect: invariance violation; expected black, got ").append(t).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree balLeft$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        void apply_left;
        void apply_value;
        void apply_key;
        void apply_right;
        RedBlackTree$ apply_this;
        if (this.isRedTree(tl)) {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree.Tree tree = tr;
            RedBlackTree.Tree tree2 = tl.black();
            Object object = xv;
            Object object2 = x;
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<Object, Object> redTree = new RedBlackTree.RedTree<Object, Object>(object2, object, tree2, tree);
            return redTree;
        }
        if (apply_this.isBlackTree((RedBlackTree.Tree<?, ?>)apply_right)) {
            return apply_this.balance$1(apply_key, apply_value, (RedBlackTree.Tree)apply_left, apply_right.red());
        }
        if (apply_this.isRedTree((RedBlackTree.Tree<?, ?>)apply_right) && apply_this.isBlackTree(apply_right.left())) {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree tree = apply_right.left().left();
            void var14_12 = apply_left;
            void var13_13 = apply_value;
            void var12_14 = apply_key;
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree<void, void> blackTree = new RedBlackTree.BlackTree<void, void>(var12_14, var13_13, (RedBlackTree.Tree<void, void>)var14_12, tree);
            RedBlackTree.Tree tree3 = apply_this.balance$1(apply_right.key(), apply_right.value(), apply_right.left().right(), apply_this.subl$1(apply_right.right()));
            RedBlackTree.BlackTree<void, void> blackTree2 = blackTree;
            Object b = apply_right.left().value();
            Object a = apply_right.left().key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$3 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>((void)a, (void)b, (RedBlackTree.Tree<void, void>)blackTree2, tree3);
            return redTree;
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree balRight$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        void apply_right;
        void apply_value;
        void apply_key;
        void apply_left;
        RedBlackTree$ apply_this;
        if (this.isRedTree(tr)) {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree.Tree tree = tr.black();
            RedBlackTree.Tree tree2 = tl;
            Object object = xv;
            Object object2 = x;
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<Object, Object> redTree = new RedBlackTree.RedTree<Object, Object>(object2, object, tree2, tree);
            return redTree;
        }
        if (apply_this.isBlackTree((RedBlackTree.Tree<?, ?>)apply_left)) {
            return apply_this.balance$1(apply_key, apply_value, apply_left.red(), (RedBlackTree.Tree)apply_right);
        }
        if (apply_this.isRedTree((RedBlackTree.Tree<?, ?>)apply_left) && apply_this.isBlackTree(apply_left.right())) {
            RedBlackTree.BlackTree<void, void> blackTree;
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            void var15_11 = apply_right;
            RedBlackTree.Tree tree = apply_left.right().right();
            void var13_13 = apply_value;
            void var12_14 = apply_key;
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree<void, void> blackTree2 = blackTree = new RedBlackTree.BlackTree<void, void>(var12_14, var13_13, tree, (RedBlackTree.Tree<void, void>)var15_11);
            RedBlackTree.Tree tree3 = apply_this.balance$1(apply_left.key(), apply_left.value(), apply_this.subl$1(apply_left.left()), apply_left.right().left());
            Object b = apply_left.right().value();
            Object a = apply_left.right().key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$3 = redBlackTree$RedTree$;
            RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>((void)a, (void)b, tree3, (RedBlackTree.Tree<void, void>)blackTree2);
            return redTree;
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private final RedBlackTree.Tree delLeft$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        if (this.isBlackTree(tree$1.left())) {
            return this.balLeft$1(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right());
        }
        RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
        RedBlackTree.Tree tree = tree$1.right();
        RedBlackTree.Tree tree2 = this.del(tree$1.left(), k$1, ordering$1);
        Object b = tree$1.value();
        Object a = tree$1.key();
        if (redBlackTree$RedTree$ == null) {
            throw null;
        }
        RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
        RedBlackTree.RedTree redTree = new RedBlackTree.RedTree(a, b, tree2, tree);
        return redTree;
    }

    private final RedBlackTree.Tree delRight$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        if (this.isBlackTree(tree$1.right())) {
            return this.balRight$1(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1));
        }
        RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
        RedBlackTree.Tree tree = this.del(tree$1.right(), k$1, ordering$1);
        RedBlackTree.Tree tree2 = tree$1.left();
        Object b = tree$1.value();
        Object a = tree$1.key();
        if (redBlackTree$RedTree$ == null) {
            throw null;
        }
        RedBlackTree$RedTree$ redBlackTree$RedTree$2 = redBlackTree$RedTree$;
        RedBlackTree.RedTree redTree = new RedBlackTree.RedTree(a, b, tree2, tree);
        return redTree;
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree append$1(RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        void var2_2;
        void var1_1;
        RedBlackTree$ apply_this;
        void apply_key;
        void apply_value;
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        if (this.isRedTree(tl) && this.isRedTree(tr)) {
            RedBlackTree.RedTree redTree;
            RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
            if (this.isRedTree(bc)) {
                RedBlackTree.RedTree redTree2;
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                RedBlackTree$RedTree$ redBlackTree$RedTree$2 = RedBlackTree$RedTree$.MODULE$;
                RedBlackTree.Tree tree = bc.left();
                RedBlackTree.Tree tree2 = tl.left();
                Object b = tl.value();
                Object a = tl.key();
                if (redBlackTree$RedTree$2 == null) {
                    throw null;
                }
                RedBlackTree$RedTree$ redBlackTree$RedTree$3 = redBlackTree$RedTree$2;
                RedBlackTree.RedTree redTree3 = new RedBlackTree.RedTree(a, b, tree2, tree);
                RedBlackTree$RedTree$ redBlackTree$RedTree$4 = RedBlackTree$RedTree$.MODULE$;
                RedBlackTree.Tree tree3 = apply_value.right();
                RedBlackTree.Tree tree4 = bc.right();
                Object b2 = apply_value.value();
                Object a2 = apply_value.key();
                if (redBlackTree$RedTree$4 == null) {
                    throw null;
                }
                RedBlackTree$RedTree$ redBlackTree$RedTree$5 = redBlackTree$RedTree$4;
                RedBlackTree.RedTree redTree4 = redTree2 = new RedBlackTree.RedTree(a2, b2, tree4, tree3);
                RedBlackTree.RedTree redTree5 = redTree3;
                Object b3 = bc.value();
                Object a3 = bc.key();
                if (redBlackTree$RedTree$ == null) {
                    throw null;
                }
                RedBlackTree$RedTree$ redBlackTree$RedTree$6 = redBlackTree$RedTree$;
                RedBlackTree.RedTree redTree6 = new RedBlackTree.RedTree(a3, b3, redTree5, redTree4);
                return redTree6;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree$RedTree$ redBlackTree$RedTree$7 = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree.Tree tree = apply_value.right();
            RedBlackTree.Tree tree5 = bc;
            Object b = apply_value.value();
            Object a = apply_value.key();
            if (redBlackTree$RedTree$7 == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$8 = redBlackTree$RedTree$7;
            RedBlackTree.RedTree redTree7 = redTree = new RedBlackTree.RedTree(a, b, tree5, tree);
            RedBlackTree.Tree tree6 = apply_key.left();
            Object b4 = apply_key.value();
            Object a4 = apply_key.key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$9 = redBlackTree$RedTree$;
            RedBlackTree.RedTree redTree8 = new RedBlackTree.RedTree(a4, b4, tree6, redTree7);
            return redTree8;
        }
        if (apply_this.isBlackTree((RedBlackTree.Tree<?, ?>)apply_key) && apply_this.isBlackTree((RedBlackTree.Tree<?, ?>)apply_value)) {
            RedBlackTree.Tree bc = apply_this.append$1(apply_key.right(), apply_value.left());
            if (apply_this.isRedTree(bc)) {
                RedBlackTree.BlackTree blackTree;
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree = bc.left();
                RedBlackTree.Tree tree7 = apply_key.left();
                Object b = apply_key.value();
                Object a = apply_key.key();
                if (redBlackTree$BlackTree$ == null) {
                    throw null;
                }
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = redBlackTree$BlackTree$;
                RedBlackTree.BlackTree blackTree2 = new RedBlackTree.BlackTree(a, b, tree7, tree);
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$3 = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree8 = apply_value.right();
                RedBlackTree.Tree tree9 = bc.right();
                Object b5 = apply_value.value();
                Object a5 = apply_value.key();
                if (redBlackTree$BlackTree$3 == null) {
                    throw null;
                }
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$4 = redBlackTree$BlackTree$3;
                RedBlackTree.BlackTree blackTree3 = blackTree = new RedBlackTree.BlackTree(a5, b5, tree9, tree8);
                RedBlackTree.BlackTree blackTree4 = blackTree2;
                Object b6 = bc.value();
                Object a6 = bc.key();
                if (redBlackTree$RedTree$ == null) {
                    throw null;
                }
                RedBlackTree$RedTree$ redBlackTree$RedTree$10 = redBlackTree$RedTree$;
                RedBlackTree.RedTree redTree = new RedBlackTree.RedTree(a6, b6, blackTree4, blackTree3);
                return redTree;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree tree = apply_value.right();
            RedBlackTree.Tree tree10 = bc;
            Object b = apply_value.value();
            Object a = apply_value.key();
            if (redBlackTree$BlackTree$ == null) {
                throw null;
            }
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$5 = redBlackTree$BlackTree$;
            RedBlackTree.BlackTree blackTree = new RedBlackTree.BlackTree(a, b, tree10, tree);
            return apply_this.balLeft$1(apply_key.key(), apply_key.value(), apply_key.left(), blackTree);
        }
        if (apply_this.isRedTree((RedBlackTree.Tree<?, ?>)apply_value)) {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree.Tree tree = apply_value.right();
            RedBlackTree.Tree tree11 = apply_this.append$1((RedBlackTree.Tree)apply_key, apply_value.left());
            Object b = apply_value.value();
            Object a = apply_value.key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$11 = redBlackTree$RedTree$;
            RedBlackTree.RedTree redTree = new RedBlackTree.RedTree(a, b, tree11, tree);
            return redTree;
        }
        if (apply_this.isRedTree((RedBlackTree.Tree<?, ?>)apply_key)) {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            RedBlackTree.Tree tree = apply_this.append$1(apply_key.right(), (RedBlackTree.Tree)apply_value);
            RedBlackTree.Tree tree12 = apply_key.left();
            Object b = apply_key.value();
            Object a = apply_key.key();
            if (redBlackTree$RedTree$ == null) {
                throw null;
            }
            RedBlackTree$RedTree$ redBlackTree$RedTree$12 = redBlackTree$RedTree$;
            RedBlackTree.RedTree redTree = new RedBlackTree.RedTree(a, b, tree12, tree);
            return redTree;
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"unmatched tree on append: ").append(var1_1).append((Object)", ").append(var2_2).toString());
    }

    private final RedBlackTree.NList unzip$1(RedBlackTree.NList zipper, boolean leftMost) {
        while (true) {
            RedBlackTree.Tree next;
            RedBlackTree.Tree tree = next = leftMost ? ((RedBlackTree.Tree)zipper.head()).left() : ((RedBlackTree.Tree)zipper.head()).right();
            if (next == null) {
                return zipper;
            }
            zipper = RedBlackTree$NList$.MODULE$.cons(next, zipper);
        }
    }

    private final Tuple4 unzipBoth$1(RedBlackTree.Tree left, RedBlackTree.Tree right, RedBlackTree.NList leftZipper, RedBlackTree.NList rightZipper, int smallerDepth) {
        while (true) {
            if (this.isBlackTree(left) && this.isBlackTree(right)) {
                ++smallerDepth;
                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
                right = right.left();
                left = left.right();
                continue;
            }
            if (this.isRedTree(left) && this.isRedTree(right)) {
                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
                right = right.left();
                left = left.right();
                continue;
            }
            if (this.isRedTree(right)) {
                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                right = right.left();
                continue;
            }
            if (!this.isRedTree(left)) break;
            leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
            left = left.right();
        }
        if (left == null && right == null) {
            return new Tuple4<Object, Boolean, Boolean, Integer>(null, BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(smallerDepth));
        }
        if (left == null && this.isBlackTree(right)) {
            boolean leftMost = true;
            return new Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer>(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(right, rightZipper), leftMost), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(leftMost), BoxesRunTime.boxToInteger(smallerDepth));
        }
        if (this.isBlackTree(left) && right == null) {
            boolean leftMost = false;
            return new Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer>(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(left, leftZipper), leftMost), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(leftMost), BoxesRunTime.boxToInteger(smallerDepth));
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"unmatched trees in unzip: ").append(left).append((Object)", ").append(right).toString());
    }

    private final RedBlackTree.NList findDepth$1(RedBlackTree.NList zipper, int depth) {
        while (true) {
            if (zipper == null) {
                throw package$.MODULE$.error("Defect: unexpected empty zipper while computing range");
            }
            if (this.isBlackTree((RedBlackTree.Tree)zipper.head())) {
                if (depth == 1) {
                    return zipper;
                }
                --depth;
                zipper = zipper.tail();
                continue;
            }
            zipper = zipper.tail();
        }
    }

    private RedBlackTree$() {
        MODULE$ = this;
    }
}

