/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction1;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private final double maxPreciseDouble;
    private final List<Tuple2<TimeUnit, String>> timeUnitLabels;
    private final Map<TimeUnit, String> timeUnitName;
    private final Map<String, TimeUnit> timeUnit;
    private final long \u00b5s_per_ns;
    private final long ms_per_ns;
    private final long s_per_ns;
    private final long min_per_ns;
    private final long h_per_ns;
    private final long d_per_ns;
    private final FiniteDuration Zero;
    private final Duration.Infinite Undefined;
    private final Duration.Infinite Inf;
    private final Duration.Infinite MinusInf;
    private static /* synthetic */ java.util.Map $deserializeLambdaCache$;

    static {
        new Duration$();
    }

    public Duration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, (TimeUnit)((Object)this.timeUnit().apply(unit)));
    }

    /*
     * WARNING - void declaration
     */
    public Duration apply(String s) {
        Duration duration;
        Duration$ augmentString_this;
        Predef$ predef$ = Predef$.MODULE$;
        String string = s;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        String string2 = string;
        String s1 = (String)new StringOps(string2).filterNot((JFunction1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean(Duration$.scala$concurrent$duration$Duration$$$anonfun$1(BoxesRunTime.unboxToChar(x$1))));
        String string3 = s1;
        boolean bl = "Inf".equals(string3) ? true : ("PlusInf".equals(string3) ? true : "+Inf".equals(string3));
        if (bl) {
            duration = augmentString_this.Inf();
        } else {
            boolean bl2 = "MinusInf".equals(string3) ? true : "-Inf".equals(string3);
            if (bl2) {
                duration = augmentString_this.MinusInf();
            } else {
                String string4;
                Predef$ predef$3;
                TimeUnit unit;
                Predef$ predef$4 = Predef$.MODULE$;
                Predef$ predef$5 = Predef$.MODULE$;
                Predef$ predef$6 = Predef$.MODULE$;
                String string5 = s1;
                if (predef$6 == null) {
                    throw null;
                }
                Predef$ predef$7 = predef$6;
                String string6 = string5;
                String string7 = (String)new StringOps(string6).reverse();
                if (predef$5 == null) {
                    throw null;
                }
                Predef$ predef$8 = predef$5;
                String string8 = string7;
                String string9 = (String)new StringOps(string8).takeWhile((JFunction1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean(Duration$.scala$concurrent$duration$Duration$$$anonfun$2(BoxesRunTime.unboxToChar(x$2))));
                if (predef$4 == null) {
                    throw null;
                }
                Predef$ predef$9 = predef$4;
                String string10 = string9;
                String unitName = (String)new StringOps(string10).reverse();
                Option option = augmentString_this.timeUnit().get(unitName);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    unit = (TimeUnit)((Object)some.x());
                    predef$3 = Predef$.MODULE$;
                    string4 = s1;
                    if (predef$3 == null) {
                        throw null;
                    }
                } else {
                    void var1_1;
                    throw new NumberFormatException(new StringBuilder().append((Object)"format error ").append(var1_1).toString());
                }
                Predef$ predef$10 = predef$3;
                String string11 = string4;
                String valueStr = (String)new StringOps(string11).dropRight(unitName.length());
                double valueD = Double.parseDouble(valueStr);
                FiniteDuration finiteDuration = valueD >= -9.007199254740992E15 && valueD <= 9.007199254740992E15 ? this.apply(valueD, unit) : this.apply(Long.parseLong(valueStr), unit);
                duration = finiteDuration;
            }
        }
        return duration;
    }

    private List<String> words(String s) {
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$._refArrayOps((Object[])s.trim().split("\\s+"))).toList();
    }

    private List<String> expandLabels(String labels) {
        List<String> list = this.words(labels);
        if (!(list instanceof $colon$colon)) {
            throw new MatchError(list);
        }
        $colon$colon $colon$colon = ($colon$colon)list;
        String hd = (String)$colon$colon.head();
        List rest = $colon$colon.tl$access$1();
        Tuple2 tuple2 = new Tuple2(hd, rest);
        Tuple2 tuple22 = tuple2;
        String hd2 = tuple22._1();
        List rest2 = tuple22._2();
        String string = hd2;
        return rest2.flatMap((JFunction1 & java.io.Serializable & Serializable)s -> List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{s, new StringBuilder().append(s).append((Object)"s").toString()})), List$.MODULE$.canBuildFrom()).$colon$colon(string);
    }

    public Map<TimeUnit, String> timeUnitName() {
        return this.timeUnitName;
    }

    public Map<String, TimeUnit> timeUnit() {
        return this.timeUnit;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(String s) {
        Option option;
        Option option2 = this.liftedTree1$1(s);
        Duration$ duration$ = this;
        Function1 function1 = (JFunction1 & java.io.Serializable & Serializable)d -> this.unapply((Duration)d);
        if (option2 == null) {
            throw null;
        }
        Option option3 = option2;
        if (option3.isEmpty()) {
            option = None$.MODULE$;
        } else {
            Object a = option3.get();
            option = duration$.scala$concurrent$duration$Duration$$$anonfun$7((Duration)a);
        }
        None$ none$ = option;
        return none$;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        if (d.isFinite()) {
            return new Some<Tuple2<Object, TimeUnit>>(new Tuple2<Long, TimeUnit>(BoxesRunTime.boxToLong(d.length()), d.unit()));
        }
        return None$.MODULE$;
    }

    public Duration fromNanos(double nanos) {
        if (Predef$.MODULE$.double2Double(nanos).isInfinite()) {
            if (nanos > 0.0) {
                return this.Inf();
            }
            return this.MinusInf();
        }
        if (Predef$.MODULE$.double2Double(nanos).isNaN()) {
            return this.Undefined();
        }
        if (nanos > (double)Long.MAX_VALUE || nanos < (double)Long.MIN_VALUE) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"trying to construct too large duration with ").append(BoxesRunTime.boxToDouble(nanos)).append((Object)"ns").toString());
        }
        return this.fromNanos((long)(nanos + 0.5));
    }

    public FiniteDuration fromNanos(long nanos) {
        if (nanos % 86400000000000L == 0L) {
            return this.apply(nanos / 86400000000000L, TimeUnit.DAYS);
        }
        if (nanos % 3600000000000L == 0L) {
            return this.apply(nanos / 3600000000000L, TimeUnit.HOURS);
        }
        if (nanos % 60000000000L == 0L) {
            return this.apply(nanos / 60000000000L, TimeUnit.MINUTES);
        }
        if (nanos % 1000000000L == 0L) {
            return this.apply(nanos / 1000000000L, TimeUnit.SECONDS);
        }
        if (nanos % 1000000L == 0L) {
            return this.apply(nanos / 1000000L, TimeUnit.MILLISECONDS);
        }
        if (nanos % 1000L == 0L) {
            return this.apply(nanos / 1000L, TimeUnit.MICROSECONDS);
        }
        return this.apply(nanos, TimeUnit.NANOSECONDS);
    }

    public FiniteDuration Zero() {
        return this.Zero;
    }

    public Duration.Infinite Undefined() {
        return this.Undefined;
    }

    public Duration.Infinite Inf() {
        return this.Inf;
    }

    public Duration.Infinite MinusInf() {
        return this.MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public Duration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration create(String s) {
        return this.apply(s);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean scala$concurrent$duration$Duration$$$anonfun$1(char x$1) {
        Predef$ predef$ = Predef$.MODULE$;
        char c = x$1;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        char c2 = c;
        return RichChar$.MODULE$.isWhitespace$extension(c2);
    }

    public static final /* synthetic */ boolean scala$concurrent$duration$Duration$$$anonfun$2(char x$2) {
        Predef$ predef$ = Predef$.MODULE$;
        char c = x$2;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        char c2 = c;
        return RichChar$.MODULE$.isLetter$extension(c2);
    }

    private final Option liftedTree1$1(String s$1) {
        try {
            return new Some<Duration>(this.apply(s$1));
        }
        catch (RuntimeException runtimeException) {
            return None$.MODULE$;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Duration$() {
        Tuple2<TimeUnit, String> tuple2;
        Tuple2<TimeUnit, String> tuple22;
        Tuple2<TimeUnit, String> tuple23;
        Tuple2<TimeUnit, String> tuple24;
        Tuple2<TimeUnit, String> tuple25;
        Tuple2<TimeUnit, String> tuple26;
        void $minus$greater$extension_y;
        Tuple2<void, String> tuple27;
        MODULE$ = this;
        Tuple2[] tuple2Array = new Tuple2[7];
        Predef$ArrowAssoc$ predef$ArrowAssoc$ = Predef$ArrowAssoc$.MODULE$;
        String string = "d day";
        TimeUnit timeUnit = Predef$.MODULE$.ArrowAssoc(TimeUnit.DAYS);
        if (predef$ArrowAssoc$ == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$2 = predef$ArrowAssoc$;
        tuple2Array[0] = tuple27 = new Tuple2<void, String>($minus$greater$extension_y, string);
        Predef$ArrowAssoc$ predef$ArrowAssoc$3 = Predef$ArrowAssoc$.MODULE$;
        String string2 = "h hour";
        TimeUnit timeUnit2 = Predef$.MODULE$.ArrowAssoc(TimeUnit.HOURS);
        if (predef$ArrowAssoc$3 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$4 = predef$ArrowAssoc$3;
        tuple2Array[1] = tuple26 = new Tuple2<TimeUnit, String>(timeUnit2, string2);
        Predef$ArrowAssoc$ predef$ArrowAssoc$5 = Predef$ArrowAssoc$.MODULE$;
        String string3 = "min minute";
        TimeUnit timeUnit3 = Predef$.MODULE$.ArrowAssoc(TimeUnit.MINUTES);
        if (predef$ArrowAssoc$5 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$6 = predef$ArrowAssoc$5;
        tuple2Array[2] = tuple25 = new Tuple2<TimeUnit, String>(timeUnit3, string3);
        Predef$ArrowAssoc$ predef$ArrowAssoc$7 = Predef$ArrowAssoc$.MODULE$;
        String string4 = "s sec second";
        TimeUnit timeUnit4 = Predef$.MODULE$.ArrowAssoc(TimeUnit.SECONDS);
        if (predef$ArrowAssoc$7 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$8 = predef$ArrowAssoc$7;
        tuple2Array[3] = tuple24 = new Tuple2<TimeUnit, String>(timeUnit4, string4);
        Predef$ArrowAssoc$ predef$ArrowAssoc$9 = Predef$ArrowAssoc$.MODULE$;
        String string5 = "ms milli millisecond";
        TimeUnit timeUnit5 = Predef$.MODULE$.ArrowAssoc(TimeUnit.MILLISECONDS);
        if (predef$ArrowAssoc$9 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$10 = predef$ArrowAssoc$9;
        tuple2Array[4] = tuple23 = new Tuple2<TimeUnit, String>(timeUnit5, string5);
        Predef$ArrowAssoc$ predef$ArrowAssoc$11 = Predef$ArrowAssoc$.MODULE$;
        String string6 = "\u00b5s micro microsecond";
        TimeUnit timeUnit6 = Predef$.MODULE$.ArrowAssoc(TimeUnit.MICROSECONDS);
        if (predef$ArrowAssoc$11 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$12 = predef$ArrowAssoc$11;
        tuple2Array[5] = tuple22 = new Tuple2<TimeUnit, String>(timeUnit6, string6);
        Predef$ArrowAssoc$ predef$ArrowAssoc$13 = Predef$ArrowAssoc$.MODULE$;
        String string7 = "ns nano nanosecond";
        TimeUnit timeUnit7 = Predef$.MODULE$.ArrowAssoc(TimeUnit.NANOSECONDS);
        if (predef$ArrowAssoc$13 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$14 = predef$ArrowAssoc$13;
        tuple2Array[6] = tuple2 = new Tuple2<TimeUnit, String>(timeUnit7, string7);
        this.timeUnitLabels = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.timeUnitName = this.timeUnitLabels.toMap(Predef$.MODULE$.$conforms()).mapValues((JFunction1 & java.io.Serializable & Serializable)s -> this.words((String)s).last()).toMap(Predef$.MODULE$.$conforms());
        this.timeUnit = ((TraversableOnce)this.timeUnitLabels.flatMap((JFunction1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TimeUnit unit = (TimeUnit)((Object)((Object)tuple2._1()));
            String names = (String)tuple2._2();
            List list = this.expandLabels(names).map((JFunction1 & java.io.Serializable & Serializable)x$5 -> {
                Predef$ArrowAssoc$ predef$ArrowAssoc$ = Predef$ArrowAssoc$.MODULE$;
                TimeUnit timeUnit = unit;
                String string = Predef$.MODULE$.ArrowAssoc(x$5);
                if (predef$ArrowAssoc$ == null) {
                    throw null;
                }
                Predef$ArrowAssoc$ predef$ArrowAssoc$2 = predef$ArrowAssoc$;
                Tuple2<String, TimeUnit> tuple2 = new Tuple2<String, TimeUnit>(string, timeUnit);
                return tuple2;
            }, List$.MODULE$.canBuildFrom());
            return list;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.Zero = new FiniteDuration(0L, TimeUnit.DAYS);
        this.Undefined = new Duration.Infinite(){

            public String toString() {
                return "Duration.Undefined";
            }

            public boolean equals(Object other) {
                return false;
            }

            public Duration $plus(Duration other) {
                return this;
            }

            public Duration $minus(Duration other) {
                return this;
            }

            public Duration $times(double factor) {
                return this;
            }

            public Duration $div(double factor) {
                return this;
            }

            public double $div(Duration other) {
                return Double.NaN;
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return 1;
            }

            public Duration unary_$minus() {
                return this;
            }

            public double toUnit(TimeUnit unit) {
                return Double.NaN;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Undefined();
            }
        };
        this.Inf = new Duration.Infinite(){

            public String toString() {
                return "Duration.Inf";
            }

            public int compare(Duration other) {
                Duration duration = other;
                int n = duration == Duration$.MODULE$.Undefined() ? -1 : (duration == this ? 0 : 1);
                return n;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.MinusInf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.POSITIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Inf();
            }
        };
        this.MinusInf = new Duration.Infinite(){

            public String toString() {
                return "Duration.MinusInf";
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return -1;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.Inf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.NEGATIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.MinusInf();
            }
        };
    }
}

