/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.BufferedIterator;
import scala.collection.BufferedIterator$class;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Traversable;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Stream$cons$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public abstract class Iterator$class {
    private static /* synthetic */ Map $deserializeLambdaCache$;

    public static Iterator seq(Iterator $this) {
        return $this;
    }

    public static boolean isEmpty(Iterator $this) {
        return !$this.hasNext();
    }

    public static boolean isTraversableAgain(Iterator $this) {
        return false;
    }

    public static boolean hasDefiniteSize(Iterator $this) {
        return $this.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static Iterator take(Iterator $this, int n) {
        void intWrapper_x;
        Predef$ predef$ = Predef$.MODULE$;
        int n2 = n;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        void var4_4 = intWrapper_x;
        return $this.sliceIterator(0, RichInt$.MODULE$.max$extension((int)var4_4, 0));
    }

    public static Iterator drop(Iterator $this, int n) {
        for (int j = 0; j < n && $this.hasNext(); ++j) {
            $this.next();
        }
        return $this;
    }

    /*
     * WARNING - void declaration
     */
    public static Iterator slice(Iterator $this, int from, int until) {
        void intWrapper_x;
        Predef$ predef$ = Predef$.MODULE$;
        int n = until;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        void var5_5 = intWrapper_x;
        return $this.sliceIterator(from, RichInt$.MODULE$.max$extension((int)var5_5, 0));
    }

    /*
     * WARNING - void declaration
     */
    public static Iterator sliceIterator(Iterator $this, int from, int until) {
        int rest;
        void intWrapper_x;
        Predef$ predef$ = Predef$.MODULE$;
        int n = from;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        void var7_5 = intWrapper_x;
        int lo = RichInt$.MODULE$.max$extension((int)var7_5, 0);
        int n2 = until < 0 ? -1 : (rest = until <= lo ? 0 : until - lo);
        if (rest == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new Iterator.SliceIterator($this, lo, rest);
    }

    public static Iterator map(Iterator $this, Function1 f) {
        return new AbstractIterator<B>($this, f){
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$3;

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public B next() {
                return (B)this.f$3.apply(this.$outer.next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$3 = f$3;
            }
        };
    }

    public static Iterator $plus$plus(Iterator $this, Function0 that) {
        return new Iterator.JoinIterator($this, that);
    }

    public static Iterator flatMap(Iterator $this, Function1 f) {
        return new AbstractIterator<B>($this, f){
            private Iterator<B> cur;
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$4;

            private Iterator<B> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<B> x$1) {
                this.cur = x$1;
            }

            private void nextCur() {
                this.cur_$eq(((GenTraversableOnce)this.f$4.apply(this.$outer.next())).toIterator());
            }

            public boolean hasNext() {
                while (!this.cur().hasNext()) {
                    if (!this.$outer.hasNext()) {
                        return false;
                    }
                    this.nextCur();
                }
                return true;
            }

            public B next() {
                return (B)(this.hasNext() ? this.cur() : Iterator$.MODULE$.empty()).next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$4 = f$4;
                this.cur = Iterator$.MODULE$.empty();
            }
        };
    }

    public static Iterator filter(Iterator $this, Function1 p) {
        return new AbstractIterator<A>($this, p){
            private A hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$1;

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            public boolean hasNext() {
                block6: {
                    block5: {
                        if (this.hdDefined()) break block5;
                        do {
                            if (!this.$outer.hasNext()) {
                                return false;
                            }
                            this.hd_$eq(this.$outer.next());
                        } while (!BoxesRunTime.unboxToBoolean(this.p$1.apply(this.hd())));
                        this.hdDefined_$eq(true);
                        if (!true) break block6;
                    }
                    return true;
                }
                return false;
            }

            public A next() {
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    return this.hd();
                }
                return (A)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$1 = p$1;
                this.hdDefined = false;
            }
        };
    }

    public static boolean corresponds(Iterator $this, GenTraversableOnce that, Function2 p) {
        Iterator that0 = that.toIterator();
        while ($this.hasNext() && that0.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply($this.next(), that0.next()))) continue;
            return false;
        }
        return $this.hasNext() == that0.hasNext();
    }

    public static Iterator withFilter(Iterator $this, Function1 p) {
        return $this.filter(p);
    }

    public static Iterator filterNot(Iterator $this, Function1 p) {
        return $this.filter((JFunction1 & java.io.Serializable & Serializable)x$12 -> BoxesRunTime.boxToBoolean(Iterator$class.scala$collection$Iterator$class$$$anonfun$3($this, p, x$12)));
    }

    public static Iterator collect(Iterator $this, PartialFunction pf) {
        return new AbstractIterator<B>($this, pf){
            private A hd;
            private int status;
            private final /* synthetic */ Iterator $outer;
            private final PartialFunction pf$1;

            public boolean hasNext() {
                while (this.status == 0) {
                    if (this.$outer.hasNext()) {
                        this.hd = this.$outer.next();
                        if (!this.pf$1.isDefinedAt(this.hd)) continue;
                        this.status = 1;
                        continue;
                    }
                    this.status = -1;
                }
                return this.status == 1;
            }

            public B next() {
                if (this.hasNext()) {
                    this.status = 0;
                    return (B)this.pf$1.apply(this.hd);
                }
                return (B)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pf$1 = pf$1;
                this.status = 0;
            }
        };
    }

    public static Iterator scanLeft(Iterator $this, Object z, Function2 op) {
        return new AbstractIterator<B>($this, z, op){
            private boolean hasNext;
            private B elem;
            private final /* synthetic */ Iterator $outer;
            private final Function2 op$1;

            public boolean hasNext() {
                return this.hasNext;
            }

            private void hasNext_$eq(boolean x$1) {
                this.hasNext = x$1;
            }

            private B elem() {
                return this.elem;
            }

            private void elem_$eq(B x$1) {
                this.elem = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public B next() {
                if (this.hasNext()) {
                    void var1_1;
                    B res = this.elem();
                    if (this.$outer.hasNext()) {
                        this.elem_$eq(this.op$1.apply(this.elem(), this.$outer.next()));
                    } else {
                        this.hasNext_$eq(false);
                    }
                    return var1_1;
                }
                return (B)Iterator$.MODULE$.empty().next();
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$1 = var3_3;
                this.hasNext = true;
                this.elem = z$1;
            }
        };
    }

    public static Iterator scanRight(Iterator $this, Object z, Function2 op) {
        return ((IterableLike)$this.toBuffer().scanRight(z, op, Buffer$.MODULE$.canBuildFrom())).iterator();
    }

    public static Iterator takeWhile(Iterator $this, Function1 p) {
        return new AbstractIterator<A>($this, p){
            private A hd;
            private boolean hdDefined;
            private Iterator<A> tail;
            private final Function1 p$3;

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            private Iterator<A> tail() {
                return this.tail;
            }

            private void tail_$eq(Iterator<A> x$1) {
                this.tail = x$1;
            }

            public boolean hasNext() {
                block6: {
                    block5: {
                        if (this.hdDefined()) break block5;
                        if (!this.tail().hasNext()) break block6;
                        this.hd_$eq(this.tail().next());
                        if (BoxesRunTime.unboxToBoolean(this.p$3.apply(this.hd()))) {
                            this.hdDefined_$eq(true);
                        } else {
                            this.tail_$eq(Iterator$.MODULE$.empty());
                        }
                        if (!this.hdDefined()) break block6;
                    }
                    return true;
                }
                return false;
            }

            public A next() {
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    return this.hd();
                }
                return (A)Iterator$.MODULE$.empty().next();
            }
            {
                this.p$3 = p$3;
                this.hdDefined = false;
                this.tail = $outer;
            }
        };
    }

    public static Tuple2 partition(Iterator $this, Function1 p) {
        BufferedIterator self = $this.buffered();
        public class Scala_collection_Iterator$PartitionIterator$1
        extends AbstractIterator<A> {
            private final Function1<A, Object> p;
            private Scala_collection_Iterator$PartitionIterator$1 other;
            private final Queue<A> lookahead;
            private final BufferedIterator self$1;

            public Scala_collection_Iterator$PartitionIterator$1 other() {
                return this.other;
            }

            public void other_$eq(Scala_collection_Iterator$PartitionIterator$1 x$1) {
                this.other = x$1;
            }

            public Queue<A> lookahead() {
                return this.lookahead;
            }

            public void skip() {
                while (this.self$1.hasNext() && !BoxesRunTime.unboxToBoolean(this.p.apply(this.self$1.head()))) {
                    this.other().lookahead().$plus$eq((Object)this.self$1.next());
                }
            }

            public boolean hasNext() {
                block3: {
                    block2: {
                        if (!this.lookahead().isEmpty()) break block2;
                        this.skip();
                        if (!this.self$1.hasNext()) break block3;
                    }
                    return true;
                }
                return false;
            }

            public A next() {
                if (!this.lookahead().isEmpty()) {
                    return this.lookahead().dequeue();
                }
                this.skip();
                return this.self$1.next();
            }

            public Scala_collection_Iterator$PartitionIterator$1(Iterator<A> p, Function1<A, Object> self$1) {
                this.p = p;
                this.self$1 = self$1;
                this.lookahead = new Queue<A>();
            }
        }
        Scala_collection_Iterator$PartitionIterator$1 l = new Scala_collection_Iterator$PartitionIterator$1($this, p, self);
        Scala_collection_Iterator$PartitionIterator$1 r = new Scala_collection_Iterator$PartitionIterator$1($this, (JFunction1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean(Iterator$class.scala$collection$Iterator$class$$$anonfun$4($this, p, x$2)), self);
        l.other_$eq(r);
        r.other_$eq(l);
        return new Tuple2<Scala_collection_Iterator$PartitionIterator$1, Scala_collection_Iterator$PartitionIterator$1>(l, r);
    }

    public static Tuple2 span(Iterator $this, Function1 p) {
        public class Scala_collection_Iterator$Leading$1
        extends AbstractIterator<A> {
            private Queue<A> lookahead;
            private A hd;
            private int status;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$5;

            public Queue<A> lookahead() {
                return this.lookahead;
            }

            public void lookahead_$eq(Queue<A> x$1) {
                this.lookahead = x$1;
            }

            public A hd() {
                return this.hd;
            }

            public void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            public int status() {
                return this.status;
            }

            public void status_$eq(int x$1) {
                this.status = x$1;
            }

            private void store(A a) {
                if (this.lookahead() == null) {
                    this.lookahead_$eq(new Queue<A>());
                }
                this.lookahead().$plus$eq((Object)a);
            }

            public boolean hasNext() {
                if (this.status() < 0) {
                    return this.lookahead() != null && this.lookahead().nonEmpty();
                }
                if (this.status() > 0) {
                    return true;
                }
                if (this.$outer.hasNext()) {
                    this.hd_$eq(this.$outer.next());
                    this.status_$eq(BoxesRunTime.unboxToBoolean(this.p$5.apply(this.hd())) ? 1 : -2);
                } else {
                    this.status_$eq(-1);
                }
                return this.status() > 0;
            }

            public A next() {
                if (this.hasNext()) {
                    if (this.status() == 1) {
                        this.status_$eq(0);
                        return this.hd();
                    }
                    return this.lookahead().dequeue();
                }
                return (A)Iterator$.MODULE$.empty().next();
            }

            public boolean finish() {
                if (this.status() == -1) {
                    return false;
                }
                if (this.status() == -2) {
                    this.status_$eq(-1);
                    return true;
                }
                if (this.status() == 1) {
                    this.store(this.hd());
                }
                while (this.$outer.hasNext()) {
                    A a = this.$outer.next();
                    if (BoxesRunTime.unboxToBoolean(this.p$5.apply(a))) {
                        this.store(a);
                        continue;
                    }
                    this.hd_$eq(a);
                    this.status_$eq(-1);
                    return true;
                }
                return false;
            }

            public Scala_collection_Iterator$Leading$1(Iterator<A> p$5) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$5 = p$5;
                this.lookahead = null;
                this.status = 0;
            }
        }
        Scala_collection_Iterator$Leading$1 leading = new Scala_collection_Iterator$Leading$1($this, p);
        AbstractIterator trailing = new AbstractIterator<A>($this, leading){
            private Scala_collection_Iterator$Leading$1 myLeading;
            private int status;
            private final /* synthetic */ Iterator $outer;

            public boolean hasNext() {
                if (this.status > 0) {
                    return this.$outer.hasNext();
                }
                if (this.status == 0) {
                    return true;
                }
                if (this.myLeading.finish()) {
                    this.status = 0;
                    return true;
                }
                this.status = 1;
                this.myLeading = null;
                return this.$outer.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public A next() {
                if (this.hasNext()) {
                    void var1_1;
                    if (this.status > 0) {
                        return this.$outer.next();
                    }
                    this.status = 1;
                    A ans = this.myLeading.hd();
                    this.myLeading = null;
                    return var1_1;
                }
                return (A)Iterator$.MODULE$.empty().next();
            }

            public String toString() {
                return "unknown-if-empty iterator";
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.myLeading = leading$1;
                this.status = -1;
            }
        };
        return new Tuple2<Scala_collection_Iterator$Leading$1, Iterator$.anon.16>(leading, trailing);
    }

    public static Iterator dropWhile(Iterator $this, Function1 p) {
        return new AbstractIterator<A>($this, p){
            private int status;
            private A fst;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$6;

            public boolean hasNext() {
                if (this.status == 1) {
                    return this.$outer.hasNext();
                }
                if (this.status == 0) {
                    return true;
                }
                while (this.$outer.hasNext()) {
                    A a = this.$outer.next();
                    if (BoxesRunTime.unboxToBoolean(this.p$6.apply(a))) continue;
                    this.fst = a;
                    this.status = 0;
                    return true;
                }
                this.status = 1;
                return false;
            }

            public A next() {
                if (this.hasNext()) {
                    if (this.status == 1) {
                        return this.$outer.next();
                    }
                    this.status = 1;
                    return this.fst;
                }
                return (A)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$6 = p$6;
                this.status = -1;
            }
        };
    }

    public static Iterator zip(Iterator $this, Iterator that) {
        return new AbstractIterator<Tuple2<A, B>>($this, that){
            private final /* synthetic */ Iterator $outer;
            private final Iterator that$3;

            public boolean hasNext() {
                return this.$outer.hasNext() && this.that$3.hasNext();
            }

            public Tuple2<A, B> next() {
                return new Tuple2<A, A>(this.$outer.next(), this.that$3.next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.that$3 = that$3;
            }
        };
    }

    public static Iterator padTo(Iterator $this, int len, Object elem) {
        return new AbstractIterator<A1>($this, len, elem){
            private int count;
            private final /* synthetic */ Iterator $outer;
            private final int len$3;
            private final Object elem$4;

            private int count() {
                return this.count;
            }

            private void count_$eq(int x$1) {
                this.count = x$1;
            }

            public boolean hasNext() {
                return this.$outer.hasNext() || this.count() < this.len$3;
            }

            public A1 next() {
                this.count_$eq(this.count() + 1);
                if (this.$outer.hasNext()) {
                    return (A1)this.$outer.next();
                }
                if (this.count() <= this.len$3) {
                    return (A1)this.elem$4;
                }
                return (A1)Iterator$.MODULE$.empty().next();
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.len$3 = len$3;
                this.elem$4 = var3_3;
                this.count = 0;
            }
        };
    }

    public static Iterator zipWithIndex(Iterator $this) {
        return new AbstractIterator<Tuple2<A, Object>>($this){
            private int idx;
            private final /* synthetic */ Iterator $outer;

            private int idx() {
                return this.idx;
            }

            private void idx_$eq(int x$1) {
                this.idx = x$1;
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public Tuple2<A, Object> next() {
                void var1_1;
                Tuple2<A, Integer> ret = new Tuple2<A, Integer>(this.$outer.next(), BoxesRunTime.boxToInteger(this.idx()));
                this.idx_$eq(this.idx() + 1);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.idx = 0;
            }
        };
    }

    public static Iterator zipAll(Iterator $this, Iterator that, Object thisElem, Object thatElem) {
        return new AbstractIterator<Tuple2<A1, B1>>($this, that, thisElem, thatElem){
            private final /* synthetic */ Iterator $outer;
            private final Iterator that$4;
            private final Object thisElem$1;
            private final Object thatElem$1;

            public boolean hasNext() {
                return this.$outer.hasNext() || this.that$4.hasNext();
            }

            public Tuple2<A1, B1> next() {
                if (this.$outer.hasNext()) {
                    if (this.that$4.hasNext()) {
                        return new Tuple2<A, A>(this.$outer.next(), this.that$4.next());
                    }
                    return new Tuple2<A, Object>(this.$outer.next(), this.thatElem$1);
                }
                if (this.that$4.hasNext()) {
                    return new Tuple2<Object, A>(this.thisElem$1, this.that$4.next());
                }
                return (Tuple2)((Object)Iterator$.MODULE$.empty().next());
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.that$4 = that$4;
                this.thisElem$1 = var3_3;
                this.thatElem$1 = var4_4;
            }
        };
    }

    public static void foreach(Iterator $this, Function1 f) {
        while ($this.hasNext()) {
            f.apply($this.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean forall(Iterator $this, Function1 p) {
        void var2_2;
        boolean res = true;
        while (res && $this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean exists(Iterator $this, Function1 p) {
        void var2_2;
        boolean res = false;
        while (!res && $this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    public static boolean contains(Iterator $this, Object elem) {
        return $this.exists((JFunction1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean(Iterator$class.scala$collection$Iterator$class$$$anonfun$5($this, elem, x$3)));
    }

    public static Option find(Iterator $this, Function1 p) {
        while ($this.hasNext()) {
            Object a = $this.next();
            if (!BoxesRunTime.unboxToBoolean(p.apply(a))) continue;
            return new Some(a);
        }
        return None$.MODULE$;
    }

    public static int indexWhere(Iterator $this, Function1 p) {
        return $this.indexWhere(p, 0);
    }

    public static int indexWhere(Iterator $this, Function1 p, int from) {
        int i;
        for (i = 0; i < from && $this.hasNext(); ++i) {
            $this.next();
        }
        while ($this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply($this.next()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(Iterator $this, Object elem) {
        return $this.indexOf(elem, 0);
    }

    public static int indexOf(Iterator $this, Object elem, int from) {
        int i;
        for (i = 0; i < from && $this.hasNext(); ++i) {
            $this.next();
        }
        while ($this.hasNext()) {
            if (BoxesRunTime.equals($this.next(), elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static BufferedIterator buffered(Iterator $this) {
        return new BufferedIterator<A>($this){
            private A hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;

            public BufferedIterator<A> buffered() {
                return BufferedIterator$class.buffered(this);
            }

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            public A head() {
                if (!this.hdDefined()) {
                    this.hd_$eq(this.next());
                    this.hdDefined_$eq(true);
                }
                return this.hd();
            }

            public boolean hasNext() {
                return this.hdDefined() || this.$outer.hasNext();
            }

            public A next() {
                if (this.hdDefined()) {
                    this.hdDefined_$eq(false);
                    return this.hd();
                }
                return this.$outer.next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                BufferedIterator$class.$init$(this);
                this.hdDefined = false;
            }
        };
    }

    public static Iterator.GroupedIterator grouped(Iterator $this, int size) {
        return new Iterator.GroupedIterator($this, $this, size, size);
    }

    public static Iterator.GroupedIterator sliding(Iterator $this, int size, int step) {
        return new Iterator.GroupedIterator($this, $this, size, step);
    }

    public static int sliding$default$2(Iterator $this) {
        return 1;
    }

    public static int length(Iterator $this) {
        return $this.size();
    }

    public static Tuple2 duplicate(Iterator $this) {
        Queue gap = new Queue();
        ObjectRef<Object> ahead = ObjectRef.create(null);
        public class Scala_collection_Iterator$Partner$1
        extends AbstractIterator<A> {
            private final /* synthetic */ Iterator $outer;
            private final Queue gap$1;
            private final ObjectRef ahead$1;

            public boolean hasNext() {
                Boolean bl;
                Iterator iterator = this.$outer;
                synchronized (iterator) {
                    bl = BoxesRunTime.boxToBoolean(this != (Iterator)this.ahead$1.elem && !this.gap$1.isEmpty() || this.$outer.hasNext());
                }
                return BoxesRunTime.unboxToBoolean(bl);
            }

            /*
             * WARNING - void declaration
             */
            public A next() {
                Iterator iterator = this.$outer;
                synchronized (iterator) {
                    A a;
                    if (this.gap$1.isEmpty()) {
                        this.ahead$1.elem = this;
                    }
                    if (this == (Iterator)this.ahead$1.elem) {
                        void var3_2;
                        A e = this.$outer.next();
                        this.gap$1.enqueue(Predef$.MODULE$.genericWrapArray(new Object[]{e}));
                        a = var3_2;
                    } else {
                        a = this.gap$1.dequeue();
                    }
                    A a2 = a;
                    return a2;
                }
            }

            private boolean compareGap(Queue<A> queue) {
                return this.gap$1 == queue;
            }

            public int hashCode() {
                return this.gap$1.hashCode();
            }

            public boolean equals(Object other) {
                Scala_collection_Iterator$Partner$1 var4_3;
                Object object = other;
                boolean bl = object instanceof Scala_collection_Iterator$Partner$1 ? (var4_3 = (Scala_collection_Iterator$Partner$1)object).compareGap(this.gap$1) && this.gap$1.isEmpty() : super.equals(other);
                return bl;
            }

            /*
             * WARNING - void declaration
             */
            public Scala_collection_Iterator$Partner$1(Iterator<A> gap$1) {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.gap$1 = gap$1;
                this.ahead$1 = var3_3;
            }
        }
        return new Tuple2<Scala_collection_Iterator$Partner$1, Scala_collection_Iterator$Partner$1>(new Scala_collection_Iterator$Partner$1($this, gap, ahead), new Scala_collection_Iterator$Partner$1($this, gap, ahead));
    }

    public static Iterator patch(Iterator $this, int from, Iterator patchElems, int replaced) {
        return new AbstractIterator<B>($this, from, patchElems, replaced){
            private Iterator<A> origElems;
            private int i;
            private final Iterator patchElems$1;
            private final int replaced$1;

            private Iterator<A> origElems() {
                return this.origElems;
            }

            private void origElems_$eq(Iterator<A> x$1) {
                this.origElems = x$1;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                if (this.i() == 0) {
                    this.origElems_$eq(this.origElems().drop(this.replaced$1));
                    this.i_$eq(-1);
                }
                return this.origElems().hasNext() || this.patchElems$1.hasNext();
            }

            public B next() {
                if (this.i() == 0) {
                    this.origElems_$eq(this.origElems().drop(this.replaced$1));
                    this.i_$eq(-1);
                }
                if (this.i() < 0) {
                    if (this.patchElems$1.hasNext()) {
                        return (B)this.patchElems$1.next();
                    }
                    return (B)this.origElems().next();
                }
                if (this.origElems().hasNext()) {
                    this.i_$eq(this.i() - 1);
                    return (B)this.origElems().next();
                }
                this.i_$eq(-1);
                return (B)this.patchElems$1.next();
            }
            {
                void var3_3;
                this.patchElems$1 = var3_3;
                this.replaced$1 = replaced$1;
                this.origElems = $outer;
                this.i = from$1 > 0 ? from$1 : 0;
            }
        };
    }

    public static void copyToArray(Iterator $this, Object xs, int start, int len) {
        int end = start + package$.MODULE$.min(len, ScalaRunTime$.MODULE$.array_length(xs) - start);
        for (int i = start; i < end && $this.hasNext(); ++i) {
            ScalaRunTime$.MODULE$.array_update(xs, i, $this.next());
        }
    }

    public static boolean sameElements(Iterator $this, Iterator that) {
        while ($this.hasNext() && that.hasNext()) {
            if (BoxesRunTime.equals($this.next(), that.next())) continue;
            return false;
        }
        return !$this.hasNext() && !that.hasNext();
    }

    public static Traversable toTraversable(Iterator $this) {
        return $this.toStream();
    }

    public static Iterator toIterator(Iterator $this) {
        return $this;
    }

    /*
     * WARNING - void declaration
     */
    public static Stream toStream(Iterator $this) {
        if ($this.hasNext()) {
            void apply_tl;
            void apply_hd;
            Stream$cons$ stream$cons$ = Stream$cons$.MODULE$;
            Function0 function0 = (JFunction0 & java.io.Serializable & Serializable)() -> $this.toStream();
            Object a = $this.next();
            if (stream$cons$ == null) {
                throw null;
            }
            Stream$cons$ stream$cons$2 = stream$cons$;
            Stream.Cons<void> cons = new Stream.Cons<void>(apply_hd, (Function0<Stream<void>>)apply_tl);
            return cons;
        }
        return Stream$.MODULE$.empty();
    }

    public static String toString(Iterator $this) {
        return new StringBuilder().append((Object)($this.hasNext() ? "non-empty" : "empty")).append((Object)" iterator").toString();
    }

    public static final /* synthetic */ boolean scala$collection$Iterator$class$$$anonfun$3(Iterator $this, Function1 p$2, Object x$1) {
        return !BoxesRunTime.unboxToBoolean(p$2.apply(x$1));
    }

    public static final /* synthetic */ boolean scala$collection$Iterator$class$$$anonfun$4(Iterator $this, Function1 p$4, Object x$2) {
        return !BoxesRunTime.unboxToBoolean(p$4.apply(x$2));
    }

    public static final /* synthetic */ boolean scala$collection$Iterator$class$$$anonfun$5(Iterator $this, Object elem$5, Object x$3) {
        return BoxesRunTime.equals(x$3, elem$5);
    }

    public static void $init$(Iterator $this) {
    }
}

