/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.RedBlackTree;
import scala.collection.mutable.RedBlackTree$Node$;
import scala.math.Ordering;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$;

    static {
        new RedBlackTree$();
    }

    public boolean isRed(RedBlackTree.Node<?, ?> node) {
        return node != null && node.red();
    }

    public boolean isBlack(RedBlackTree.Node<?, ?> node) {
        return node == null || !node.red();
    }

    public int size(RedBlackTree.Node<?, ?> node) {
        if (node == null) {
            return 0;
        }
        return 1 + this.size(node.left()) + this.size(node.right());
    }

    public int size(RedBlackTree.Tree<?, ?> tree) {
        return tree.size();
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree.root() == null;
    }

    public void clear(RedBlackTree.Tree<?, ?> tree) {
        tree.root_$eq(null);
        tree.size_$eq(0);
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$1) {
        RedBlackTree.Node node;
        RedBlackTree.Node node2;
        block3: {
            RedBlackTree.Node getNode_node;
            Ordering<A> ordering = evidence$1;
            A a = key;
            RedBlackTree.Node<A, B> node3 = tree.root();
            RedBlackTree$ redBlackTree$ = this;
            while (true) {
                void getNode_key;
                void getNode_ord;
                if (getNode_node == null) {
                    node2 = null;
                    break block3;
                }
                int getNode_cmp = getNode_ord.compare(getNode_key, getNode_node.key());
                if (getNode_cmp < 0) {
                    getNode_node = getNode_node.left();
                    continue;
                }
                if (getNode_cmp <= 0) break;
                getNode_node = getNode_node.right();
            }
            node2 = getNode_node;
        }
        RedBlackTree.Node node4 = node = node2;
        Option option = node4 == null ? None$.MODULE$ : new Some(node4.value());
        return option;
    }

    private <A, B> RedBlackTree.Node<A, B> getNode(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        while (true) {
            if (node == null) {
                return null;
            }
            int cmp = ord.compare(key, node.key());
            if (cmp < 0) {
                node = node.left();
                continue;
            }
            if (cmp <= 0) break;
            node = node.right();
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> evidence$2) {
        Object var9_9;
        block3: {
            Object v0;
            RedBlackTree.Node getNode_node;
            Ordering<A> ordering = evidence$2;
            A a = key;
            RedBlackTree.Node<A, ?> node = tree.root();
            RedBlackTree$ redBlackTree$ = this;
            while (true) {
                void getNode_key;
                void getNode_ord;
                if (getNode_node == null) {
                    v0 = null;
                    break block3;
                }
                int getNode_cmp = getNode_ord.compare(getNode_key, getNode_node.key());
                if (getNode_cmp < 0) {
                    getNode_node = getNode_node.left();
                    continue;
                }
                if (getNode_cmp <= 0) break;
                getNode_node = getNode_node.right();
            }
            v0 = var9_9 = getNode_node;
        }
        return var9_9 != null;
    }

    public <A, B> Option<Tuple2<A, B>> min(RedBlackTree.Tree<A, B> tree) {
        RedBlackTree.Node<A, B> node = this.scala$collection$mutable$RedBlackTree$$minNode(tree.root());
        Option option = node == null ? None$.MODULE$ : new Some<Tuple2<A, B>>(new Tuple2<A, B>(node.key(), node.value()));
        return option;
    }

    public <A> Option<A> minKey(RedBlackTree.Tree<A, ?> tree) {
        RedBlackTree.Node<A, ?> node = this.scala$collection$mutable$RedBlackTree$$minNode(tree.root());
        Option option = node == null ? None$.MODULE$ : new Some<A>(node.key());
        return option;
    }

    public <A, B> RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$minNode(RedBlackTree.Node<A, B> node) {
        if (node == null) {
            return null;
        }
        return this.minNodeNonNull(node);
    }

    public <A, B> RedBlackTree.Node<A, B> minNodeNonNull(RedBlackTree.Node<A, B> node) {
        while (node.left() != null) {
            node = node.left();
        }
        return node;
    }

    public <A, B> Option<Tuple2<A, B>> max(RedBlackTree.Tree<A, B> tree) {
        RedBlackTree.Node<A, B> node = this.maxNode(tree.root());
        Option option = node == null ? None$.MODULE$ : new Some<Tuple2<A, B>>(new Tuple2<A, B>(node.key(), node.value()));
        return option;
    }

    public <A> Option<A> maxKey(RedBlackTree.Tree<A, ?> tree) {
        RedBlackTree.Node<A, ?> node = this.maxNode(tree.root());
        Option option = node == null ? None$.MODULE$ : new Some<A>(node.key());
        return option;
    }

    private <A, B> RedBlackTree.Node<A, B> maxNode(RedBlackTree.Node<A, B> node) {
        if (node == null) {
            return null;
        }
        return this.maxNodeNonNull(node);
    }

    public <A, B> RedBlackTree.Node<A, B> maxNodeNonNull(RedBlackTree.Node<A, B> node) {
        while (node.right() != null) {
            node = node.right();
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> Option<Tuple2<A, B>> minAfter(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, B> node;
        RedBlackTree.Node<A, B> node2;
        void scala$collection$mutable$RedBlackTree$$minNodeAfter_node;
        Ordering<A> ordering = ord;
        A a = key;
        RedBlackTree.Node<A, B> node3 = tree.root();
        RedBlackTree$ scala$collection$mutable$RedBlackTree$$minNodeAfter_this = this;
        if (scala$collection$mutable$RedBlackTree$$minNodeAfter_node == null) {
            node2 = null;
        } else {
            RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$minNodeAfter_y = null;
            RedBlackTree.Node scala$collection$mutable$RedBlackTree$$minNodeAfter_x = scala$collection$mutable$RedBlackTree$$minNodeAfter_node;
            int scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp = 1;
            while (scala$collection$mutable$RedBlackTree$$minNodeAfter_x != null && scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp != 0) {
                void scala$collection$mutable$RedBlackTree$$minNodeAfter_key;
                void scala$collection$mutable$RedBlackTree$$minNodeAfter_ord;
                scala$collection$mutable$RedBlackTree$$minNodeAfter_y = scala$collection$mutable$RedBlackTree$$minNodeAfter_x;
                scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp = scala$collection$mutable$RedBlackTree$$minNodeAfter_ord.compare(scala$collection$mutable$RedBlackTree$$minNodeAfter_key, scala$collection$mutable$RedBlackTree$$minNodeAfter_x.key());
                scala$collection$mutable$RedBlackTree$$minNodeAfter_x = scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp < 0 ? scala$collection$mutable$RedBlackTree$$minNodeAfter_x.left() : scala$collection$mutable$RedBlackTree$$minNodeAfter_x.right();
            }
            node2 = scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp <= 0 ? scala$collection$mutable$RedBlackTree$$minNodeAfter_y : scala$collection$mutable$RedBlackTree$$minNodeAfter_this.scala$collection$mutable$RedBlackTree$$successor(scala$collection$mutable$RedBlackTree$$minNodeAfter_y);
        }
        RedBlackTree.Node<A, B> node4 = node = node2;
        Option option = node4 == null ? None$.MODULE$ : new Some(new Tuple2(node4.key(), node4.value()));
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public <A> Option<A> minKeyAfter(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node node;
        RedBlackTree.Node node2;
        void scala$collection$mutable$RedBlackTree$$minNodeAfter_node;
        Ordering<A> ordering = ord;
        A a = key;
        RedBlackTree.Node<A, ?> node3 = tree.root();
        RedBlackTree$ scala$collection$mutable$RedBlackTree$$minNodeAfter_this = this;
        if (scala$collection$mutable$RedBlackTree$$minNodeAfter_node == null) {
            node2 = null;
        } else {
            RedBlackTree.Node scala$collection$mutable$RedBlackTree$$minNodeAfter_y = null;
            RedBlackTree.Node scala$collection$mutable$RedBlackTree$$minNodeAfter_x = scala$collection$mutable$RedBlackTree$$minNodeAfter_node;
            int scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp = 1;
            while (scala$collection$mutable$RedBlackTree$$minNodeAfter_x != null && scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp != 0) {
                void scala$collection$mutable$RedBlackTree$$minNodeAfter_key;
                void scala$collection$mutable$RedBlackTree$$minNodeAfter_ord;
                scala$collection$mutable$RedBlackTree$$minNodeAfter_y = scala$collection$mutable$RedBlackTree$$minNodeAfter_x;
                scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp = scala$collection$mutable$RedBlackTree$$minNodeAfter_ord.compare(scala$collection$mutable$RedBlackTree$$minNodeAfter_key, scala$collection$mutable$RedBlackTree$$minNodeAfter_x.key());
                scala$collection$mutable$RedBlackTree$$minNodeAfter_x = scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp < 0 ? scala$collection$mutable$RedBlackTree$$minNodeAfter_x.left() : scala$collection$mutable$RedBlackTree$$minNodeAfter_x.right();
            }
            node2 = scala$collection$mutable$RedBlackTree$$minNodeAfter_cmp <= 0 ? scala$collection$mutable$RedBlackTree$$minNodeAfter_y : scala$collection$mutable$RedBlackTree$$minNodeAfter_this.scala$collection$mutable$RedBlackTree$$successor(scala$collection$mutable$RedBlackTree$$minNodeAfter_y);
        }
        RedBlackTree.Node node4 = node = node2;
        Option option = node4 == null ? None$.MODULE$ : new Some(node4.key());
        return option;
    }

    public <A, B> RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$minNodeAfter(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        if (node == null) {
            return null;
        }
        RedBlackTree.Node<A, B> y = null;
        RedBlackTree.Node<A, B> x = node;
        int cmp = 1;
        while (x != null && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp <= 0) {
            return y;
        }
        return this.scala$collection$mutable$RedBlackTree$$successor(y);
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> Option<Tuple2<A, B>> maxBefore(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, B> node;
        RedBlackTree.Node<A, B> node2;
        void maxNodeBefore_node;
        Ordering<A> ordering = ord;
        A a = key;
        RedBlackTree.Node<A, B> node3 = tree.root();
        RedBlackTree$ maxNodeBefore_this = this;
        if (maxNodeBefore_node == null) {
            node2 = null;
        } else {
            RedBlackTree.Node<A, B> maxNodeBefore_y = null;
            RedBlackTree.Node maxNodeBefore_x = maxNodeBefore_node;
            int maxNodeBefore_cmp = 1;
            while (maxNodeBefore_x != null && maxNodeBefore_cmp != 0) {
                void maxNodeBefore_key;
                void maxNodeBefore_ord;
                maxNodeBefore_y = maxNodeBefore_x;
                maxNodeBefore_cmp = maxNodeBefore_ord.compare(maxNodeBefore_key, maxNodeBefore_x.key());
                maxNodeBefore_x = maxNodeBefore_cmp < 0 ? maxNodeBefore_x.left() : maxNodeBefore_x.right();
            }
            node2 = maxNodeBefore_cmp > 0 ? maxNodeBefore_y : maxNodeBefore_this.predecessor(maxNodeBefore_y);
        }
        RedBlackTree.Node<A, B> node4 = node = node2;
        Option option = node4 == null ? None$.MODULE$ : new Some(new Tuple2(node4.key(), node4.value()));
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public <A> Option<A> maxKeyBefore(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node node;
        RedBlackTree.Node node2;
        void maxNodeBefore_node;
        Ordering<A> ordering = ord;
        A a = key;
        RedBlackTree.Node<A, ?> node3 = tree.root();
        RedBlackTree$ maxNodeBefore_this = this;
        if (maxNodeBefore_node == null) {
            node2 = null;
        } else {
            RedBlackTree.Node maxNodeBefore_y = null;
            RedBlackTree.Node maxNodeBefore_x = maxNodeBefore_node;
            int maxNodeBefore_cmp = 1;
            while (maxNodeBefore_x != null && maxNodeBefore_cmp != 0) {
                void maxNodeBefore_key;
                void maxNodeBefore_ord;
                maxNodeBefore_y = maxNodeBefore_x;
                maxNodeBefore_cmp = maxNodeBefore_ord.compare(maxNodeBefore_key, maxNodeBefore_x.key());
                maxNodeBefore_x = maxNodeBefore_cmp < 0 ? maxNodeBefore_x.left() : maxNodeBefore_x.right();
            }
            node2 = maxNodeBefore_cmp > 0 ? maxNodeBefore_y : maxNodeBefore_this.predecessor(maxNodeBefore_y);
        }
        RedBlackTree.Node node4 = node = node2;
        Option option = node4 == null ? None$.MODULE$ : new Some(node4.key());
        return option;
    }

    private <A, B> RedBlackTree.Node<A, B> maxNodeBefore(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        if (node == null) {
            return null;
        }
        RedBlackTree.Node<A, B> y = null;
        RedBlackTree.Node<A, B> x = node;
        int cmp = 1;
        while (x != null && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp > 0) {
            return y;
        }
        return this.predecessor(y);
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> void insert(RedBlackTree.Tree<A, B> tree, A key, B value, Ordering<A> ord) {
        void leaf_parent;
        void leaf_red;
        void leaf_value;
        void leaf_key;
        RedBlackTree.Node<void, void> node;
        RedBlackTree.Node<void, void> y = null;
        RedBlackTree.Node<void, void> x = tree.root();
        int cmp = 1;
        while (x != null && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp == 0) {
            y.value_$eq((void)value);
            return;
        }
        RedBlackTree$Node$ redBlackTree$Node$ = RedBlackTree$Node$.MODULE$;
        RedBlackTree.Node<void, void> node2 = y;
        boolean bl = true;
        B b = value;
        A a = key;
        if (redBlackTree$Node$ == null) {
            throw null;
        }
        RedBlackTree$Node$ redBlackTree$Node$2 = redBlackTree$Node$;
        RedBlackTree.Node<void, void> z = node = new RedBlackTree.Node<void, void>(leaf_key, leaf_value, (boolean)leaf_red, null, null, (RedBlackTree.Node<void, void>)leaf_parent);
        if (y == null) {
            tree.root_$eq(z);
        } else if (cmp < 0) {
            y.left_$eq(z);
        } else {
            y.right_$eq(z);
        }
        this.fixAfterInsert(tree, z);
        tree.size_$eq(tree.size() + 1);
    }

    private <A, B> void fixAfterInsert(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> node) {
        RedBlackTree.Node<A, B> z = node;
        while (this.isRed(z.parent())) {
            if (z.parent() == z.parent().parent().left()) {
                RedBlackTree.Node<A, B> y = z.parent().parent().right();
                if (this.isRed(y)) {
                    z.parent().red_$eq(false);
                    y.red_$eq(false);
                    z.parent().parent().red_$eq(true);
                    z = z.parent().parent();
                    continue;
                }
                if (z == z.parent().right()) {
                    z = z.parent();
                    this.rotateLeft(tree, z);
                }
                z.parent().red_$eq(false);
                z.parent().parent().red_$eq(true);
                this.rotateRight(tree, z.parent().parent());
                continue;
            }
            RedBlackTree.Node<A, B> y = z.parent().parent().left();
            if (this.isRed(y)) {
                z.parent().red_$eq(false);
                y.red_$eq(false);
                z.parent().parent().red_$eq(true);
                z = z.parent().parent();
                continue;
            }
            if (z == z.parent().left()) {
                z = z.parent();
                this.rotateRight(tree, z);
            }
            z.parent().red_$eq(false);
            z.parent().parent().red_$eq(true);
            this.rotateLeft(tree, z.parent().parent());
        }
        tree.root().red_$eq(false);
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> void delete(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node node;
        RedBlackTree.Node node2;
        block11: {
            RedBlackTree.Node getNode_node;
            Ordering<A> ordering = ord;
            A a = key;
            RedBlackTree.Node<A, B> node3 = tree.root();
            RedBlackTree$ redBlackTree$ = this;
            while (true) {
                void getNode_key;
                void getNode_ord;
                if (getNode_node == null) {
                    node2 = null;
                    break block11;
                }
                int getNode_cmp = getNode_ord.compare(getNode_key, getNode_node.key());
                if (getNode_cmp < 0) {
                    getNode_node = getNode_node.left();
                    continue;
                }
                if (getNode_cmp <= 0) break;
                getNode_node = getNode_node.right();
            }
            node2 = getNode_node;
        }
        RedBlackTree.Node z = node = node2;
        if (z != null) {
            RedBlackTree.Node y = z;
            boolean yIsRed = y.red();
            RedBlackTree.Node x = null;
            RedBlackTree.Node xParent = null;
            if (z.left() == null) {
                x = z.right();
                this.transplant(tree, z, z.right());
                xParent = z.parent();
            } else if (z.right() == null) {
                x = z.left();
                this.transplant(tree, z, z.left());
                xParent = z.parent();
            } else {
                y = this.minNodeNonNull(z.right());
                yIsRed = y.red();
                x = y.right();
                if (y.parent() == z) {
                    xParent = y;
                } else {
                    xParent = y.parent();
                    this.transplant(tree, y, y.right());
                    y.right_$eq(z.right());
                    y.right().parent_$eq(y);
                }
                this.transplant(tree, z, y);
                y.left_$eq(z.left());
                y.left().parent_$eq(y);
                y.red_$eq(z.red());
            }
            if (!yIsRed) {
                this.fixAfterDelete(tree, x, xParent);
            }
            tree.size_$eq(tree.size() - 1);
        }
    }

    private <A, B> void fixAfterDelete(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> node, RedBlackTree.Node<A, B> parent) {
        RedBlackTree.Node<A, B> x = node;
        RedBlackTree.Node<A, B> xParent = parent;
        while (x != tree.root() && this.isBlack(x)) {
            if (x == xParent.left()) {
                RedBlackTree.Node<A, B> w = xParent.right();
                if (w.red()) {
                    w.red_$eq(false);
                    xParent.red_$eq(true);
                    this.rotateLeft(tree, xParent);
                    w = xParent.right();
                }
                if (this.isBlack(w.left()) && this.isBlack(w.right())) {
                    w.red_$eq(true);
                    x = xParent;
                } else {
                    if (this.isBlack(w.right())) {
                        w.left().red_$eq(false);
                        w.red_$eq(true);
                        this.rotateRight(tree, w);
                        w = xParent.right();
                    }
                    w.red_$eq(xParent.red());
                    xParent.red_$eq(false);
                    w.right().red_$eq(false);
                    this.rotateLeft(tree, xParent);
                    x = tree.root();
                }
            } else {
                RedBlackTree.Node<A, B> w = xParent.left();
                if (w.red()) {
                    w.red_$eq(false);
                    xParent.red_$eq(true);
                    this.rotateRight(tree, xParent);
                    w = xParent.left();
                }
                if (this.isBlack(w.right()) && this.isBlack(w.left())) {
                    w.red_$eq(true);
                    x = xParent;
                } else {
                    if (this.isBlack(w.left())) {
                        w.right().red_$eq(false);
                        w.red_$eq(true);
                        this.rotateLeft(tree, w);
                        w = xParent.left();
                    }
                    w.red_$eq(xParent.red());
                    xParent.red_$eq(false);
                    w.left().red_$eq(false);
                    this.rotateRight(tree, xParent);
                    x = tree.root();
                }
            }
            xParent = x.parent();
        }
        if (x != null) {
            x.red_$eq(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$successor(RedBlackTree.Node<A, B> node) {
        void var3_3;
        if (node.right() != null) {
            return this.minNodeNonNull(node.right());
        }
        RedBlackTree.Node<A, B> x = node;
        for (RedBlackTree.Node<A, B> y = x.parent(); y != null && x == y.right(); y = y.parent()) {
            x = y;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Node<A, B> predecessor(RedBlackTree.Node<A, B> node) {
        void var3_3;
        if (node.left() != null) {
            return this.maxNodeNonNull(node.left());
        }
        RedBlackTree.Node<A, B> x = node;
        for (RedBlackTree.Node<A, B> y = x.parent(); y != null && x == y.left(); y = y.parent()) {
            x = y;
        }
        return var3_3;
    }

    private <A, B> void rotateLeft(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> x) {
        if (x != null) {
            RedBlackTree.Node<A, B> y = x.right();
            x.right_$eq(y.left());
            if (y.left() != null) {
                y.left().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                tree.root_$eq(y);
            } else if (x == x.parent().left()) {
                x.parent().left_$eq(y);
            } else {
                x.parent().right_$eq(y);
            }
            y.left_$eq(x);
            x.parent_$eq(y);
        }
    }

    private <A, B> void rotateRight(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> x) {
        if (x != null) {
            RedBlackTree.Node<A, B> y = x.left();
            x.left_$eq(y.right());
            if (y.right() != null) {
                y.right().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                tree.root_$eq(y);
            } else if (x == x.parent().right()) {
                x.parent().right_$eq(y);
            } else {
                x.parent().left_$eq(y);
            }
            y.right_$eq(x);
            x.parent_$eq(y);
        }
    }

    private <A, B> void transplant(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> to, RedBlackTree.Node<A, B> from) {
        if (to.parent() == null) {
            tree.root_$eq(from);
        } else if (to == to.parent().left()) {
            to.parent().left_$eq(from);
        } else {
            to.parent().right_$eq(from);
        }
        if (from != null) {
            from.parent_$eq(to.parent());
        }
    }

    /*
     * WARNING - void declaration
     */
    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        void foreachNode_node;
        Function1<Tuple2<A, B>, U> function1 = f;
        RedBlackTree.Node<A, B> node = tree.root();
        RedBlackTree$ foreachNode_this = this;
        if (foreachNode_node != null) {
            void foreachNode_f;
            foreachNode_this.foreachNodeNonNull((RedBlackTree.Node<A, B>)foreachNode_node, (Function1<Tuple2<A, B>, U>)foreachNode_f);
            return;
        }
    }

    private <A, B, U> void foreachNode(RedBlackTree.Node<A, B> node, Function1<Tuple2<A, B>, U> f) {
        if (node != null) {
            this.foreachNodeNonNull(node, f);
        }
    }

    private <A, B, U> void foreachNodeNonNull(RedBlackTree.Node<A, B> node, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (node.left() != null) {
                this.foreachNodeNonNull(node.left(), f);
            }
            f.apply(new Tuple2<A, B>(node.key(), node.value()));
            if (node.right() == null) break;
            node = node.right();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        void foreachNodeKey_node;
        Function1<A, U> function1 = f;
        RedBlackTree.Node<A, ?> node = tree.root();
        RedBlackTree$ foreachNodeKey_this = this;
        if (foreachNodeKey_node != null) {
            void foreachNodeKey_f;
            foreachNodeKey_this.foreachNodeKeyNonNull((RedBlackTree.Node<A, ?>)foreachNodeKey_node, (Function1<A, U>)foreachNodeKey_f);
            return;
        }
    }

    private <A, U> void foreachNodeKey(RedBlackTree.Node<A, ?> node, Function1<A, U> f) {
        if (node != null) {
            this.foreachNodeKeyNonNull(node, f);
        }
    }

    private <A, U> void foreachNodeKeyNonNull(RedBlackTree.Node<A, ?> node, Function1<A, U> f) {
        while (true) {
            if (node.left() != null) {
                this.foreachNodeKeyNonNull(node.left(), f);
            }
            f.apply(node.key());
            if (node.right() == null) break;
            node = node.right();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> void transform(RedBlackTree.Tree<A, B> tree, Function2<A, B, B> f) {
        void transformNode_node;
        Function2<A, B, B> function2 = f;
        RedBlackTree.Node<A, B> node = tree.root();
        RedBlackTree$ transformNode_this = this;
        if (transformNode_node != null) {
            void transformNode_transformNodeNonNull_f;
            void transformNode_transformNodeNonNull_node;
            void transformNode_f;
            void var8_6 = transformNode_f;
            void var7_7 = transformNode_node;
            RedBlackTree$ transformNode_transformNodeNonNull_this = transformNode_this;
            if (transformNode_transformNodeNonNull_node.left() != null) {
                transformNode_transformNodeNonNull_this.transformNodeNonNull(transformNode_transformNodeNonNull_node.left(), (Function2<A, B, B>)transformNode_transformNodeNonNull_f);
            }
            transformNode_transformNodeNonNull_node.value_$eq(transformNode_transformNodeNonNull_f.apply(transformNode_transformNodeNonNull_node.key(), transformNode_transformNodeNonNull_node.value()));
            if (transformNode_transformNodeNonNull_node.right() != null) {
                transformNode_transformNodeNonNull_this.transformNodeNonNull(transformNode_transformNodeNonNull_node.right(), (Function2<A, B, B>)transformNode_transformNodeNonNull_f);
                return;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <A, B, U> void transformNode(RedBlackTree.Node<A, B> node, Function2<A, B, B> f) {
        if (node != null) {
            void transformNodeNonNull_f;
            void transformNodeNonNull_node;
            Function2<A, B, B> function2 = f;
            RedBlackTree.Node<A, B> node2 = node;
            RedBlackTree$ transformNodeNonNull_this = this;
            if (transformNodeNonNull_node.left() != null) {
                transformNodeNonNull_this.transformNodeNonNull(transformNodeNonNull_node.left(), (Function2<A, B, B>)transformNodeNonNull_f);
            }
            transformNodeNonNull_node.value_$eq(transformNodeNonNull_f.apply(transformNodeNonNull_node.key(), transformNodeNonNull_node.value()));
            if (transformNodeNonNull_node.right() != null) {
                transformNodeNonNull_this.transformNodeNonNull(transformNodeNonNull_node.right(), (Function2<A, B, B>)transformNodeNonNull_f);
                return;
            }
            return;
        }
    }

    private <A, B, U> void transformNodeNonNull(RedBlackTree.Node<A, B> node, Function2<A, B, B> f) {
        if (node.left() != null) {
            this.transformNodeNonNull(node.left(), f);
        }
        node.value_$eq(f.apply(node.key(), node.value()));
        if (node.right() != null) {
            this.transformNodeNonNull(node.right(), f);
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$3) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, end, evidence$3);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> None$ iterator$default$3() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Option<A> end, Ordering<A> evidence$4) {
        return new RedBlackTree.KeysIterator(tree, start, end, evidence$4);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A> None$ keysIterator$default$3() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$5) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, end, evidence$5);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> None$ valuesIterator$default$3() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> boolean isValid(RedBlackTree.Tree<A, B> tree, Ordering<A> evidence$9) {
        boolean bl;
        block3: {
            boolean bl2;
            Ordering<A> ordering = evidence$9;
            RedBlackTree.Node<A, B> node = tree.root();
            RedBlackTree$ isValidBST_this = this;
            while (true) {
                void isValidBST_ord;
                RedBlackTree.Node isValidBST_node;
                if (isValidBST_node == null) {
                    bl2 = true;
                    break block3;
                }
                if (isValidBST_node.left() != null && isValidBST_ord.compare(isValidBST_node.key(), isValidBST_node.left().key()) <= 0 || isValidBST_node.right() != null && isValidBST_ord.compare(isValidBST_node.key(), isValidBST_node.right().key()) >= 0) {
                    bl2 = false;
                    break block3;
                }
                if (!isValidBST_this.isValidBST(isValidBST_node.left(), (Ordering<A>)isValidBST_ord)) break;
                isValidBST_node = isValidBST_node.right();
            }
            bl2 = bl = false;
        }
        return bl && this.hasProperParentRefs(tree) && this.isValidRedBlackTree(tree) && this.size(tree.root()) == tree.size();
    }

    private <A, B> boolean hasProperParentRefs(RedBlackTree.Tree<A, B> tree) {
        if (tree.root() == null) {
            return true;
        }
        return tree.root().parent() == null && this.hasProperParentRefs$1(tree.root());
    }

    private <A, B> boolean isValidBST(RedBlackTree.Node<A, B> node, Ordering<A> ord) {
        while (true) {
            if (node == null) {
                return true;
            }
            if (node.left() != null && ord.compare(node.key(), node.left().key()) <= 0 || node.right() != null && ord.compare(node.key(), node.right().key()) >= 0) {
                return false;
            }
            if (!this.isValidBST(node.left(), ord)) break;
            node = node.right();
        }
        return false;
    }

    private <A, B> boolean isValidRedBlackTree(RedBlackTree.Tree<A, B> tree) {
        return this.isBlack(tree.root()) && this.noRedAfterRed$1(tree.root()) && this.blackHeight$1(tree.root()) >= 0;
    }

    private final boolean hasProperParentRefs$1(RedBlackTree.Node node) {
        while (true) {
            if (node == null) {
                return true;
            }
            if (node.left() != null && node.left().parent() != node || node.right() != null && node.right().parent() != node) {
                return false;
            }
            if (!this.hasProperParentRefs$1(node.left())) break;
            node = node.right();
        }
        return false;
    }

    private final boolean noRedAfterRed$1(RedBlackTree.Node node) {
        while (true) {
            if (node == null) {
                return true;
            }
            if (node.red() && (this.isRed(node.left()) || this.isRed(node.right()))) {
                return false;
            }
            if (!this.noRedAfterRed$1(node.left())) break;
            node = node.right();
        }
        return false;
    }

    private final int blackHeight$1(RedBlackTree.Node node) {
        if (node == null) {
            return 1;
        }
        int lh = this.blackHeight$1(node.left());
        int rh = this.blackHeight$1(node.right());
        if (lh == -1 || lh != rh) {
            return -1;
        }
        if (this.isRed(node)) {
            return lh;
        }
        return lh + 1;
    }

    private RedBlackTree$() {
        MODULE$ = this;
    }
}

