/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.impl.ExecutionContextImpl;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class ExecutionContextImpl$ {
    public static final ExecutionContextImpl$ MODULE$;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    static {
        new ExecutionContextImpl$();
    }

    public ExecutorService createDefaultExecutorService(Function1<Throwable, BoxedUnit> reporter) {
        int numThreads = this.getInt$1("scala.concurrent.context.numThreads", "x1");
        int maxNoOfThreads = this.getInt$1("scala.concurrent.context.maxThreads", "x1");
        int desiredParallelism = this.range$1(this.getInt$1("scala.concurrent.context.minThreads", "1"), numThreads, maxNoOfThreads);
        int maxExtraThreads = this.getInt$1("scala.concurrent.context.maxExtraThreads", "256");
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(reporter){
            private final Function1 reporter$3;

            public void uncaughtException(Thread thread, Throwable cause) {
                this.reporter$3.apply(cause);
            }
            {
                this.reporter$3 = reporter$3;
            }
        };
        ExecutionContextImpl.DefaultThreadFactory threadFactory = new ExecutionContextImpl.DefaultThreadFactory(true, maxNoOfThreads + maxExtraThreads, "scala-execution-context-global", uncaughtExceptionHandler);
        try {
            return new ForkJoinPool(desiredParallelism, uncaughtExceptionHandler, threadFactory){

                public void execute(Runnable runnable) {
                    ForkJoinWorkerThread forkJoinWorkerThread;
                    ForkJoinTask<V> forkJoinTask;
                    Runnable runnable2 = runnable;
                    ForkJoinTask<V> forkJoinTask2 = runnable2 instanceof ForkJoinTask ? (forkJoinTask = (ForkJoinTask<V>)((Object)runnable2)) : new ExecutionContextImpl.AdaptedForkJoinTask(runnable2);
                    ForkJoinTask<V> fjt = forkJoinTask2;
                    Thread thread = Thread.currentThread();
                    if (thread instanceof ForkJoinWorkerThread && (forkJoinWorkerThread = (ForkJoinWorkerThread)thread).getPool() == this) {
                        fjt.fork();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    super.execute(fjt);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            };
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = option.get();
            System.err.println("Failed to create ForkJoinPool for the default ExecutionContext, falling back to ThreadPoolExecutor");
            t.printStackTrace(System.err);
            ThreadPoolExecutor exec = new ThreadPoolExecutor(desiredParallelism, desiredParallelism, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), threadFactory);
            exec.allowCoreThreadTimeOut(true);
            ThreadPoolExecutor threadPoolExecutor = exec;
            return threadPoolExecutor;
        }
    }

    public ExecutionContextImpl fromExecutor(Executor e, Function1<Throwable, BoxedUnit> reporter) {
        Option<Executor> option = Option$.MODULE$.apply(e);
        Function1<Throwable, BoxedUnit> function1 = reporter;
        ExecutionContextImpl$ executionContextImpl$ = this;
        Function0 function0 = (JFunction0 & java.io.Serializable & Serializable)() -> {
            AbstractExecutorService abstractExecutorService;
            Function1 createDefaultExecutorService_reporter = function1;
            ExecutionContextImpl$ createDefaultExecutorService_this = this;
            int createDefaultExecutorService_numThreads = createDefaultExecutorService_this.getInt$1("scala.concurrent.context.numThreads", "x1");
            int createDefaultExecutorService_maxNoOfThreads = createDefaultExecutorService_this.getInt$1("scala.concurrent.context.maxThreads", "x1");
            int createDefaultExecutorService_desiredParallelism = createDefaultExecutorService_this.range$1(createDefaultExecutorService_this.getInt$1("scala.concurrent.context.minThreads", "1"), createDefaultExecutorService_numThreads, createDefaultExecutorService_maxNoOfThreads);
            int createDefaultExecutorService_maxExtraThreads = createDefaultExecutorService_this.getInt$1("scala.concurrent.context.maxExtraThreads", "256");
            Thread.UncaughtExceptionHandler createDefaultExecutorService_uncaughtExceptionHandler = new /* invalid duplicate definition of identical inner class */;
            ExecutionContextImpl.DefaultThreadFactory createDefaultExecutorService_threadFactory = new ExecutionContextImpl.DefaultThreadFactory(true, createDefaultExecutorService_maxNoOfThreads + createDefaultExecutorService_maxExtraThreads, "scala-execution-context-global", createDefaultExecutorService_uncaughtExceptionHandler);
            try {
                abstractExecutorService = new /* invalid duplicate definition of identical inner class */;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable createDefaultExecutorService_t = option.get();
                System.err.println("Failed to create ForkJoinPool for the default ExecutionContext, falling back to ThreadPoolExecutor");
                createDefaultExecutorService_t.printStackTrace(System.err);
                ThreadPoolExecutor createDefaultExecutorService_exec = new ThreadPoolExecutor(createDefaultExecutorService_desiredParallelism, createDefaultExecutorService_desiredParallelism, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), createDefaultExecutorService_threadFactory);
                createDefaultExecutorService_exec.allowCoreThreadTimeOut(true);
                ThreadPoolExecutor threadPoolExecutor = createDefaultExecutorService_exec;
                abstractExecutorService = threadPoolExecutor;
            }
            ForkJoinPool forkJoinPool = abstractExecutorService;
            return forkJoinPool;
        };
        if (option == null) {
            throw null;
        }
        Option<Executor> getOrElse_this = option;
        Executor executor = getOrElse_this.isEmpty() ? executionContextImpl$.scala$concurrent$impl$ExecutionContextImpl$$$anonfun$4(function1) : getOrElse_this.get();
        return new ExecutionContextImpl(executor, reporter);
    }

    public Function1<Throwable, BoxedUnit> fromExecutor$default$2() {
        return ExecutionContext$.MODULE$.defaultReporter();
    }

    public ExecutionContextImpl fromExecutorService(ExecutorService es, Function1<Throwable, BoxedUnit> reporter) {
        return new ExecutionContextExecutorService(es, reporter){

            private final ExecutorService asExecutorService() {
                return (ExecutorService)this.executor();
            }

            public void execute(Runnable command) {
                this.executor().execute(command);
            }

            public void shutdown() {
                this.asExecutorService().shutdown();
            }

            public List<Runnable> shutdownNow() {
                return this.asExecutorService().shutdownNow();
            }

            public boolean isShutdown() {
                return this.asExecutorService().isShutdown();
            }

            public boolean isTerminated() {
                return this.asExecutorService().isTerminated();
            }

            public boolean awaitTermination(long l, TimeUnit timeUnit) {
                return this.asExecutorService().awaitTermination(l, timeUnit);
            }

            public <T> Future<T> submit(Callable<T> callable) {
                return this.asExecutorService().submit(callable);
            }

            public <T> Future<T> submit(Runnable runnable, T t) {
                return this.asExecutorService().submit(runnable, t);
            }

            public Future<?> submit(Runnable runnable) {
                return this.asExecutorService().submit(runnable);
            }

            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) {
                return this.asExecutorService().invokeAll(callables);
            }

            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) {
                return this.asExecutorService().invokeAll(callables, l, timeUnit);
            }

            public <T> T invokeAny(Collection<? extends Callable<T>> callables) {
                return this.asExecutorService().invokeAny(callables);
            }

            public <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) {
                return this.asExecutorService().invokeAny(callables, l, timeUnit);
            }
            {
                void getOrElse_default;
                Option<ExecutorService> option = Option$.MODULE$.apply(es$1);
                Serializable serializable = new Serializable(reporter$2){
                    public static final long serialVersionUID = 0L;
                    private final Function1 reporter$2;

                    public final ExecutorService apply() {
                        return ExecutionContextImpl$.MODULE$.createDefaultExecutorService(this.reporter$2);
                    }
                    {
                        this.reporter$2 = reporter$2;
                    }
                };
                if (option == null) {
                    throw null;
                }
                Option<ExecutorService> getOrElse_this = option;
                Object object = getOrElse_this.isEmpty() ? getOrElse_default.apply() : getOrElse_this.get();
                super((Executor)object, reporter$2);
            }
        };
    }

    public Function1<Throwable, BoxedUnit> fromExecutorService$default$2() {
        return ExecutionContext$.MODULE$.defaultReporter();
    }

    /*
     * WARNING - void declaration
     */
    private final int getInt$1(String name, String string) {
        int n;
        String string2;
        String string3;
        try {
            string3 = System.getProperty(name, string);
        }
        catch (SecurityException e) {
            string3 = string2 = string;
        }
        if (string2.charAt(0) == 'x') {
            void doubleWrapper_x;
            void augmentString_x;
            Predef$ predef$ = Predef$.MODULE$;
            Predef$ predef$2 = Predef$.MODULE$;
            String string4 = string2.substring(1);
            if (predef$2 == null) {
                throw null;
            }
            Predef$ predef$3 = predef$2;
            void var8_7 = augmentString_x;
            double d = (double)Runtime.getRuntime().availableProcessors() * new StringOps((String)var8_7).toDouble();
            if (predef$ == null) {
                throw null;
            }
            Predef$ predef$4 = predef$;
            void var12_10 = doubleWrapper_x;
            n = (int)RichDouble$.MODULE$.ceil$extension((double)var12_10);
        } else {
            void augmentString_x;
            Predef$ predef$ = Predef$.MODULE$;
            String string5 = string2;
            if (predef$ == null) {
                throw null;
            }
            Predef$ predef$5 = predef$;
            void var16_14 = augmentString_x;
            n = new StringOps((String)var16_14).toInt();
        }
        return n;
    }

    private final int range$1(int floor, int desired, int ceiling) {
        return package$.MODULE$.min(package$.MODULE$.max(floor, desired), ceiling);
    }

    private ExecutionContextImpl$() {
        MODULE$ = this;
    }
}

