/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Hashing$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.BitmapIndexedMapNode;
import scala.collection.immutable.ChampBaseIterator;
import scala.collection.immutable.HashCollisionMapNode;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005ed!\u0002\r\u001a\u0005ey\u0002\"B!\u0001\t\u0003\u0011\u0005\"\u0002#\u0001\t\u0013)\u0005\"C%\u0001\u0001\u0004\u0005\r\u0011\"\u0003K\u0011%Y\u0005\u00011AA\u0002\u0013%A\nC\u0005S\u0001\u0001\u0007\t\u0011)Q\u0005{!)1\u000b\u0001C\u0005)\"9\u0001\f\u0001a\u0001\n\u0013I\u0006bB/\u0001\u0001\u0004%IA\u0018\u0005\u0007A\u0002\u0001\u000b\u0015\u0002.\t\u000b\u0005\u0004A\u0011\u00022\t\u000b=\u0004A\u0011\u00029\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b!9\u0011Q\u0002\u0001\u0005\n\u0005=\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\t\u0003c\u0001A\u0011A\r\u00024!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA%\u0001\u0011%\u0011q\t\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\ty\u0005\u0001C!\u0003#Bq!a\u0014\u0001\t\u0003\t9\u0006C\u0004\u0002^\u0001!\t%a\u0018\t\u000f\u0005M\u0004\u0001\"\u0011\u0002H!A\u0011Q\u000f\u0001\u0005\u0002m\t9H\u0001\bICNDW*\u00199Ck&dG-\u001a:\u000b\u0005iY\u0012!C5n[V$\u0018M\u00197f\u0015\taR$\u0001\u0006d_2dWm\u0019;j_:T\u0011AH\u0001\u0006g\u000e\fG.Y\u000b\u0004AAZ4c\u0001\u0001\"KA\u0011!eI\u0007\u0002;%\u0011A%\b\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0019J3&P\u0007\u0002O)\u0011\u0001fG\u0001\b[V$\u0018M\u00197f\u0013\tQsEA\u0004Ck&dG-\u001a:\u0011\t\tbcFO\u0005\u0003[u\u0011a\u0001V;qY\u0016\u0014\u0004CA\u00181\u0019\u0001!Q!\r\u0001C\u0002M\u0012\u0011aS\u0002\u0001#\t!t\u0007\u0005\u0002#k%\u0011a'\b\u0002\b\u001d>$\b.\u001b8h!\t\u0011\u0003(\u0003\u0002:;\t\u0019\u0011I\\=\u0011\u0005=ZD!\u0002\u001f\u0001\u0005\u0004\u0019$!\u0001,\u0011\tyzdFO\u0007\u00023%\u0011\u0001)\u0007\u0002\b\u0011\u0006\u001c\b.T1q\u0003\u0019a\u0014N\\5u}Q\t1\t\u0005\u0003?\u00019R\u0014\u0001\u00058fo\u0016k\u0007\u000f^=S_>$hj\u001c3f+\u00051\u0005\u0003\u0002 H]iJ!\u0001S\r\u0003)\tKG/\\1q\u0013:$W\r_3e\u001b\u0006\u0004hj\u001c3f\u0003\u001d\tG.[1tK\u0012,\u0012!P\u0001\fC2L\u0017m]3e?\u0012*\u0017\u000f\u0006\u0002N!B\u0011!ET\u0005\u0003\u001fv\u0011A!\u00168ji\"9\u0011\u000bBA\u0001\u0002\u0004i\u0014a\u0001=%c\u0005A\u0011\r\\5bg\u0016$\u0007%A\u0005jg\u0006c\u0017.Y:fIV\tQ\u000b\u0005\u0002#-&\u0011q+\b\u0002\b\u0005>|G.Z1o\u0003!\u0011xn\u001c;O_\u0012,W#\u0001.\u0011\tyZfFO\u0005\u00039f\u0011q!T1q\u001d>$W-\u0001\u0007s_>$hj\u001c3f?\u0012*\u0017\u000f\u0006\u0002N?\"9\u0011\u000bCA\u0001\u0002\u0004Q\u0016!\u0003:p_Rtu\u000eZ3!\u00035Ign]3si\u0016cW-\\3oiR!1-[6n!\r\u0011CMZ\u0005\u0003Kv\u0011Q!\u0011:sCf\u0004\"AI4\n\u0005!l\"aA%oi\")!N\u0003a\u0001G\u0006\u0011\u0011m\u001d\u0005\u0006Y*\u0001\rAZ\u0001\u0003SbDQA\u001c\u0006A\u0002\u0019\fA!\u001a7f[\u0006Y\u0011N\\:feR4\u0016\r\\;f+\t\tx\u0010F\u0004NeR4\bP\u001f?\t\u000bM\\\u0001\u0019\u0001$\u0002\u0005\tl\u0007\"B;\f\u0001\u00041\u0017A\u00022jiB|7\u000fC\u0003x\u0017\u0001\u0007a&A\u0002lKfDQ!_\u0006A\u0002\u0019\fAb\u001c:jO&t\u0017\r\u001c%bg\"DQa_\u0006A\u0002\u0019\fqa[3z\u0011\u0006\u001c\b\u000eC\u0003~\u0017\u0001\u0007a0A\u0003wC2,X\r\u0005\u00020\u007f\u00129\u0011\u0011A\u0006C\u0002\u0005\r!A\u0001,2#\tQt'A\u0007sK6|g/Z#mK6,g\u000e\u001e\u000b\u0006G\u0006%\u00111\u0002\u0005\u0006U2\u0001\ra\u0019\u0005\u0006Y2\u0001\rAZ\u0001\u0018[&<'/\u0019;f\rJ|W.\u00138mS:,Gk\u001c(pI\u0016$\u0012\"TA\t\u0003'\t)\"a\u0006\t\u000bMl\u0001\u0019\u0001$\t\u000bml\u0001\u0019\u00014\t\u000bUl\u0001\u0019\u00014\t\r\u0005eQ\u00021\u0001[\u0003\u0011qw\u000eZ3\u0002\u0011M,GOV1mk\u0016,B!a\b\u00020QIQ*!\t\u0002$\u0005\u0015\u0012\u0011\u0006\u0005\u0006g:\u0001\rA\u0012\u0005\u0006k:\u0001\rA\u001a\u0005\u0007\u0003Oq\u0001\u0019\u0001\u0018\u0002\r9,woS3z\u0011\u001d\tYC\u0004a\u0001\u0003[\t\u0001B\\3x-\u0006dW/\u001a\t\u0004_\u0005=BaBA\u0001\u001d\t\u0007\u00111A\u0001\u0007kB$\u0017\r^3\u0015\u001b5\u000b)$!\u000f\u0002<\u0005u\u0012qHA!\u0011\u0019\t9d\u0004a\u00015\u00069Q.\u00199O_\u0012,\u0007\"B<\u0010\u0001\u0004q\u0003\"B?\u0010\u0001\u0004Q\u0004\"B=\u0010\u0001\u00041\u0007\"B>\u0010\u0001\u00041\u0007BBA\"\u001f\u0001\u0007a-A\u0003tQ&4G/A\bf]N,(/Z+oC2L\u0017m]3e)\u0005i\u0015!C2paf,E.Z7t\u0003\u0019\u0011Xm];miR\tQ(\u0001\u0004bI\u0012|e.\u001a\u000b\u0005\u0003'\n)&D\u0001\u0001\u0011\u0015q7\u00031\u0001,)\u0019\t\u0019&!\u0017\u0002\\!)q\u000f\u0006a\u0001]!)Q\u0010\u0006a\u0001u\u00051\u0011\r\u001a3BY2$B!a\u0015\u0002b!9\u00111M\u000bA\u0002\u0005\u0015\u0014A\u0001=t!\u0015\t9'!\u001c,\u001d\r\u0011\u0013\u0011N\u0005\u0004\u0003Wj\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003_\n\tH\u0001\u0007Ji\u0016\u0014\u0018M\u00197f\u001f:\u001cWMC\u0002\u0002lu\tQa\u00197fCJ\fAa]5{KV\ta\r")
public final class HashMapBuilder<K, V>
implements Builder<Tuple2<K, V>, HashMap<K, V>> {
    private HashMap<K, V> aliased;
    private MapNode<K, V> scala$collection$immutable$HashMapBuilder$$rootNode = this.newEmptyRootNode();

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public final int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<Tuple2<K, V>, NewTo> mapResult(Function1<HashMap<K, V>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable<Tuple2<K, V>> $plus$plus$eq(IterableOnce<Tuple2<K, V>> xs) {
        return Growable.$plus$plus$eq$(this, xs);
    }

    private BitmapIndexedMapNode<K, V> newEmptyRootNode() {
        return new BitmapIndexedMapNode(0, 0, (Object[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Any()), (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, 0);
    }

    private HashMap<K, V> aliased() {
        return this.aliased;
    }

    private void aliased_$eq(HashMap<K, V> x$1) {
        this.aliased = x$1;
    }

    private boolean isAliased() {
        return this.aliased() != null;
    }

    public MapNode<K, V> scala$collection$immutable$HashMapBuilder$$rootNode() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode;
    }

    private void scala$collection$immutable$HashMapBuilder$$rootNode_$eq(MapNode<K, V> x$1) {
        this.scala$collection$immutable$HashMapBuilder$$rootNode = x$1;
    }

    private int[] insertElement(int[] as, int ix, int elem) {
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = elem;
        System.arraycopy(as, ix, result, ix + 1, as.length - ix);
        return result;
    }

    private <V1> void insertValue(BitmapIndexedMapNode<K, V> bm, int bitpos, K key, int originalHash, int keyHash, V1 value) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        dst[idx + 1] = value;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        bm.dataMap_$eq(bm.dataMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() + 1);
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + keyHash);
    }

    /*
     * WARNING - void declaration
     */
    private int[] removeElement(int[] as, int ix) {
        void var3_3;
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length - 1];
        System.arraycopy(as, 0, result, 0, ix);
        System.arraycopy(as, ix + 1, result, ix, as.length - ix - 1);
        return var3_3;
    }

    private void migrateFromInlineToNode(BitmapIndexedMapNode<K, V> bm, int keyHash, int bitpos, MapNode<K, V> node) {
        int dataIx = bm.dataIndex(bitpos);
        int idxOld = 2 * dataIx;
        int idxNew = bm.content().length - 2 - bm.nodeIndex(bitpos);
        Object[] src = bm.content();
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        int[] dstHashes = this.removeElement(bm.originalHashes(), dataIx);
        bm.dataMap_$eq(bm.dataMap() ^ bitpos);
        bm.nodeMap_$eq(bm.nodeMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() - 1 + node.size());
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + (node.cachedJavaKeySetHashCode() - keyHash));
    }

    private <V1> void setValue(BitmapIndexedMapNode<K, V> bm, int bitpos, K newKey, V1 newValue) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 2 * dataIx;
        bm.content()[idx] = newKey;
        bm.content()[idx + 1] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    public void update(MapNode<K, V> mapNode, K key, V value, int originalHash, int keyHash, int shift) {
        if (mapNode instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode = (BitmapIndexedMapNode)mapNode;
            int n = keyHash >>> shift & 0x1F;
            int n2 = 1 << n;
            if ((bitmapIndexedMapNode.dataMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedMapNode.dataMap(), n, n2);
                Object object = bitmapIndexedMapNode.content()[2 * index];
                int n3 = bitmapIndexedMapNode.originalHashes()[index];
                if (n3 == originalHash && BoxesRunTime.equals(object, key)) {
                    this.setValue(bitmapIndexedMapNode, n2, key, value);
                    return;
                }
                Object object2 = bitmapIndexedMapNode.content()[2 * index + 1];
                int key0Hash = Hashing$.MODULE$.improve(n3);
                MapNode<Object, Object> subNodeNew = bitmapIndexedMapNode.mergeTwoKeyValPairs(object, object2, n3, key0Hash, key, value, originalHash, keyHash, shift + 5);
                this.migrateFromInlineToNode(bitmapIndexedMapNode, key0Hash, n2, subNodeNew);
                return;
            }
            if ((bitmapIndexedMapNode.nodeMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedMapNode.nodeMap(), n, n2);
                Node subNode = bitmapIndexedMapNode.getNode(index);
                int beforeSize = ((MapNode)subNode).size();
                int beforeHash = subNode.cachedJavaKeySetHashCode();
                this.update((MapNode<K, V>)subNode, key, value, originalHash, keyHash, shift + 5);
                bitmapIndexedMapNode.size_$eq(bitmapIndexedMapNode.size() + (((MapNode)subNode).size() - beforeSize));
                bitmapIndexedMapNode.cachedJavaKeySetHashCode_$eq(bitmapIndexedMapNode.cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHash));
                return;
            }
            this.insertValue(bitmapIndexedMapNode, n2, key, originalHash, keyHash, value);
            return;
        }
        if (mapNode instanceof HashCollisionMapNode) {
            void updated_elem;
            HashCollisionMapNode hashCollisionMapNode = (HashCollisionMapNode)mapNode;
            int index = hashCollisionMapNode.indexOf(key);
            if (index < 0) {
                hashCollisionMapNode.content_$eq(hashCollisionMapNode.content().appended(new Tuple2<K, V>(key, value)));
                return;
            }
            Vector vector = hashCollisionMapNode.content();
            Tuple2<K, V> tuple2 = new Tuple2<K, V>(key, value);
            if (vector == null) {
                throw null;
            }
            tuple2 = null;
            hashCollisionMapNode.content_$eq(vector.updateAt(index, updated_elem));
            return;
        }
        throw new MatchError(mapNode);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased_$eq(null);
    }

    private void copyElems() {
        this.scala$collection$immutable$HashMapBuilder$$rootNode_$eq(this.scala$collection$immutable$HashMapBuilder$$rootNode().copy());
    }

    @Override
    public HashMap<K, V> result() {
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() == 0) {
            return HashMap$.MODULE$.empty();
        }
        if (this.aliased() != null) {
            return this.aliased();
        }
        this.aliased_$eq(new HashMap<K, V>(this.scala$collection$immutable$HashMapBuilder$$rootNode()));
        Statics.releaseFence();
        return this.aliased();
    }

    public HashMapBuilder<K, V> addOne(Tuple2<K, V> elem) {
        this.ensureUnaliased();
        int h = Statics.anyHash(elem._1());
        int im = Hashing$.MODULE$.improve(h);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), elem._1(), elem._2(), h, im, 0);
        return this;
    }

    public HashMapBuilder<K, V> addOne(K key, V value) {
        this.ensureUnaliased();
        int originalHash = Statics.anyHash(key);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), key, value, originalHash, Hashing$.MODULE$.improve(originalHash), 0);
        return this;
    }

    public HashMapBuilder<K, V> addAll(IterableOnce<Tuple2<K, V>> xs) {
        this.ensureUnaliased();
        if (xs instanceof HashMap) {
            HashMap hashMap = (HashMap)xs;
            new ChampBaseIterator<MapNode<K, V>>(this, hashMap){
                {
                    while (this.hasNext()) {
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        $outer.update($outer.scala$collection$immutable$HashMapBuilder$$rootNode(), ((MapNode)this.currentValueNode()).getKey(this.currentValueCursor()), ((MapNode)this.currentValueNode()).getValue(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve(originalHash), 0);
                        this.currentValueCursor_$eq(this.currentValueCursor() + 1);
                    }
                }
            };
        } else {
            Iterator<Tuple2<K, V>> it = xs.iterator();
            while (it.hasNext()) {
                this.addOne(it.next());
            }
        }
        return this;
    }

    @Override
    public void clear() {
        this.aliased_$eq(null);
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() > 0) {
            this.scala$collection$immutable$HashMapBuilder$$rootNode_$eq(this.newEmptyRootNode());
        }
    }

    public int size() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode().size();
    }
}

