/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.ArrayOps;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.LazyZip2;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.PartialOrdering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2$mcIII$sp;

public final class ArrayOps$ {
    public static final ArrayOps$ MODULE$ = new ArrayOps$();

    public final <A> ClassTag<A> elemTag$extension(Object $this) {
        return ClassTag$.MODULE$.apply($this.getClass().getComponentType());
    }

    public final <A> int size$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> int knownSize$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> boolean isEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) == 0;
    }

    public final <A> boolean nonEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) != 0;
    }

    public final <A> A head$extension(Object $this) {
        try {
            return (A)ScalaRunTime$.MODULE$.array_apply($this, 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException("head of empty array");
        }
    }

    public final <A> A last$extension(Object $this) {
        try {
            return (A)ScalaRunTime$.MODULE$.array_apply($this, ScalaRunTime$.MODULE$.array_length($this) - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException("last of empty array");
        }
    }

    public final <A> Option<A> headOption$extension(Object $this) {
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            return None$.MODULE$;
        }
        return new Some<A>(this.head$extension($this));
    }

    public final <A> Option<A> lastOption$extension(Object $this) {
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            return None$.MODULE$;
        }
        return new Some<A>(this.last$extension($this));
    }

    public final <A> int lengthCompare$extension(Object $this, int len) {
        return Integer.compare(ScalaRunTime$.MODULE$.array_length($this), len);
    }

    public final <A> Object slice$extension(Object $this, int from, int until) {
        int lo = Math.max(from, 0);
        int hi = Math.min(until, ScalaRunTime$.MODULE$.array_length($this));
        if (hi > lo) {
            Object[] objectArray;
            if ($this instanceof Object[]) {
                objectArray = Arrays.copyOfRange((Object[])$this, lo, hi);
            } else if ($this instanceof int[]) {
                objectArray = Arrays.copyOfRange((int[])$this, lo, hi);
            } else if ($this instanceof double[]) {
                objectArray = Arrays.copyOfRange((double[])$this, lo, hi);
            } else if ($this instanceof long[]) {
                objectArray = Arrays.copyOfRange((long[])$this, lo, hi);
            } else if ($this instanceof float[]) {
                objectArray = Arrays.copyOfRange((float[])$this, lo, hi);
            } else if ($this instanceof char[]) {
                objectArray = Arrays.copyOfRange((char[])$this, lo, hi);
            } else if ($this instanceof byte[]) {
                objectArray = Arrays.copyOfRange((byte[])$this, lo, hi);
            } else if ($this instanceof short[]) {
                objectArray = Arrays.copyOfRange((short[])$this, lo, hi);
            } else if ($this instanceof boolean[]) {
                objectArray = Arrays.copyOfRange((boolean[])$this, lo, hi);
            } else {
                throw new MatchError($this);
            }
            return objectArray;
        }
        return this.elemTag$extension($this).newArray(0);
    }

    public final <A> Object tail$extension(Object $this) {
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            throw new UnsupportedOperationException("tail of empty array");
        }
        return this.slice$extension($this, 1, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object init$extension(Object $this) {
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            throw new UnsupportedOperationException("init of empty array");
        }
        return this.slice$extension($this, 0, ScalaRunTime$.MODULE$.array_length($this) - 1);
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Iterator<Object> tails$extension(Object $this) {
        void iterateUntilEmpty$extension_$plus$plus_xs;
        Function1<Object, Object> & java.io.Serializable & Serializable iterateUntilEmpty$extension_f = (Function1<Object, Object> & java.io.Serializable & Serializable)xs -> MODULE$.tail$extension(xs);
        if (Iterator$.MODULE$ == null) {
            throw null;
        }
        Iterator iterator = new AbstractIterator<T>($this, iterateUntilEmpty$extension_f){
            private boolean first;
            private T acc;
            private final Function1 f$5;

            public boolean hasNext() {
                return true;
            }

            public T next() {
                if (this.first) {
                    this.first = false;
                } else {
                    this.acc = this.f$5.apply(this.acc);
                }
                return this.acc;
            }
            {
                this.f$5 = f$5;
                this.first = true;
                this.acc = start$3;
            }
        }.takeWhile((Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$iterateUntilEmpty$1(x)));
        Function0<Iterator> & java.io.Serializable & Serializable intersect = (Function0<Iterator> & java.io.Serializable & Serializable)() -> Iterator$.MODULE$.single(Array$.MODULE$.empty(MODULE$.elemTag$extension($this)));
        if (iterator == null) {
            throw null;
        }
        return iterator.concat(iterateUntilEmpty$extension_$plus$plus_xs);
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Iterator<Object> inits$extension(Object $this) {
        void iterateUntilEmpty$extension_$plus$plus_xs;
        Function1<Object, Object> & java.io.Serializable & Serializable iterateUntilEmpty$extension_f = (Function1<Object, Object> & java.io.Serializable & Serializable)xs -> MODULE$.init$extension(xs);
        if (Iterator$.MODULE$ == null) {
            throw null;
        }
        Iterator iterator = new /* invalid duplicate definition of identical inner class */.takeWhile((Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$iterateUntilEmpty$1(x)));
        Function0<Iterator> & java.io.Serializable & Serializable intersect = (Function0<Iterator> & java.io.Serializable & Serializable)() -> Iterator$.MODULE$.single(Array$.MODULE$.empty(MODULE$.elemTag$extension($this)));
        if (iterator == null) {
            throw null;
        }
        return iterator.concat(iterateUntilEmpty$extension_$plus$plus_xs);
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Iterator<Object> iterateUntilEmpty$extension(Object $this, Function1<Object, Object> f) {
        void $plus$plus_xs;
        if (Iterator$.MODULE$ == null) {
            throw null;
        }
        Iterator iterator = new /* invalid duplicate definition of identical inner class */.takeWhile((Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$iterateUntilEmpty$1(x)));
        Function0<Iterator> & java.io.Serializable & Serializable intersect = (Function0<Iterator> & java.io.Serializable & Serializable)() -> Iterator$.MODULE$.single(Array$.MODULE$.empty(MODULE$.elemTag$extension($this)));
        if (iterator == null) {
            throw null;
        }
        return iterator.concat($plus$plus_xs);
    }

    public final <A> Object take$extension(Object $this, int n) {
        return this.slice$extension($this, 0, n);
    }

    public final <A> Object drop$extension(Object $this, int n) {
        return this.slice$extension($this, n, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object takeRight$extension(Object $this, int n) {
        return this.drop$extension($this, ScalaRunTime$.MODULE$.array_length($this) - Math.max(n, 0));
    }

    public final <A> Object dropRight$extension(Object $this, int n) {
        return this.take$extension($this, ScalaRunTime$.MODULE$.array_length($this) - Math.max(n, 0));
    }

    public final <A> Object takeWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$takeWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        int hi = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, 0, hi);
    }

    public final <A> Object dropWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$dropWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        int lo = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, lo, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Iterator<A> iterator$extension(Object $this) {
        return new ArrayOps.ArrayIterator($this);
    }

    public final <A> Iterator<Object> grouped$extension(Object $this, int size) {
        return new ArrayOps.GroupedIterator($this, size);
    }

    public final <A> Tuple2<Object, Object> span$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$span$1(p, x)), this.indexWhere$default$2$extension($this));
        int idx = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return new Tuple2<Object, Object>(this.slice$extension($this, 0, idx), this.slice$extension($this, idx, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <A> Tuple2<Object, Object> splitAt$extension(Object $this, int n) {
        return new Tuple2<Object, Object>(this.take$extension($this, n), this.drop$extension($this, n));
    }

    public final <A> Tuple2<Object, Object> partition$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<Object> res1 = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        ArrayBuilder<A> res2 = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            ArrayBuilder<Object> arrayBuilder = BoxesRunTime.unboxToBoolean(p.apply(x)) ? res1 : res2;
            if (arrayBuilder == null) {
                throw null;
            }
            arrayBuilder.addOne(x);
        }
        return new Tuple2<Object, Object>(res1.result(), res2.result());
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Object reverse$extension(Object $this) {
        void var3_3;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        Object res = this.elemTag$extension($this).newArray(len);
        for (int i = 0; i < len; ++i) {
            ScalaRunTime$.MODULE$.array_update(res, len - i - 1, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        return var3_3;
    }

    public final <A> Iterator<A> reverseIterator$extension(Object $this) {
        return new ArrayOps.ReverseIterator($this);
    }

    public final <A> Object filter$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<Object> res = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            if (!BoxesRunTime.unboxToBoolean(p.apply(x))) continue;
            if (res == null) {
                throw null;
            }
            res.addOne(x);
        }
        return res.result();
    }

    public final <A> Object filterNot$extension(Object $this, Function1<A, Object> p) {
        return this.filter$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$filterNot$1(p, x)));
    }

    public final <B, A> Object sorted$extension(Object $this, Ordering<B> ord) {
        int len = ScalaRunTime$.MODULE$.array_length($this);
        if ($this.getClass().getComponentType().isPrimitive() && len > 1) {
            int i;
            Object[] a = new Object[len];
            for (i = 0; i < len; ++i) {
                a[i] = ScalaRunTime$.MODULE$.array_apply($this, i);
            }
            Arrays.sort(a, ord);
            Object res = this.elemTag$extension($this).newArray(len);
            for (i = 0; i < len; ++i) {
                ScalaRunTime$.MODULE$.array_update(res, i, a[i]);
            }
            return res;
        }
        Object copy = this.slice$extension($this, 0, len);
        if (len > 1) {
            Arrays.sort((Object[])copy, ord);
        }
        return copy;
    }

    public final <A> Object sortWith$extension(Object $this, Function2<A, A, Object> lt) {
        if (Ordering$.MODULE$ == null) {
            throw null;
        }
        return this.sorted$extension($this, new Ordering<T>(lt){
            private final Function2 cmp$2;

            public Some<Object> tryCompare(T x, T y) {
                return Ordering.tryCompare$(this, x, y);
            }

            public boolean equiv(T x, T y) {
                return Ordering.equiv$(this, x, y);
            }

            public <U extends T> U max(U x, U y) {
                return (U)Ordering.max$(this, x, y);
            }

            public <U extends T> U min(U x, U y) {
                return (U)Ordering.min$(this, x, y);
            }

            public Ordering<T> reverse() {
                return Ordering.reverse$(this);
            }

            public <U> Ordering<U> on(Function1<U, T> f) {
                return Ordering.on$(this, f);
            }

            public Ordering<T> orElse(Ordering<T> other) {
                return Ordering.orElse$(this, other);
            }

            public <S> Ordering<T> orElseBy(Function1<T, S> f, Ordering<S> ord) {
                return Ordering.orElseBy$(this, f, ord);
            }

            public Ordering.OrderingOps mkOrderingOps(T lhs) {
                return Ordering.mkOrderingOps$(this, lhs);
            }

            public int compare(T x, T y) {
                if (BoxesRunTime.unboxToBoolean(this.cmp$2.apply(x, y))) {
                    return -1;
                }
                if (BoxesRunTime.unboxToBoolean(this.cmp$2.apply(y, x))) {
                    return 1;
                }
                return 0;
            }

            public boolean lt(T x, T y) {
                return BoxesRunTime.unboxToBoolean(this.cmp$2.apply(x, y));
            }

            public boolean gt(T x, T y) {
                return BoxesRunTime.unboxToBoolean(this.cmp$2.apply(y, x));
            }

            public boolean gteq(T x, T y) {
                return !BoxesRunTime.unboxToBoolean(this.cmp$2.apply(x, y));
            }

            public boolean lteq(T x, T y) {
                return !BoxesRunTime.unboxToBoolean(this.cmp$2.apply(y, x));
            }
            {
                this.cmp$2 = cmp$2;
                PartialOrdering.$init$(this);
                Ordering.$init$(this);
            }
        });
    }

    public final <B, A> Object sortBy$extension(Object $this, Function1<A, B> f, Ordering<B> ord) {
        return this.sorted$extension($this, ord.on(f));
    }

    public final <A> ArrayOps.WithFilter<A> withFilter$extension(Object $this, Function1<A, Object> p) {
        return new ArrayOps.WithFilter<A>(p, $this);
    }

    public final <A> int indexOf$extension(Object $this, A elem, int from) {
        for (int i = from; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (!BoxesRunTime.equals(elem, ScalaRunTime$.MODULE$.array_apply($this, i))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int indexOf$default$2$extension(Object $this) {
        return 0;
    }

    public final <A> int indexWhere$extension(Object $this, Function1<A, Object> f, int from) {
        for (int i = from; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (!BoxesRunTime.unboxToBoolean(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int indexWhere$default$2$extension(Object $this) {
        return 0;
    }

    public final <A> int lastIndexOf$extension(Object $this, A elem, int end) {
        for (int i = Math.min(end, ScalaRunTime$.MODULE$.array_length($this) - 1); i >= 0; --i) {
            if (!BoxesRunTime.equals(elem, ScalaRunTime$.MODULE$.array_apply($this, i))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int lastIndexOf$default$2$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) - 1;
    }

    public final <A> int lastIndexWhere$extension(Object $this, Function1<A, Object> p, int end) {
        for (int i = Math.min(end, ScalaRunTime$.MODULE$.array_length($this) - 1); i >= 0; --i) {
            if (!BoxesRunTime.unboxToBoolean(p.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int lastIndexWhere$default$2$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) - 1;
    }

    public final <A> Option<A> find$extension(Object $this, Function1<A, Object> f) {
        int idx = this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this));
        if (idx == -1) {
            return None$.MODULE$;
        }
        return new Some<Object>(ScalaRunTime$.MODULE$.array_apply($this, idx));
    }

    public final <A> boolean exists$extension(Object $this, Function1<A, Object> f) {
        return this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this)) >= 0;
    }

    public final <A> boolean forall$extension(Object $this, Function1<A, Object> f) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (BoxesRunTime.unboxToBoolean(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> B foldLeft$extension(Object $this, B z, Function2<B, A, B> op) {
        Object object;
        if ($this instanceof Object[]) {
            void var8_6;
            Object[] objectArray = (Object[])$this;
            int f$2_length = ScalaRunTime$.MODULE$.array_length(objectArray);
            B f$2_v = z;
            for (int f$2_i = 0; f$2_i < f$2_length; ++f$2_i) {
                f$2_v = op.apply(f$2_v, ScalaRunTime$.MODULE$.array_apply(objectArray, f$2_i));
            }
            object = var8_6;
        } else if ($this instanceof int[]) {
            object = ArrayOps$.f$mIc$sp$1((int[])$this, op, z);
        } else if ($this instanceof double[]) {
            object = ArrayOps$.f$mDc$sp$1((double[])$this, op, z);
        } else if ($this instanceof long[]) {
            object = ArrayOps$.f$mJc$sp$1((long[])$this, op, z);
        } else if ($this instanceof float[]) {
            object = ArrayOps$.f$mFc$sp$1((float[])$this, op, z);
        } else if ($this instanceof char[]) {
            object = ArrayOps$.f$mCc$sp$1((char[])$this, op, z);
        } else if ($this instanceof byte[]) {
            object = ArrayOps$.f$mBc$sp$1((byte[])$this, op, z);
        } else if ($this instanceof short[]) {
            object = ArrayOps$.f$mSc$sp$1((short[])$this, op, z);
        } else if ($this instanceof boolean[]) {
            object = ArrayOps$.f$mZc$sp$1((boolean[])$this, op, z);
        } else if ($this instanceof BoxedUnit[]) {
            void var11_11;
            BoxedUnit[] boxedUnitArray = (BoxedUnit[])$this;
            int f$mVc$sp$1_length = boxedUnitArray.length;
            B f$mVc$sp$1_v = z;
            for (int f$mVc$sp$1_i = 0; f$mVc$sp$1_i < f$mVc$sp$1_length; ++f$mVc$sp$1_i) {
                f$mVc$sp$1_v = op.apply(f$mVc$sp$1_v, boxedUnitArray[f$mVc$sp$1_i]);
            }
            object = var11_11;
        } else {
            if ($this == null) {
                throw new NullPointerException();
            }
            throw new MatchError($this);
        }
        return (B)object;
    }

    public final <B, A> Object scanLeft$extension(Object $this, B z, Function2<B, A, B> op, ClassTag<B> evidence$3) {
        int i;
        B v = z;
        Object res = evidence$3.newArray(ScalaRunTime$.MODULE$.array_length($this) + 1);
        for (i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update(res, i, v);
            v = op.apply(v, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        ScalaRunTime$.MODULE$.array_update(res, i, v);
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object scan$extension(Object $this, B z, Function2<B, B, B> op, ClassTag<B> evidence$4) {
        void var7_7;
        int scanLeft$extension_i;
        B scanLeft$extension_v = z;
        Object scanLeft$extension_res = evidence$4.newArray(ScalaRunTime$.MODULE$.array_length($this) + 1);
        for (scanLeft$extension_i = 0; scanLeft$extension_i < ScalaRunTime$.MODULE$.array_length($this); ++scanLeft$extension_i) {
            ScalaRunTime$.MODULE$.array_update(scanLeft$extension_res, scanLeft$extension_i, scanLeft$extension_v);
            scanLeft$extension_v = op.apply(scanLeft$extension_v, ScalaRunTime$.MODULE$.array_apply($this, scanLeft$extension_i));
        }
        ScalaRunTime$.MODULE$.array_update(scanLeft$extension_res, scanLeft$extension_i, scanLeft$extension_v);
        return var7_7;
    }

    public final <B, A> Object scanRight$extension(Object $this, B z, Function2<A, B, B> op, ClassTag<B> evidence$5) {
        B v = z;
        Object res = evidence$5.newArray(ScalaRunTime$.MODULE$.array_length($this) + 1);
        ScalaRunTime$.MODULE$.array_update(res, ScalaRunTime$.MODULE$.array_length($this), z);
        for (int i = ScalaRunTime$.MODULE$.array_length($this) - 1; i >= 0; --i) {
            v = op.apply(ScalaRunTime$.MODULE$.array_apply($this, i), v);
            ScalaRunTime$.MODULE$.array_update(res, i, v);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> B foldRight$extension(Object $this, B z, Function2<A, B, B> op) {
        Object object;
        if ($this instanceof Object[]) {
            void var7_5;
            Object[] objectArray = (Object[])$this;
            B f$3_v = z;
            for (int f$3_i = ScalaRunTime$.MODULE$.array_length(objectArray) - 1; f$3_i >= 0; --f$3_i) {
                f$3_v = op.apply(ScalaRunTime$.MODULE$.array_apply(objectArray, f$3_i), f$3_v);
            }
            object = var7_5;
        } else if ($this instanceof int[]) {
            object = ArrayOps$.f$mIc$sp$2((int[])$this, op, z);
        } else if ($this instanceof double[]) {
            object = ArrayOps$.f$mDc$sp$2((double[])$this, op, z);
        } else if ($this instanceof long[]) {
            object = ArrayOps$.f$mJc$sp$2((long[])$this, op, z);
        } else if ($this instanceof float[]) {
            object = ArrayOps$.f$mFc$sp$2((float[])$this, op, z);
        } else if ($this instanceof char[]) {
            object = ArrayOps$.f$mCc$sp$2((char[])$this, op, z);
        } else if ($this instanceof byte[]) {
            object = ArrayOps$.f$mBc$sp$2((byte[])$this, op, z);
        } else if ($this instanceof short[]) {
            object = ArrayOps$.f$mSc$sp$2((short[])$this, op, z);
        } else if ($this instanceof boolean[]) {
            object = ArrayOps$.f$mZc$sp$2((boolean[])$this, op, z);
        } else if ($this instanceof BoxedUnit[]) {
            void var9_9;
            BoxedUnit[] boxedUnitArray = (BoxedUnit[])$this;
            B f$mVc$sp$2_v = z;
            for (int f$mVc$sp$2_i = boxedUnitArray.length - 1; f$mVc$sp$2_i >= 0; --f$mVc$sp$2_i) {
                f$mVc$sp$2_v = op.apply(boxedUnitArray[f$mVc$sp$2_i], f$mVc$sp$2_v);
            }
            object = var9_9;
        } else {
            if ($this == null) {
                throw new NullPointerException();
            }
            throw new MatchError($this);
        }
        return (B)object;
    }

    public final <A1, A> A1 fold$extension(Object $this, A1 z, Function2<A1, A1, A1> op) {
        Object object;
        if ($this instanceof Object[]) {
            Object object2;
            Object[] objectArray = (Object[])$this;
            int f$4_length = ScalaRunTime$.MODULE$.array_length(objectArray) - 1;
            if (f$4_length >= 0) {
                Object f$4_v = ScalaRunTime$.MODULE$.array_apply(objectArray, f$4_length);
                for (int f$4_i = 0; f$4_i < f$4_length; ++f$4_i) {
                    f$4_v = op.apply(f$4_v, ScalaRunTime$.MODULE$.array_apply(objectArray, f$4_i));
                }
                object2 = f$4_v;
            } else {
                object2 = z;
            }
            object = object2;
        } else if ($this instanceof int[]) {
            object = ArrayOps$.f$mIc$sp$3((int[])$this, op, z);
        } else if ($this instanceof double[]) {
            object = ArrayOps$.f$mDc$sp$3((double[])$this, op, z);
        } else if ($this instanceof long[]) {
            object = ArrayOps$.f$mJc$sp$3((long[])$this, op, z);
        } else if ($this instanceof float[]) {
            object = ArrayOps$.f$mFc$sp$3((float[])$this, op, z);
        } else if ($this instanceof char[]) {
            object = ArrayOps$.f$mCc$sp$3((char[])$this, op, z);
        } else if ($this instanceof byte[]) {
            object = ArrayOps$.f$mBc$sp$3((byte[])$this, op, z);
        } else if ($this instanceof short[]) {
            object = ArrayOps$.f$mSc$sp$3((short[])$this, op, z);
        } else if ($this instanceof boolean[]) {
            object = ArrayOps$.f$mZc$sp$3((boolean[])$this, op, z);
        } else if ($this instanceof BoxedUnit[]) {
            Object object3;
            BoxedUnit[] boxedUnitArray = (BoxedUnit[])$this;
            int f$mVc$sp$3_length = boxedUnitArray.length - 1;
            if (f$mVc$sp$3_length >= 0) {
                BoxedUnit f$mVc$sp$3_v = boxedUnitArray[f$mVc$sp$3_length];
                for (int f$mVc$sp$3_i = 0; f$mVc$sp$3_i < f$mVc$sp$3_length; ++f$mVc$sp$3_i) {
                    f$mVc$sp$3_v = op.apply(f$mVc$sp$3_v, boxedUnitArray[f$mVc$sp$3_i]);
                }
                object3 = f$mVc$sp$3_v;
            } else {
                object3 = z;
            }
            object = object3;
        } else {
            if ($this == null) {
                throw new NullPointerException();
            }
            throw new MatchError($this);
        }
        return (A1)object;
    }

    public final <B, A> Object map$extension(Object $this, Function1<A, B> f, ClassTag<B> evidence$6) {
        Object res = evidence$6.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update(res, i, f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return res;
    }

    public final <A> Object mapInPlace$extension(Object $this, Function1<A, A> f) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update($this, i, f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return $this;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object flatMap$extension0(Object $this, Function1<A, IterableOnce<B>> f, ClassTag<B> evidence$7) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$7);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            void $plus$plus$eq_xs;
            IterableOnce<B> iterableOnce = f.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            if (b == null) {
                throw null;
            }
            b.addAll($plus$plus$eq_xs);
        }
        return b.result();
    }

    /*
     * WARNING - void declaration
     */
    public final <BS, B, A> Object flatMap$extension1(Object $this, Function1<A, BS> f, Function1<BS, Iterable<B>> asIterable, ClassTag<B> m) {
        ArrayBuilder<B> flatMap$extension0_b = ArrayBuilder$.MODULE$.make(m);
        for (int flatMap$extension0_i = 0; flatMap$extension0_i < ScalaRunTime$.MODULE$.array_length($this); ++flatMap$extension0_i) {
            void flatMap$extension0_$plus$plus$eq_xs;
            Object object = ScalaRunTime$.MODULE$.array_apply($this, flatMap$extension0_i);
            Iterable iterable = ArrayOps$.$anonfun$flatMap$2(asIterable, f, object);
            if (flatMap$extension0_b == null) {
                throw null;
            }
            flatMap$extension0_b.addAll(flatMap$extension0_$plus$plus$eq_xs);
        }
        return flatMap$extension0_b.result();
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object flatten$extension(Object $this, Function1<A, Iterable<B>> asIterable, ClassTag<B> m) {
        void fold$extension_op;
        Object object;
        int n;
        void var6_5;
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(m);
        Object map$extension_res = ClassTag$.MODULE$.Int().newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int map$extension_i = 0; map$extension_i < ScalaRunTime$.MODULE$.array_length($this); ++map$extension_i) {
            ScalaRunTime$.MODULE$.array_update(map$extension_res, map$extension_i, ArrayOps$.$anonfun$flatten$1$adapted(ScalaRunTime$.MODULE$.array_apply($this, map$extension_i)));
        }
        int[] sizes = (int[])var6_5;
        JFunction2$mcIII$sp & Serializable intersect = (JFunction2$mcIII$sp & Serializable)(x$1, x$2) -> x$1 + x$2;
        Integer fold$extension_z = BoxesRunTime.boxToInteger(0);
        if (sizes instanceof Object[]) {
            Object object2;
            Object[] objectArray = sizes;
            int fold$extension_f$4_length = ScalaRunTime$.MODULE$.array_length(objectArray) - 1;
            if (fold$extension_f$4_length >= 0) {
                Object fold$extension_f$4_v = ScalaRunTime$.MODULE$.array_apply(objectArray, fold$extension_f$4_length);
                for (int fold$extension_f$4_i = 0; fold$extension_f$4_i < fold$extension_f$4_length; ++fold$extension_f$4_i) {
                    n = BoxesRunTime.unboxToInt(ScalaRunTime$.MODULE$.array_apply(objectArray, fold$extension_f$4_i));
                    fold$extension_f$4_v = BoxesRunTime.boxToInteger(ArrayOps$.$anonfun$flatten$2(BoxesRunTime.unboxToInt(fold$extension_f$4_v), n));
                }
                object2 = fold$extension_f$4_v;
            } else {
                object2 = fold$extension_z;
            }
            object = object2;
        } else if (sizes instanceof int[]) {
            object = ArrayOps$.f$mIc$sp$3(sizes, (Function2)fold$extension_op, fold$extension_z);
        } else if (sizes instanceof double[]) {
            object = ArrayOps$.f$mDc$sp$3(sizes, (Function2)fold$extension_op, fold$extension_z);
        } else if (sizes instanceof long[]) {
            object = ArrayOps$.f$mJc$sp$3(sizes, (Function2)fold$extension_op, fold$extension_z);
        } else if (sizes instanceof float[]) {
            object = ArrayOps$.f$mFc$sp$3(sizes, (Function2)fold$extension_op, fold$extension_z);
        } else if (sizes instanceof char[]) {
            object = ArrayOps$.f$mCc$sp$3((char[])sizes, (Function2)fold$extension_op, fold$extension_z);
        } else if (sizes instanceof byte[]) {
            object = ArrayOps$.f$mBc$sp$3((byte[])sizes, (Function2)fold$extension_op, fold$extension_z);
        } else if (sizes instanceof short[]) {
            object = ArrayOps$.f$mSc$sp$3((short[])sizes, (Function2)fold$extension_op, fold$extension_z);
        } else if (sizes instanceof boolean[]) {
            object = ArrayOps$.f$mZc$sp$3((boolean[])sizes, (Function2)fold$extension_op, fold$extension_z);
        } else if (sizes instanceof BoxedUnit[]) {
            java.io.Serializable serializable;
            BoxedUnit[] boxedUnitArray = (BoxedUnit[])sizes;
            int fold$extension_f$mVc$sp$3_length = boxedUnitArray.length - 1;
            if (fold$extension_f$mVc$sp$3_length >= 0) {
                java.io.Serializable fold$extension_f$mVc$sp$3_v = boxedUnitArray[fold$extension_f$mVc$sp$3_length];
                for (int fold$extension_f$mVc$sp$3_i = 0; fold$extension_f$mVc$sp$3_i < fold$extension_f$mVc$sp$3_length; ++fold$extension_f$mVc$sp$3_i) {
                    n = BoxesRunTime.unboxToInt(boxedUnitArray[fold$extension_f$mVc$sp$3_i]);
                    fold$extension_f$mVc$sp$3_v = BoxesRunTime.boxToInteger(ArrayOps$.$anonfun$flatten$2(BoxesRunTime.unboxToInt(fold$extension_f$mVc$sp$3_v), n));
                }
                serializable = fold$extension_f$mVc$sp$3_v;
            } else {
                serializable = fold$extension_z;
            }
            object = serializable;
        } else {
            if (sizes == null) {
                throw new NullPointerException();
            }
            throw new MatchError(sizes);
        }
        b.sizeHint(BoxesRunTime.unboxToInt(object));
        int foreach$extension_len = ScalaRunTime$.MODULE$.array_length($this);
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len; ++foreach$extension_i) {
            Object object3 = ScalaRunTime$.MODULE$.array_apply($this, foreach$extension_i);
            ArrayOps$.$anonfun$flatten$3(b, asIterable, object3);
        }
        return b.result();
    }

    public final <B, A> Object collect$extension(Object $this, PartialFunction<A, B> pf, ClassTag<B> evidence$8) {
        BooleanRef matched = BooleanRef.create(true);
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$8);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            matched.elem = true;
            Object v = pf.applyOrElse(ScalaRunTime$.MODULE$.array_apply($this, i), (Function1<Object, Object> & java.io.Serializable & Serializable)x -> ArrayOps$.d$1(x, matched));
            if (!matched.elem) continue;
            if (b == null) {
                throw null;
            }
            b.addOne(v);
        }
        return b.result();
    }

    public final <B, A> Option<B> collectFirst$extension(Object $this, PartialFunction<A, B> f) {
        BooleanRef matched = BooleanRef.create(true);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            matched.elem = true;
            Object v = f.applyOrElse(ScalaRunTime$.MODULE$.array_apply($this, i), (Function1<Object, Object> & java.io.Serializable & Serializable)x -> ArrayOps$.d$2(x, matched));
            if (!matched.elem) continue;
            return new Some(v);
        }
        return None$.MODULE$;
    }

    public final <B, A> Tuple2<A, B>[] zip$extension(Object $this, IterableOnce<B> that) {
        ArrayBuilder.ofRef b = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(Tuple2.class));
        int k = that.knownSize();
        b.sizeHint(k >= 0 ? Math.min(k, ScalaRunTime$.MODULE$.array_length($this)) : ScalaRunTime$.MODULE$.array_length($this));
        Iterator<B> it = that.iterator();
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this) && it.hasNext(); ++i) {
            Tuple2<Object, B> $plus$eq_elem = new Tuple2<Object, B>(ScalaRunTime$.MODULE$.array_apply($this, i), it.next());
            b.addOne($plus$eq_elem);
        }
        return (Tuple2[])b.result();
    }

    public final <B, A> LazyZip2<A, B, Object> lazyZip$extension(Object $this, Iterable<B> that) {
        return new LazyZip2($this, scala.collection.immutable.ArraySeq$.MODULE$.unsafeWrapArray($this), that);
    }

    public final <A1, B, A> Tuple2<A1, B>[] zipAll$extension(Object $this, Iterable<B> that, A1 thisElem, B thatElem) {
        int i;
        ArrayBuilder.ofRef b = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(Tuple2.class));
        int k = that.knownSize();
        b.sizeHint(k >= 0 ? Math.max(k, ScalaRunTime$.MODULE$.array_length($this)) : ScalaRunTime$.MODULE$.array_length($this));
        Iterator it = that.iterator();
        for (i = 0; i < ScalaRunTime$.MODULE$.array_length($this) && it.hasNext(); ++i) {
            Tuple2 $plus$eq_elem = new Tuple2(ScalaRunTime$.MODULE$.array_apply($this, i), it.next());
            b.addOne($plus$eq_elem);
        }
        while (it.hasNext()) {
            Tuple2 $plus$eq_elem = new Tuple2(thisElem, it.next());
            b.addOne($plus$eq_elem);
            ++i;
        }
        while (i < ScalaRunTime$.MODULE$.array_length($this)) {
            Tuple2<Object, B> $plus$eq_elem = new Tuple2<Object, B>(ScalaRunTime$.MODULE$.array_apply($this, i), thatElem);
            b.addOne($plus$eq_elem);
            ++i;
        }
        return (Tuple2[])b.result();
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Tuple2<A, Object>[] zipWithIndex$extension(Object $this) {
        void var2_2;
        Tuple2[] b = new Tuple2[ScalaRunTime$.MODULE$.array_length($this)];
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            b[i] = new Tuple2<Object, Integer>(ScalaRunTime$.MODULE$.array_apply($this, i), BoxesRunTime.boxToInteger(i));
        }
        return var2_2;
    }

    public final <B, A> Object appended$extension(Object $this, B x, ClassTag<B> evidence$9) {
        Object dest = Array$.MODULE$.copyAs($this, ScalaRunTime$.MODULE$.array_length($this) + 1, evidence$9);
        ScalaRunTime$.MODULE$.array_update(dest, ScalaRunTime$.MODULE$.array_length($this), x);
        return dest;
    }

    public final <B, A> Object $colon$plus$extension(Object $this, B x, ClassTag<B> evidence$10) {
        return this.appended$extension($this, x, evidence$10);
    }

    public final <B, A> Object prepended$extension(Object $this, B x, ClassTag<B> evidence$11) {
        Object dest = evidence$11.newArray(ScalaRunTime$.MODULE$.array_length($this) + 1);
        ScalaRunTime$.MODULE$.array_update(dest, 0, x);
        Array$.MODULE$.copy($this, 0, dest, 1, ScalaRunTime$.MODULE$.array_length($this));
        return dest;
    }

    public final <B, A> Object $plus$colon$extension(Object $this, B x, ClassTag<B> evidence$12) {
        return this.prepended$extension($this, x, evidence$12);
    }

    public final <B, A> Object prependedAll$extension0(Object $this, IterableOnce<B> prefix, ClassTag<B> evidence$13) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$13);
        int k = prefix.knownSize();
        if (k >= 0) {
            b.sizeHint(k + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll((IterableOnce)prefix);
        if (k < 0) {
            b.sizeHint(b.length() + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll($this);
        return b.result();
    }

    public final <B, A> Object prependedAll$extension1(Object $this, Object prefix, ClassTag<B> evidence$14) {
        Object dest = Array$.MODULE$.copyAs(prefix, ScalaRunTime$.MODULE$.array_length(prefix) + ScalaRunTime$.MODULE$.array_length($this), evidence$14);
        Array$.MODULE$.copy($this, 0, dest, ScalaRunTime$.MODULE$.array_length(prefix), ScalaRunTime$.MODULE$.array_length($this));
        return dest;
    }

    public final <B, A> Object $plus$plus$colon$extension0(Object $this, IterableOnce<B> prefix, ClassTag<B> evidence$15) {
        return this.prependedAll$extension0($this, prefix, evidence$15);
    }

    public final <B, A> Object $plus$plus$colon$extension1(Object $this, Object prefix, ClassTag<B> evidence$16) {
        return this.prependedAll$extension1($this, prefix, evidence$16);
    }

    public final <B, A> Object appendedAll$extension0(Object $this, IterableOnce<B> suffix, ClassTag<B> evidence$17) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$17);
        int k = suffix.knownSize();
        if (k >= 0) {
            b.sizeHint(k + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll($this);
        b.addAll((IterableOnce)suffix);
        return b.result();
    }

    public final <B, A> Object appendedAll$extension1(Object $this, Object suffix, ClassTag<B> evidence$18) {
        Object dest = Array$.MODULE$.copyAs($this, ScalaRunTime$.MODULE$.array_length($this) + ScalaRunTime$.MODULE$.array_length(suffix), evidence$18);
        Array$.MODULE$.copy(suffix, 0, dest, ScalaRunTime$.MODULE$.array_length($this), ScalaRunTime$.MODULE$.array_length(suffix));
        return dest;
    }

    public final <B, A> Object $colon$plus$plus$extension0(Object $this, IterableOnce<B> suffix, ClassTag<B> evidence$19) {
        return this.appendedAll$extension0($this, suffix, evidence$19);
    }

    public final <B, A> Object $colon$plus$plus$extension1(Object $this, Object suffix, ClassTag<B> evidence$20) {
        return this.appendedAll$extension1($this, suffix, evidence$20);
    }

    public final <B, A> Object concat$extension0(Object $this, IterableOnce<B> suffix, ClassTag<B> evidence$21) {
        return this.appendedAll$extension0($this, suffix, evidence$21);
    }

    public final <B, A> Object concat$extension1(Object $this, Object suffix, ClassTag<B> evidence$22) {
        return this.appendedAll$extension1($this, suffix, evidence$22);
    }

    public final <B, A> Object $plus$plus$extension0(Object $this, IterableOnce<B> xs, ClassTag<B> evidence$23) {
        return this.appendedAll$extension0($this, xs, evidence$23);
    }

    public final <B, A> Object $plus$plus$extension1(Object $this, Object xs, ClassTag<B> evidence$24) {
        return this.appendedAll$extension1($this, xs, evidence$24);
    }

    public final <A> boolean contains$extension(Object $this, A elem) {
        Function1<Object, Object> & java.io.Serializable & Serializable exists$extension_f = (Function1<Object, Object> & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$contains$1(elem, x$3));
        return this.indexWhere$extension($this, exists$extension_f, this.indexWhere$default$2$extension($this)) >= 0;
    }

    public final <B, A> Object patch$extension(Object $this, int from, IterableOnce<B> other, int replaced, ClassTag<B> evidence$25) {
        int chunk1;
        int r;
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$25);
        int k = other.knownSize();
        int n = r = replaced < 0 ? 0 : replaced;
        if (k >= 0) {
            b.sizeHint(ScalaRunTime$.MODULE$.array_length($this) + k - r);
        }
        int n2 = chunk1 = from > 0 ? Math.min(from, ScalaRunTime$.MODULE$.array_length($this)) : 0;
        if (chunk1 > 0) {
            b.addAll($this, 0, chunk1);
        }
        if (b == null) {
            throw null;
        }
        b.addAll(other);
        int remaining = ScalaRunTime$.MODULE$.array_length($this) - chunk1 - r;
        if (remaining > 0) {
            b.addAll($this, ScalaRunTime$.MODULE$.array_length($this) - remaining, remaining);
        }
        return b.result();
    }

    public final <A1, A2, A> Tuple2<Object, Object> unzip$extension(Object $this, Function1<A, Tuple2<A1, A2>> asPair, ClassTag<A1> ct1, ClassTag<A2> ct2) {
        Object a1 = ct1.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a2 = ct2.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple2<A1, A2> e = asPair.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
        }
        return new Tuple2<Object, Object>(a1, a2);
    }

    public final <A1, A2, A3, A> Tuple3<Object, Object, Object> unzip3$extension(Object $this, Function1<A, Tuple3<A1, A2, A3>> asTriple, ClassTag<A1> ct1, ClassTag<A2> ct2, ClassTag<A3> ct3) {
        Object a1 = ct1.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a2 = ct2.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a3 = ct3.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple3<A1, A2, A3> e = asTriple.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
            ScalaRunTime$.MODULE$.array_update(a3, i, e._3());
        }
        return new Tuple3<Object, Object, Object>(a1, a2, a3);
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object[] transpose$extension(Object $this, Function1<A, Object> asArray) {
        void var8_7;
        void map$extension_evidence$6;
        Class<?> aClass = $this.getClass().getComponentType();
        ArrayBuilder.ofRef bb = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(aClass));
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            return bb.result();
        }
        ClassTag classTag = ClassTag$.MODULE$.apply(ArrayBuilder.class);
        Object map$extension_$this = asArray.apply(ScalaRunTime$.MODULE$.array_apply($this, 0));
        Object map$extension_res = map$extension_evidence$6.newArray(ScalaRunTime$.MODULE$.array_length(map$extension_$this));
        for (int map$extension_i = 0; map$extension_i < ScalaRunTime$.MODULE$.array_length(map$extension_$this); ++map$extension_i) {
            Object object = ScalaRunTime$.MODULE$.array_apply(map$extension_$this, map$extension_i);
            ScalaRunTime$.MODULE$.array_update(map$extension_res, map$extension_i, ArrayOps$.mkRowBuilder$1(aClass));
        }
        ArrayBuilder[] bs = (ArrayBuilder[])var8_7;
        int foreach$extension_len = ScalaRunTime$.MODULE$.array_length($this);
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len; ++foreach$extension_i) {
            Object object = ScalaRunTime$.MODULE$.array_apply($this, foreach$extension_i);
            ArrayOps$.$anonfun$transpose$2$adapted(asArray, bs, object);
        }
        int foreach$extension_len2 = ScalaRunTime$.MODULE$.array_length(bs);
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len2; ++foreach$extension_i) {
            ArrayBuilder arrayBuilder = (ArrayBuilder)ScalaRunTime$.MODULE$.array_apply(bs, foreach$extension_i);
            ArrayOps$.$anonfun$transpose$4(bb, arrayBuilder);
        }
        return bb.result();
    }

    public final <U, A> void foreach$extension(Object $this, Function1<A, U> f) {
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            f.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
        }
    }

    public final <A> Object distinct$extension(Object $this) {
        Function1<Object, Object> & java.io.Serializable & Serializable distinctBy$extension_f = (Function1<Object, Object> & java.io.Serializable & Serializable)x -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return x;
        };
        return ArrayBuilder$.MODULE$.make(this.elemTag$extension($this)).addAll((IterableOnce)this.iterator$extension($this).distinctBy(distinctBy$extension_f)).result();
    }

    public final <B, A> Object distinctBy$extension(Object $this, Function1<A, B> f) {
        return ArrayBuilder$.MODULE$.make(this.elemTag$extension($this)).addAll((IterableOnce)this.iterator$extension($this).distinctBy(f)).result();
    }

    public final <B, A> Object padTo$extension(Object $this, int len, B elem, ClassTag<B> evidence$26) {
        int i;
        int newlen = Math.max(i, len);
        Object dest = Array$.MODULE$.copyAs($this, newlen, evidence$26);
        for (i = ScalaRunTime$.MODULE$.array_length($this); i < newlen; ++i) {
            ScalaRunTime$.MODULE$.array_update(dest, i, elem);
        }
        return dest;
    }

    public final <A> Range indices$extension(Object $this) {
        return Range$.MODULE$.apply(0, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <K, A> Map<K, Object> groupBy$extension(Object $this, Function1<A, K> f) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            Object elem = ScalaRunTime$.MODULE$.array_apply($this, i);
            K key = f.apply(elem);
            ArrayBuilder bldr = (ArrayBuilder)m.getOrElseUpdate(key, (Function0<ArrayBuilder> & java.io.Serializable & Serializable)() -> ArrayBuilder$.MODULE$.make(MODULE$.elemTag$extension($this)));
            if (bldr == null) {
                throw null;
            }
            bldr.addOne(elem);
        }
        return m.view().mapValues((Function1<ArrayBuilder, Object> & java.io.Serializable & Serializable)x$4 -> x$4.result()).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public final <K, B, A> Map<K, Object> groupMap$extension(Object $this, Function1<A, K> key, Function1<A, B> f, ClassTag<B> evidence$27) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            void $plus$eq_elem;
            Object elem = ScalaRunTime$.MODULE$.array_apply($this, i);
            K k = key.apply(elem);
            ArrayBuilder bldr = (ArrayBuilder)m.getOrElseUpdate(k, (Function0<ArrayBuilder> & java.io.Serializable & Serializable)() -> ArrayBuilder$.MODULE$.make(evidence$27));
            B b = f.apply(elem);
            if (bldr == null) {
                throw null;
            }
            bldr.addOne($plus$eq_elem);
        }
        return m.view().mapValues((Function1<ArrayBuilder, Object> & java.io.Serializable & Serializable)x$5 -> x$5.result()).toMap(Predef$.MODULE$.$conforms());
    }

    public final <A> scala.collection.immutable.Seq<A> toSeq$extension(Object $this) {
        return this.toIndexedSeq$extension($this);
    }

    public final <A> scala.collection.immutable.IndexedSeq<A> toIndexedSeq$extension(Object $this) {
        return scala.collection.immutable.ArraySeq$.MODULE$.unsafeWrapArray(Array$.MODULE$.copyOf($this, ScalaRunTime$.MODULE$.array_length($this)));
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> int copyToArray$extension(Object $this, Object dest, int start, int len) {
        void elemsToCopyToArray_destLen;
        void elemsToCopyToArray_srcLen;
        int n = ScalaRunTime$.MODULE$.array_length(dest);
        int n2 = ScalaRunTime$.MODULE$.array_length($this);
        if (IterableOnce$.MODULE$ == null) {
            throw null;
        }
        int n3 = package$.MODULE$.max(package$.MODULE$.min(package$.MODULE$.min(len, (int)elemsToCopyToArray_srcLen), (int)(elemsToCopyToArray_destLen - start)), 0);
        if (n3 > 0) {
            Array$.MODULE$.copy($this, 0, dest, start, n3);
        }
        return n3;
    }

    public final <B, A> int copyToArray$default$3$extension(Object $this) {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object toArray$extension(Object $this, ClassTag<B> evidence$28) {
        void var3_3;
        Object destination = evidence$28.newArray(ScalaRunTime$.MODULE$.array_length($this));
        this.copyToArray$extension($this, destination, 0, this.copyToArray$default$3$extension($this));
        return var3_3;
    }

    public final <A> int count$extension(Object $this, Function1<A, Object> p) {
        int res = 0;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            if (!BoxesRunTime.unboxToBoolean(p.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            ++res;
        }
        return res;
    }

    public final <B, A> boolean startsWith$extension0(Object $this, Object that) {
        return this.startsWith$extension1($this, that, 0);
    }

    public final <B, A> boolean startsWith$extension1(Object $this, Object that, int offset) {
        int thatl = ScalaRunTime$.MODULE$.array_length(that);
        if (thatl > ScalaRunTime$.MODULE$.array_length($this) - offset) {
            return thatl == 0;
        }
        for (int i = 0; i < thatl; ++i) {
            if (BoxesRunTime.equals(ScalaRunTime$.MODULE$.array_apply($this, i + offset), ScalaRunTime$.MODULE$.array_apply(that, i))) continue;
            return false;
        }
        return true;
    }

    public final <B, A> boolean endsWith$extension0(Object $this, Object that) {
        int thatl = ScalaRunTime$.MODULE$.array_length(that);
        int off = ScalaRunTime$.MODULE$.array_length($this) - thatl;
        if (off < 0) {
            return false;
        }
        for (int i = 0; i < thatl; ++i) {
            if (BoxesRunTime.equals(ScalaRunTime$.MODULE$.array_apply($this, i + off), ScalaRunTime$.MODULE$.array_apply(that, i))) continue;
            return false;
        }
        return true;
    }

    public final <B, A> Object updated$extension(Object $this, int index, B elem, ClassTag<B> evidence$29) {
        if (index < 0 || index >= ScalaRunTime$.MODULE$.array_length($this)) {
            throw new IndexOutOfBoundsException();
        }
        Object dest = this.toArray$extension($this, evidence$29);
        ScalaRunTime$.MODULE$.array_update(dest, index, elem);
        return dest;
    }

    public final <A> IndexedSeqView<A> view$extension(Object $this) {
        return new ArrayOps.ArrayView($this);
    }

    public final <A> Object diff$extension(Object $this, Seq<? super A> that) {
        return ((ArraySeq)ArraySeq$.MODULE$.make($this).diff((Seq)that)).array();
    }

    public final <A> Object intersect$extension(Object $this, Seq<? super A> that) {
        return ((ArraySeq)ArraySeq$.MODULE$.make($this).intersect((Seq)that)).array();
    }

    public final <A> Iterator<Object> sliding$extension(Object $this, int size, int step) {
        return ArraySeq$.MODULE$.make($this).sliding(size, step).map((Function1<ArraySeq, Object> & java.io.Serializable & Serializable)x$6 -> x$6.array());
    }

    public final <A> int sliding$default$2$extension(Object $this) {
        return 1;
    }

    public final <A> Iterator<Object> combinations$extension(Object $this, int n) {
        return ArraySeq$.MODULE$.make($this).combinations(n).map((Function1<ArraySeq, Object> & java.io.Serializable & Serializable)x$7 -> x$7.array());
    }

    public final <A> Iterator<Object> permutations$extension(Object $this) {
        return ArraySeq$.MODULE$.make($this).permutations().map((Function1<ArraySeq, Object> & java.io.Serializable & Serializable)x$8 -> x$8.array());
    }

    public final <B, A> boolean startsWith$extension2(Object $this, IterableOnce<B> that, int offset) {
        return ArraySeq$.MODULE$.make($this).startsWith(that, offset);
    }

    public final <B, A> int startsWith$default$2$extension(Object $this) {
        return 0;
    }

    public final <B, A> boolean endsWith$extension1(Object $this, Iterable<B> that) {
        return ArraySeq$.MODULE$.make($this).endsWith(that);
    }

    public final <A> int hashCode$extension(Object $this) {
        return $this.hashCode();
    }

    public final <A> boolean equals$extension(Object $this, Object x$1) {
        Object object;
        boolean bl = x$1 instanceof ArrayOps;
        return bl && BoxesRunTime.equals($this, object = x$1 == null ? null : ((ArrayOps)x$1).xs());
    }

    public static final /* synthetic */ boolean $anonfun$iterateUntilEmpty$1(Object x) {
        return ScalaRunTime$.MODULE$.array_length(x) != 0;
    }

    public static final /* synthetic */ boolean $anonfun$takeWhile$1(Function1 p$1, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$1.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$dropWhile$1(Function1 p$2, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$2.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$span$1(Function1 p$3, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$3.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$filterNot$1(Function1 p$4, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$4.apply(x));
    }

    private static final Object f$mZc$sp$1(boolean[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToBoolean(xs[i]));
        }
        return v;
    }

    private static final Object f$mBc$sp$1(byte[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToByte(xs[i]));
        }
        return v;
    }

    private static final Object f$mCc$sp$1(char[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToCharacter(xs[i]));
        }
        return v;
    }

    private static final Object f$mDc$sp$1(double[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToDouble(xs[i]));
        }
        return v;
    }

    private static final Object f$mFc$sp$1(float[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToFloat(xs[i]));
        }
        return v;
    }

    private static final Object f$mIc$sp$1(int[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToInteger(xs[i]));
        }
        return v;
    }

    private static final Object f$mJc$sp$1(long[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToLong(xs[i]));
        }
        return v;
    }

    private static final Object f$mSc$sp$1(short[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, BoxesRunTime.boxToShort(xs[i]));
        }
        return v;
    }

    private static final Object f$mVc$sp$1(BoxedUnit[] xs, Function2 op, Object z) {
        int length = xs.length;
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, xs[i]);
        }
        return v;
    }

    private static final Object f$2(Object xs, Function2 op, Object z) {
        int length = ScalaRunTime$.MODULE$.array_length(xs);
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, ScalaRunTime$.MODULE$.array_apply(xs, i));
        }
        return v;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mZc$sp$2(boolean[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToBoolean(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mBc$sp$2(byte[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToByte(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mCc$sp$2(char[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToCharacter(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mDc$sp$2(double[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToDouble(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mFc$sp$2(float[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToFloat(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mIc$sp$2(int[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToInteger(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mJc$sp$2(long[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToLong(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mSc$sp$2(short[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(BoxesRunTime.boxToShort(xs[i]), v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$mVc$sp$2(BoxedUnit[] xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = xs.length - 1; i >= 0; --i) {
            v = op.apply(xs[i], v);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object f$3(Object xs, Function2 op, Object z) {
        void var3_3;
        Object v = z;
        for (int i = ScalaRunTime$.MODULE$.array_length(xs) - 1; i >= 0; --i) {
            v = op.apply(ScalaRunTime$.MODULE$.array_apply(xs, i), v);
        }
        return var3_3;
    }

    private static final Object f$mZc$sp$3(boolean[] xs, Function2 op, Object z) {
        int length = xs.length - 1;
        if (length >= 0) {
            Boolean v = BoxesRunTime.boxToBoolean(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToBoolean(xs[i]));
            }
            return v;
        }
        return z;
    }

    private static final Object f$mBc$sp$3(byte[] xs, Function2 op, Object z) {
        int length = xs.length - 1;
        if (length >= 0) {
            Byte v = BoxesRunTime.boxToByte(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToByte(xs[i]));
            }
            return v;
        }
        return z;
    }

    private static final Object f$mCc$sp$3(char[] xs, Function2 op, Object z) {
        int length = xs.length - 1;
        if (length >= 0) {
            Character v = BoxesRunTime.boxToCharacter(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToCharacter(xs[i]));
            }
            return v;
        }
        return z;
    }

    private static final Object f$mDc$sp$3(double[] xs, Function2 op, Object z) {
        int length = xs.length - 1;
        if (length >= 0) {
            Double v = BoxesRunTime.boxToDouble(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToDouble(xs[i]));
            }
            return v;
        }
        return z;
    }

    private static final Object f$mFc$sp$3(float[] xs, Function2 op, Object z) {
        int length = xs.length - 1;
        if (length >= 0) {
            Float v = BoxesRunTime.boxToFloat(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToFloat(xs[i]));
            }
            return v;
        }
        return z;
    }

    private static final Object f$mIc$sp$3(int[] xs, Function2 op, Object z) {
        int length = xs.length - 1;
        if (length >= 0) {
            Integer v = BoxesRunTime.boxToInteger(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToInteger(xs[i]));
            }
            return v;
        }
        return z;
    }

    private static final Object f$mJc$sp$3(long[] xs, Function2 op, Object z) {
        int length = xs.length - 1;
        if (length >= 0) {
            Long v = BoxesRunTime.boxToLong(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToLong(xs[i]));
            }
            return v;
        }
        return z;
    }

    private static final Object f$mSc$sp$3(short[] xs, Function2 op, Object z) {
        int length = xs.length - 1;
        if (length >= 0) {
            Short v = BoxesRunTime.boxToShort(xs[length]);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, BoxesRunTime.boxToShort(xs[i]));
            }
            return v;
        }
        return z;
    }

    private static final Object f$mVc$sp$3(BoxedUnit[] xs, Function2 op, Object z) {
        int length = xs.length - 1;
        if (length >= 0) {
            BoxedUnit v = xs[length];
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, xs[i]);
            }
            return v;
        }
        return z;
    }

    private static final Object f$4(Object xs, Function2 op, Object z) {
        int length = ScalaRunTime$.MODULE$.array_length(xs) - 1;
        if (length >= 0) {
            Object v = ScalaRunTime$.MODULE$.array_apply(xs, length);
            for (int i = 0; i < length; ++i) {
                v = op.apply(v, ScalaRunTime$.MODULE$.array_apply(xs, i));
            }
            return v;
        }
        return z;
    }

    public static final /* synthetic */ Iterable $anonfun$flatMap$2(Function1 asIterable$2, Function1 f$5, Object x) {
        return (Iterable)asIterable$2.apply(f$5.apply(x));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuilder $anonfun$flatten$3(ArrayBuilder b$1, Function1 asIterable$3, Object xs) {
        void $plus$plus$eq_xs;
        IterableOnce iterableOnce = (IterableOnce)asIterable$3.apply(xs);
        if (b$1 == null) {
            throw null;
        }
        return (ArrayBuilder)b$1.addAll($plus$plus$eq_xs);
    }

    private static final Object d$1(Object x, BooleanRef matched$1) {
        matched$1.elem = false;
        return null;
    }

    private static final Object d$2(Object x, BooleanRef matched$2) {
        matched$2.elem = false;
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$contains$1(Object elem$1, Object x$3) {
        return BoxesRunTime.equals(x$3, elem$1);
    }

    private static final ArrayBuilder mkRowBuilder$1(Class aClass$1) {
        return ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(aClass$1.getComponentType()));
    }

    public static final /* synthetic */ void $anonfun$transpose$3(ArrayBuilder[] bs$1, IntRef i$1, Object x) {
        ArrayBuilder arrayBuilder = bs$1[i$1.elem];
        if (arrayBuilder == null) {
            throw null;
        }
        arrayBuilder.addOne(x);
        ++i$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$transpose$2(Function1 asArray$1, ArrayBuilder[] bs$1, Object xs) {
        void foreach$extension_$this;
        IntRef i = IntRef.create(0);
        Object r = asArray$1.apply(xs);
        if (MODULE$ == null) {
            throw null;
        }
        int foreach$extension_len = ScalaRunTime$.MODULE$.array_length(foreach$extension_$this);
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len; ++foreach$extension_i) {
            Object object = ScalaRunTime$.MODULE$.array_apply(foreach$extension_$this, foreach$extension_i);
            ArrayOps$.$anonfun$transpose$3$adapted(bs$1, i, object);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuilder.ofRef $anonfun$transpose$4(ArrayBuilder.ofRef bb$1, ArrayBuilder b) {
        void $plus$eq_elem;
        Object To = b.result();
        if (bb$1 == null) {
            throw null;
        }
        return (ArrayBuilder.ofRef)bb$1.addOne($plus$eq_elem);
    }

    private ArrayOps$() {
    }

    public static final /* synthetic */ Object $anonfun$flatten$1$adapted(Object x0$1) {
        return BoxesRunTime.boxToInteger(n = x0$1 instanceof IndexedSeq ? ((SeqOps)x0$1).size() : 0);
    }

    public static final /* synthetic */ Object $anonfun$transpose$2$adapted(Function1 asArray$1, ArrayBuilder[] bs$1, Object xs) {
        ArrayOps$.$anonfun$transpose$2(asArray$1, bs$1, xs);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$transpose$3$adapted(ArrayBuilder[] bs$1, IntRef i$1, Object x) {
        ArrayOps$.$anonfun$transpose$3(bs$1, i$1, x);
        return BoxedUnit.UNIT;
    }
}

