/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedSeqFactory;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.Builder;
import scala.collection.mutable.GrowableBuilder;
import scala.runtime.ModuleSerializationProxy;

public final class ArrayDeque$
implements StrictOptimizedSeqFactory<ArrayDeque> {
    public static final ArrayDeque$ MODULE$ = new ArrayDeque$();
    private static final long serialVersionUID = 3L;

    public <A> int $lessinit$greater$default$1() {
        return 16;
    }

    @Override
    public <B> ArrayDeque<B> from(IterableOnce<B> coll) {
        int s = coll.knownSize();
        if (s >= 0) {
            Object[] array = this.alloc(s);
            Iterator<B> it = coll.iterator();
            int i = 0;
            while (it.hasNext()) {
                array[i] = it.next();
                ++i;
            }
            return new ArrayDeque(array, 0, s);
        }
        Object object = this.empty();
        if (object == null) {
            throw null;
        }
        return (ArrayDeque)object.addAll(coll);
    }

    @Override
    public <A> Builder<A, ArrayDeque<A>> newBuilder() {
        return new GrowableBuilder<A, ArrayDeque<A>>(){

            public void sizeHint(int size) {
                ((ArrayDeque)this.elems()).ensureSize(size);
            }
        };
    }

    @Override
    public <A> ArrayDeque<A> empty() {
        return new ArrayDeque(16);
    }

    public final int DefaultInitialSize() {
        return 16;
    }

    public final int StableSize() {
        return 256;
    }

    public Object[] alloc(int len) {
        if (!(len >= 0)) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Non-negative array size required").toString());
        }
        int size = Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(len) << 1;
        if (!(size >= 0)) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ArrayDeque$.$anonfun$alloc$2(len)).toString());
        }
        return new Object[Math.max(size, 16)];
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArrayDeque$.class);
    }

    public static final /* synthetic */ String $anonfun$alloc$1() {
        return "Non-negative array size required";
    }

    public static final /* synthetic */ String $anonfun$alloc$2(int len$1) {
        return new StringBuilder(58).append("ArrayDeque too big - cannot allocate ArrayDeque of length ").append(len$1).toString();
    }

    private ArrayDeque$() {
    }
}

