/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;

public abstract class FlatHashTable$class {
    public static void $init$(FlatHashTable flatHashTable) {
        flatHashTable.table_$eq((Object[])(flatHashTable.initialSize() != 0 ? new Object[flatHashTable.initialSize()] : null));
        flatHashTable.tableSize_$eq(0);
        flatHashTable.threshold_$eq(FlatHashTable$class.newThreshold(flatHashTable, flatHashTable.initialSize()));
    }

    private static final boolean precedes$0(FlatHashTable flatHashTable, int n, int n2) {
        int n3 = flatHashTable.table().length >> 1;
        return n > n2 ? n - n2 > n3 : n2 - n < n3;
    }

    public static void clear(FlatHashTable flatHashTable) {
        int n = flatHashTable.table().length - 1;
        while (true) {
            if (n < 0) {
                flatHashTable.tableSize_$eq(0);
                return;
            }
            flatHashTable.table()[n] = null;
            --n;
        }
    }

    private static int newThreshold(FlatHashTable flatHashTable, int n) {
        float f = flatHashTable.loadFactor();
        Predef$.MODULE$.assert(f < 0.5f, "loadFactor too large; must be < 0.5");
        return (int)((float)n * f);
    }

    public static final int index(FlatHashTable flatHashTable, int n) {
        return flatHashTable.improve(n) & flatHashTable.table().length - 1;
    }

    public static final int improve(FlatHashTable flatHashTable, int n) {
        int n2 = n + ~(n << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        return n2 ^ n2 >>> 10;
    }

    public static int elemHashCode(FlatHashTable flatHashTable, Object object) {
        return object.hashCode();
    }

    private static void checkConsistent(FlatHashTable flatHashTable) {
        Predef$.MODULE$.intWrapper(0).until(flatHashTable.table().length).foreach(new FlatHashTable$.anonfun.0(flatHashTable));
    }

    private static void growTable(FlatHashTable flatHashTable) {
        Object[] objectArray = flatHashTable.table();
        flatHashTable.table_$eq(new Object[flatHashTable.table().length * 2]);
        flatHashTable.tableSize_$eq(0);
        flatHashTable.threshold_$eq(FlatHashTable$class.newThreshold(flatHashTable, flatHashTable.table().length));
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object != null) {
                flatHashTable.addEntry(object);
            }
            ++n;
        }
        return;
    }

    public static Object elements(FlatHashTable flatHashTable) {
        return new FlatHashTable$.anon.0(flatHashTable);
    }

    public static void removeEntry(FlatHashTable flatHashTable, Object object) {
        FlatHashTable$class.checkConsistent(flatHashTable);
        int n = flatHashTable.index(flatHashTable.elemHashCode(object));
        Object object2 = flatHashTable.table()[n];
        while (object2 != null) {
            Object object3 = object2;
            Object object4 = object;
            if (object3 != null ? !object3.equals(object4) : object4 != null) {
                n = (n + 1) % flatHashTable.table().length;
                object2 = flatHashTable.table()[n];
                continue;
            }
            int n2 = n;
            int n3 = (n2 + 1) % flatHashTable.table().length;
            while (flatHashTable.table()[n3] != null) {
                int n4 = flatHashTable.index(flatHashTable.elemHashCode(flatHashTable.table()[n3]));
                if (n4 != n3 && FlatHashTable$class.precedes$0(flatHashTable, n4, n2)) {
                    flatHashTable.table()[n2] = flatHashTable.table()[n3];
                    n2 = n3;
                }
                n3 = (n3 + 1) % flatHashTable.table().length;
            }
            flatHashTable.table()[n2] = null;
            flatHashTable.tableSize_$eq(flatHashTable.tableSize() - 1);
            return;
        }
    }

    public static void addEntry(FlatHashTable flatHashTable, Object object) {
        int n = flatHashTable.index(flatHashTable.elemHashCode(object));
        Object object2 = flatHashTable.table()[n];
        while (object2 != null) {
            Object object3 = object2;
            Object object4 = object;
            if (object3 != null ? !object3.equals(object4) : object4 != null) {
                n = (n + 1) % flatHashTable.table().length;
                object2 = flatHashTable.table()[n];
                continue;
            }
            return;
        }
        flatHashTable.table()[n] = object;
        flatHashTable.tableSize_$eq(flatHashTable.tableSize() + 1);
        if (flatHashTable.tableSize() >= flatHashTable.threshold()) {
            FlatHashTable$class.growTable(flatHashTable);
        }
    }

    public static boolean containsEntry(FlatHashTable flatHashTable, Object object) {
        int n = flatHashTable.index(flatHashTable.elemHashCode(object));
        Object object2 = flatHashTable.table()[n];
        while (object2 != null) {
            Object object3 = object2;
            Object object4 = object;
            if (!(object3 != null ? !object3.equals(object4) : object4 != null)) break;
            n = (n + 1) % flatHashTable.table().length;
            object2 = flatHashTable.table()[n];
        }
        return object2 != null;
    }

    public static Option findEntry(FlatHashTable flatHashTable, Object object) {
        int n = flatHashTable.index(flatHashTable.elemHashCode(object));
        Object object2 = flatHashTable.table()[n];
        while (object2 != null) {
            Object object3 = object2;
            Object object4 = object;
            if (!(object3 != null ? !object3.equals(object4) : object4 != null)) break;
            n = (n + 1) % flatHashTable.table().length;
            object2 = flatHashTable.table()[n];
        }
        return object2 != null ? new Some(object2) : None$.MODULE$;
    }

    public static int size(FlatHashTable flatHashTable) {
        return flatHashTable.tableSize();
    }

    public static int initialSize(FlatHashTable flatHashTable) {
        return 16;
    }

    public static float loadFactor(FlatHashTable flatHashTable) {
        return 0.45f;
    }
}

