/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import scala.Console$;
import scala.Function0;
import scala.List;
import scala.List$;
import scala.Nil$;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.collection.mutable.Stack;
import scala.compat.StringBuilder;
import scala.runtime.BoxedObjectArray;
import scala.runtime.ObjectRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.parsing.FactoryAdapter$;

public abstract class FactoryAdapter
extends DefaultHandler
implements ScalaObject {
    private Node rootElem = null;
    private boolean normalizeWhitespace = false;
    private boolean capture = false;
    private String curTag = null;
    private Stack scopeStack;
    private Stack tagStack;
    private Stack hStack;
    private Stack attribStack;
    private StringBuilder buffer = new StringBuilder();

    public FactoryAdapter() {
        this.attribStack = new Stack();
        this.hStack = new Stack();
        this.tagStack = new Stack();
        this.scopeStack = new Stack();
    }

    public Node load(String sysID) {
        return this.loadXML(new InputSource(sysID));
    }

    public Node load(Reader reader) {
        return this.loadXML(new InputSource(reader));
    }

    public Node load(InputStream is) {
        return this.loadXML(new InputSource(is));
    }

    public Node loadFile(String fileName) {
        return this.loadXML(new InputSource(new FileInputStream(fileName)));
    }

    public Node loadFile(FileDescriptor fileDesc) {
        return this.loadXML(new InputSource(new FileInputStream(fileDesc)));
    }

    public Node loadFile(File file) {
        return this.loadXML(new InputSource(new FileInputStream(file)));
    }

    public Node loadXML(InputSource source) {
        SAXParser parser;
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(false);
            parser = f.newSAXParser();
        }
        catch (Exception exception) {
            Console$.MODULE$.err().println("error: Unable to instantiate parser");
            Predef$.MODULE$.exit(1);
            return null;
        }
        this.scopeStack().push(new BoxedObjectArray(new NamespaceBinding[]{TopScope$.MODULE$}));
        parser.parse(source, (DefaultHandler)this);
        this.scopeStack().pop();
        return this.rootElem();
    }

    public void rootElem_$eq(Node x$1) {
        this.rootElem = x$1;
    }

    public Node rootElem() {
        return this.rootElem;
    }

    public void printError(String errtype$0, SAXParseException ex$0) {
        Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new $anonfun$1(this, errtype$0, ex$0));
    }

    public void fatalError(SAXParseException ex) {
        this.printError("Fatal Error", ex);
    }

    public void error(SAXParseException ex) {
        this.printError("Error", ex);
    }

    public void warning(SAXParseException ex) {
    }

    public void endElement(String uri, String _localName, String qname) {
        this.captureText();
        MetaData metaData = (MetaData)this.attribStack().pop();
        List v = Nil$.MODULE$;
        Node child = (Node)this.hStack().pop();
        while (child != null) {
            Node node = child;
            v = v.$colon$colon(node);
            child = (Node)this.hStack().pop();
        }
        int colon2 = qname.indexOf(58);
        String localName = -1 != colon2 ? qname.substring(colon2 + 1, qname.length()) : qname;
        NamespaceBinding scp = (NamespaceBinding)this.scopeStack().pop();
        String pre = -1 != colon2 ? qname.substring(0, colon2) : null;
        this.rootElem_$eq(this.createNode(pre, localName, metaData, scp, v));
        this.hStack().push(new BoxedObjectArray(new Node[]{this.rootElem()}));
        this.curTag_$eq((String)this.tagStack().pop());
        this.capture_$eq(this.curTag() != null ? this.nodeContainsText(this.curTag()) : false);
    }

    public void captureText() {
        String text;
        if (this.capture() && (text = this.buffer().toString()).length() > 0 && !text.equals(" ")) {
            this.hStack().push(new BoxedObjectArray(new Node[]{this.createText(text)}));
        }
        this.buffer().setLength(0);
    }

    public void startElement(String uri, String _localName, String qname, Attributes attributes$0) {
        this.captureText();
        this.tagStack().push(new BoxedObjectArray(new String[]{this.curTag()}));
        this.curTag_$eq(qname);
        int colon2 = qname.indexOf(58);
        String localName = -1 != colon2 ? qname.substring(colon2 + 1, qname.length()) : qname;
        this.capture_$eq(this.nodeContainsText(localName));
        Node[] nodeArray = new Node[1];
        nodeArray[0] = null;
        this.hStack().push(new BoxedObjectArray(nodeArray));
        ObjectRef m$0 = new ObjectRef(Null$.MODULE$);
        ObjectRef scpe$0 = new ObjectRef((NamespaceBinding)this.scopeStack().top());
        List$.MODULE$.range(0, attributes$0.getLength()).foreach(new $anonfun$0(this, attributes$0, m$0, scpe$0));
        this.scopeStack().push(new BoxedObjectArray(new NamespaceBinding[]{(NamespaceBinding)scpe$0.elem}));
        this.attribStack().push(new BoxedObjectArray(new MetaData[]{(MetaData)m$0.elem}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void characters(char[] ch, int offset, int length) {
        if (!this.capture()) return;
        if (!this.normalizeWhitespace()) {
            this.buffer().append(ch, offset, length);
            return;
        }
        int i = offset;
        boolean ws = false;
        while (i < offset + length) {
            if (!Predef$.MODULE$.charWrapper(ch[i]).isWhitespace()) {
                this.buffer().append(ch[i]);
                ws = false;
            } else if (!ws) {
                this.buffer().append(' ');
                ws = true;
            }
            ++i;
        }
        return;
    }

    public boolean normalizeWhitespace() {
        return this.normalizeWhitespace;
    }

    public abstract Text createText(String var1);

    public abstract Node createNode(String var1, String var2, MetaData var3, NamespaceBinding var4, List var5);

    public abstract boolean nodeContainsText(String var1);

    public void capture_$eq(boolean x$1) {
        this.capture = x$1;
    }

    public boolean capture() {
        return this.capture;
    }

    public void curTag_$eq(String x$1) {
        this.curTag = x$1;
    }

    public String curTag() {
        return this.curTag;
    }

    public void scopeStack_$eq(Stack x$1) {
        this.scopeStack = x$1;
    }

    public Stack scopeStack() {
        return this.scopeStack;
    }

    public Stack tagStack() {
        return this.tagStack;
    }

    public Stack hStack() {
        return this.hStack;
    }

    public Stack attribStack() {
        return this.attribStack;
    }

    public StringBuilder buffer() {
        return this.buffer;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

