/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Map;
import scala.runtime.BoxesUtility;
import scala.util.logging.Logged;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.dtd.ANY$;
import scala.xml.dtd.AttListDecl;
import scala.xml.dtd.ContentModel;
import scala.xml.dtd.ContentModel$;
import scala.xml.dtd.DFAContentModel;
import scala.xml.dtd.ELEMENTS;
import scala.xml.dtd.EMPTY$;
import scala.xml.dtd.ElemDecl;
import scala.xml.dtd.ExternalID;
import scala.xml.dtd.MIXED;
import scala.xml.dtd.NotationDecl;
import scala.xml.dtd.PCDATA$;
import scala.xml.dtd.PEReference;
import scala.xml.dtd.UnparsedEntityDecl;
import scala.xml.parsing.MarkupHandler;

public abstract class ValidatingMarkupHandler
extends MarkupHandler
implements Logged,
ScalaObject {
    private final boolean isValidating;
    private ElemDecl declCurrent = null;
    private List declStack;
    private int qCurrent = -1;
    private List qStack = Nil$.MODULE$;
    private String rootLabel;

    public ValidatingMarkupHandler() {
        this.declStack = Nil$.MODULE$;
    }

    private final void advanceDFA$0(DFAContentModel dm, int n, String string) {
        Map trans = dm.dfa().delta()[this.qCurrent()];
        this.log("advanceDFA(dm): " + dm);
        this.log("advanceDFA(trans): " + trans);
        Option option = trans.get(new ContentModel.ElemName(string));
        if (option instanceof Some) {
            this.qCurrent_$eq(BoxesUtility.unboxToInt(((Some)option).x()));
        } else {
            this.reportValidationError(n, "DTD says, wrong element, expected one of " + trans.keys().toString());
        }
    }

    public abstract void reportValidationError(int var1, String var2);

    public final void peReference(String name) {
        PEReference pEReference = new PEReference(name);
        this.decls_$eq(this.decls().$colon$colon(pEReference));
    }

    public final void notationDecl(String notat, ExternalID extID) {
        NotationDecl notationDecl = new NotationDecl(notat, extID);
        this.decls_$eq(this.decls().$colon$colon(notationDecl));
    }

    public final void unparsedEntityDecl(String name, ExternalID extID, String notat) {
        UnparsedEntityDecl unparsedEntityDecl = new UnparsedEntityDecl(name, extID, notat);
        this.decls_$eq(this.decls().$colon$colon(unparsedEntityDecl));
    }

    public final void attListDecl(String name, List attList) {
        AttListDecl attListDecl = new AttListDecl(name, attList);
        this.decls_$eq(this.decls().$colon$colon(attListDecl));
    }

    public final void elemDecl(String name, String cmstr) {
        ElemDecl elemDecl = new ElemDecl(name, ContentModel$.MODULE$.parse(cmstr));
        this.decls_$eq(this.decls().$colon$colon(elemDecl));
    }

    public void elemEnd(int pos, String pre, String label) {
        this.log("  elemEnd");
        this.qCurrent_$eq(BoxesUtility.unboxToInt(this.qStack().head()));
        this.qStack_$eq(this.qStack().tail());
        this.declCurrent_$eq((ElemDecl)this.declStack().head());
        this.declStack_$eq(this.declStack().tail());
        this.log("    qCurrent now" + BoxesUtility.boxToInteger(this.qCurrent()));
        this.log("    declCurrent now" + this.declCurrent());
    }

    public void elemStart(int pos$0, String pre, String label$0, MetaData attrs, NamespaceBinding scope) {
        ContentModel contentModel;
        block10: {
            block6: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                this.log("[qCurrent = " + BoxesUtility.boxToInteger(this.qCurrent()) + " visiting " + label$0 + "]");
                                if (this.qCurrent() != -1) break block5;
                                this.log("  checking root");
                                String string = label$0;
                                String string2 = this.rootLabel();
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    this.reportValidationError(pos$0, "this element should be " + this.rootLabel());
                                }
                                break block6;
                            }
                            this.log("  checking node");
                            contentModel = this.declCurrent().contentModel();
                            if (ANY$.MODULE$ == contentModel) break block6;
                            if (EMPTY$.MODULE$ != contentModel) break block7;
                            this.reportValidationError(pos$0, "DTD says, no elems, no text allowed here");
                            break block6;
                        }
                        if (PCDATA$.MODULE$ != contentModel) break block8;
                        this.reportValidationError(pos$0, "DTD says, no elements allowed here");
                        break block6;
                    }
                    if (!(contentModel instanceof MIXED)) break block9;
                    this.advanceDFA$0((MIXED)contentModel, pos$0, label$0);
                    break block6;
                }
                if (!(contentModel instanceof ELEMENTS)) break block10;
                this.advanceDFA$0((ELEMENTS)contentModel, pos$0, label$0);
            }
            int n = this.qCurrent();
            this.qStack_$eq(this.qStack().$colon$colon(BoxesUtility.boxToInteger(n)));
            ElemDecl elemDecl = this.declCurrent();
            this.declStack_$eq(this.declStack().$colon$colon(elemDecl));
            this.declCurrent_$eq(this.lookupElemDecl(label$0));
            this.qCurrent_$eq(0);
            this.log("  done  now");
            return;
        }
        throw new MatchError(contentModel);
    }

    public void endDTD(String n) {
        this.rootLabel_$eq(n);
    }

    public void log(String msg) {
    }

    public final boolean isValidating() {
        return true;
    }

    public void declCurrent_$eq(ElemDecl x$1) {
        this.declCurrent = x$1;
    }

    public ElemDecl declCurrent() {
        return this.declCurrent;
    }

    public void declStack_$eq(List x$1) {
        this.declStack = x$1;
    }

    public List declStack() {
        return this.declStack;
    }

    public void qCurrent_$eq(int x$1) {
        this.qCurrent = x$1;
    }

    public int qCurrent() {
        return this.qCurrent;
    }

    public void qStack_$eq(List x$1) {
        this.qStack = x$1;
    }

    public List qStack() {
        return this.qStack;
    }

    public void rootLabel_$eq(String x$1) {
        this.rootLabel = x$1;
    }

    public String rootLabel() {
        return this.rootLabel;
    }
}

