/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime;

public class BoxesUtility {
    private static int charLowBound;
    private static int charUpBound;
    private static Character[] charCache;
    private static int byteLowBound;
    private static int byteUpBound;
    private static Byte[] byteCache;
    private static int shortLowBound;
    private static int shortUpBound;
    private static Short[] shortCache;
    private static int intLowBound;
    private static int intUpBound;
    private static Integer[] intCache;
    private static int longLowBound;
    private static int longUpBound;
    private static Long[] longCache;

    public static Boolean boxToBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Character boxToCharacter(char c) {
        if (c >= charLowBound && c <= charUpBound) {
            return charCache[c - charLowBound];
        }
        return new Character(c);
    }

    public static Byte boxToByte(byte by) {
        if (by >= byteLowBound && by <= byteUpBound) {
            return byteCache[by - byteLowBound];
        }
        return new Byte(by);
    }

    public static Short boxToShort(short s) {
        if (s >= shortLowBound && s <= shortUpBound) {
            return shortCache[s - shortLowBound];
        }
        return new Short(s);
    }

    public static Integer boxToInteger(int n) {
        if (n >= intLowBound && n <= intUpBound) {
            return intCache[n - intLowBound];
        }
        return new Integer(n);
    }

    public static Long boxToLong(long l) {
        if (l >= (long)longLowBound && l <= (long)longUpBound) {
            return longCache[(int)l - longLowBound];
        }
        return new Long(l);
    }

    public static Float boxToFloat(float f) {
        return new Float(f);
    }

    public static Double boxToDouble(double d) {
        return new Double(d);
    }

    public static boolean unboxToBoolean(Object object) {
        return object == null ? false : (Boolean)object;
    }

    public static char unboxToChar(Object object) {
        if (object == null) {
            return '\u0000';
        }
        return ((Character)object).charValue();
    }

    public static byte unboxToByte(Object object) {
        if (object == null) {
            return 0;
        }
        return (Byte)object;
    }

    public static short unboxToShort(Object object) {
        if (object == null) {
            return 0;
        }
        return (Short)object;
    }

    public static int unboxToInt(Object object) {
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public static long unboxToLong(Object object) {
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    public static float unboxToFloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public static double unboxToDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    static {
        int n;
        charLowBound = 0;
        charUpBound = 255;
        charCache = new Character[charUpBound - charLowBound + 1];
        byteLowBound = -128;
        byteUpBound = 127;
        byteCache = new Byte[byteUpBound - byteLowBound + 1];
        shortLowBound = -128;
        shortUpBound = 127;
        shortCache = new Short[shortUpBound - shortLowBound + 1];
        intLowBound = -128;
        intUpBound = 1024;
        intCache = new Integer[intUpBound - intLowBound + 1];
        longLowBound = -128;
        longUpBound = 1024;
        longCache = new Long[longUpBound - longLowBound + 1];
        for (n = 0; n <= charUpBound - charLowBound; ++n) {
            BoxesUtility.charCache[n] = new Character((char)(n + charLowBound));
        }
        for (n = 0; n <= byteUpBound - byteLowBound; ++n) {
            BoxesUtility.byteCache[n] = new Byte((byte)(n + byteLowBound));
        }
        for (n = 0; n <= shortUpBound - shortLowBound; ++n) {
            BoxesUtility.shortCache[n] = new Short((short)(n + shortLowBound));
        }
        for (n = 0; n <= intUpBound - intLowBound; ++n) {
            BoxesUtility.intCache[n] = new Integer(n + intLowBound);
        }
        for (n = 0; n <= longUpBound - longLowBound; ++n) {
            BoxesUtility.longCache[n] = new Long(n + longLowBound);
        }
    }
}

